# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/private/external/collateAIAppPrivateConfig.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from ......type import basic


class CollateAILimits(BaseModel):
    descriptions: Annotated[
        Optional[int],
        Field(
            None,
            description='Maximum number of descriptions generated by the CollateAI',
        ),
    ]
    queries: Annotated[
        Optional[int],
        Field(None, description='Maximum number of queries generated by CollateAI.'),
    ]
    billingCycleStart: Annotated[
        Optional[basic.Date], Field(None, description='Start of the billing cycle.')
    ]


class CollateAIAppPrivateConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    waiiInstance: Annotated[
        str, Field(description='WAII API host URL', title='WAII Instance')
    ]
    collateURL: Annotated[
        str,
        Field(
            description='Collate Server public URL. WAII will use this information to interact with the server. E.g., https://sandbox.getcollate.io',
            title='Collate URL',
        ),
    ]
    token: Annotated[
        CustomSecretStr, Field(description='WAII API Token', title='WAII API Token')
    ]
    limits: Annotated[
        CollateAILimits,
        Field(description='Limits for the CollateAI Application.', title='Limits'),
    ]
