# generated by datamodel-codegen:
#   filename:  metadataIngestion/databaseServiceQueryLineagePipeline.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import filterPattern


class DatabaseLineageConfigType(Enum):
    DatabaseLineage = 'DatabaseLineage'


class DatabaseServiceQueryLineagePipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DatabaseLineageConfigType],
        Field(DatabaseLineageConfigType.DatabaseLineage, description='Pipeline type'),
    ]
    queryLogDuration: Annotated[
        Optional[int],
        Field(
            1,
            description='Configuration to tune how far we want to look back in query logs to process lineage data.',
            title='Query Log Duration',
        ),
    ]
    queryLogFilePath: Annotated[
        Optional[str],
        Field(
            None,
            description='Configuration to set the file path for query logs',
            title='Query Log File Path',
        ),
    ]
    resultLimit: Annotated[
        Optional[int],
        Field(
            1000,
            description='Configuration to set the limit for query logs',
            title='Result Limit',
        ),
    ]
    parsingTimeoutLimit: Annotated[
        Optional[int],
        Field(
            300,
            description='Configuration to set the timeout for parsing the query in seconds.',
            title='Parsing Timeout Limit',
        ),
    ]
    filterCondition: Annotated[
        Optional[str],
        Field(
            None,
            description='Configuration the condition to filter the query history.',
            title='Filter Condition',
        ),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch tables or databases that matches the pattern.',
            title='Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude tables or databases that matches the pattern.',
            title='Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch databases that matches the pattern.',
            title='Database Filter Pattern',
        ),
    ]
