# generated by datamodel-codegen:
#   filename:  security/secrets/secretsManagerConfiguration.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import secretsManagerProvider


class SecretsManagerConfiguration(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    secretsManager: Annotated[
        Optional[secretsManagerProvider.SecretsManagerProvider],
        Field(
            'noop',
            description='OpenMetadata Secrets Manager Provider. Make sure to configure the same secrets manager providers as the ones configured on the OpenMetadata server.',
            title='Secrets Manager Provider',
        ),
    ]
    prefix: Annotated[
        Optional[str],
        Field(
            None,
            description='Prefix to be added to the secret key ID: `/<prefix>/<clusterName>/<key>`',
            title='Secret ID Prefix',
        ),
    ]
    tags: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Add tags to the created resource, e.g., in AWS. Format is `[key1:value1,key2:value2,...]`',
            title='Secret Resource Tags',
        ),
    ]
    parameters: Annotated[
        Optional[Dict[str, Any]],
        Field(
            None,
            description='Extra parameters used by the Secrets Manager implementation.',
            title='Parameters',
        ),
    ]
