# generated by datamodel-codegen:
#   filename:  api/services/createSearchService.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.services import searchService
from ...type import basic, entityReferenceList, tagLabel


class CreateSearchServiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies the this entity instance uniquely'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this search service. It could be title or label from the source services.',
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of search service entity.'),
    ]
    serviceType: searchService.SearchServiceType
    connection: Optional[searchService.SearchConnection] = None
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Search Service.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this search service.'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domain: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully qualified name of the domain the Search Service belongs to.',
        ),
    ]
