# generated by datamodel-codegen:
#   filename:  entity/data/metrics.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    tagLabel,
    usageDetails,
    votes,
)


class Metrics(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies this metrics instance.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this metrics instance uniquely.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="A unique name that identifies a metric in the format 'ServiceName.MetricName'.",
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this metric.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of metrics instance, what it is, and how to use it.',
        ),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this metrics.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this chart.'),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(description='Link to service where this metrics is hosted in.'),
    ]
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this database.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Domain the Metrics belongs to.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
