# generated by datamodel-codegen:
#   filename:  entity/events/webhook.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class Webhook(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    receivers: Annotated[
        Optional[List[str]],
        Field(None, description='List of receivers to send mail to'),
    ]
    endpoint: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Endpoint to receive the webhook events over POST requests.',
        ),
    ]
    secretKey: Annotated[
        Optional[str],
        Field(
            None,
            description='Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.',
        ),
    ]
    sendToAdmins: Annotated[
        Optional[bool], Field(False, description='Send the Event to Admins')
    ]
    sendToOwners: Annotated[
        Optional[bool], Field(False, description='Send the Event to Owners')
    ]
    sendToFollowers: Annotated[
        Optional[bool], Field(False, description='Send the Event to Followers')
    ]


class EntityName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Unique name of the application receiving webhook events.',
            max_length=128,
            min_length=1,
            pattern="(?u)^[\\w'\\-.]+$",
        ),
    ]
