# generated by datamodel-codegen:
#   filename:  entity/services/connections/connectionBasicType.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from typing import Any, Dict, Optional, Union

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....security.credentials import awsCredentials


class ConnectionType(RootModel[Any]):
    root: Annotated[
        Any,
        Field(
            description='This schema defines basic common types that are used by other schemas.',
            title='ConnectionType',
        ),
    ]


class ConnectionOptions(RootModel[Optional[Dict[str, str]]]):
    root: Optional[Dict[str, str]] = None


class ConnectionArguments(RootModel[Optional[Dict[str, Any]]]):
    root: Optional[Dict[str, Any]] = None


class SupportsMetadataExtraction(RootModel[bool]):
    root: Annotated[bool, Field(description='Supports Metadata Extraction.')]


class SupportsUsageExtraction(RootModel[bool]):
    root: Annotated[bool, Field(description='Supports Usage Extraction.')]


class SupportsLineageExtraction(RootModel[bool]):
    root: Annotated[bool, Field(description='Supports Lineage Extraction.')]


class SupportsProfiler(RootModel[bool]):
    root: Annotated[bool, Field(description='Supports Profiler')]


class SupportsDatabase(RootModel[bool]):
    root: Annotated[
        bool,
        Field(
            description='The source service supports the database concept in its hierarchy'
        ),
    ]


class SupportsQueryComment(RootModel[bool]):
    root: Annotated[
        bool,
        Field(
            description='For Database Services using SQLAlchemy, True to enable running a comment for all queries run from OpenMetadata.'
        ),
    ]


class SupportsDataInsightExtraction(RootModel[bool]):
    root: Annotated[bool, Field(description='Support Metadata To Elastic Search')]


class SupportsElasticSearchReindexingExtraction(RootModel[bool]):
    root: Annotated[bool, Field(description='Support Elastic Search Reindexing')]


class SupportsDBTExtraction(RootModel[bool]):
    root: Annotated[bool, Field(description='Supports DBT Extraction.')]


class DataStorageConfig(BaseModel):
    bucketName: Annotated[
        Optional[str], Field('', description='Bucket Name', title='Bucket Name')
    ]
    prefix: Annotated[
        Optional[str],
        Field('', description='Prefix of the data source.', title='Prefix'),
    ]
    filePathPattern: Annotated[
        Optional[str],
        Field(
            '{service_name}/{database_name}/{database_schema_name}/{table_name}/sample_data.parquet',
            description='Provide the pattern of the path where the generated sample data file needs to be stored.',
            title='File Path Pattern',
        ),
    ]
    overwriteData: Annotated[
        Optional[bool],
        Field(
            True,
            description='When this field enabled a single parquet file will be created to store sample data, otherwise we will create a new file per day',
            title='Overwrite Sample Data',
        ),
    ]
    storageConfig: Optional[Union[awsCredentials.AWSCredentials, Dict[str, Any]]] = None


class SampleDataStorageConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    config: Optional[Union[DataStorageConfig, Dict[str, Any]]] = None
