# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/powerbi/gcsConfig.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......security.credentials import gcpCredentials
from . import bucketDetails


class PbitFileConfigType(Enum):
    gcs = 'gcs'


class GCSConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    pbitFileConfigType: Annotated[
        Optional[PbitFileConfigType],
        Field(PbitFileConfigType.gcs, description='pbit File Configuration type'),
    ]
    securityConfig: Annotated[
        gcpCredentials.GCPCredentials, Field(title='GCS Security Config')
    ]
    prefixConfig: Annotated[
        Optional[bucketDetails.BucketDetails], Field(None, title='Prefix Config')
    ]
    pbitFilesExtractDir: Annotated[
        Optional[str],
        Field(
            '/tmp/pbitFiles',
            description='Path of the folder where the .pbit files will be unzipped and datamodel schema will be extracted',
            title='pbit Files Extraction Directory',
        ),
    ]
