# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/sasConnection.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr


class SasType(Enum):
    SAS = 'SAS'


class SASConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[Optional[SasType], Field(SasType.SAS, description='Service Type')]
    username: Annotated[str, Field(description='Username to connect to SAS Viya.')]
    password: Annotated[
        CustomSecretStr, Field(description='Password to connect to SAS Viya')
    ]
    serverHost: Annotated[AnyUrl, Field(description='Hostname of SAS Viya deployment.')]
    datatables: Annotated[
        Optional[bool], Field(True, description='Enable datatables for ingestion')
    ]
    dataTablesCustomFilter: Annotated[
        Optional[Union[Dict[str, Any], str]],
        Field(
            None,
            description='Custom filter for datatables',
            title='Custom Filter for datatables',
        ),
    ]
    reports: Annotated[
        Optional[bool], Field(False, description='Enable report for ingestion')
    ]
    reportsCustomFilter: Annotated[
        Optional[Union[Dict[str, Any], str]],
        Field(
            None,
            description='Custom filter for reports',
            title='Custom Filter for reports',
        ),
    ]
    dataflows: Annotated[
        Optional[bool], Field(False, description='Enable dataflow for ingestion')
    ]
    dataflowsCustomFilter: Annotated[
        Optional[Union[Dict[str, Any], str]],
        Field(
            None,
            description='Custom filter for dataflows',
            title='Custom Filter for dataflows',
        ),
    ]
