# generated by datamodel-codegen:
#   filename:  system/ui/page.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import entityReference, entityReferenceList


class EntityType(Enum):
    Page = 'Page'


class PageType(Enum):
    LandingPage = 'LandingPage'
    TableLandingPage = 'TableLandingPage'
    StoredProcedureLandingPage = 'StoredProcedureLandingPage'
    DatabaseLandingPage = 'DatabaseLandingPage'
    DatabaseSchemaLandingPage = 'DatabaseSchemaLandingPage'
    TopicLandingPage = 'TopicLandingPage'
    PipelineLandingPage = 'PipelineLandingPage'
    DashboardLandingPage = 'DashboardLandingPage'
    DashboardDataModelLandingPage = 'DashboardDataModelLandingPage'
    ContainerLandingPage = 'ContainerLandingPage'
    SearchIndexLandingPage = 'SearchIndexLandingPage'
    GlossaryLandingPage = 'GlossaryLandingPage'
    GlossaryTermLandingPage = 'GlossaryTermLandingPage'
    DomainLandingPage = 'DomainLandingPage'


class Team(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entityType: Annotated[EntityType, Field(description='Entity Type.')]
    pageType: PageType
    layout: Annotated[
        Dict[str, Any], Field(description='Configuration for the Knowledge Panel.')
    ]
    persona: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Persona this page belongs to.'),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Domain this page belongs to.'),
    ]
    knowledgePanels: Annotated[
        entityReferenceList.EntityReferenceList,
        Field(description='KnowledgePanels that are part of this Page.'),
    ]
