# generated by datamodel-codegen:
#   filename:  type/basic.json
#   timestamp: 2024-11-26T06:50:54+00:00

from __future__ import annotations

from datetime import date, time, datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from uuid import UUID

from pydantic import AnyUrl, ConfigDict, EmailStr, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class Basic(RootModel[Any]):
    root: Annotated[
        Any,
        Field(
            description='This schema defines basic common types that are used by other schemas.',
            title='Basic',
        ),
    ]


class Integer(RootModel[int]):
    root: Annotated[int, Field(description='An integer type.')]


class Number(RootModel[int]):
    root: Annotated[
        int,
        Field(
            description='A numeric type that includes integer or floating point numbers.'
        ),
    ]


class String(RootModel[str]):
    root: Annotated[str, Field(description='A String type.')]


class Uuid(RootModel[UUID]):
    root: Annotated[UUID, Field(description='Unique id used to identify an entity.')]


class Email(RootModel[EmailStr]):
    root: Annotated[
        EmailStr,
        Field(
            description='Email address of a user or other entities.',
            max_length=127,
            min_length=6,
            pattern='^[\\S.!#$%&’*+/=?^_`{|}~-]+@\\S+\\.\\S+$',
        ),
    ]


class Timestamp(RootModel[int]):
    root: Annotated[
        int, Field(description='Timestamp in Unix epoch time milliseconds.')
    ]


class Href(RootModel[AnyUrl]):
    root: Annotated[AnyUrl, Field(description='URI that points to a resource.')]


class TimeInterval(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    start: Annotated[
        Optional[int], Field(None, description='Start time in unixTimeMillis.')
    ]
    end: Annotated[
        Optional[int], Field(None, description='End time in unixTimeMillis.')
    ]


class Duration(RootModel[str]):
    root: Annotated[
        str,
        Field(description="Duration in ISO 8601 format in UTC. Example - 'P23DT23H'."),
    ]


class Date(RootModel[date]):
    root: Annotated[
        date,
        Field(description="Date in ISO 8601 format in UTC. Example - '2018-11-13'."),
    ]


class DateTime(RootModel[datetime]):
    root: Annotated[
        datetime,
        Field(
            description="Date and time in ISO 8601 format. Example - '2018-11-13T20:20:39+00:00'."
        ),
    ]


class Time(RootModel[time]):
    root: Annotated[
        time, Field(description="time in ISO 8601 format. Example - '20:20:39+00:00'.")
    ]


class DateCp(RootModel[str]):
    root: Annotated[str, Field(description='Date as defined in custom property.')]


class DateTimeCp(RootModel[str]):
    root: Annotated[
        str, Field(description='Date and time as defined in custom property.')
    ]


class TimeCp(RootModel[str]):
    root: Annotated[str, Field(description='Time as defined in custom property.')]


class EnumModel(RootModel[List[str]]):
    root: Annotated[List[str], Field(description='List of values in Enum.')]


class Timezone(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Timezone of the user in the format `America/Los_Angeles`, `Brazil/East`, etc.'
        ),
    ]


class EntityLink(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Link to an entity or field within an entity using this format `<#E::{entities}::{entityType}::{field}::{arrayFieldName}::{arrayFieldValue}`.',
            pattern='(?u)^<#E::\\w+::(?:[^:<>|]|:[^:<>|])+(?:::(?:[^:<>|]|:[^:<>|])+)*>$',
        ),
    ]


class EntityName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Name that identifies an entity.',
            max_length=256,
            min_length=1,
            
        ),
    ]


class TestCaseEntityName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='Name that identifies a test definition and test case.',
            min_length=1,
            
        ),
    ]


class FullyQualifiedEntityName(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description="A unique name that identifies an entity. Example for table 'DatabaseService.Database.Schema.Table'.",
            max_length=3072,
            min_length=1,
        ),
    ]


class SqlQuery(RootModel[str]):
    root: Annotated[
        str, Field(description="SQL query statement. Example - 'select * from orders'.")
    ]


class SqlFunction(RootModel[str]):
    root: Annotated[
        str, Field(description="SQL function. Example - 'AVG()`, `COUNT()`, etc..")
    ]


class Markdown(RootModel[str]):
    root: Annotated[str, Field(description='Text in Markdown format.')]


class Expression(RootModel[str]):
    root: Annotated[str, Field(description='Expression in SpEL.')]


class JsonSchema(RootModel[str]):
    root: Annotated[
        str,
        Field(
            description='JSON schema encoded as string. This will be used to validate the JSON fields using this schema.'
        ),
    ]


class EntityExtension(RootModel[Any]):
    root: Annotated[
        Any,
        Field(
            description='Entity extension data with custom attributes added to the entity.'
        ),
    ]


class ProviderType(Enum):
    system = 'system'
    user = 'user'


class ComponentConfig(RootModel[Optional[Dict[str, Any]]]):
    root: Optional[Dict[str, Any]] = None


class Status(Enum):
    success = 'success'
    failure = 'failure'
    aborted = 'aborted'
    partialSuccess = 'partialSuccess'


class SourceUrl(RootModel[str]):
    root: Annotated[str, Field(description='Source Url of the respective entity.')]


class Style(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    color: Annotated[
        Optional[str],
        Field(
            None,
            description='Hex Color Code to mark an entity such as GlossaryTerm, Tag, Domain or Data Product.',
        ),
    ]
    iconURL: Annotated[
        Optional[str],
        Field(
            None,
            description='An icon to associate with GlossaryTerm, Tag, Domain or Data Product.',
        ),
    ]
