"""
High-Level Control Library for Franka Robots
"""
from __future__ import annotations
import numpy
import pybind11_stubgen.typing_ext
import typing
__all__ = ['Affine', 'BaseCartesianPoseMotion', 'BaseCartesianVelocityMotion', 'BaseJointPositionMotion', 'BaseJointVelocityMotion', 'BaseTorqueMotion', 'BoolFuture', 'CartesianImpedanceMotion', 'CartesianMotion', 'CartesianPose', 'CartesianPoseReaction', 'CartesianState', 'CartesianStopMotion', 'CartesianVelocities', 'CartesianVelocityMotion', 'CartesianVelocityReaction', 'CartesianVelocityStopMotion', 'CartesianVelocityWaypoint', 'CartesianVelocityWaypointMotion', 'CartesianWaypoint', 'CartesianWaypointMotion', 'CommandException', 'Condition', 'ControlException', 'ControlSignalType', 'ControllerMode', 'DoubleDynamicsLimit', 'Duration', 'ElbowState', 'Errors', 'Exception', 'ExponentialImpedanceMotion', 'FlipDirection', 'Frame', 'Gripper', 'GripperException', 'GripperState', 'ImpedanceMotion', 'IncompatibleVersionException', 'InvalidMotionTypeException', 'InvalidOperationException', 'JointMotion', 'JointPositionReaction', 'JointPositions', 'JointState', 'JointStopMotion', 'JointVelocities', 'JointVelocityMotion', 'JointVelocityReaction', 'JointVelocityStopMotion', 'JointVelocityWaypoint', 'JointVelocityWaypointMotion', 'JointWaypoint', 'JointWaypointMotion', 'Measure', 'Model', 'ModelException', 'NetworkException', 'ProtocolException', 'ReactionRecursionException', 'RealtimeConfig', 'RealtimeException', 'ReferenceType', 'RelativeDynamicsFactor', 'RobotMode', 'RobotPose', 'RobotState', 'RobotVelocity', 'TorqueReaction', 'Torques', 'Twist', 'TwistAcceleration', 'VectorDynamicsLimit']
class Affine:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    @typing.overload
    def __init__(self, transformation_matrix: numpy.ndarray[numpy.float64[4, 4]] = ...) -> None:
        ...
    @typing.overload
    def __init__(self, translation: numpy.ndarray[numpy.float64[3, 1]] = ..., quaternion: numpy.ndarray[numpy.float64[4, 1]] = ...) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: Affine) -> None:
        ...
    def __mul__(self, arg0: Affine) -> Affine:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def inverse(self) -> Affine:
        ...
    @property
    def matrix(self) -> numpy.ndarray[numpy.float64[4, 4]]:
        ...
    @property
    def quaternion(self) -> numpy.ndarray[numpy.float64[4, 1]]:
        ...
    @property
    def translation(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
class BaseCartesianPoseMotion:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def add_reaction(self, arg0: CartesianPoseReaction) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration, _franky.Duration, _franky.CartesianPose], None]) -> None:
        ...
    @property
    def reactions(self) -> list[CartesianPoseReaction]:
        ...
class BaseCartesianVelocityMotion:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def add_reaction(self, arg0: CartesianVelocityReaction) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration, _franky.Duration, _franky.CartesianVelocities], None]) -> None:
        ...
    @property
    def reactions(self) -> list[CartesianVelocityReaction]:
        ...
class BaseJointPositionMotion:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def add_reaction(self, arg0: JointPositionReaction) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration, _franky.Duration, _franky.JointPositions], None]) -> None:
        ...
    @property
    def reactions(self) -> list[JointPositionReaction]:
        ...
class BaseJointVelocityMotion:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def add_reaction(self, arg0: JointVelocityReaction) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration, _franky.Duration, _franky.JointVelocities], None]) -> None:
        ...
    @property
    def reactions(self) -> list[JointVelocityReaction]:
        ...
class BaseTorqueMotion:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def add_reaction(self, arg0: TorqueReaction) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration, _franky.Duration, _franky.Torques], None]) -> None:
        ...
    @property
    def reactions(self) -> list[TorqueReaction]:
        ...
class BoolFuture:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def get(self) -> bool:
        ...
    def wait(self, timeout: float | None = None) -> bool:
        ...
class CartesianImpedanceMotion(ImpedanceMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: Affine, duration: Duration, target_type: ReferenceType = ..., translational_stiffness: float = 2000, rotational_stiffness: float = 200, force_constraints: typing.Annotated[list[float | None], pybind11_stubgen.typing_ext.FixedSize(6)] | None = None, return_when_finished: bool = True, finish_wait_factor: float = 1.2) -> None:
        ...
class CartesianMotion(CartesianWaypointMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: CartesianState | RobotPose | Affine, reference_type: ReferenceType = ..., relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, return_when_finished: bool = True, ee_frame: Affine | None = None) -> None:
        ...
class CartesianPose:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def O_T_EE(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(16)]:
        ...
class CartesianPoseReaction:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, condition: Condition | bool, motion: BaseCartesianPoseMotion = None) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration], None]) -> None:
        ...
class CartesianState:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    @typing.overload
    def __init__(self, pose: RobotPose | Affine) -> None:
        ...
    @typing.overload
    def __init__(self, pose: RobotPose | Affine, velocity: RobotVelocity | Twist) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: CartesianState | RobotPose | Affine) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def __rmul__(self, arg0: Affine) -> CartesianState:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    def change_end_effector_frame(self, transform: Affine) -> CartesianState:
        ...
    def transform_with(self, transform: Affine) -> CartesianState:
        ...
    @property
    def pose(self) -> RobotPose:
        ...
    @property
    def velocity(self) -> RobotVelocity:
        ...
class CartesianStopMotion(BaseCartesianPoseMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0) -> None:
        ...
class CartesianVelocities:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def O_dP_EE(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)]:
        ...
    @property
    def elbow(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(2)]:
        ...
class CartesianVelocityMotion(CartesianVelocityWaypointMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: RobotVelocity | Twist, duration: Duration = ..., relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, ee_frame: Affine | None = None) -> None:
        ...
class CartesianVelocityReaction:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, condition: Condition | bool, motion: BaseCartesianVelocityMotion = None) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration], None]) -> None:
        ...
class CartesianVelocityStopMotion(BaseCartesianVelocityMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0) -> None:
        ...
class CartesianVelocityWaypoint:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: RobotVelocity | Twist, relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, minimum_time: Duration | None = None, hold_target_duration: Duration = ..., max_total_duration: Duration | None = None) -> None:
        ...
    @property
    def hold_target_duration(self) -> Duration:
        ...
    @property
    def max_total_duration(self) -> Duration | None:
        ...
    @property
    def minimum_time(self) -> Duration | None:
        ...
    @property
    def relative_dynamics_factor(self) -> RelativeDynamicsFactor:
        ...
    @property
    def target(self) -> RobotVelocity:
        ...
class CartesianVelocityWaypointMotion(BaseCartesianVelocityMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, waypoints: list[CartesianVelocityWaypoint], ee_frame: Affine | None = None, relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0) -> None:
        ...
class CartesianWaypoint:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: CartesianState | RobotPose | Affine, reference_type: ReferenceType = ..., relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, minimum_time: Duration | None = None, hold_target_duration: Duration = ..., max_total_duration: Duration | None = None) -> None:
        ...
    @property
    def hold_target_duration(self) -> Duration:
        ...
    @property
    def max_total_duration(self) -> Duration | None:
        ...
    @property
    def minimum_time(self) -> Duration | None:
        ...
    @property
    def reference_type(self) -> ReferenceType:
        ...
    @property
    def relative_dynamics_factor(self) -> RelativeDynamicsFactor:
        ...
    @property
    def target(self) -> CartesianState:
        ...
class CartesianWaypointMotion(BaseCartesianPoseMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, waypoints: list[CartesianWaypoint], ee_frame: Affine | None = None, relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, return_when_finished: bool = True) -> None:
        ...
class CommandException(Exception):
    pass
class Condition:
    __hash__: typing.ClassVar[None] = None
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    @typing.overload
    def __and__(self, arg0: Condition | bool) -> Condition:
        ...
    @typing.overload
    def __and__(self, arg0: bool) -> Condition:
        ...
    @typing.overload
    def __eq__(self, arg0: Condition | bool) -> Condition:
        ...
    @typing.overload
    def __eq__(self, arg0: bool) -> Condition:
        ...
    def __init__(self, constant_value: bool) -> None:
        ...
    def __invert__(self) -> Condition:
        ...
    @typing.overload
    def __ne__(self, arg0: Condition | bool) -> Condition:
        ...
    @typing.overload
    def __ne__(self, arg0: bool) -> Condition:
        ...
    @typing.overload
    def __or__(self, arg0: Condition | bool) -> Condition:
        ...
    @typing.overload
    def __or__(self, arg0: bool) -> Condition:
        ...
    def __rand__(self, arg0: Condition | bool) -> Condition:
        ...
    def __repr__(self) -> str:
        ...
    def __ror__(self, arg0: Condition | bool) -> Condition:
        ...
class ControlException(Exception):
    pass
class ControlSignalType:
    """
    Members:
    
      Torques
    
      JointVelocities
    
      JointPositions
    
      CartesianVelocities
    
      CartesianPose
    """
    CartesianPose: typing.ClassVar[ControlSignalType]  # value = <ControlSignalType.CartesianPose: 4>
    CartesianVelocities: typing.ClassVar[ControlSignalType]  # value = <ControlSignalType.CartesianVelocities: 3>
    JointPositions: typing.ClassVar[ControlSignalType]  # value = <ControlSignalType.JointPositions: 2>
    JointVelocities: typing.ClassVar[ControlSignalType]  # value = <ControlSignalType.JointVelocities: 1>
    Torques: typing.ClassVar[ControlSignalType]  # value = <ControlSignalType.Torques: 0>
    __members__: typing.ClassVar[dict[str, ControlSignalType]]  # value = {'Torques': <ControlSignalType.Torques: 0>, 'JointVelocities': <ControlSignalType.JointVelocities: 1>, 'JointPositions': <ControlSignalType.JointPositions: 2>, 'CartesianVelocities': <ControlSignalType.CartesianVelocities: 3>, 'CartesianPose': <ControlSignalType.CartesianPose: 4>}
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class ControllerMode:
    """
    Members:
    
      JointImpedance
    
      CartesianImpedance
    """
    CartesianImpedance: typing.ClassVar[ControllerMode]  # value = <ControllerMode.CartesianImpedance: 1>
    JointImpedance: typing.ClassVar[ControllerMode]  # value = <ControllerMode.JointImpedance: 0>
    __members__: typing.ClassVar[dict[str, ControllerMode]]  # value = {'JointImpedance': <ControllerMode.JointImpedance: 0>, 'CartesianImpedance': <ControllerMode.CartesianImpedance: 1>}
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class DoubleDynamicsLimit:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __repr__(self) -> str:
        ...
    def get(self) -> float:
        ...
    def set(self, value: float) -> None:
        ...
    @property
    def desc(self) -> str:
        ...
    @property
    def max(self) -> float:
        ...
class Duration:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __add__(self, arg0: Duration) -> Duration:
        ...
    def __getstate__(self) -> tuple:
        ...
    def __iadd__(self, arg0: Duration) -> Duration:
        ...
    def __imul__(self, arg0: int) -> Duration:
        ...
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: int) -> None:
        ...
    def __isub__(self, arg0: Duration) -> Duration:
        ...
    def __itruediv__(self, arg0: int) -> Duration:
        ...
    def __mul__(self, arg0: int) -> Duration:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    def __sub__(self, arg0: Duration) -> Duration:
        ...
    def __truediv__(self, arg0: int) -> Duration:
        ...
    def to_msec(self) -> int:
        ...
    def to_sec(self) -> float:
        ...
class ElbowState:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    @typing.overload
    def __init__(self, joint_3_pos: float, joint_4_flip: FlipDirection | None = None) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: ElbowState) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def joint_3_pos(self) -> float:
        ...
    @property
    def joint_4_flip(self) -> FlipDirection | None:
        ...
class Errors:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    def __init__(self) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def base_acceleration_initialization_timeout(self) -> bool:
        ...
    @property
    def base_acceleration_invalid_reading(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_acceleration_discontinuity(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_elbow_limit_violation(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_elbow_sign_inconsistent(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_joint_acceleration_discontinuity(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_joint_position_limits_violation(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_joint_velocity_discontinuity(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_joint_velocity_limits_violation(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_start_elbow_invalid(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_velocity_discontinuity(self) -> bool:
        ...
    @property
    def cartesian_motion_generator_velocity_limits_violation(self) -> bool:
        ...
    @property
    def cartesian_position_limits_violation(self) -> bool:
        ...
    @property
    def cartesian_position_motion_generator_invalid_frame(self) -> bool:
        ...
    @property
    def cartesian_position_motion_generator_start_pose_invalid(self) -> bool:
        ...
    @property
    def cartesian_reflex(self) -> bool:
        ...
    @property
    def cartesian_spline_motion_generator_violation(self) -> bool:
        ...
    @property
    def cartesian_velocity_profile_safety_violation(self) -> bool:
        ...
    @property
    def cartesian_velocity_violation(self) -> bool:
        ...
    @property
    def communication_constraints_violation(self) -> bool:
        ...
    @property
    def controller_torque_discontinuity(self) -> bool:
        ...
    @property
    def force_control_safety_violation(self) -> bool:
        ...
    @property
    def force_controller_desired_force_tolerance_violation(self) -> bool:
        ...
    @property
    def instability_detected(self) -> bool:
        ...
    @property
    def joint_motion_generator_acceleration_discontinuity(self) -> bool:
        ...
    @property
    def joint_motion_generator_position_limits_violation(self) -> bool:
        ...
    @property
    def joint_motion_generator_velocity_discontinuity(self) -> bool:
        ...
    @property
    def joint_motion_generator_velocity_limits_violation(self) -> bool:
        ...
    @property
    def joint_move_in_wrong_direction(self) -> bool:
        ...
    @property
    def joint_p2p_insufficient_torque_for_planning(self) -> bool:
        ...
    @property
    def joint_position_limits_violation(self) -> bool:
        ...
    @property
    def joint_position_motion_generator_start_pose_invalid(self) -> bool:
        ...
    @property
    def joint_reflex(self) -> bool:
        ...
    @property
    def joint_velocity_violation(self) -> bool:
        ...
    @property
    def joint_via_motion_generator_planning_joint_limit_violation(self) -> bool:
        ...
    @property
    def max_goal_pose_deviation_violation(self) -> bool:
        ...
    @property
    def max_path_pose_deviation_violation(self) -> bool:
        ...
    @property
    def power_limit_violation(self) -> bool:
        ...
    @property
    def self_collision_avoidance_violation(self) -> bool:
        ...
    @property
    def start_elbow_sign_inconsistent(self) -> bool:
        ...
    @property
    def tau_j_range_violation(self) -> bool:
        ...
class Exception(Exception):
    pass
class ExponentialImpedanceMotion(ImpedanceMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: Affine, target_type: ReferenceType = ..., translational_stiffness: float = 2000, rotational_stiffness: float = 200, force_constraints: typing.Annotated[list[float | None], pybind11_stubgen.typing_ext.FixedSize(6)] | None = None, exponential_decay: float = 0.005) -> None:
        ...
class FlipDirection:
    """
    Members:
    
      Negative
    
      Neutral
    
      Positive
    """
    Negative: typing.ClassVar[FlipDirection]  # value = <FlipDirection.Negative: -1>
    Neutral: typing.ClassVar[FlipDirection]  # value = <FlipDirection.Neutral: 0>
    Positive: typing.ClassVar[FlipDirection]  # value = <FlipDirection.Positive: 1>
    __members__: typing.ClassVar[dict[str, FlipDirection]]  # value = {'Negative': <FlipDirection.Negative: -1>, 'Neutral': <FlipDirection.Neutral: 0>, 'Positive': <FlipDirection.Positive: 1>}
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class Frame:
    """
    Members:
    
      Joint1
    
      Joint2
    
      Joint3
    
      Joint4
    
      Joint5
    
      Joint6
    
      Joint7
    
      Flange
    
      EndEffector
    
      Stiffness
    """
    EndEffector: typing.ClassVar[Frame]  # value = <Frame.EndEffector: 8>
    Flange: typing.ClassVar[Frame]  # value = <Frame.Flange: 7>
    Joint1: typing.ClassVar[Frame]  # value = <Frame.Joint1: 0>
    Joint2: typing.ClassVar[Frame]  # value = <Frame.Joint2: 1>
    Joint3: typing.ClassVar[Frame]  # value = <Frame.Joint3: 2>
    Joint4: typing.ClassVar[Frame]  # value = <Frame.Joint4: 3>
    Joint5: typing.ClassVar[Frame]  # value = <Frame.Joint5: 4>
    Joint6: typing.ClassVar[Frame]  # value = <Frame.Joint6: 5>
    Joint7: typing.ClassVar[Frame]  # value = <Frame.Joint7: 6>
    Stiffness: typing.ClassVar[Frame]  # value = <Frame.Stiffness: 9>
    __members__: typing.ClassVar[dict[str, Frame]]  # value = {'Joint1': <Frame.Joint1: 0>, 'Joint2': <Frame.Joint2: 1>, 'Joint3': <Frame.Joint3: 2>, 'Joint4': <Frame.Joint4: 3>, 'Joint5': <Frame.Joint5: 4>, 'Joint6': <Frame.Joint6: 5>, 'Joint7': <Frame.Joint7: 6>, 'Flange': <Frame.Flange: 7>, 'EndEffector': <Frame.EndEffector: 8>, 'Stiffness': <Frame.Stiffness: 9>}
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class Gripper:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, fci_hostname: str) -> None:
        ...
    def grasp(self, width: float, speed: float, force: float, epsilon_inner: float = 0.005, epsilon_outer: float = 0.005) -> bool:
        ...
    def grasp_async(self, width: float, speed: float, force: float, epsilon_inner: float = 0.005, epsilon_outer: float = 0.005) -> BoolFuture:
        ...
    def homing(self) -> bool:
        ...
    def homing_async(self) -> BoolFuture:
        ...
    def move(self, width: float, speed: float) -> bool:
        ...
    def move_async(self, width: float, speed: float) -> BoolFuture:
        ...
    def open(self, speed: float) -> bool:
        ...
    def open_async(self, speed: float) -> BoolFuture:
        ...
    def stop(self) -> bool:
        ...
    def stop_async(self) -> BoolFuture:
        ...
    @property
    def is_grasped(self) -> bool:
        ...
    @property
    def max_width(self) -> float:
        ...
    @property
    def server_version(self) -> int:
        ...
    @property
    def state(self) -> GripperState:
        ...
    @property
    def width(self) -> float:
        ...
class GripperException(Exception):
    pass
class GripperState:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def is_grasped(self) -> bool:
        ...
    @property
    def max_width(self) -> float:
        ...
    @property
    def temperature(self) -> int:
        ...
    @property
    def time(self) -> Duration:
        ...
    @property
    def width(self) -> float:
        ...
class ImpedanceMotion(BaseTorqueMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
class IncompatibleVersionException(Exception):
    pass
class InvalidMotionTypeException(Exception):
    pass
class InvalidOperationException(Exception):
    pass
class JointMotion(JointWaypointMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: JointState | list[float] | np.ndarray, reference_type: ReferenceType = ..., relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, return_when_finished: bool = True) -> None:
        ...
class JointPositionReaction:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, condition: Condition | bool, motion: BaseJointPositionMotion = None) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration], None]) -> None:
        ...
class JointPositions:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def q(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)]:
        ...
class JointState:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    @typing.overload
    def __init__(self, position: numpy.ndarray[numpy.float64[7, 1]]) -> None:
        ...
    @typing.overload
    def __init__(self, position: numpy.ndarray[numpy.float64[7, 1]], velocity: numpy.ndarray[numpy.float64[7, 1]]) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: JointState | list[float] | np.ndarray) -> None:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def position(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def velocity(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
class JointStopMotion(BaseJointPositionMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0) -> None:
        ...
class JointVelocities:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def dq(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)]:
        ...
class JointVelocityMotion(JointVelocityWaypointMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: numpy.ndarray[numpy.float64[7, 1]], duration: Duration = ..., relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0) -> None:
        ...
class JointVelocityReaction:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, condition: Condition | bool, motion: BaseJointVelocityMotion = None) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration], None]) -> None:
        ...
class JointVelocityStopMotion(BaseJointVelocityMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0) -> None:
        ...
class JointVelocityWaypoint:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: numpy.ndarray[numpy.float64[7, 1]], relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, minimum_time: Duration | None = None, hold_target_duration: Duration = ..., max_total_duration: Duration | None = None) -> None:
        ...
    @property
    def hold_target_duration(self) -> Duration:
        ...
    @property
    def max_total_duration(self) -> Duration | None:
        ...
    @property
    def minimum_time(self) -> Duration | None:
        ...
    @property
    def relative_dynamics_factor(self) -> RelativeDynamicsFactor:
        ...
    @property
    def target(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
class JointVelocityWaypointMotion(BaseJointVelocityMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, waypoints: list[JointVelocityWaypoint], relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0) -> None:
        ...
class JointWaypoint:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, target: JointState | list[float] | np.ndarray, reference_type: ReferenceType = ..., relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, minimum_time: Duration | None = None, hold_target_duration: Duration = ..., max_total_duration: Duration | None = None) -> None:
        ...
    @property
    def hold_target_duration(self) -> Duration:
        ...
    @property
    def max_total_duration(self) -> Duration | None:
        ...
    @property
    def minimum_time(self) -> Duration | None:
        ...
    @property
    def reference_type(self) -> ReferenceType:
        ...
    @property
    def relative_dynamics_factor(self) -> RelativeDynamicsFactor:
        ...
    @property
    def target(self) -> JointState:
        ...
class JointWaypointMotion(BaseJointPositionMotion):
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, waypoints: list[JointWaypoint], relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, return_when_finished: bool = True) -> None:
        ...
class Measure:
    ABS_TIME: typing.ClassVar[Measure]  # value = t
    FORCE_X: typing.ClassVar[Measure]  # value = F_x
    FORCE_Y: typing.ClassVar[Measure]  # value = F_y
    FORCE_Z: typing.ClassVar[Measure]  # value = F_z
    REL_TIME: typing.ClassVar[Measure]  # value = t
    __hash__: typing.ClassVar[None] = None
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    @typing.overload
    def __add__(self, arg0: Measure) -> Measure:
        ...
    @typing.overload
    def __add__(self, arg0: float) -> Measure:
        ...
    @typing.overload
    def __eq__(self, arg0: Measure) -> Condition:
        ...
    @typing.overload
    def __eq__(self, arg0: float) -> Condition:
        ...
    @typing.overload
    def __ge__(self, arg0: Measure) -> Condition:
        ...
    @typing.overload
    def __ge__(self, arg0: float) -> Condition:
        ...
    @typing.overload
    def __gt__(self, arg0: Measure) -> Condition:
        ...
    @typing.overload
    def __gt__(self, arg0: float) -> Condition:
        ...
    @typing.overload
    def __le__(self, arg0: Measure) -> Condition:
        ...
    @typing.overload
    def __le__(self, arg0: float) -> Condition:
        ...
    @typing.overload
    def __lt__(self, arg0: Measure) -> Condition:
        ...
    @typing.overload
    def __lt__(self, arg0: float) -> Condition:
        ...
    @typing.overload
    def __mul__(self, arg0: Measure) -> Measure:
        ...
    @typing.overload
    def __mul__(self, arg0: float) -> Measure:
        ...
    @typing.overload
    def __ne__(self, arg0: Measure) -> Condition:
        ...
    @typing.overload
    def __ne__(self, arg0: float) -> Condition:
        ...
    def __neg__(self) -> Measure:
        ...
    @typing.overload
    def __pow__(self, arg0: Measure) -> Measure:
        ...
    @typing.overload
    def __pow__(self, arg0: float) -> Measure:
        ...
    def __radd__(self, arg0: float) -> Measure:
        ...
    def __repr__(self) -> str:
        ...
    def __rmul__(self, arg0: float) -> Measure:
        ...
    def __rpow__(self, arg0: float) -> Measure:
        ...
    def __rsub__(self, arg0: float) -> Measure:
        ...
    def __rtruediv__(self, arg0: float) -> Measure:
        ...
    @typing.overload
    def __sub__(self, arg0: Measure) -> Measure:
        ...
    @typing.overload
    def __sub__(self, arg0: float) -> Measure:
        ...
    @typing.overload
    def __truediv__(self, arg0: Measure) -> Measure:
        ...
    @typing.overload
    def __truediv__(self, arg0: float) -> Measure:
        ...
class Model:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    @typing.overload
    def body_jacobian(self, frame: Frame, state: RobotState) -> numpy.ndarray[numpy.float64[6, 7]]:
        ...
    @typing.overload
    def body_jacobian(self, frame: Frame, q: numpy.ndarray[numpy.float64[7, 1]], F_T_EE: Affine, EE_T_K: Affine) -> numpy.ndarray[numpy.float64[6, 7]]:
        ...
    @typing.overload
    def coriolis(self, state: RobotState) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @typing.overload
    def coriolis(self, q: numpy.ndarray[numpy.float64[7, 1]], dq: numpy.ndarray[numpy.float64[7, 1]], I_total: numpy.ndarray[numpy.float64[3, 3]], m_total: float, F_x_Ctotal: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @typing.overload
    def gravity(self, state: RobotState, gravity_earth: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @typing.overload
    def gravity(self, state: RobotState) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @typing.overload
    def gravity(self, q: numpy.ndarray[numpy.float64[7, 1]], m_total: float, F_x_Ctotal: numpy.ndarray[numpy.float64[3, 1]], gravity_earth: numpy.ndarray[numpy.float64[3, 1]] = ...) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @typing.overload
    def mass(self, state: RobotState) -> numpy.ndarray[numpy.float64[7, 7]]:
        ...
    @typing.overload
    def mass(self, q: numpy.ndarray[numpy.float64[7, 1]], I_total: numpy.ndarray[numpy.float64[3, 3]], m_total: float, F_x_Ctotal: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[7, 7]]:
        ...
    @typing.overload
    def pose(self, frame: Frame, state: RobotState) -> Affine:
        ...
    @typing.overload
    def pose(self, frame: Frame, q: numpy.ndarray[numpy.float64[7, 1]], F_T_EE: Affine, EE_T_K: Affine) -> Affine:
        ...
    @typing.overload
    def zero_jacobian(self, frame: Frame, state: RobotState) -> numpy.ndarray[numpy.float64[6, 7]]:
        ...
    @typing.overload
    def zero_jacobian(self, frame: Frame, q: numpy.ndarray[numpy.float64[7, 1]], F_T_EE: Affine, EE_T_K: Affine) -> numpy.ndarray[numpy.float64[6, 7]]:
        ...
class ModelException(Exception):
    pass
class NetworkException(Exception):
    pass
class ProtocolException(Exception):
    pass
class ReactionRecursionException(Exception):
    pass
class RealtimeConfig:
    """
    Members:
    
      Enforce
    
      Ignore
    """
    Enforce: typing.ClassVar[RealtimeConfig]  # value = <RealtimeConfig.Enforce: 0>
    Ignore: typing.ClassVar[RealtimeConfig]  # value = <RealtimeConfig.Ignore: 1>
    __members__: typing.ClassVar[dict[str, RealtimeConfig]]  # value = {'Enforce': <RealtimeConfig.Enforce: 0>, 'Ignore': <RealtimeConfig.Ignore: 1>}
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class RealtimeException(Exception):
    pass
class ReferenceType:
    """
    Members:
    
      Relative
    
      Absolute
    """
    Absolute: typing.ClassVar[ReferenceType]  # value = <ReferenceType.Absolute: 0>
    Relative: typing.ClassVar[ReferenceType]  # value = <ReferenceType.Relative: 1>
    __members__: typing.ClassVar[dict[str, ReferenceType]]  # value = {'Relative': <ReferenceType.Relative: 1>, 'Absolute': <ReferenceType.Absolute: 0>}
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class RelativeDynamicsFactor:
    MAX_DYNAMICS: typing.ClassVar[RelativeDynamicsFactor]  # value = <_franky.RelativeDynamicsFactor object>
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    @typing.overload
    def __init__(self) -> None:
        ...
    @typing.overload
    def __init__(self, value: float) -> None:
        ...
    @typing.overload
    def __init__(self, velocity: float, acceleration: float, jerk: float) -> None:
        ...
    def __mul__(self, arg0: RelativeDynamicsFactor | float) -> RelativeDynamicsFactor:
        ...
    @property
    def acceleration(self) -> float:
        ...
    @property
    def jerk(self) -> float:
        ...
    @property
    def max_dynamics(self) -> bool:
        ...
    @property
    def velocity(self) -> float:
        ...
class RobotMode:
    """
    Members:
    
      Other
    
      Idle
    
      Move
    
      Guiding
    
      Reflex
    
      UserStopped
    
      AutomaticErrorRecovery
    """
    AutomaticErrorRecovery: typing.ClassVar[RobotMode]  # value = <RobotMode.AutomaticErrorRecovery: 6>
    Guiding: typing.ClassVar[RobotMode]  # value = <RobotMode.Guiding: 3>
    Idle: typing.ClassVar[RobotMode]  # value = <RobotMode.Idle: 1>
    Move: typing.ClassVar[RobotMode]  # value = <RobotMode.Move: 2>
    Other: typing.ClassVar[RobotMode]  # value = <RobotMode.Other: 0>
    Reflex: typing.ClassVar[RobotMode]  # value = <RobotMode.Reflex: 4>
    UserStopped: typing.ClassVar[RobotMode]  # value = <RobotMode.UserStopped: 5>
    __members__: typing.ClassVar[dict[str, RobotMode]]  # value = {'Other': <RobotMode.Other: 0>, 'Idle': <RobotMode.Idle: 1>, 'Move': <RobotMode.Move: 2>, 'Guiding': <RobotMode.Guiding: 3>, 'Reflex': <RobotMode.Reflex: 4>, 'UserStopped': <RobotMode.UserStopped: 5>, 'AutomaticErrorRecovery': <RobotMode.AutomaticErrorRecovery: 6>}
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __eq__(self, other: typing.Any) -> bool:
        ...
    def __getstate__(self) -> int:
        ...
    def __hash__(self) -> int:
        ...
    def __index__(self) -> int:
        ...
    def __init__(self, value: int) -> None:
        ...
    def __int__(self) -> int:
        ...
    def __ne__(self, other: typing.Any) -> bool:
        ...
    def __repr__(self) -> str:
        ...
    def __setstate__(self, state: int) -> None:
        ...
    def __str__(self) -> str:
        ...
    @property
    def name(self) -> str:
        ...
    @property
    def value(self) -> int:
        ...
class RobotPose:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    @typing.overload
    def __init__(self, end_effector_pose: Affine, elbow_state: ElbowState | None = None) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: RobotPose | Affine) -> None:
        ...
    def __mul__(self, arg0: Affine) -> RobotPose:
        ...
    def __repr__(self) -> str:
        ...
    def __rmul__(self, arg0: Affine) -> RobotPose:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    def change_end_effector_frame(self, offset_world_frame: Affine) -> RobotPose:
        ...
    def with_elbow_state(self, elbow_state: ElbowState | None) -> RobotPose:
        ...
    @property
    def elbow_state(self) -> ElbowState | None:
        ...
    @property
    def end_effector_pose(self) -> Affine:
        ...
class RobotState:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def EE_T_K(self) -> Affine:
        ...
    @property
    def F_T_EE(self) -> Affine:
        ...
    @property
    def F_T_NE(self) -> Affine:
        ...
    @property
    def F_x_Cee(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
    @property
    def F_x_Cload(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
    @property
    def F_x_Ctotal(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
    @property
    def I_ee(self) -> numpy.ndarray[numpy.float64[3, 3]]:
        ...
    @property
    def I_load(self) -> numpy.ndarray[numpy.float64[3, 3]]:
        ...
    @property
    def I_total(self) -> numpy.ndarray[numpy.float64[3, 3]]:
        ...
    @property
    def K_F_ext_hat_K(self) -> numpy.ndarray[numpy.float64[6, 1]]:
        ...
    @property
    def NE_T_EE(self) -> Affine:
        ...
    @property
    def O_F_ext_hat_K(self) -> numpy.ndarray[numpy.float64[6, 1]]:
        ...
    @property
    def O_T_EE(self) -> Affine:
        ...
    @property
    def O_T_EE_c(self) -> Affine:
        ...
    @property
    def O_T_EE_d(self) -> Affine:
        ...
    @property
    def O_dP_EE_c(self) -> Twist:
        ...
    @property
    def O_dP_EE_d(self) -> Twist:
        ...
    @property
    def O_dP_EE_est(self) -> Twist | None:
        ...
    @property
    def O_ddP_EE_c(self) -> TwistAcceleration:
        ...
    @property
    def O_ddP_EE_est(self) -> TwistAcceleration | None:
        ...
    @property
    def O_ddP_O(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
    @property
    def cartesian_collision(self) -> numpy.ndarray[numpy.float64[6, 1]]:
        ...
    @property
    def cartesian_contact(self) -> numpy.ndarray[numpy.float64[6, 1]]:
        ...
    @property
    def control_command_success_rate(self) -> float:
        ...
    @property
    def current_errors(self) -> Errors:
        ...
    @property
    def ddelbow_c(self) -> float:
        ...
    @property
    def ddelbow_est(self) -> float | None:
        ...
    @property
    def ddq_d(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def ddq_est(self) -> numpy.ndarray[numpy.float64[7, 1]] | None:
        ...
    @property
    def delbow_c(self) -> float:
        ...
    @property
    def delbow_est(self) -> float | None:
        ...
    @property
    def dq(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def dq_d(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def dq_est(self) -> numpy.ndarray[numpy.float64[7, 1]] | None:
        ...
    @property
    def dtau_J(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def dtheta(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def elbow(self) -> ElbowState:
        ...
    @property
    def elbow_c(self) -> ElbowState:
        ...
    @property
    def elbow_d(self) -> ElbowState:
        ...
    @property
    def joint_collision(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def joint_contact(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def last_motion_errors(self) -> Errors:
        ...
    @property
    def m_ee(self) -> float:
        ...
    @property
    def m_load(self) -> float:
        ...
    @property
    def m_total(self) -> float:
        ...
    @property
    def q(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def q_d(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def q_est(self) -> numpy.ndarray[numpy.float64[7, 1]] | None:
        ...
    @property
    def robot_mode(self) -> RobotMode:
        ...
    @property
    def tau_J(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def tau_J_d(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def tau_ext_hat_filtered(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def theta(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def time(self) -> Duration:
        ...
class RobotVelocity:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    @typing.overload
    def __init__(self, end_effector_twist: Twist, elbow_velocity: float | None = None) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: RobotVelocity | Twist) -> None:
        ...
    def __repr__(self) -> str:
        ...
    @typing.overload
    def __rmul__(self, arg0: Affine) -> RobotVelocity:
        ...
    @typing.overload
    def __rmul__(self, arg0: numpy.ndarray[numpy.float64[4, 1]]) -> RobotVelocity:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    def change_end_effector_frame(self, offset_world_frame: numpy.ndarray[numpy.float64[3, 1]]) -> RobotVelocity:
        ...
    def with_elbow_velocity(self, elbow_velocity: float | None) -> RobotVelocity:
        ...
    @property
    def elbow_velocity(self) -> float | None:
        ...
    @property
    def end_effector_twist(self) -> Twist:
        ...
class TorqueReaction:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, condition: Condition | bool, motion: BaseTorqueMotion = None) -> None:
        ...
    def register_callback(self, callback: typing.Callable[[_franky.RobotState, _franky.Duration, _franky.Duration], None]) -> None:
        ...
class Torques:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    @property
    def tau_J(self) -> typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)]:
        ...
class Twist:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    @typing.overload
    def __init__(self, linear_velocity: numpy.ndarray[numpy.float64[3, 1]] | None = None, angular_velocity: numpy.ndarray[numpy.float64[3, 1]] | None = None) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: Twist) -> None:
        ...
    def __repr__(self) -> str:
        ...
    @typing.overload
    def __rmul__(self, arg0: Affine) -> Twist:
        ...
    @typing.overload
    def __rmul__(self, arg0: numpy.ndarray[numpy.float64[4, 1]]) -> Twist:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    def propagate_through_link(self, link_translation: numpy.ndarray[numpy.float64[3, 1]]) -> Twist:
        ...
    @typing.overload
    def transform_with(self, affine: Affine) -> Twist:
        ...
    @typing.overload
    def transform_with(self, quaternion: numpy.ndarray[numpy.float64[4, 1]]) -> Twist:
        ...
    @property
    def angular(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
    @property
    def linear(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
class TwistAcceleration:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __getstate__(self) -> tuple:
        ...
    @typing.overload
    def __init__(self, linear_acceleration: numpy.ndarray[numpy.float64[3, 1]] | None = None, angular_acceleration: numpy.ndarray[numpy.float64[3, 1]] | None = None) -> None:
        ...
    @typing.overload
    def __init__(self, arg0: TwistAcceleration) -> None:
        ...
    def __repr__(self) -> str:
        ...
    @typing.overload
    def __rmul__(self, arg0: Affine) -> TwistAcceleration:
        ...
    @typing.overload
    def __rmul__(self, arg0: numpy.ndarray[numpy.float64[4, 1]]) -> TwistAcceleration:
        ...
    def __setstate__(self, arg0: tuple) -> None:
        ...
    def propagate_through_link(self, link_translation: numpy.ndarray[numpy.float64[3, 1]], base_angular_acceleration: numpy.ndarray[numpy.float64[3, 1]]) -> TwistAcceleration:
        ...
    @typing.overload
    def transform_with(self, affine: Affine) -> TwistAcceleration:
        ...
    @typing.overload
    def transform_with(self, quaternion: numpy.ndarray[numpy.float64[4, 1]]) -> TwistAcceleration:
        ...
    @property
    def angular(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
    @property
    def linear(self) -> numpy.ndarray[numpy.float64[3, 1]]:
        ...
class VectorDynamicsLimit:
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __repr__(self) -> str:
        ...
    def get(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    def set(self, value: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)] | numpy.ndarray[numpy.float64[7, 1]]) -> None:
        ...
    @property
    def desc(self) -> str:
        ...
    @property
    def max(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
class _RobotInternal:
    control_rate: typing.ClassVar[float] = 0.001
    degrees_of_freedom: typing.ClassVar[int] = 7
    relative_dynamics_factor: RelativeDynamicsFactor | float
    @staticmethod
    def _pybind11_conduit_v1_(*args, **kwargs):
        ...
    def __init__(self, fci_hostname: str, relative_dynamics_factor: RelativeDynamicsFactor | float = 1.0, default_torque_threshold: float = 20.0, default_force_threshold: float = 30.0, controller_mode: ControllerMode = ..., realtime_config: RealtimeConfig = ..., kalman_q_process_var: float = 0.0001, kalman_dq_process_var: float = 0.001, kalman_ddq_process_var: float = 0.1, kalman_control_process_var: float = 1.0, kalman_q_obs_var: float = 0.01, kalman_dq_obs_var: float = 0.1, kalman_q_d_obs_var: float = 0.0001, kalman_dq_d_obs_var: float = 0.0001, kalman_ddq_d_obs_var: float = 0.0001, kalman_control_adaptation_rate: float = 0.1) -> None:
        ...
    def join_motion(self, timeout: float | None = None) -> bool:
        ...
    @typing.overload
    def move(self, motion: BaseCartesianPoseMotion, asynchronous: bool = False) -> None:
        ...
    @typing.overload
    def move(self, motion: BaseCartesianVelocityMotion, asynchronous: bool = False) -> None:
        ...
    @typing.overload
    def move(self, motion: BaseJointPositionMotion, asynchronous: bool = False) -> None:
        ...
    @typing.overload
    def move(self, motion: BaseJointVelocityMotion, asynchronous: bool = False) -> None:
        ...
    @typing.overload
    def move(self, motion: BaseTorqueMotion, asynchronous: bool = False) -> None:
        ...
    def poll_motion(self) -> bool:
        ...
    def recover_from_errors(self) -> bool:
        ...
    def set_cartesian_impedance(self, K_x: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)]) -> None:
        ...
    @typing.overload
    def set_collision_behavior(self, torque_thresholds: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)] | numpy.ndarray[numpy.float64[7, 1]], force_thresholds: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)] | numpy.ndarray[numpy.float64[6, 1]]) -> None:
        ...
    @typing.overload
    def set_collision_behavior(self, lower_torque_threshold: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)] | numpy.ndarray[numpy.float64[7, 1]], upper_torque_threshold: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)] | numpy.ndarray[numpy.float64[7, 1]], lower_force_threshold: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)] | numpy.ndarray[numpy.float64[6, 1]], upper_force_threshold: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)] | numpy.ndarray[numpy.float64[6, 1]]) -> None:
        ...
    @typing.overload
    def set_collision_behavior(self, lower_torque_threshold_acceleration: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)] | numpy.ndarray[numpy.float64[7, 1]], upper_torque_threshold_acceleration: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)] | numpy.ndarray[numpy.float64[7, 1]], lower_torque_threshold_nominal: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)] | numpy.ndarray[numpy.float64[7, 1]], upper_torque_threshold_nominal: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)] | numpy.ndarray[numpy.float64[7, 1]], lower_force_threshold_acceleration: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)] | numpy.ndarray[numpy.float64[6, 1]], upper_force_threshold_acceleration: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)] | numpy.ndarray[numpy.float64[6, 1]], lower_force_threshold_nominal: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)] | numpy.ndarray[numpy.float64[6, 1]], upper_force_threshold_nominal: float | typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(6)] | numpy.ndarray[numpy.float64[6, 1]]) -> None:
        ...
    def set_ee(self, NE_T_EE: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(16)]) -> None:
        ...
    def set_guiding_mode(self, guiding_mode: typing.Annotated[list[bool], pybind11_stubgen.typing_ext.FixedSize(6)], elbow: bool) -> None:
        ...
    def set_joint_impedance(self, K_theta: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(7)]) -> None:
        ...
    def set_k(self, EE_T_K: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(16)]) -> None:
        ...
    def set_load(self, load_mass: float, F_x_Cload: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(3)], load_inertia: typing.Annotated[list[float], pybind11_stubgen.typing_ext.FixedSize(9)]) -> None:
        ...
    def stop(self) -> None:
        ...
    @property
    def current_cartesian_state(self) -> CartesianState:
        ...
    @property
    def current_cartesian_velocity(self) -> RobotVelocity:
        ...
    @property
    def current_control_signal_type(self) -> ControlSignalType | None:
        ...
    @property
    def current_joint_positions(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def current_joint_state(self) -> JointState:
        ...
    @property
    def current_joint_velocities(self) -> numpy.ndarray[numpy.float64[7, 1]]:
        ...
    @property
    def current_pose(self) -> RobotPose:
        ...
    @property
    def elbow_acceleration_limit(self) -> DoubleDynamicsLimit:
        """
        [rad/s²]
        """
    @property
    def elbow_jerk_limit(self) -> DoubleDynamicsLimit:
        """
        [rad/s³]
        """
    @property
    def elbow_velocity_limit(self) -> DoubleDynamicsLimit:
        """
        [rad/s]
        """
    @property
    def fci_hostname(self) -> str:
        ...
    @property
    def has_errors(self) -> bool:
        ...
    @property
    def is_in_control(self) -> bool:
        ...
    @property
    def joint_acceleration_limit(self) -> VectorDynamicsLimit:
        """
        [rad/s²]
        """
    @property
    def joint_jerk_limit(self) -> VectorDynamicsLimit:
        """
        [rad/s^3]
        """
    @property
    def joint_velocity_limit(self) -> VectorDynamicsLimit:
        """
        [rad/s]
        """
    @property
    def model(self) -> Model:
        ...
    @property
    def model_urdf(self) -> str:
        ...
    @property
    def rotation_acceleration_limit(self) -> DoubleDynamicsLimit:
        """
        [rad/s²]
        """
    @property
    def rotation_jerk_limit(self) -> DoubleDynamicsLimit:
        """
        [rad/s³]
        """
    @property
    def rotation_velocity_limit(self) -> DoubleDynamicsLimit:
        """
        [rad/s]
        """
    @property
    def state(self) -> RobotState:
        ...
    @property
    def translation_acceleration_limit(self) -> DoubleDynamicsLimit:
        """
        [m/s²]
        """
    @property
    def translation_jerk_limit(self) -> DoubleDynamicsLimit:
        """
        [m/s³]
        """
    @property
    def translation_velocity_limit(self) -> DoubleDynamicsLimit:
        """
        [m/s]
        """
