# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.workspace_api_key_list_response_model import WorkspaceApiKeyListResponseModel
from ...types.workspace_create_api_key_response_model import WorkspaceCreateApiKeyResponseModel
from .raw_client import AsyncRawApiKeysClient, RawApiKeysClient
from .types.body_create_service_account_api_key_v_1_service_accounts_service_account_user_id_api_keys_post_permissions import (
    BodyCreateServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysPostPermissions,
)
from .types.body_edit_service_account_api_key_v_1_service_accounts_service_account_user_id_api_keys_api_key_id_patch_permissions import (
    BodyEditServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysApiKeyIdPatchPermissions,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ApiKeysClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApiKeysClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApiKeysClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApiKeysClient
        """
        return self._raw_client

    def list(
        self, service_account_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspaceApiKeyListResponseModel:
        """
        Get all API keys for a service account

        Parameters
        ----------
        service_account_user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceApiKeyListResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.service_accounts.api_keys.list(
            service_account_user_id="service_account_user_id",
        )
        """
        _response = self._raw_client.list(service_account_user_id, request_options=request_options)
        return _response.data

    def create(
        self,
        service_account_user_id: str,
        *,
        name: str,
        permissions: BodyCreateServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysPostPermissions,
        character_limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkspaceCreateApiKeyResponseModel:
        """
        Create a new API key for a service account

        Parameters
        ----------
        service_account_user_id : str

        name : str

        permissions : BodyCreateServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysPostPermissions
            The permissions of the XI API.

        character_limit : typing.Optional[int]
            The character limit of the XI API key. If provided this will limit the usage of this api key to n characters per month where n is the chosen value. Requests that incur charges will fail after reaching this monthly limit.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceCreateApiKeyResponseModel
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.service_accounts.api_keys.create(
            service_account_user_id="service_account_user_id",
            name="name",
            permissions=["text_to_speech"],
        )
        """
        _response = self._raw_client.create(
            service_account_user_id,
            name=name,
            permissions=permissions,
            character_limit=character_limit,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self, service_account_user_id: str, api_key_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete an existing API key for a service account

        Parameters
        ----------
        service_account_user_id : str

        api_key_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.service_accounts.api_keys.delete(
            service_account_user_id="service_account_user_id",
            api_key_id="api_key_id",
        )
        """
        _response = self._raw_client.delete(service_account_user_id, api_key_id, request_options=request_options)
        return _response.data

    def update(
        self,
        service_account_user_id: str,
        api_key_id: str,
        *,
        is_enabled: bool,
        name: str,
        permissions: BodyEditServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysApiKeyIdPatchPermissions,
        character_limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Update an existing API key for a service account

        Parameters
        ----------
        service_account_user_id : str

        api_key_id : str

        is_enabled : bool
            Whether to enable or disable the API key.

        name : str
            The name of the XI API key to use (used for identification purposes only).

        permissions : BodyEditServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysApiKeyIdPatchPermissions
            The permissions of the XI API.

        character_limit : typing.Optional[int]
            The character limit of the XI API key. If provided this will limit the usage of this api key to n characters per month where n is the chosen value. Requests that incur charges will fail after reaching this monthly limit.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from elevenlabs import ElevenLabs

        client = ElevenLabs(
            api_key="YOUR_API_KEY",
        )
        client.service_accounts.api_keys.update(
            service_account_user_id="service_account_user_id",
            api_key_id="api_key_id",
            is_enabled=True,
            name="Sneaky Fox",
            permissions=["text_to_speech"],
        )
        """
        _response = self._raw_client.update(
            service_account_user_id,
            api_key_id,
            is_enabled=is_enabled,
            name=name,
            permissions=permissions,
            character_limit=character_limit,
            request_options=request_options,
        )
        return _response.data


class AsyncApiKeysClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApiKeysClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApiKeysClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApiKeysClient
        """
        return self._raw_client

    async def list(
        self, service_account_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkspaceApiKeyListResponseModel:
        """
        Get all API keys for a service account

        Parameters
        ----------
        service_account_user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceApiKeyListResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.service_accounts.api_keys.list(
                service_account_user_id="service_account_user_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(service_account_user_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        service_account_user_id: str,
        *,
        name: str,
        permissions: BodyCreateServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysPostPermissions,
        character_limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WorkspaceCreateApiKeyResponseModel:
        """
        Create a new API key for a service account

        Parameters
        ----------
        service_account_user_id : str

        name : str

        permissions : BodyCreateServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysPostPermissions
            The permissions of the XI API.

        character_limit : typing.Optional[int]
            The character limit of the XI API key. If provided this will limit the usage of this api key to n characters per month where n is the chosen value. Requests that incur charges will fail after reaching this monthly limit.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkspaceCreateApiKeyResponseModel
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.service_accounts.api_keys.create(
                service_account_user_id="service_account_user_id",
                name="name",
                permissions=["text_to_speech"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            service_account_user_id,
            name=name,
            permissions=permissions,
            character_limit=character_limit,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, service_account_user_id: str, api_key_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Delete an existing API key for a service account

        Parameters
        ----------
        service_account_user_id : str

        api_key_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.service_accounts.api_keys.delete(
                service_account_user_id="service_account_user_id",
                api_key_id="api_key_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(service_account_user_id, api_key_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        service_account_user_id: str,
        api_key_id: str,
        *,
        is_enabled: bool,
        name: str,
        permissions: BodyEditServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysApiKeyIdPatchPermissions,
        character_limit: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Update an existing API key for a service account

        Parameters
        ----------
        service_account_user_id : str

        api_key_id : str

        is_enabled : bool
            Whether to enable or disable the API key.

        name : str
            The name of the XI API key to use (used for identification purposes only).

        permissions : BodyEditServiceAccountApiKeyV1ServiceAccountsServiceAccountUserIdApiKeysApiKeyIdPatchPermissions
            The permissions of the XI API.

        character_limit : typing.Optional[int]
            The character limit of the XI API key. If provided this will limit the usage of this api key to n characters per month where n is the chosen value. Requests that incur charges will fail after reaching this monthly limit.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from elevenlabs import AsyncElevenLabs

        client = AsyncElevenLabs(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.service_accounts.api_keys.update(
                service_account_user_id="service_account_user_id",
                api_key_id="api_key_id",
                is_enabled=True,
                name="Sneaky Fox",
                permissions=["text_to_speech"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            service_account_user_id,
            api_key_id,
            is_enabled=is_enabled,
            name=name,
            permissions=permissions,
            character_limit=character_limit,
            request_options=request_options,
        )
        return _response.data
