from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
from __future__ import unicode_literals

import click
import os

from git import Repo, GitCommandError
from github import Github


def create_repo(token, repo_name, path):
    repo = _create_github_repo(token, repo_name)
    init_repo_and_push(path, repo.ssh_url)
    return repo.full_name


def _create_github_repo(token, repo_name):
    github = Github(token)
    user = github.get_user()
    return user.create_repo(repo_name, private=False)


def init_repo_and_push(path, remote, force=False):
    try:
        repo = Repo(path)
    except Exception as e:
        repo = Repo.init(path)

    path = '{0}/'.format(path.rstrip('/'))
    gitkeep_path = os.path.join(path, '.gitkeep')
    os.system('touch {0}'.format(gitkeep_path))

    _initial_commit(path)

    repo = Repo(path)
    _create_remote_and_push(repo, remote, force=force)


def _initial_commit(path):
    original_path = os.getcwd()
    os.chdir(path)
    try:
        os.system('git add .')
        os.system('git commit -m "Autogenerated initial commit"')
    finally:
        os.chdir(original_path)


def _create_remote_and_push(repo, remote, force=False):
    try:
        origin_remote = repo.create_remote('origin', remote)
    except GitCommandError as e:
        if force or click.confirm('Git Remote "origin" already exists.  '
                                  'Do you wish to use it?'):
            origin_remote = repo.remotes.origin
        else:
            raise e

    origin_remote.push('master', set_upstream=True)
