# Generated by Django 4.0.3 on 2022-03-13 15:54

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):

    replaces = [('marketmanager', '0001_initial'), ('marketmanager', '0002_auto_20211129_1339'), ('marketmanager', '0003_alter_general_options'), ('marketmanager', '0004_alter_order_wallet_division'), ('marketmanager', '0005_alter_general_options'), ('marketmanager', '0006_auto_20211201_1343'), ('marketmanager', '0007_alter_order_is_buy_order'), ('marketmanager', '0008_alter_order_state'), ('marketmanager', '0009_rename_config_publicconfig_order_source_character_and_more'), ('marketmanager', '0010_order_source_private'), ('marketmanager', '0011_alter_privateconfig_failed_and_more'), ('marketmanager', '0012_structure_created_at_structure_updated_at_and_more'), ('marketmanager', '0013_alter_privateconfig_failure_reason_and_more'), ('marketmanager', '0014_alter_privateconfig_valid_corporations_and_more')]

    initial = True

    dependencies = [
        ('eveonline', '0015_factions'),
        ('eveuniverse', '0005_type_materials_and_sections'),
        ('esi', '0010_set_new_tokens_to_sso_v2'),
    ]

    operations = [
        migrations.CreateModel(
            name='Structure',
            fields=[
                ('structure_id', models.PositiveBigIntegerField(primary_key=True, serialize=False, verbose_name='Structure ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('owner_id', models.IntegerField(verbose_name='Owner Corporation ID')),
                ('pull_market', models.BooleanField(default=True, help_text='Useful to ignore specific structures for _reasons_', verbose_name='Pull Market Orders')),
                ('eve_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.evetype', verbose_name='Type')),
                ('solar_system', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.evesolarsystem', verbose_name='Solar System')),
                ('created_at', models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Webhook',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('webhook', models.URLField(verbose_name='URL')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='General',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': (('basic_market_browser', 'Can access the Market Browser with standard features'), ('order_highlight_user', "Market orders owned by the user's characters may be highlighted in the standard/basic Market Browser"), ('order_highlight_corporation', 'Market orders owned by any corporation a user is a member of may be highlighted in the standard/basic Market Browser WARNING: This has no checks for Corporation Roles.'), ('advanced_market_browser', 'Can access the Market Browser with more detail such as the owners of orders')),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='PublicConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('fetch_regions', models.ManyToManyField(to='eveuniverse.everegion', verbose_name='Fetch Regions')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('order_id', models.PositiveBigIntegerField(help_text='Unique order ID', primary_key=True, serialize=False, verbose_name='Order ID')),
                ('duration', models.PositiveIntegerField(help_text='Number of days the order was valid for (starting from the issued date). An order expires at time issued + duration', verbose_name='Duration')),
                ('is_buy_order', models.BooleanField(db_index=True, default=False, help_text='True if the order is a bid (buy) order', verbose_name='Buy Order')),
                ('issued', models.DateTimeField(help_text='Date and time when this order was issued', verbose_name='Issued')),
                ('location_id', models.PositiveBigIntegerField(help_text='ID of the location where order was placed', verbose_name='Location ID')),
                ('min_volume', models.PositiveIntegerField(blank=True, help_text='For buy orders, the minimum quantity that will be accepted in a matching sell order', null=True, verbose_name='Minimum Volume')),
                ('price', models.DecimalField(decimal_places=2, help_text='Cost per unit for this order', max_digits=20, verbose_name='Price')),
                ('escrow', models.DecimalField(blank=True, decimal_places=2, help_text='For buy orders, the amount of ISK in escrow', max_digits=20, null=True, verbose_name='Escrow')),
                ('range', models.CharField(choices=[('1', '1'), ('10', '10'), ('2', '2'), ('20', '20'), ('3', '3'), ('30', '30'), ('4', '4'), ('40', '40'), ('5', '5'), ('region', 'Region'), ('solarsystem', 'Solar System'), ('station', 'Station')], help_text='Valid order range, numbers are ranges in jumps', max_length=20, verbose_name='Order Range')),
                ('volume_remain', models.PositiveIntegerField(help_text='Quantity of items still required or offered', verbose_name='Volume Remaining')),
                ('volume_total', models.PositiveIntegerField(help_text='Quantity of items required or offered at time order was placed', verbose_name='Volume Total')),
                ('is_corporation', models.BooleanField(default=False, help_text='Signifies whether the buy/sell order was placed on behalf of a corporation.', verbose_name='Is Corporation')),
                ('wallet_division', models.PositiveSmallIntegerField(blank=True, help_text='The corporation wallet division used for this order.', null=True, verbose_name='Wallet Division')),
                ('state', models.CharField(choices=[('', ''), ('cancelled', 'Cancelled'), ('expired ', 'Expired')], help_text='Current order state, Only valid for Authenticated order History. Will not update from Public Market Data.', max_length=20, verbose_name='Order State')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('eve_region', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.everegion', verbose_name='Region')),
                ('eve_solar_system', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.evesolarsystem', verbose_name='System')),
                ('eve_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.evetype', verbose_name='Type')),
                ('issued_by_character', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='eveonline.evecharacter', verbose_name='Character')),
                ('issued_by_corporation', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='eveonline.evecorporationinfo', verbose_name='Corporation')),
                ('source_character', models.BooleanField(default=False, verbose_name='Sourced From Character API Market Data')),
                ('source_corporation', models.BooleanField(default=False, verbose_name='Sourced From Corporation API Market Data')),
                ('source_public', models.BooleanField(default=False, verbose_name='Sourced From Public Market Data')),
                ('source_private', models.BooleanField(default=False, verbose_name='Sourced From Public Market Data')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='WatchConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('buy_order', models.BooleanField(verbose_name='Buy Order')),
                ('volume', models.IntegerField(help_text='Set to Zero to check ANY/EVERY order against Price', verbose_name='Volume')),
                ('price', models.IntegerField(help_text='Set to Zero to check ANY/EVERY order against Volume', verbose_name='Price')),
                ('jita_compare_percent', models.IntegerField(help_text='If set ignores Flat price value', verbose_name='Jita Comparison %')),
                ('constellation', models.ManyToManyField(to='eveuniverse.eveconstellation', verbose_name='Constellation')),
                ('location', models.ManyToManyField(to='marketmanager.structure', verbose_name='Structure')),
                ('region', models.ManyToManyField(to='eveuniverse.everegion', verbose_name='Region')),
                ('solar_system', models.ManyToManyField(to='eveuniverse.evesolarsystem', verbose_name='Solar System')),
                ('structure_type', models.ManyToManyField(help_text='Filter by structure Type/Size/Docking (ie, forts/keeps for cap fuel)', related_name='structure_type', to='eveuniverse.evetype', verbose_name='Structure Type Filter')),
                ('webhooks', models.ManyToManyField(to='marketmanager.webhook', verbose_name='Webhooks')),
                ('type', models.ForeignKey(default='', on_delete=django.db.models.deletion.CASCADE, to='eveuniverse.evetype', verbose_name='EVE Type')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='PrivateConfig',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('failed', models.BooleanField(verbose_name='Disabled due to Failure, Check reason, adjust config and re-enable')),
                ('failure_reason', models.CharField(blank=True, default='', max_length=100, verbose_name='Failure Reason')),
                ('token', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='esi.token', verbose_name='ESI Token')),
                ('valid_corporations', models.ManyToManyField(blank=True, to='eveonline.evecorporationinfo', verbose_name='Valid Corporation Markets for this Token')),
                ('valid_structures', models.ManyToManyField(blank=True, to='marketmanager.structure', verbose_name='Valid Structure Markets for this Token')),
            ],
            options={
                'default_permissions': (),
            },
        ),
    ]
