# Generated by Django 4.0.3 on 2022-03-19 04:03

from decimal import Decimal

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('marketmanager', '0019_remove_order_escrow_remove_order_source_character_and_more'),
    ]

    operations = [
        migrations.AlterField(
            model_name='order',
            name='duration',
            field=models.PositiveSmallIntegerField(help_text='Number of days the order was valid for (starting from the issued date). An order expires at time issued + duration', verbose_name='Duration'),
        ),
        migrations.AlterField(
            model_name='order',
            name='price',
            field=models.DecimalField(decimal_places=2, help_text='Cost per unit for this order', max_digits=15, verbose_name='Price'),
        ),
        migrations.AlterField(
            model_name='order',
            name='range',
            field=models.CharField(choices=[('1', '1'), ('10', '10'), ('2', '2'), ('20', '20'), ('3', '3'), ('30', '30'), ('4', '4'), ('40', '40'), ('5', '5'), ('region', 'Region'), ('solarsystem', 'Solar System'), ('station', 'Station')], help_text='Valid order range, numbers are ranges in jumps', max_length=12, verbose_name='Order Range'),
        ),
        migrations.AlterField(
            model_name='order',
            name='state',
            field=models.CharField(choices=[('', ''), ('cancelled', 'Cancelled'), ('expired ', 'Expired')], help_text='Current order state, Only valid for Authenticated order History. Will not update from Public Market Data.', max_length=10, verbose_name='Order State'),
        ),
        migrations.AlterField(
            model_name='structure',
            name='name',
            field=models.CharField(max_length=60, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='typestatistics',
            name='buy_fifth_percentile',
            field=models.DecimalField(decimal_places=2, max_digits=15, verbose_name='Buy 5th Percentile'),
        ),
        migrations.AlterField(
            model_name='typestatistics',
            name='buy_median',
            field=models.DecimalField(decimal_places=2, max_digits=15, verbose_name='Buy Median'),
        ),
        migrations.AlterField(
            model_name='typestatistics',
            name='buy_weighted_average',
            field=models.DecimalField(decimal_places=2, max_digits=15, verbose_name='Buy Weighted Average'),
        ),
        migrations.AlterField(
            model_name='typestatistics',
            name='sell_fifth_percentile',
            field=models.DecimalField(decimal_places=2, max_digits=15, verbose_name='Sell 5th Percentile'),
        ),
        migrations.AlterField(
            model_name='typestatistics',
            name='sell_median',
            field=models.DecimalField(decimal_places=2, max_digits=15, verbose_name='Sell Median'),
        ),
        migrations.AlterField(
            model_name='typestatistics',
            name='sell_weighted_average',
            field=models.DecimalField(decimal_places=2, max_digits=15, verbose_name='Sell Weighted Average'),
        ),
        migrations.AlterField(
            model_name='watchconfig',
            name='price',
            field=models.DecimalField(decimal_places=2, default=Decimal('0'), help_text='Set to Zero to skip this filter', max_digits=15, verbose_name='Price'),
        ),
    ]
