# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'CloudAccountAws',
    'CloudAccountAzure',
    'CloudAccountGcp',
    'CloudAccountNgs',
    'DomainRouteHeaders',
    'DomainRouteHeadersRequest',
    'DomainSpec',
    'DomainSpecPort',
    'DomainSpecPortCors',
    'DomainSpecPortCorsAllowOrigin',
    'DomainSpecPortTls',
    'DomainSpecPortTlsClientCertificate',
    'DomainSpecPortTlsServerCertificate',
    'DomainStatus',
    'DomainStatusDnsConfig',
    'DomainStatusEndpoint',
    'DomainStatusLocation',
    'GroupIdentityMatcher',
    'GroupMemberQuery',
    'GroupMemberQuerySpec',
    'GroupMemberQuerySpecTerm',
    'GvcControlplaneTracing',
    'GvcLightstepTracing',
    'GvcLoadBalancer',
    'GvcLoadBalancerMultiZone',
    'GvcLoadBalancerRedirect',
    'GvcLoadBalancerRedirectClass',
    'GvcOtelTracing',
    'GvcSidecar',
    'IdentityAwsAccessPolicy',
    'IdentityAwsAccessPolicyTrustPolicy',
    'IdentityAzureAccessPolicy',
    'IdentityAzureAccessPolicyRoleAssignment',
    'IdentityGcpAccessPolicy',
    'IdentityGcpAccessPolicyBinding',
    'IdentityNativeNetworkResource',
    'IdentityNativeNetworkResourceAwsPrivateLink',
    'IdentityNativeNetworkResourceGcpServiceConnect',
    'IdentityNetworkResource',
    'IdentityNgsAccessPolicy',
    'IdentityNgsAccessPolicyPub',
    'IdentityNgsAccessPolicyResp',
    'IdentityNgsAccessPolicySub',
    'IpSetLocation',
    'IpSetStatus',
    'IpSetStatusIpAddress',
    'LocationGeo',
    'Mk8sAddOns',
    'Mk8sAddOnsAwsEcr',
    'Mk8sAddOnsAwsEfs',
    'Mk8sAddOnsAwsElb',
    'Mk8sAddOnsAzureAcr',
    'Mk8sAddOnsAzureWorkloadIdentity',
    'Mk8sAddOnsLogs',
    'Mk8sAddOnsMetrics',
    'Mk8sAddOnsMetricsScrapeAnnotated',
    'Mk8sAddOnsNvidia',
    'Mk8sAddOnsRegistryMirror',
    'Mk8sAddOnsRegistryMirrorMirror',
    'Mk8sAwsProvider',
    'Mk8sAwsProviderAutoscaler',
    'Mk8sAwsProviderDeployRoleChain',
    'Mk8sAwsProviderImage',
    'Mk8sAwsProviderNetworking',
    'Mk8sAwsProviderNodePool',
    'Mk8sAwsProviderNodePoolOverrideImage',
    'Mk8sAwsProviderNodePoolTaint',
    'Mk8sAzureProvider',
    'Mk8sAzureProviderAutoscaler',
    'Mk8sAzureProviderImage',
    'Mk8sAzureProviderImageReference',
    'Mk8sAzureProviderNetworking',
    'Mk8sAzureProviderNodePool',
    'Mk8sAzureProviderNodePoolOverrideImage',
    'Mk8sAzureProviderNodePoolOverrideImageReference',
    'Mk8sAzureProviderNodePoolTaint',
    'Mk8sDigitalOceanProvider',
    'Mk8sDigitalOceanProviderAutoscaler',
    'Mk8sDigitalOceanProviderNetworking',
    'Mk8sDigitalOceanProviderNodePool',
    'Mk8sDigitalOceanProviderNodePoolTaint',
    'Mk8sEphemeralProvider',
    'Mk8sEphemeralProviderNodePool',
    'Mk8sEphemeralProviderNodePoolTaint',
    'Mk8sFirewall',
    'Mk8sGenericProvider',
    'Mk8sGenericProviderNetworking',
    'Mk8sGenericProviderNodePool',
    'Mk8sGenericProviderNodePoolTaint',
    'Mk8sHetznerProvider',
    'Mk8sHetznerProviderAutoscaler',
    'Mk8sHetznerProviderDedicatedServerNodePool',
    'Mk8sHetznerProviderDedicatedServerNodePoolTaint',
    'Mk8sHetznerProviderNetworking',
    'Mk8sHetznerProviderNodePool',
    'Mk8sHetznerProviderNodePoolTaint',
    'Mk8sLambdalabsProvider',
    'Mk8sLambdalabsProviderAutoscaler',
    'Mk8sLambdalabsProviderNodePool',
    'Mk8sLambdalabsProviderNodePoolTaint',
    'Mk8sLambdalabsProviderUnmanagedNodePool',
    'Mk8sLambdalabsProviderUnmanagedNodePoolTaint',
    'Mk8sLinodeProvider',
    'Mk8sLinodeProviderAutoscaler',
    'Mk8sLinodeProviderNetworking',
    'Mk8sLinodeProviderNodePool',
    'Mk8sLinodeProviderNodePoolTaint',
    'Mk8sOblivusProvider',
    'Mk8sOblivusProviderAutoscaler',
    'Mk8sOblivusProviderNodePool',
    'Mk8sOblivusProviderNodePoolTaint',
    'Mk8sOblivusProviderUnmanagedNodePool',
    'Mk8sOblivusProviderUnmanagedNodePoolTaint',
    'Mk8sPaperspaceProvider',
    'Mk8sPaperspaceProviderAutoscaler',
    'Mk8sPaperspaceProviderNodePool',
    'Mk8sPaperspaceProviderNodePoolTaint',
    'Mk8sPaperspaceProviderUnmanagedNodePool',
    'Mk8sPaperspaceProviderUnmanagedNodePoolTaint',
    'Mk8sStatus',
    'Mk8sStatusAddOn',
    'Mk8sStatusAddOnAwsEcr',
    'Mk8sStatusAddOnAwsEf',
    'Mk8sStatusAddOnAwsElb',
    'Mk8sStatusAddOnAwsWorkloadIdentity',
    'Mk8sStatusAddOnAwsWorkloadIdentityOidcProviderConfig',
    'Mk8sStatusAddOnDashboard',
    'Mk8sStatusAddOnLog',
    'Mk8sStatusAddOnMetric',
    'Mk8sTritonProvider',
    'Mk8sTritonProviderAutoscaler',
    'Mk8sTritonProviderConnection',
    'Mk8sTritonProviderLoadBalancer',
    'Mk8sTritonProviderLoadBalancerGateway',
    'Mk8sTritonProviderLoadBalancerManual',
    'Mk8sTritonProviderLoadBalancerManualLogging',
    'Mk8sTritonProviderNetworking',
    'Mk8sTritonProviderNodePool',
    'Mk8sTritonProviderNodePoolTaint',
    'OrgAuthConfig',
    'OrgLoggingCloudWatchLogging',
    'OrgLoggingCoralogixLogging',
    'OrgLoggingDatadogLogging',
    'OrgLoggingElasticLogging',
    'OrgLoggingElasticLoggingAws',
    'OrgLoggingElasticLoggingElasticCloud',
    'OrgLoggingElasticLoggingGeneric',
    'OrgLoggingFluentdLogging',
    'OrgLoggingLogzioLogging',
    'OrgLoggingS3Logging',
    'OrgLoggingStackdriverLogging',
    'OrgLoggingSyslogLogging',
    'OrgObservability',
    'OrgSecurity',
    'OrgSecurityThreatDetection',
    'OrgSecurityThreatDetectionSyslog',
    'OrgStatus',
    'OrgTracingControlplaneTracing',
    'OrgTracingLightstepTracing',
    'OrgTracingOtelTracing',
    'PolicyBinding',
    'PolicyTargetQuery',
    'PolicyTargetQuerySpec',
    'PolicyTargetQuerySpecTerm',
    'SecretAws',
    'SecretAzureConnector',
    'SecretEcr',
    'SecretKeypair',
    'SecretNatsAccount',
    'SecretOpaque',
    'SecretTls',
    'SecretUserpass',
    'VolumeSetAutoscaling',
    'VolumeSetMountOptions',
    'VolumeSetMountOptionsResources',
    'VolumeSetSnapshots',
    'VolumeSetStatus',
    'WorkloadContainer',
    'WorkloadContainerGpuCustom',
    'WorkloadContainerGpuNvidia',
    'WorkloadContainerLifecycle',
    'WorkloadContainerLifecyclePostStart',
    'WorkloadContainerLifecyclePostStartExec',
    'WorkloadContainerLifecyclePreStop',
    'WorkloadContainerLifecyclePreStopExec',
    'WorkloadContainerLivenessProbe',
    'WorkloadContainerLivenessProbeExec',
    'WorkloadContainerLivenessProbeGrpc',
    'WorkloadContainerLivenessProbeHttpGet',
    'WorkloadContainerLivenessProbeTcpSocket',
    'WorkloadContainerMetrics',
    'WorkloadContainerPort',
    'WorkloadContainerReadinessProbe',
    'WorkloadContainerReadinessProbeExec',
    'WorkloadContainerReadinessProbeGrpc',
    'WorkloadContainerReadinessProbeHttpGet',
    'WorkloadContainerReadinessProbeTcpSocket',
    'WorkloadContainerVolume',
    'WorkloadFirewallSpec',
    'WorkloadFirewallSpecExternal',
    'WorkloadFirewallSpecExternalHttp',
    'WorkloadFirewallSpecExternalHttpInboundHeaderFilter',
    'WorkloadFirewallSpecExternalOutboundAllowPort',
    'WorkloadFirewallSpecInternal',
    'WorkloadJob',
    'WorkloadLoadBalancer',
    'WorkloadLoadBalancerDirect',
    'WorkloadLoadBalancerDirectPort',
    'WorkloadLoadBalancerGeoLocation',
    'WorkloadLoadBalancerGeoLocationHeaders',
    'WorkloadLocalOption',
    'WorkloadLocalOptionAutoscaling',
    'WorkloadLocalOptionAutoscalingMulti',
    'WorkloadLocalOptionMultiZone',
    'WorkloadOptions',
    'WorkloadOptionsAutoscaling',
    'WorkloadOptionsAutoscalingMulti',
    'WorkloadOptionsMultiZone',
    'WorkloadRequestRetryPolicy',
    'WorkloadRolloutOption',
    'WorkloadSecurityOptions',
    'WorkloadSidecar',
    'WorkloadStatus',
    'WorkloadStatusHealthCheck',
    'WorkloadStatusLoadBalancer',
    'WorkloadStatusResolvedImage',
    'WorkloadStatusResolvedImageImage',
    'WorkloadStatusResolvedImageImageManifest',
    'GetGvcControlplaneTracingResult',
    'GetGvcLightstepTracingResult',
    'GetGvcLoadBalancerResult',
    'GetGvcLoadBalancerMultiZoneResult',
    'GetGvcLoadBalancerRedirectResult',
    'GetGvcLoadBalancerRedirectClassResult',
    'GetGvcOtelTracingResult',
    'GetGvcSidecarResult',
    'GetImageManifestResult',
    'GetImageManifestConfigResult',
    'GetImageManifestLayerResult',
    'GetImagesImageResult',
    'GetImagesImageManifestResult',
    'GetImagesImageManifestConfigResult',
    'GetImagesImageManifestLayerResult',
    'GetImagesQueryResult',
    'GetImagesQuerySpecResult',
    'GetImagesQuerySpecTermResult',
    'GetLocationGeoResult',
    'GetLocationsLocationResult',
    'GetLocationsLocationGeoResult',
    'GetOrgAuthConfigResult',
    'GetOrgObservabilityResult',
    'GetOrgSecurityResult',
    'GetOrgSecurityThreatDetectionResult',
    'GetOrgSecurityThreatDetectionSyslogResult',
    'GetOrgStatusResult',
    'GetSecretAwResult',
    'GetSecretAzureConnectorResult',
    'GetSecretEcrResult',
    'GetSecretKeypairResult',
    'GetSecretNatsAccountResult',
    'GetSecretOpaqueResult',
    'GetSecretTlResult',
    'GetSecretUserpassResult',
]

@pulumi.output_type
class CloudAccountAws(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudAccountAws. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudAccountAws.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudAccountAws.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str role_arn: Amazon Resource Name (ARN) Role.
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) Role.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class CloudAccountAzure(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretLink":
            suggest = "secret_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudAccountAzure. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudAccountAzure.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudAccountAzure.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_link: Optional[builtins.str] = None):
        """
        :param builtins.str secret_link: Full link to an Azure secret. (e.g., /org/ORG_NAME/secret/AZURE_SECRET).
        """
        if secret_link is not None:
            pulumi.set(__self__, "secret_link", secret_link)

    @property
    @pulumi.getter(name="secretLink")
    def secret_link(self) -> Optional[builtins.str]:
        """
        Full link to an Azure secret. (e.g., /org/ORG_NAME/secret/AZURE_SECRET).
        """
        return pulumi.get(self, "secret_link")


@pulumi.output_type
class CloudAccountGcp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudAccountGcp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudAccountGcp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudAccountGcp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_id: Optional[builtins.str] = None):
        """
        :param builtins.str project_id: GCP project ID. Obtained from the GCP cloud console.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        GCP project ID. Obtained from the GCP cloud console.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class CloudAccountNgs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretLink":
            suggest = "secret_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudAccountNgs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudAccountNgs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudAccountNgs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_link: Optional[builtins.str] = None):
        """
        :param builtins.str secret_link: Full link to a NATS Account Secret secret. (e.g., /org/ORG_NAME/secret/NATS_ACCOUNT_SECRET).
        """
        if secret_link is not None:
            pulumi.set(__self__, "secret_link", secret_link)

    @property
    @pulumi.getter(name="secretLink")
    def secret_link(self) -> Optional[builtins.str]:
        """
        Full link to a NATS Account Secret secret. (e.g., /org/ORG_NAME/secret/NATS_ACCOUNT_SECRET).
        """
        return pulumi.get(self, "secret_link")


@pulumi.output_type
class DomainRouteHeaders(dict):
    def __init__(__self__, *,
                 request: Optional['outputs.DomainRouteHeadersRequest'] = None):
        """
        :param 'DomainRouteHeadersRequestArgs' request: Manipulates HTTP headers.
        """
        if request is not None:
            pulumi.set(__self__, "request", request)

    @property
    @pulumi.getter
    def request(self) -> Optional['outputs.DomainRouteHeadersRequest']:
        """
        Manipulates HTTP headers.
        """
        return pulumi.get(self, "request")


@pulumi.output_type
class DomainRouteHeadersRequest(dict):
    def __init__(__self__, *,
                 set: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] set: Sets or overrides headers to all http requests for this route.
        """
        if set is not None:
            pulumi.set(__self__, "set", set)

    @property
    @pulumi.getter
    def set(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Sets or overrides headers to all http requests for this route.
        """
        return pulumi.get(self, "set")


@pulumi.output_type
class DomainSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceptAllHosts":
            suggest = "accept_all_hosts"
        elif key == "dnsMode":
            suggest = "dns_mode"
        elif key == "gvcLink":
            suggest = "gvc_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accept_all_hosts: Optional[builtins.bool] = None,
                 dns_mode: Optional[builtins.str] = None,
                 gvc_link: Optional[builtins.str] = None,
                 ports: Optional[Sequence['outputs.DomainSpecPort']] = None):
        """
        :param builtins.bool accept_all_hosts: Allows domain to accept wildcards. The associated GVC must have dedicated load balancing enabled.
        :param builtins.str dns_mode: In `cname` dnsMode, Control Plane will configure workloads to accept traffic for the domain but will not manage DNS records for the domain. End users must configure CNAME records in their own DNS pointed to the canonical workload endpoint. Currently `cname` dnsMode requires that a TLS server certificate be configured when subdomain based routing is used. In `ns` dnsMode, Control Plane will manage the subdomains and create all necessary DNS records. End users configure NS records to forward DNS requests to the Control Plane managed DNS servers. Valid values: `cname`, `ns`. Default: `cname`.
        :param builtins.str gvc_link: This value is set to a target GVC (using a full link) for use by subdomain based routing. Each workload in the GVC will receive a subdomain in the form ${workload.name}.${domain.name}. **Do not include if path based routing is used.**
        :param Sequence['DomainSpecPortArgs'] ports: Domain port specifications.
        """
        if accept_all_hosts is not None:
            pulumi.set(__self__, "accept_all_hosts", accept_all_hosts)
        if dns_mode is not None:
            pulumi.set(__self__, "dns_mode", dns_mode)
        if gvc_link is not None:
            pulumi.set(__self__, "gvc_link", gvc_link)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="acceptAllHosts")
    def accept_all_hosts(self) -> Optional[builtins.bool]:
        """
        Allows domain to accept wildcards. The associated GVC must have dedicated load balancing enabled.
        """
        return pulumi.get(self, "accept_all_hosts")

    @property
    @pulumi.getter(name="dnsMode")
    def dns_mode(self) -> Optional[builtins.str]:
        """
        In `cname` dnsMode, Control Plane will configure workloads to accept traffic for the domain but will not manage DNS records for the domain. End users must configure CNAME records in their own DNS pointed to the canonical workload endpoint. Currently `cname` dnsMode requires that a TLS server certificate be configured when subdomain based routing is used. In `ns` dnsMode, Control Plane will manage the subdomains and create all necessary DNS records. End users configure NS records to forward DNS requests to the Control Plane managed DNS servers. Valid values: `cname`, `ns`. Default: `cname`.
        """
        return pulumi.get(self, "dns_mode")

    @property
    @pulumi.getter(name="gvcLink")
    def gvc_link(self) -> Optional[builtins.str]:
        """
        This value is set to a target GVC (using a full link) for use by subdomain based routing. Each workload in the GVC will receive a subdomain in the form ${workload.name}.${domain.name}. **Do not include if path based routing is used.**
        """
        return pulumi.get(self, "gvc_link")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.DomainSpecPort']]:
        """
        Domain port specifications.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class DomainSpecPort(dict):
    def __init__(__self__, *,
                 cors: Optional['outputs.DomainSpecPortCors'] = None,
                 number: Optional[builtins.int] = None,
                 protocol: Optional[builtins.str] = None,
                 tls: Optional['outputs.DomainSpecPortTls'] = None):
        """
        :param 'DomainSpecPortCorsArgs' cors: A security feature implemented by web browsers to allow resources on a web page to be requested from another domain outside the domain from which the resource originated.
        :param builtins.int number: Sets or overrides headers to all http requests for this route.
        :param builtins.str protocol: Allowed protocol. Valid values: `http`, `http2`, `tcp`. Default: `http2`.
        :param 'DomainSpecPortTlsArgs' tls: Used for TLS connections for this Domain. End users are responsible for certificate updates.
        """
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter
    def cors(self) -> Optional['outputs.DomainSpecPortCors']:
        """
        A security feature implemented by web browsers to allow resources on a web page to be requested from another domain outside the domain from which the resource originated.
        """
        return pulumi.get(self, "cors")

    @property
    @pulumi.getter
    def number(self) -> Optional[builtins.int]:
        """
        Sets or overrides headers to all http requests for this route.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        Allowed protocol. Valid values: `http`, `http2`, `tcp`. Default: `http2`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def tls(self) -> Optional['outputs.DomainSpecPortTls']:
        """
        Used for TLS connections for this Domain. End users are responsible for certificate updates.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class DomainSpecPortCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowCredentials":
            suggest = "allow_credentials"
        elif key == "allowHeaders":
            suggest = "allow_headers"
        elif key == "allowMethods":
            suggest = "allow_methods"
        elif key == "allowOrigins":
            suggest = "allow_origins"
        elif key == "exposeHeaders":
            suggest = "expose_headers"
        elif key == "maxAge":
            suggest = "max_age"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSpecPortCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSpecPortCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSpecPortCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_credentials: Optional[builtins.bool] = None,
                 allow_headers: Optional[Sequence[builtins.str]] = None,
                 allow_methods: Optional[Sequence[builtins.str]] = None,
                 allow_origins: Optional[Sequence['outputs.DomainSpecPortCorsAllowOrigin']] = None,
                 expose_headers: Optional[Sequence[builtins.str]] = None,
                 max_age: Optional[builtins.str] = None):
        """
        :param builtins.bool allow_credentials: Determines whether the client-side code (typically running in a web browser) is allowed to include credentials (such as cookies, HTTP authentication, or client-side SSL certificates) in cross-origin requests.
        :param Sequence[builtins.str] allow_headers: Specifies the custom HTTP headers that are allowed in a cross-origin request to a specific resource.
        :param Sequence[builtins.str] allow_methods: Specifies the HTTP methods (such as `GET`, `POST`, `PUT`, `DELETE`, etc.) that are allowed for a cross-origin request to a specific resource.
        :param Sequence['DomainSpecPortCorsAllowOriginArgs'] allow_origins: Determines which origins are allowed to access a particular resource on a server from a web browser.
        :param Sequence[builtins.str] expose_headers: The HTTP headers that a server allows to be exposed to the client in response to a cross-origin request. These headers provide additional information about the server's capabilities or requirements, aiding in proper handling of the request by the client's browser or application.
        :param builtins.str max_age: Maximum amount of time that a preflight request result can be cached by the client browser. Input is expected as a duration string (i.e, 24h, 20m, etc.).
        """
        if allow_credentials is not None:
            pulumi.set(__self__, "allow_credentials", allow_credentials)
        if allow_headers is not None:
            pulumi.set(__self__, "allow_headers", allow_headers)
        if allow_methods is not None:
            pulumi.set(__self__, "allow_methods", allow_methods)
        if allow_origins is not None:
            pulumi.set(__self__, "allow_origins", allow_origins)
        if expose_headers is not None:
            pulumi.set(__self__, "expose_headers", expose_headers)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)

    @property
    @pulumi.getter(name="allowCredentials")
    def allow_credentials(self) -> Optional[builtins.bool]:
        """
        Determines whether the client-side code (typically running in a web browser) is allowed to include credentials (such as cookies, HTTP authentication, or client-side SSL certificates) in cross-origin requests.
        """
        return pulumi.get(self, "allow_credentials")

    @property
    @pulumi.getter(name="allowHeaders")
    def allow_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the custom HTTP headers that are allowed in a cross-origin request to a specific resource.
        """
        return pulumi.get(self, "allow_headers")

    @property
    @pulumi.getter(name="allowMethods")
    def allow_methods(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the HTTP methods (such as `GET`, `POST`, `PUT`, `DELETE`, etc.) that are allowed for a cross-origin request to a specific resource.
        """
        return pulumi.get(self, "allow_methods")

    @property
    @pulumi.getter(name="allowOrigins")
    def allow_origins(self) -> Optional[Sequence['outputs.DomainSpecPortCorsAllowOrigin']]:
        """
        Determines which origins are allowed to access a particular resource on a server from a web browser.
        """
        return pulumi.get(self, "allow_origins")

    @property
    @pulumi.getter(name="exposeHeaders")
    def expose_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        The HTTP headers that a server allows to be exposed to the client in response to a cross-origin request. These headers provide additional information about the server's capabilities or requirements, aiding in proper handling of the request by the client's browser or application.
        """
        return pulumi.get(self, "expose_headers")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[builtins.str]:
        """
        Maximum amount of time that a preflight request result can be cached by the client browser. Input is expected as a duration string (i.e, 24h, 20m, etc.).
        """
        return pulumi.get(self, "max_age")


@pulumi.output_type
class DomainSpecPortCorsAllowOrigin(dict):
    def __init__(__self__, *,
                 exact: Optional[builtins.str] = None,
                 regex: Optional[builtins.str] = None):
        """
        :param builtins.str exact: Value of allowed origin.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        Value of allowed origin.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.str]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class DomainSpecPortTls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cipherSuites":
            suggest = "cipher_suites"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "minProtocolVersion":
            suggest = "min_protocol_version"
        elif key == "serverCertificate":
            suggest = "server_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSpecPortTls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSpecPortTls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSpecPortTls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cipher_suites: Optional[Sequence[builtins.str]] = None,
                 client_certificate: Optional['outputs.DomainSpecPortTlsClientCertificate'] = None,
                 min_protocol_version: Optional[builtins.str] = None,
                 server_certificate: Optional['outputs.DomainSpecPortTlsServerCertificate'] = None):
        """
        :param Sequence[builtins.str] cipher_suites: Allowed cipher suites. Refer to the [Domain Reference](https://docs.controlplane.com/reference/domain#cipher-suites) for details.
        :param 'DomainSpecPortTlsClientCertificateArgs' client_certificate: The certificate authority PEM, stored as a TLS Secret, used to verify the authority of the client certificate. The only verification performed checks that the CN of the PEM matches the Domain (i.e., CN=*.DOMAIN).
        :param builtins.str min_protocol_version: Minimum TLS version to accept. Minimum is `1.0`. Default: `1.2`.
        :param 'DomainSpecPortTlsServerCertificateArgs' server_certificate: Configure an optional custom server certificate for the domain. When the port number is 443 and this is not supplied, a certificate is provisioned automatically.
        """
        if cipher_suites is not None:
            pulumi.set(__self__, "cipher_suites", cipher_suites)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if min_protocol_version is not None:
            pulumi.set(__self__, "min_protocol_version", min_protocol_version)
        if server_certificate is not None:
            pulumi.set(__self__, "server_certificate", server_certificate)

    @property
    @pulumi.getter(name="cipherSuites")
    def cipher_suites(self) -> Optional[Sequence[builtins.str]]:
        """
        Allowed cipher suites. Refer to the [Domain Reference](https://docs.controlplane.com/reference/domain#cipher-suites) for details.
        """
        return pulumi.get(self, "cipher_suites")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional['outputs.DomainSpecPortTlsClientCertificate']:
        """
        The certificate authority PEM, stored as a TLS Secret, used to verify the authority of the client certificate. The only verification performed checks that the CN of the PEM matches the Domain (i.e., CN=*.DOMAIN).
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="minProtocolVersion")
    def min_protocol_version(self) -> Optional[builtins.str]:
        """
        Minimum TLS version to accept. Minimum is `1.0`. Default: `1.2`.
        """
        return pulumi.get(self, "min_protocol_version")

    @property
    @pulumi.getter(name="serverCertificate")
    def server_certificate(self) -> Optional['outputs.DomainSpecPortTlsServerCertificate']:
        """
        Configure an optional custom server certificate for the domain. When the port number is 443 and this is not supplied, a certificate is provisioned automatically.
        """
        return pulumi.get(self, "server_certificate")


@pulumi.output_type
class DomainSpecPortTlsClientCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretLink":
            suggest = "secret_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSpecPortTlsClientCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSpecPortTlsClientCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSpecPortTlsClientCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_link: Optional[builtins.str] = None):
        """
        :param builtins.str secret_link: The secret will include a client certificate authority cert in PEM format used to verify requests which include client certificates. The key subject must match the domain and the key usage properties must be configured for client certificate authorization. The secret type must be keypair.
        """
        if secret_link is not None:
            pulumi.set(__self__, "secret_link", secret_link)

    @property
    @pulumi.getter(name="secretLink")
    def secret_link(self) -> Optional[builtins.str]:
        """
        The secret will include a client certificate authority cert in PEM format used to verify requests which include client certificates. The key subject must match the domain and the key usage properties must be configured for client certificate authorization. The secret type must be keypair.
        """
        return pulumi.get(self, "secret_link")


@pulumi.output_type
class DomainSpecPortTlsServerCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretLink":
            suggest = "secret_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainSpecPortTlsServerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainSpecPortTlsServerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainSpecPortTlsServerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_link: Optional[builtins.str] = None):
        """
        :param builtins.str secret_link: When provided, this is used as the server certificate authority. The secret type must be keypair and the content must be PEM encoded.
        """
        if secret_link is not None:
            pulumi.set(__self__, "secret_link", secret_link)

    @property
    @pulumi.getter(name="secretLink")
    def secret_link(self) -> Optional[builtins.str]:
        """
        When provided, this is used as the server certificate authority. The secret type must be keypair and the content must be PEM encoded.
        """
        return pulumi.get(self, "secret_link")


@pulumi.output_type
class DomainStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsConfigs":
            suggest = "dns_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_configs: Optional[Sequence['outputs.DomainStatusDnsConfig']] = None,
                 endpoints: Optional[Sequence['outputs.DomainStatusEndpoint']] = None,
                 fingerprint: Optional[builtins.str] = None,
                 locations: Optional[Sequence['outputs.DomainStatusLocation']] = None,
                 status: Optional[builtins.str] = None,
                 warning: Optional[builtins.str] = None):
        """
        :param Sequence['DomainStatusDnsConfigArgs'] dns_configs: List of required DNS record entries.
        :param Sequence['DomainStatusEndpointArgs'] endpoints: List of configured domain endpoints.
        :param Sequence['DomainStatusLocationArgs'] locations: Contains the cloud provider name, region, and certificate status.
        :param builtins.str status: Status of Domain. Possible values: `initializing`, `ready`, `pendingDnsConfig`, `pendingCertificate`, `usedByGvc`.
        :param builtins.str warning: Warning message.
        """
        if dns_configs is not None:
            pulumi.set(__self__, "dns_configs", dns_configs)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @property
    @pulumi.getter(name="dnsConfigs")
    def dns_configs(self) -> Optional[Sequence['outputs.DomainStatusDnsConfig']]:
        """
        List of required DNS record entries.
        """
        return pulumi.get(self, "dns_configs")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[Sequence['outputs.DomainStatusEndpoint']]:
        """
        List of configured domain endpoints.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence['outputs.DomainStatusLocation']]:
        """
        Contains the cloud provider name, region, and certificate status.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Status of Domain. Possible values: `initializing`, `ready`, `pendingDnsConfig`, `pendingCertificate`, `usedByGvc`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def warning(self) -> Optional[builtins.str]:
        """
        Warning message.
        """
        return pulumi.get(self, "warning")


@pulumi.output_type
class DomainStatusDnsConfig(dict):
    def __init__(__self__, *,
                 host: Optional[builtins.str] = None,
                 ttl: Optional[builtins.int] = None,
                 type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str host: The host in DNS terminology refers to the domain or subdomain that the DNS record is associated with. It's essentially the name that is being queried or managed. For example, in a DNS record for `www.example.com`, `www` is a host in the domain `example.com`.
        :param builtins.int ttl: Time to live (TTL) is a value that signifies how long (in seconds) a DNS record should be cached by a resolver or a browser before a new request should be sent to refresh the data. Lower TTL values mean records are updated more frequently, which is beneficial for dynamic DNS configurations or during DNS migrations. Higher TTL values reduce the load on DNS servers and improve the speed of name resolution for end users by relying on cached data.
        :param builtins.str type: The DNS record type specifies the type of data the DNS record contains. Valid values: `CNAME`, `NS`, `TXT`.
        :param builtins.str value: The value of a DNS record contains the data the record is meant to convey, based on the type of the record.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[builtins.str]:
        """
        The host in DNS terminology refers to the domain or subdomain that the DNS record is associated with. It's essentially the name that is being queried or managed. For example, in a DNS record for `www.example.com`, `www` is a host in the domain `example.com`.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[builtins.int]:
        """
        Time to live (TTL) is a value that signifies how long (in seconds) a DNS record should be cached by a resolver or a browser before a new request should be sent to refresh the data. Lower TTL values mean records are updated more frequently, which is beneficial for dynamic DNS configurations or during DNS migrations. Higher TTL values reduce the load on DNS servers and improve the speed of name resolution for end users by relying on cached data.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The DNS record type specifies the type of data the DNS record contains. Valid values: `CNAME`, `NS`, `TXT`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of a DNS record contains the data the record is meant to convey, based on the type of the record.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DomainStatusEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workloadLink":
            suggest = "workload_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainStatusEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainStatusEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainStatusEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: Optional[builtins.str] = None,
                 workload_link: Optional[builtins.str] = None):
        """
        :param builtins.str url: URL of endpoint.
        :param builtins.str workload_link: Full link to associated workload.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workload_link is not None:
            pulumi.set(__self__, "workload_link", workload_link)

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        URL of endpoint.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="workloadLink")
    def workload_link(self) -> Optional[builtins.str]:
        """
        Full link to associated workload.
        """
        return pulumi.get(self, "workload_link")


@pulumi.output_type
class DomainStatusLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateStatus":
            suggest = "certificate_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainStatusLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainStatusLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainStatusLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_status: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str certificate_status: The current validity or status of the SSL/TLS certificate.
        :param builtins.str name: The name of the location.
        """
        if certificate_status is not None:
            pulumi.set(__self__, "certificate_status", certificate_status)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="certificateStatus")
    def certificate_status(self) -> Optional[builtins.str]:
        """
        The current validity or status of the SSL/TLS certificate.
        """
        return pulumi.get(self, "certificate_status")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the location.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GroupIdentityMatcher(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 language: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Executes the expression against the users' claims to decide whether a user belongs to this group. This method is useful for managing the grouping of users logged in with SAML providers.
        :param builtins.str language: Language of the expression. Either `jmespath` or `javascript`. Default: `jmespath`.
        """
        pulumi.set(__self__, "expression", expression)
        if language is not None:
            pulumi.set(__self__, "language", language)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Executes the expression against the users' claims to decide whether a user belongs to this group. This method is useful for managing the grouping of users logged in with SAML providers.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def language(self) -> Optional[builtins.str]:
        """
        Language of the expression. Either `jmespath` or `javascript`. Default: `jmespath`.
        """
        return pulumi.get(self, "language")


@pulumi.output_type
class GroupMemberQuery(dict):
    def __init__(__self__, *,
                 fetch: Optional[builtins.str] = None,
                 spec: Optional['outputs.GroupMemberQuerySpec'] = None):
        """
        :param builtins.str fetch: Type of fetch. Specify either: `links` or `items`. Default: `items`.
        """
        if fetch is not None:
            pulumi.set(__self__, "fetch", fetch)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def fetch(self) -> Optional[builtins.str]:
        """
        Type of fetch. Specify either: `links` or `items`. Default: `items`.
        """
        return pulumi.get(self, "fetch")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.GroupMemberQuerySpec']:
        return pulumi.get(self, "spec")


@pulumi.output_type
class GroupMemberQuerySpec(dict):
    def __init__(__self__, *,
                 match: Optional[builtins.str] = None,
                 terms: Optional[Sequence['outputs.GroupMemberQuerySpecTerm']] = None):
        """
        :param builtins.str match: Type of match. Available values: `all`, `any`, `none`. Default: `all`.
        :param Sequence['GroupMemberQuerySpecTermArgs'] terms: Terms can only contain one of the following attributes: `property`, `rel`, `tag`.
        """
        if match is not None:
            pulumi.set(__self__, "match", match)
        if terms is not None:
            pulumi.set(__self__, "terms", terms)

    @property
    @pulumi.getter
    def match(self) -> Optional[builtins.str]:
        """
        Type of match. Available values: `all`, `any`, `none`. Default: `all`.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def terms(self) -> Optional[Sequence['outputs.GroupMemberQuerySpecTerm']]:
        """
        Terms can only contain one of the following attributes: `property`, `rel`, `tag`.
        """
        return pulumi.get(self, "terms")


@pulumi.output_type
class GroupMemberQuerySpecTerm(dict):
    def __init__(__self__, *,
                 op: Optional[builtins.str] = None,
                 property: Optional[builtins.str] = None,
                 rel: Optional[builtins.str] = None,
                 tag: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str op: Type of query operation. Available values: `=`, `>`, `>=`, `<`, `<=`, `!=`, `exists`, `!exists`. Default: `=`.
        :param builtins.str property: Property to use for query evaluation.
        :param builtins.str rel: Relation to use for query evaluation.
        :param builtins.str tag: Tag key to use for query evaluation.
        :param builtins.str value: Testing value for query evaluation.
        """
        if op is not None:
            pulumi.set(__self__, "op", op)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if rel is not None:
            pulumi.set(__self__, "rel", rel)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def op(self) -> Optional[builtins.str]:
        """
        Type of query operation. Available values: `=`, `>`, `>=`, `<`, `<=`, `!=`, `exists`, `!exists`. Default: `=`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def rel(self) -> Optional[builtins.str]:
        """
        Relation to use for query evaluation.
        """
        return pulumi.get(self, "rel")

    @property
    @pulumi.getter
    def tag(self) -> Optional[builtins.str]:
        """
        Tag key to use for query evaluation.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Testing value for query evaluation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> Optional[builtins.str]:
        """
        Property to use for query evaluation.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class GvcControlplaneTracing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTags":
            suggest = "custom_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GvcControlplaneTracing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GvcControlplaneTracing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GvcControlplaneTracing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sampling: builtins.float,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "sampling", sampling)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class GvcLightstepTracing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTags":
            suggest = "custom_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GvcLightstepTracing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GvcLightstepTracing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GvcLightstepTracing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: builtins.str,
                 sampling: builtins.float,
                 credentials: Optional[builtins.str] = None,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str endpoint: Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param builtins.str credentials: Full link to referenced Opaque Secret.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "sampling", sampling)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter
    def credentials(self) -> Optional[builtins.str]:
        """
        Full link to referenced Opaque Secret.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class GvcLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multiZone":
            suggest = "multi_zone"
        elif key == "trustedProxies":
            suggest = "trusted_proxies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GvcLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GvcLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GvcLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dedicated: Optional[builtins.bool] = None,
                 ipset: Optional[builtins.str] = None,
                 multi_zone: Optional['outputs.GvcLoadBalancerMultiZone'] = None,
                 redirect: Optional['outputs.GvcLoadBalancerRedirect'] = None,
                 trusted_proxies: Optional[builtins.int] = None):
        """
        :param builtins.bool dedicated: Creates a dedicated load balancer in each location and enables additional Domain features: custom ports, protocols and wildcard hostnames. Charges apply for each location.
        :param builtins.str ipset: The link or the name of the IP Set that will be used for this load balancer.
        :param 'GvcLoadBalancerRedirectArgs' redirect: Specify the url to be redirected to for different http status codes.
        :param builtins.int trusted_proxies: Controls the address used for request logging and for setting the X-Envoy-External-Address header. If set to 1, then the last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If set to 2, then the second to last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If the XFF header does not have at least two addresses or does not exist then the source client IP address will be used instead.
        """
        if dedicated is not None:
            pulumi.set(__self__, "dedicated", dedicated)
        if ipset is not None:
            pulumi.set(__self__, "ipset", ipset)
        if multi_zone is not None:
            pulumi.set(__self__, "multi_zone", multi_zone)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if trusted_proxies is not None:
            pulumi.set(__self__, "trusted_proxies", trusted_proxies)

    @property
    @pulumi.getter
    def dedicated(self) -> Optional[builtins.bool]:
        """
        Creates a dedicated load balancer in each location and enables additional Domain features: custom ports, protocols and wildcard hostnames. Charges apply for each location.
        """
        return pulumi.get(self, "dedicated")

    @property
    @pulumi.getter
    def ipset(self) -> Optional[builtins.str]:
        """
        The link or the name of the IP Set that will be used for this load balancer.
        """
        return pulumi.get(self, "ipset")

    @property
    @pulumi.getter(name="multiZone")
    def multi_zone(self) -> Optional['outputs.GvcLoadBalancerMultiZone']:
        return pulumi.get(self, "multi_zone")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.GvcLoadBalancerRedirect']:
        """
        Specify the url to be redirected to for different http status codes.
        """
        return pulumi.get(self, "redirect")

    @property
    @pulumi.getter(name="trustedProxies")
    def trusted_proxies(self) -> Optional[builtins.int]:
        """
        Controls the address used for request logging and for setting the X-Envoy-External-Address header. If set to 1, then the last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If set to 2, then the second to last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If the XFF header does not have at least two addresses or does not exist then the source client IP address will be used instead.
        """
        return pulumi.get(self, "trusted_proxies")


@pulumi.output_type
class GvcLoadBalancerMultiZone(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GvcLoadBalancerRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "class":
            suggest = "class_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GvcLoadBalancerRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GvcLoadBalancerRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GvcLoadBalancerRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_: Optional['outputs.GvcLoadBalancerRedirectClass'] = None):
        """
        :param 'GvcLoadBalancerRedirectClassArgs' class_: Specify the redirect url for all status codes in a class.
        """
        if class_ is not None:
            pulumi.set(__self__, "class_", class_)

    @property
    @pulumi.getter(name="class")
    def class_(self) -> Optional['outputs.GvcLoadBalancerRedirectClass']:
        """
        Specify the redirect url for all status codes in a class.
        """
        return pulumi.get(self, "class_")


@pulumi.output_type
class GvcLoadBalancerRedirectClass(dict):
    def __init__(__self__, *,
                 status401: Optional[builtins.str] = None,
                 status5xx: Optional[builtins.str] = None):
        """
        :param builtins.str status401: An optional url redirect for 401 responses. Supports envoy format strings to include request information. E.g. https://your-oauth-server/oauth2/authorize?return_to=%REQ(:path)%&client_id=your-client-id
        :param builtins.str status5xx: Specify the redirect url for any 500 level status code.
        """
        if status401 is not None:
            pulumi.set(__self__, "status401", status401)
        if status5xx is not None:
            pulumi.set(__self__, "status5xx", status5xx)

    @property
    @pulumi.getter
    def status401(self) -> Optional[builtins.str]:
        """
        An optional url redirect for 401 responses. Supports envoy format strings to include request information. E.g. https://your-oauth-server/oauth2/authorize?return_to=%REQ(:path)%&client_id=your-client-id
        """
        return pulumi.get(self, "status401")

    @property
    @pulumi.getter
    def status5xx(self) -> Optional[builtins.str]:
        """
        Specify the redirect url for any 500 level status code.
        """
        return pulumi.get(self, "status5xx")


@pulumi.output_type
class GvcOtelTracing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTags":
            suggest = "custom_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GvcOtelTracing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GvcOtelTracing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GvcOtelTracing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: builtins.str,
                 sampling: builtins.float,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str endpoint: Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "sampling", sampling)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class GvcSidecar(dict):
    def __init__(__self__, *,
                 envoy: builtins.str):
        pulumi.set(__self__, "envoy", envoy)

    @property
    @pulumi.getter
    def envoy(self) -> builtins.str:
        return pulumi.get(self, "envoy")


@pulumi.output_type
class IdentityAwsAccessPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudAccountLink":
            suggest = "cloud_account_link"
        elif key == "policyRefs":
            suggest = "policy_refs"
        elif key == "roleName":
            suggest = "role_name"
        elif key == "trustPolicies":
            suggest = "trust_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityAwsAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityAwsAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityAwsAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_account_link: builtins.str,
                 policy_refs: Optional[Sequence[builtins.str]] = None,
                 role_name: Optional[builtins.str] = None,
                 trust_policies: Optional[Sequence['outputs.IdentityAwsAccessPolicyTrustPolicy']] = None):
        """
        :param builtins.str cloud_account_link: Full link to referenced cloud account.
        :param Sequence[builtins.str] policy_refs: List of policies.
        :param builtins.str role_name: Role name.
        :param Sequence['IdentityAwsAccessPolicyTrustPolicyArgs'] trust_policies: The trust policy for the role.
        """
        pulumi.set(__self__, "cloud_account_link", cloud_account_link)
        if policy_refs is not None:
            pulumi.set(__self__, "policy_refs", policy_refs)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if trust_policies is not None:
            pulumi.set(__self__, "trust_policies", trust_policies)

    @property
    @pulumi.getter(name="cloudAccountLink")
    def cloud_account_link(self) -> builtins.str:
        """
        Full link to referenced cloud account.
        """
        return pulumi.get(self, "cloud_account_link")

    @property
    @pulumi.getter(name="policyRefs")
    def policy_refs(self) -> Optional[Sequence[builtins.str]]:
        """
        List of policies.
        """
        return pulumi.get(self, "policy_refs")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[builtins.str]:
        """
        Role name.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="trustPolicies")
    def trust_policies(self) -> Optional[Sequence['outputs.IdentityAwsAccessPolicyTrustPolicy']]:
        """
        The trust policy for the role.
        """
        return pulumi.get(self, "trust_policies")


@pulumi.output_type
class IdentityAwsAccessPolicyTrustPolicy(dict):
    def __init__(__self__, *,
                 statements: Optional[Sequence[Mapping[str, builtins.str]]] = None,
                 version: Optional[builtins.str] = None):
        """
        :param Sequence[Mapping[str, builtins.str]] statements: List of statements.
        :param builtins.str version: Version of the policy.
        """
        if statements is not None:
            pulumi.set(__self__, "statements", statements)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def statements(self) -> Optional[Sequence[Mapping[str, builtins.str]]]:
        """
        List of statements.
        """
        return pulumi.get(self, "statements")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Version of the policy.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class IdentityAzureAccessPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudAccountLink":
            suggest = "cloud_account_link"
        elif key == "roleAssignments":
            suggest = "role_assignments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityAzureAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityAzureAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityAzureAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_account_link: builtins.str,
                 role_assignments: Optional[Sequence['outputs.IdentityAzureAccessPolicyRoleAssignment']] = None):
        """
        :param builtins.str cloud_account_link: Full link to referenced cloud account.
        :param Sequence['IdentityAzureAccessPolicyRoleAssignmentArgs'] role_assignments: The process of assigning specific roles or permissions to an entity, such as a user or a service principal, within the system.
        """
        pulumi.set(__self__, "cloud_account_link", cloud_account_link)
        if role_assignments is not None:
            pulumi.set(__self__, "role_assignments", role_assignments)

    @property
    @pulumi.getter(name="cloudAccountLink")
    def cloud_account_link(self) -> builtins.str:
        """
        Full link to referenced cloud account.
        """
        return pulumi.get(self, "cloud_account_link")

    @property
    @pulumi.getter(name="roleAssignments")
    def role_assignments(self) -> Optional[Sequence['outputs.IdentityAzureAccessPolicyRoleAssignment']]:
        """
        The process of assigning specific roles or permissions to an entity, such as a user or a service principal, within the system.
        """
        return pulumi.get(self, "role_assignments")


@pulumi.output_type
class IdentityAzureAccessPolicyRoleAssignment(dict):
    def __init__(__self__, *,
                 roles: Optional[Sequence[builtins.str]] = None,
                 scope: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] roles: List of assigned roles.
        :param builtins.str scope: Scope of roles.
        """
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def roles(self) -> Optional[Sequence[builtins.str]]:
        """
        List of assigned roles.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        Scope of roles.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class IdentityGcpAccessPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudAccountLink":
            suggest = "cloud_account_link"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityGcpAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityGcpAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityGcpAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_account_link: builtins.str,
                 bindings: Optional[Sequence['outputs.IdentityGcpAccessPolicyBinding']] = None,
                 scopes: Optional[Sequence[builtins.str]] = None,
                 service_account: Optional[builtins.str] = None):
        """
        :param builtins.str cloud_account_link: Full link to referenced cloud account.
        :param Sequence['IdentityGcpAccessPolicyBindingArgs'] bindings: The association or connection between a particular identity, such as a user or a group, and a set of permissions or roles within the system.
        :param Sequence[builtins.str] scopes: Comma delimited list of GCP scope URLs.
        :param builtins.str service_account: Name of existing GCP service account.
        """
        pulumi.set(__self__, "cloud_account_link", cloud_account_link)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="cloudAccountLink")
    def cloud_account_link(self) -> builtins.str:
        """
        Full link to referenced cloud account.
        """
        return pulumi.get(self, "cloud_account_link")

    @property
    @pulumi.getter
    def bindings(self) -> Optional[Sequence['outputs.IdentityGcpAccessPolicyBinding']]:
        """
        The association or connection between a particular identity, such as a user or a group, and a set of permissions or roles within the system.
        """
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[builtins.str]]:
        """
        Comma delimited list of GCP scope URLs.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[builtins.str]:
        """
        Name of existing GCP service account.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class IdentityGcpAccessPolicyBinding(dict):
    def __init__(__self__, *,
                 resource: Optional[builtins.str] = None,
                 roles: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str resource: Name of resource for binding.
        :param Sequence[builtins.str] roles: List of allowed roles.
        """
        if resource is not None:
            pulumi.set(__self__, "resource", resource)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def resource(self) -> Optional[builtins.str]:
        """
        Name of resource for binding.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def roles(self) -> Optional[Sequence[builtins.str]]:
        """
        List of allowed roles.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class IdentityNativeNetworkResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsPrivateLink":
            suggest = "aws_private_link"
        elif key == "gcpServiceConnect":
            suggest = "gcp_service_connect"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityNativeNetworkResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityNativeNetworkResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityNativeNetworkResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fqdn: builtins.str,
                 name: builtins.str,
                 ports: Sequence[builtins.int],
                 aws_private_link: Optional['outputs.IdentityNativeNetworkResourceAwsPrivateLink'] = None,
                 gcp_service_connect: Optional['outputs.IdentityNativeNetworkResourceGcpServiceConnect'] = None):
        """
        :param builtins.str fqdn: Fully qualified domain name.
        :param builtins.str name: Name of the Native Network Resource.
        :param Sequence[builtins.int] ports: Ports to expose. At least one port is required.
        :param 'IdentityNativeNetworkResourceAwsPrivateLinkArgs' aws_private_link: A feature provided by AWS that enables private connectivity between private VPCs and compute running at Control Plane without traversing the public internet.
        :param 'IdentityNativeNetworkResourceGcpServiceConnectArgs' gcp_service_connect: Capability provided by GCP that allows private communication between private VPC networks and compute running at Control Plane.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        if aws_private_link is not None:
            pulumi.set(__self__, "aws_private_link", aws_private_link)
        if gcp_service_connect is not None:
            pulumi.set(__self__, "gcp_service_connect", gcp_service_connect)

    @property
    @pulumi.getter
    def fqdn(self) -> builtins.str:
        """
        Fully qualified domain name.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the Native Network Resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[builtins.int]:
        """
        Ports to expose. At least one port is required.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="awsPrivateLink")
    def aws_private_link(self) -> Optional['outputs.IdentityNativeNetworkResourceAwsPrivateLink']:
        """
        A feature provided by AWS that enables private connectivity between private VPCs and compute running at Control Plane without traversing the public internet.
        """
        return pulumi.get(self, "aws_private_link")

    @property
    @pulumi.getter(name="gcpServiceConnect")
    def gcp_service_connect(self) -> Optional['outputs.IdentityNativeNetworkResourceGcpServiceConnect']:
        """
        Capability provided by GCP that allows private communication between private VPC networks and compute running at Control Plane.
        """
        return pulumi.get(self, "gcp_service_connect")


@pulumi.output_type
class IdentityNativeNetworkResourceAwsPrivateLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointServiceName":
            suggest = "endpoint_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityNativeNetworkResourceAwsPrivateLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityNativeNetworkResourceAwsPrivateLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityNativeNetworkResourceAwsPrivateLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_service_name: builtins.str):
        """
        :param builtins.str endpoint_service_name: Endpoint service name.
        """
        pulumi.set(__self__, "endpoint_service_name", endpoint_service_name)

    @property
    @pulumi.getter(name="endpointServiceName")
    def endpoint_service_name(self) -> builtins.str:
        """
        Endpoint service name.
        """
        return pulumi.get(self, "endpoint_service_name")


@pulumi.output_type
class IdentityNativeNetworkResourceGcpServiceConnect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetService":
            suggest = "target_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityNativeNetworkResourceGcpServiceConnect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityNativeNetworkResourceGcpServiceConnect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityNativeNetworkResourceGcpServiceConnect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_service: builtins.str):
        """
        :param builtins.str target_service: Target service name.
        """
        pulumi.set(__self__, "target_service", target_service)

    @property
    @pulumi.getter(name="targetService")
    def target_service(self) -> builtins.str:
        """
        Target service name.
        """
        return pulumi.get(self, "target_service")


@pulumi.output_type
class IdentityNetworkResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentLink":
            suggest = "agent_link"
        elif key == "resolverIp":
            suggest = "resolver_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityNetworkResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityNetworkResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityNetworkResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 ports: Sequence[builtins.int],
                 agent_link: Optional[builtins.str] = None,
                 fqdn: Optional[builtins.str] = None,
                 ips: Optional[Sequence[builtins.str]] = None,
                 resolver_ip: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the Network Resource.
        :param Sequence[builtins.int] ports: Ports to expose.
        :param builtins.str agent_link: Full link to referenced Agent.
        :param builtins.str fqdn: Fully qualified domain name.
        :param Sequence[builtins.str] ips: List of IP addresses.
        :param builtins.str resolver_ip: Resolver IP.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        if agent_link is not None:
            pulumi.set(__self__, "agent_link", agent_link)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if resolver_ip is not None:
            pulumi.set(__self__, "resolver_ip", resolver_ip)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the Network Resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence[builtins.int]:
        """
        Ports to expose.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="agentLink")
    def agent_link(self) -> Optional[builtins.str]:
        """
        Full link to referenced Agent.
        """
        return pulumi.get(self, "agent_link")

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[builtins.str]:
        """
        Fully qualified domain name.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def ips(self) -> Optional[Sequence[builtins.str]]:
        """
        List of IP addresses.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="resolverIp")
    def resolver_ip(self) -> Optional[builtins.str]:
        """
        Resolver IP.
        """
        return pulumi.get(self, "resolver_ip")


@pulumi.output_type
class IdentityNgsAccessPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudAccountLink":
            suggest = "cloud_account_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityNgsAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityNgsAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityNgsAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_account_link: builtins.str,
                 data: Optional[builtins.int] = None,
                 payload: Optional[builtins.int] = None,
                 pub: Optional['outputs.IdentityNgsAccessPolicyPub'] = None,
                 resp: Optional['outputs.IdentityNgsAccessPolicyResp'] = None,
                 sub: Optional['outputs.IdentityNgsAccessPolicySub'] = None,
                 subs: Optional[builtins.int] = None):
        """
        :param builtins.str cloud_account_link: Full link to referenced cloud account.
        :param builtins.int data: Max number of bytes a connection can send. Default: -1
        :param builtins.int payload: Max message payload. Default: -1
        :param 'IdentityNgsAccessPolicyPubArgs' pub: Pub Permission.
        :param 'IdentityNgsAccessPolicyRespArgs' resp: Reponses.
        :param 'IdentityNgsAccessPolicySubArgs' sub: Sub Permission.
        :param builtins.int subs: Max number of subscriptions per connection. Default: -1
        """
        pulumi.set(__self__, "cloud_account_link", cloud_account_link)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if pub is not None:
            pulumi.set(__self__, "pub", pub)
        if resp is not None:
            pulumi.set(__self__, "resp", resp)
        if sub is not None:
            pulumi.set(__self__, "sub", sub)
        if subs is not None:
            pulumi.set(__self__, "subs", subs)

    @property
    @pulumi.getter(name="cloudAccountLink")
    def cloud_account_link(self) -> builtins.str:
        """
        Full link to referenced cloud account.
        """
        return pulumi.get(self, "cloud_account_link")

    @property
    @pulumi.getter
    def data(self) -> Optional[builtins.int]:
        """
        Max number of bytes a connection can send. Default: -1
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def payload(self) -> Optional[builtins.int]:
        """
        Max message payload. Default: -1
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def pub(self) -> Optional['outputs.IdentityNgsAccessPolicyPub']:
        """
        Pub Permission.
        """
        return pulumi.get(self, "pub")

    @property
    @pulumi.getter
    def resp(self) -> Optional['outputs.IdentityNgsAccessPolicyResp']:
        """
        Reponses.
        """
        return pulumi.get(self, "resp")

    @property
    @pulumi.getter
    def sub(self) -> Optional['outputs.IdentityNgsAccessPolicySub']:
        """
        Sub Permission.
        """
        return pulumi.get(self, "sub")

    @property
    @pulumi.getter
    def subs(self) -> Optional[builtins.int]:
        """
        Max number of subscriptions per connection. Default: -1
        """
        return pulumi.get(self, "subs")


@pulumi.output_type
class IdentityNgsAccessPolicyPub(dict):
    def __init__(__self__, *,
                 allows: Optional[Sequence[builtins.str]] = None,
                 denies: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] allows: List of allow subjects.
        :param Sequence[builtins.str] denies: List of deny subjects.
        """
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)

    @property
    @pulumi.getter
    def allows(self) -> Optional[Sequence[builtins.str]]:
        """
        List of allow subjects.
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter
    def denies(self) -> Optional[Sequence[builtins.str]]:
        """
        List of deny subjects.
        """
        return pulumi.get(self, "denies")


@pulumi.output_type
class IdentityNgsAccessPolicyResp(dict):
    def __init__(__self__, *,
                 max: Optional[builtins.int] = None,
                 ttl: Optional[builtins.str] = None):
        """
        :param builtins.int max: Number of responses allowed on the replyTo subject, -1 means no limit. Default: -1
        :param builtins.str ttl: Deadline to send replies on the replyTo subject [#ms(millis) | #s(econds) | m(inutes) | h(ours)]. -1 means no restriction.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def max(self) -> Optional[builtins.int]:
        """
        Number of responses allowed on the replyTo subject, -1 means no limit. Default: -1
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[builtins.str]:
        """
        Deadline to send replies on the replyTo subject [#ms(millis) | #s(econds) | m(inutes) | h(ours)]. -1 means no restriction.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class IdentityNgsAccessPolicySub(dict):
    def __init__(__self__, *,
                 allows: Optional[Sequence[builtins.str]] = None,
                 denies: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] allows: List of allow subjects.
        :param Sequence[builtins.str] denies: List of deny subjects.
        """
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)

    @property
    @pulumi.getter
    def allows(self) -> Optional[Sequence[builtins.str]]:
        """
        List of allow subjects.
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter
    def denies(self) -> Optional[Sequence[builtins.str]]:
        """
        List of deny subjects.
        """
        return pulumi.get(self, "denies")


@pulumi.output_type
class IpSetLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicy":
            suggest = "retention_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpSetLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpSetLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpSetLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 retention_policy: builtins.str):
        """
        :param builtins.str name: The self link of a location.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "retention_policy", retention_policy)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The self link of a location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> builtins.str:
        return pulumi.get(self, "retention_policy")


@pulumi.output_type
class IpSetStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpSetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpSetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpSetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error: Optional[builtins.str] = None,
                 ip_addresses: Optional[Sequence['outputs.IpSetStatusIpAddress']] = None,
                 warning: Optional[builtins.str] = None):
        if error is not None:
            pulumi.set(__self__, "error", error)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if warning is not None:
            pulumi.set(__self__, "warning", warning)

    @property
    @pulumi.getter
    def error(self) -> Optional[builtins.str]:
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[Sequence['outputs.IpSetStatusIpAddress']]:
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def warning(self) -> Optional[builtins.str]:
        return pulumi.get(self, "warning")


@pulumi.output_type
class IpSetStatusIpAddress(dict):
    def __init__(__self__, *,
                 created: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 ip: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 state: Optional[builtins.str] = None):
        if created is not None:
            pulumi.set(__self__, "created", created)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def created(self) -> Optional[builtins.str]:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        return pulumi.get(self, "state")


@pulumi.output_type
class LocationGeo(dict):
    def __init__(__self__, *,
                 city: Optional[builtins.str] = None,
                 continent: Optional[builtins.str] = None,
                 country: Optional[builtins.str] = None,
                 lat: Optional[builtins.float] = None,
                 lon: Optional[builtins.float] = None,
                 state: Optional[builtins.str] = None):
        """
        :param builtins.str city: City of the location.
        :param builtins.str continent: Continent of the location.
        :param builtins.str country: Country of the location.
        :param builtins.float lat: Latitude of the location.
        :param builtins.float lon: Longitude of the location.
        :param builtins.str state: State of the location.
        """
        if city is not None:
            pulumi.set(__self__, "city", city)
        if continent is not None:
            pulumi.set(__self__, "continent", continent)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if lat is not None:
            pulumi.set(__self__, "lat", lat)
        if lon is not None:
            pulumi.set(__self__, "lon", lon)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        City of the location.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def continent(self) -> Optional[builtins.str]:
        """
        Continent of the location.
        """
        return pulumi.get(self, "continent")

    @property
    @pulumi.getter
    def country(self) -> Optional[builtins.str]:
        """
        Country of the location.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def lat(self) -> Optional[builtins.float]:
        """
        Latitude of the location.
        """
        return pulumi.get(self, "lat")

    @property
    @pulumi.getter
    def lon(self) -> Optional[builtins.float]:
        """
        Longitude of the location.
        """
        return pulumi.get(self, "lon")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        State of the location.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class Mk8sAddOns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsEcr":
            suggest = "aws_ecr"
        elif key == "awsEfs":
            suggest = "aws_efs"
        elif key == "awsElb":
            suggest = "aws_elb"
        elif key == "awsWorkloadIdentity":
            suggest = "aws_workload_identity"
        elif key == "azureAcr":
            suggest = "azure_acr"
        elif key == "azureWorkloadIdentity":
            suggest = "azure_workload_identity"
        elif key == "localPathStorage":
            suggest = "local_path_storage"
        elif key == "registryMirror":
            suggest = "registry_mirror"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_ecr: Optional['outputs.Mk8sAddOnsAwsEcr'] = None,
                 aws_efs: Optional['outputs.Mk8sAddOnsAwsEfs'] = None,
                 aws_elb: Optional['outputs.Mk8sAddOnsAwsElb'] = None,
                 aws_workload_identity: Optional[builtins.bool] = None,
                 azure_acr: Optional['outputs.Mk8sAddOnsAzureAcr'] = None,
                 azure_workload_identity: Optional['outputs.Mk8sAddOnsAzureWorkloadIdentity'] = None,
                 dashboard: Optional[builtins.bool] = None,
                 local_path_storage: Optional[builtins.bool] = None,
                 logs: Optional['outputs.Mk8sAddOnsLogs'] = None,
                 metrics: Optional['outputs.Mk8sAddOnsMetrics'] = None,
                 nvidia: Optional['outputs.Mk8sAddOnsNvidia'] = None,
                 registry_mirror: Optional['outputs.Mk8sAddOnsRegistryMirror'] = None,
                 sysbox: Optional[builtins.bool] = None):
        """
        :param 'Mk8sAddOnsMetricsArgs' metrics: Scrape pods annotated with prometheus.io/scrape=true
        """
        if aws_ecr is not None:
            pulumi.set(__self__, "aws_ecr", aws_ecr)
        if aws_efs is not None:
            pulumi.set(__self__, "aws_efs", aws_efs)
        if aws_elb is not None:
            pulumi.set(__self__, "aws_elb", aws_elb)
        if aws_workload_identity is not None:
            pulumi.set(__self__, "aws_workload_identity", aws_workload_identity)
        if azure_acr is not None:
            pulumi.set(__self__, "azure_acr", azure_acr)
        if azure_workload_identity is not None:
            pulumi.set(__self__, "azure_workload_identity", azure_workload_identity)
        if dashboard is not None:
            pulumi.set(__self__, "dashboard", dashboard)
        if local_path_storage is not None:
            pulumi.set(__self__, "local_path_storage", local_path_storage)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if nvidia is not None:
            pulumi.set(__self__, "nvidia", nvidia)
        if registry_mirror is not None:
            pulumi.set(__self__, "registry_mirror", registry_mirror)
        if sysbox is not None:
            pulumi.set(__self__, "sysbox", sysbox)

    @property
    @pulumi.getter(name="awsEcr")
    def aws_ecr(self) -> Optional['outputs.Mk8sAddOnsAwsEcr']:
        return pulumi.get(self, "aws_ecr")

    @property
    @pulumi.getter(name="awsEfs")
    def aws_efs(self) -> Optional['outputs.Mk8sAddOnsAwsEfs']:
        return pulumi.get(self, "aws_efs")

    @property
    @pulumi.getter(name="awsElb")
    def aws_elb(self) -> Optional['outputs.Mk8sAddOnsAwsElb']:
        return pulumi.get(self, "aws_elb")

    @property
    @pulumi.getter(name="awsWorkloadIdentity")
    def aws_workload_identity(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "aws_workload_identity")

    @property
    @pulumi.getter(name="azureAcr")
    def azure_acr(self) -> Optional['outputs.Mk8sAddOnsAzureAcr']:
        return pulumi.get(self, "azure_acr")

    @property
    @pulumi.getter(name="azureWorkloadIdentity")
    def azure_workload_identity(self) -> Optional['outputs.Mk8sAddOnsAzureWorkloadIdentity']:
        return pulumi.get(self, "azure_workload_identity")

    @property
    @pulumi.getter
    def dashboard(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "dashboard")

    @property
    @pulumi.getter(name="localPathStorage")
    def local_path_storage(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "local_path_storage")

    @property
    @pulumi.getter
    def logs(self) -> Optional['outputs.Mk8sAddOnsLogs']:
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> Optional['outputs.Mk8sAddOnsMetrics']:
        """
        Scrape pods annotated with prometheus.io/scrape=true
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def nvidia(self) -> Optional['outputs.Mk8sAddOnsNvidia']:
        return pulumi.get(self, "nvidia")

    @property
    @pulumi.getter(name="registryMirror")
    def registry_mirror(self) -> Optional['outputs.Mk8sAddOnsRegistryMirror']:
        return pulumi.get(self, "registry_mirror")

    @property
    @pulumi.getter
    def sysbox(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "sysbox")


@pulumi.output_type
class Mk8sAddOnsAwsEcr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsAwsEcr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsAwsEcr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsAwsEcr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str role_arn: Role to use when authorizing ECR pulls. Optional on AWS, in which case it will use the instance role to pull.
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Role to use when authorizing ECR pulls. Optional on AWS, in which case it will use the instance role to pull.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class Mk8sAddOnsAwsEfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsAwsEfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsAwsEfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsAwsEfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str role_arn: Use this role for EFS interaction.
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Use this role for EFS interaction.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class Mk8sAddOnsAwsElb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsAwsElb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsAwsElb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsAwsElb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str role_arn: Role to use when authorizing calls to EC2 ELB. Optional on AWS, when not provided it will create the recommended role.
        """
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Role to use when authorizing calls to EC2 ELB. Optional on AWS, when not provided it will create the recommended role.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class Mk8sAddOnsAzureAcr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsAzureAcr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsAzureAcr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsAzureAcr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: builtins.str):
        pulumi.set(__self__, "client_id", client_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        return pulumi.get(self, "client_id")


@pulumi.output_type
class Mk8sAddOnsAzureWorkloadIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsAzureWorkloadIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsAzureWorkloadIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsAzureWorkloadIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str tenant_id: Tenant ID to use for workload identity.
        """
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        Tenant ID to use for workload identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class Mk8sAddOnsLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditEnabled":
            suggest = "audit_enabled"
        elif key == "excludeNamespaces":
            suggest = "exclude_namespaces"
        elif key == "includeNamespaces":
            suggest = "include_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_enabled: Optional[builtins.bool] = None,
                 docker: Optional[builtins.bool] = None,
                 events: Optional[builtins.bool] = None,
                 exclude_namespaces: Optional[builtins.str] = None,
                 include_namespaces: Optional[builtins.str] = None,
                 kernel: Optional[builtins.bool] = None,
                 kubelet: Optional[builtins.bool] = None):
        """
        :param builtins.bool audit_enabled: Collect k8s audit log as log events.
        :param builtins.bool docker: Collect docker logs if docker is also running.
        :param builtins.bool events: Collect K8S events from all namespaces.
        :param builtins.bool kernel: Collect kernel logs.
        :param builtins.bool kubelet: Collect kubelet logs from journald.
        """
        if audit_enabled is not None:
            pulumi.set(__self__, "audit_enabled", audit_enabled)
        if docker is not None:
            pulumi.set(__self__, "docker", docker)
        if events is not None:
            pulumi.set(__self__, "events", events)
        if exclude_namespaces is not None:
            pulumi.set(__self__, "exclude_namespaces", exclude_namespaces)
        if include_namespaces is not None:
            pulumi.set(__self__, "include_namespaces", include_namespaces)
        if kernel is not None:
            pulumi.set(__self__, "kernel", kernel)
        if kubelet is not None:
            pulumi.set(__self__, "kubelet", kubelet)

    @property
    @pulumi.getter(name="auditEnabled")
    def audit_enabled(self) -> Optional[builtins.bool]:
        """
        Collect k8s audit log as log events.
        """
        return pulumi.get(self, "audit_enabled")

    @property
    @pulumi.getter
    def docker(self) -> Optional[builtins.bool]:
        """
        Collect docker logs if docker is also running.
        """
        return pulumi.get(self, "docker")

    @property
    @pulumi.getter
    def events(self) -> Optional[builtins.bool]:
        """
        Collect K8S events from all namespaces.
        """
        return pulumi.get(self, "events")

    @property
    @pulumi.getter(name="excludeNamespaces")
    def exclude_namespaces(self) -> Optional[builtins.str]:
        return pulumi.get(self, "exclude_namespaces")

    @property
    @pulumi.getter(name="includeNamespaces")
    def include_namespaces(self) -> Optional[builtins.str]:
        return pulumi.get(self, "include_namespaces")

    @property
    @pulumi.getter
    def kernel(self) -> Optional[builtins.bool]:
        """
        Collect kernel logs.
        """
        return pulumi.get(self, "kernel")

    @property
    @pulumi.getter
    def kubelet(self) -> Optional[builtins.bool]:
        """
        Collect kubelet logs from journald.
        """
        return pulumi.get(self, "kubelet")


@pulumi.output_type
class Mk8sAddOnsMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServer":
            suggest = "api_server"
        elif key == "coreDns":
            suggest = "core_dns"
        elif key == "kubeState":
            suggest = "kube_state"
        elif key == "nodeExporter":
            suggest = "node_exporter"
        elif key == "scrapeAnnotated":
            suggest = "scrape_annotated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server: Optional[builtins.bool] = None,
                 cadvisor: Optional[builtins.bool] = None,
                 core_dns: Optional[builtins.bool] = None,
                 kube_state: Optional[builtins.bool] = None,
                 kubelet: Optional[builtins.bool] = None,
                 node_exporter: Optional[builtins.bool] = None,
                 scrape_annotated: Optional['outputs.Mk8sAddOnsMetricsScrapeAnnotated'] = None):
        """
        :param builtins.bool api_server: Enable scraping apiserver stats.
        :param builtins.bool cadvisor: Enable CNI-level container stats.
        :param builtins.bool core_dns: Enable scraping of core-dns service.
        :param builtins.bool kube_state: Enable kube-state metrics.
        :param builtins.bool kubelet: Enable scraping kubelet stats.
        :param builtins.bool node_exporter: Enable collecting node-level stats (disk, network, filesystem, etc).
        """
        if api_server is not None:
            pulumi.set(__self__, "api_server", api_server)
        if cadvisor is not None:
            pulumi.set(__self__, "cadvisor", cadvisor)
        if core_dns is not None:
            pulumi.set(__self__, "core_dns", core_dns)
        if kube_state is not None:
            pulumi.set(__self__, "kube_state", kube_state)
        if kubelet is not None:
            pulumi.set(__self__, "kubelet", kubelet)
        if node_exporter is not None:
            pulumi.set(__self__, "node_exporter", node_exporter)
        if scrape_annotated is not None:
            pulumi.set(__self__, "scrape_annotated", scrape_annotated)

    @property
    @pulumi.getter(name="apiServer")
    def api_server(self) -> Optional[builtins.bool]:
        """
        Enable scraping apiserver stats.
        """
        return pulumi.get(self, "api_server")

    @property
    @pulumi.getter
    def cadvisor(self) -> Optional[builtins.bool]:
        """
        Enable CNI-level container stats.
        """
        return pulumi.get(self, "cadvisor")

    @property
    @pulumi.getter(name="coreDns")
    def core_dns(self) -> Optional[builtins.bool]:
        """
        Enable scraping of core-dns service.
        """
        return pulumi.get(self, "core_dns")

    @property
    @pulumi.getter(name="kubeState")
    def kube_state(self) -> Optional[builtins.bool]:
        """
        Enable kube-state metrics.
        """
        return pulumi.get(self, "kube_state")

    @property
    @pulumi.getter
    def kubelet(self) -> Optional[builtins.bool]:
        """
        Enable scraping kubelet stats.
        """
        return pulumi.get(self, "kubelet")

    @property
    @pulumi.getter(name="nodeExporter")
    def node_exporter(self) -> Optional[builtins.bool]:
        """
        Enable collecting node-level stats (disk, network, filesystem, etc).
        """
        return pulumi.get(self, "node_exporter")

    @property
    @pulumi.getter(name="scrapeAnnotated")
    def scrape_annotated(self) -> Optional['outputs.Mk8sAddOnsMetricsScrapeAnnotated']:
        return pulumi.get(self, "scrape_annotated")


@pulumi.output_type
class Mk8sAddOnsMetricsScrapeAnnotated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeNamespaces":
            suggest = "exclude_namespaces"
        elif key == "includeNamespaces":
            suggest = "include_namespaces"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "retainLabels":
            suggest = "retain_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsMetricsScrapeAnnotated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsMetricsScrapeAnnotated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsMetricsScrapeAnnotated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_namespaces: Optional[builtins.str] = None,
                 include_namespaces: Optional[builtins.str] = None,
                 interval_seconds: Optional[builtins.int] = None,
                 retain_labels: Optional[builtins.str] = None):
        if exclude_namespaces is not None:
            pulumi.set(__self__, "exclude_namespaces", exclude_namespaces)
        if include_namespaces is not None:
            pulumi.set(__self__, "include_namespaces", include_namespaces)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if retain_labels is not None:
            pulumi.set(__self__, "retain_labels", retain_labels)

    @property
    @pulumi.getter(name="excludeNamespaces")
    def exclude_namespaces(self) -> Optional[builtins.str]:
        return pulumi.get(self, "exclude_namespaces")

    @property
    @pulumi.getter(name="includeNamespaces")
    def include_namespaces(self) -> Optional[builtins.str]:
        return pulumi.get(self, "include_namespaces")

    @property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "interval_seconds")

    @property
    @pulumi.getter(name="retainLabels")
    def retain_labels(self) -> Optional[builtins.str]:
        return pulumi.get(self, "retain_labels")


@pulumi.output_type
class Mk8sAddOnsNvidia(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taintGpuNodes":
            suggest = "taint_gpu_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAddOnsNvidia. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAddOnsNvidia.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAddOnsNvidia.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 taint_gpu_nodes: Optional[builtins.bool] = None):
        if taint_gpu_nodes is not None:
            pulumi.set(__self__, "taint_gpu_nodes", taint_gpu_nodes)

    @property
    @pulumi.getter(name="taintGpuNodes")
    def taint_gpu_nodes(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "taint_gpu_nodes")


@pulumi.output_type
class Mk8sAddOnsRegistryMirror(dict):
    def __init__(__self__, *,
                 mirrors: Optional[Sequence['outputs.Mk8sAddOnsRegistryMirrorMirror']] = None):
        if mirrors is not None:
            pulumi.set(__self__, "mirrors", mirrors)

    @property
    @pulumi.getter
    def mirrors(self) -> Optional[Sequence['outputs.Mk8sAddOnsRegistryMirrorMirror']]:
        return pulumi.get(self, "mirrors")


@pulumi.output_type
class Mk8sAddOnsRegistryMirrorMirror(dict):
    def __init__(__self__, *,
                 registry: builtins.str,
                 mirrors: Optional[Sequence[builtins.str]] = None):
        pulumi.set(__self__, "registry", registry)
        if mirrors is not None:
            pulumi.set(__self__, "mirrors", mirrors)

    @property
    @pulumi.getter
    def registry(self) -> builtins.str:
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def mirrors(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "mirrors")


@pulumi.output_type
class Mk8sAwsProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployRoleArn":
            suggest = "deploy_role_arn"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "awsTags":
            suggest = "aws_tags"
        elif key == "deployRoleChains":
            suggest = "deploy_role_chains"
        elif key == "diskEncryptionKeyArn":
            suggest = "disk_encryption_key_arn"
        elif key == "extraNodePolicies":
            suggest = "extra_node_policies"
        elif key == "keyPair":
            suggest = "key_pair"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "skipCreateRoles":
            suggest = "skip_create_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAwsProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAwsProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAwsProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deploy_role_arn: builtins.str,
                 region: builtins.str,
                 vpc_id: builtins.str,
                 autoscaler: Optional['outputs.Mk8sAwsProviderAutoscaler'] = None,
                 aws_tags: Optional[Mapping[str, builtins.str]] = None,
                 deploy_role_chains: Optional[Sequence['outputs.Mk8sAwsProviderDeployRoleChain']] = None,
                 disk_encryption_key_arn: Optional[builtins.str] = None,
                 extra_node_policies: Optional[Sequence[builtins.str]] = None,
                 image: Optional['outputs.Mk8sAwsProviderImage'] = None,
                 key_pair: Optional[builtins.str] = None,
                 networking: Optional['outputs.Mk8sAwsProviderNetworking'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sAwsProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 skip_create_roles: Optional[builtins.bool] = None):
        """
        :param builtins.str deploy_role_arn: Control Plane will set up the cluster by assuming this role.
        :param builtins.str region: Region where the cluster nodes will live.
        :param builtins.str vpc_id: The vpc where nodes will be deployed. Supports SSM.
        :param Mapping[str, builtins.str] aws_tags: Extra tags to attach to all created objects.
        :param builtins.str disk_encryption_key_arn: KMS key used to encrypt volumes. Supports SSM.
        :param 'Mk8sAwsProviderImageArgs' image: Default image for all nodes.
        :param builtins.str key_pair: Name of keyPair. Supports SSM
        :param Sequence['Mk8sAwsProviderNodePoolArgs'] node_pools: List of node pools.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        :param Sequence[builtins.str] security_group_ids: Security groups to deploy nodes to. Security groups control if the cluster is multi-zone or single-zon.
        :param builtins.bool skip_create_roles: If true, Control Plane will not create any roles.
        """
        pulumi.set(__self__, "deploy_role_arn", deploy_role_arn)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if aws_tags is not None:
            pulumi.set(__self__, "aws_tags", aws_tags)
        if deploy_role_chains is not None:
            pulumi.set(__self__, "deploy_role_chains", deploy_role_chains)
        if disk_encryption_key_arn is not None:
            pulumi.set(__self__, "disk_encryption_key_arn", disk_encryption_key_arn)
        if extra_node_policies is not None:
            pulumi.set(__self__, "extra_node_policies", extra_node_policies)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if skip_create_roles is not None:
            pulumi.set(__self__, "skip_create_roles", skip_create_roles)

    @property
    @pulumi.getter(name="deployRoleArn")
    def deploy_role_arn(self) -> builtins.str:
        """
        Control Plane will set up the cluster by assuming this role.
        """
        return pulumi.get(self, "deploy_role_arn")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region where the cluster nodes will live.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The vpc where nodes will be deployed. Supports SSM.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sAwsProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter(name="awsTags")
    def aws_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Extra tags to attach to all created objects.
        """
        return pulumi.get(self, "aws_tags")

    @property
    @pulumi.getter(name="deployRoleChains")
    def deploy_role_chains(self) -> Optional[Sequence['outputs.Mk8sAwsProviderDeployRoleChain']]:
        return pulumi.get(self, "deploy_role_chains")

    @property
    @pulumi.getter(name="diskEncryptionKeyArn")
    def disk_encryption_key_arn(self) -> Optional[builtins.str]:
        """
        KMS key used to encrypt volumes. Supports SSM.
        """
        return pulumi.get(self, "disk_encryption_key_arn")

    @property
    @pulumi.getter(name="extraNodePolicies")
    def extra_node_policies(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "extra_node_policies")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.Mk8sAwsProviderImage']:
        """
        Default image for all nodes.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[builtins.str]:
        """
        Name of keyPair. Supports SSM
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def networking(self) -> Optional['outputs.Mk8sAwsProviderNetworking']:
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sAwsProviderNodePool']]:
        """
        List of node pools.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Security groups to deploy nodes to. Security groups control if the cluster is multi-zone or single-zon.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="skipCreateRoles")
    def skip_create_roles(self) -> Optional[builtins.bool]:
        """
        If true, Control Plane will not create any roles.
        """
        return pulumi.get(self, "skip_create_roles")


@pulumi.output_type
class Mk8sAwsProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAwsProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAwsProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAwsProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sAwsProviderDeployRoleChain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "sessionNamePrefix":
            suggest = "session_name_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAwsProviderDeployRoleChain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAwsProviderDeployRoleChain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAwsProviderDeployRoleChain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 external_id: Optional[builtins.str] = None,
                 session_name_prefix: Optional[builtins.str] = None):
        """
        :param builtins.str session_name_prefix: Control Plane will set up the cluster by assuming this role.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if session_name_prefix is not None:
            pulumi.set(__self__, "session_name_prefix", session_name_prefix)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="sessionNamePrefix")
    def session_name_prefix(self) -> Optional[builtins.str]:
        """
        Control Plane will set up the cluster by assuming this role.
        """
        return pulumi.get(self, "session_name_prefix")


@pulumi.output_type
class Mk8sAwsProviderImage(dict):
    def __init__(__self__, *,
                 exact: Optional[builtins.str] = None,
                 recommended: Optional[builtins.str] = None):
        """
        :param builtins.str exact: Support SSM.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if recommended is not None:
            pulumi.set(__self__, "recommended", recommended)

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        Support SSM.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def recommended(self) -> Optional[builtins.str]:
        return pulumi.get(self, "recommended")


@pulumi.output_type
class Mk8sAwsProviderNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsForwarder":
            suggest = "dns_forwarder"
        elif key == "podNetwork":
            suggest = "pod_network"
        elif key == "serviceNetwork":
            suggest = "service_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAwsProviderNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAwsProviderNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAwsProviderNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_forwarder: Optional[builtins.str] = None,
                 pod_network: Optional[builtins.str] = None,
                 service_network: Optional[builtins.str] = None):
        """
        :param builtins.str dns_forwarder: DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        :param builtins.str pod_network: The CIDR of the pod network.
        :param builtins.str service_network: The CIDR of the service network.
        """
        if dns_forwarder is not None:
            pulumi.set(__self__, "dns_forwarder", dns_forwarder)
        if pod_network is not None:
            pulumi.set(__self__, "pod_network", pod_network)
        if service_network is not None:
            pulumi.set(__self__, "service_network", service_network)

    @property
    @pulumi.getter(name="dnsForwarder")
    def dns_forwarder(self) -> Optional[builtins.str]:
        """
        DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        """
        return pulumi.get(self, "dns_forwarder")

    @property
    @pulumi.getter(name="podNetwork")
    def pod_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the pod network.
        """
        return pulumi.get(self, "pod_network")

    @property
    @pulumi.getter(name="serviceNetwork")
    def service_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the service network.
        """
        return pulumi.get(self, "service_network")


@pulumi.output_type
class Mk8sAwsProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceTypes":
            suggest = "instance_types"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "bootDiskSize":
            suggest = "boot_disk_size"
        elif key == "extraSecurityGroupIds":
            suggest = "extra_security_group_ids"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "onDemandBaseCapacity":
            suggest = "on_demand_base_capacity"
        elif key == "onDemandPercentageAboveBaseCapacity":
            suggest = "on_demand_percentage_above_base_capacity"
        elif key == "overrideImage":
            suggest = "override_image"
        elif key == "spotAllocationStrategy":
            suggest = "spot_allocation_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAwsProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAwsProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAwsProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_types: Sequence[builtins.str],
                 name: builtins.str,
                 subnet_ids: Sequence[builtins.str],
                 boot_disk_size: Optional[builtins.int] = None,
                 extra_security_group_ids: Optional[Sequence[builtins.str]] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 on_demand_base_capacity: Optional[builtins.int] = None,
                 on_demand_percentage_above_base_capacity: Optional[builtins.int] = None,
                 override_image: Optional['outputs.Mk8sAwsProviderNodePoolOverrideImage'] = None,
                 spot_allocation_strategy: Optional[builtins.str] = None,
                 taints: Optional[Sequence['outputs.Mk8sAwsProviderNodePoolTaint']] = None):
        """
        :param builtins.int boot_disk_size: Size in GB.
        :param Sequence[builtins.str] extra_security_group_ids: Security groups to deploy nodes to. Security groups control if the cluster is multi-zone or single-zon.
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param 'Mk8sAwsProviderNodePoolOverrideImageArgs' override_image: Default image for all nodes.
        :param Sequence['Mk8sAwsProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if boot_disk_size is not None:
            pulumi.set(__self__, "boot_disk_size", boot_disk_size)
        if extra_security_group_ids is not None:
            pulumi.set(__self__, "extra_security_group_ids", extra_security_group_ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if override_image is not None:
            pulumi.set(__self__, "override_image", override_image)
        if spot_allocation_strategy is not None:
            pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="bootDiskSize")
    def boot_disk_size(self) -> Optional[builtins.int]:
        """
        Size in GB.
        """
        return pulumi.get(self, "boot_disk_size")

    @property
    @pulumi.getter(name="extraSecurityGroupIds")
    def extra_security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Security groups to deploy nodes to. Security groups control if the cluster is multi-zone or single-zon.
        """
        return pulumi.get(self, "extra_security_group_ids")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[builtins.int]:
        return pulumi.get(self, "on_demand_base_capacity")

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[builtins.int]:
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @property
    @pulumi.getter(name="overrideImage")
    def override_image(self) -> Optional['outputs.Mk8sAwsProviderNodePoolOverrideImage']:
        """
        Default image for all nodes.
        """
        return pulumi.get(self, "override_image")

    @property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> Optional[builtins.str]:
        return pulumi.get(self, "spot_allocation_strategy")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sAwsProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sAwsProviderNodePoolOverrideImage(dict):
    def __init__(__self__, *,
                 exact: Optional[builtins.str] = None,
                 recommended: Optional[builtins.str] = None):
        """
        :param builtins.str exact: Support SSM.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if recommended is not None:
            pulumi.set(__self__, "recommended", recommended)

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        Support SSM.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def recommended(self) -> Optional[builtins.str]:
        return pulumi.get(self, "recommended")


@pulumi.output_type
class Mk8sAwsProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sAzureProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "sdkSecretLink":
            suggest = "sdk_secret_link"
        elif key == "sshKeys":
            suggest = "ssh_keys"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAzureProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAzureProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAzureProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 network_id: builtins.str,
                 resource_group: builtins.str,
                 sdk_secret_link: builtins.str,
                 ssh_keys: Sequence[builtins.str],
                 subscription_id: builtins.str,
                 autoscaler: Optional['outputs.Mk8sAzureProviderAutoscaler'] = None,
                 image: Optional['outputs.Mk8sAzureProviderImage'] = None,
                 networking: Optional['outputs.Mk8sAzureProviderNetworking'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sAzureProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str location: Region where the cluster nodes will live.
        :param builtins.str network_id: The vpc where nodes will be deployed.
        :param Sequence[builtins.str] ssh_keys: SSH keys to install for "azureuser" linux user
        :param 'Mk8sAzureProviderImageArgs' image: Default image for all nodes.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        :param Mapping[str, builtins.str] tags: Extra tags to attach to all created objects.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "resource_group", resource_group)
        pulumi.set(__self__, "sdk_secret_link", sdk_secret_link)
        pulumi.set(__self__, "ssh_keys", ssh_keys)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Region where the cluster nodes will live.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        The vpc where nodes will be deployed.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> builtins.str:
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="sdkSecretLink")
    def sdk_secret_link(self) -> builtins.str:
        return pulumi.get(self, "sdk_secret_link")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Sequence[builtins.str]:
        """
        SSH keys to install for "azureuser" linux user
        """
        return pulumi.get(self, "ssh_keys")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sAzureProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.Mk8sAzureProviderImage']:
        """
        Default image for all nodes.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def networking(self) -> Optional['outputs.Mk8sAzureProviderNetworking']:
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sAzureProviderNodePool']]:
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Extra tags to attach to all created objects.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class Mk8sAzureProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAzureProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAzureProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAzureProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sAzureProviderImage(dict):
    def __init__(__self__, *,
                 recommended: Optional[builtins.str] = None,
                 reference: Optional['outputs.Mk8sAzureProviderImageReference'] = None):
        if recommended is not None:
            pulumi.set(__self__, "recommended", recommended)
        if reference is not None:
            pulumi.set(__self__, "reference", reference)

    @property
    @pulumi.getter
    def recommended(self) -> Optional[builtins.str]:
        return pulumi.get(self, "recommended")

    @property
    @pulumi.getter
    def reference(self) -> Optional['outputs.Mk8sAzureProviderImageReference']:
        return pulumi.get(self, "reference")


@pulumi.output_type
class Mk8sAzureProviderImageReference(dict):
    def __init__(__self__, *,
                 offer: builtins.str,
                 publisher: builtins.str,
                 sku: builtins.str,
                 version: builtins.str):
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> builtins.str:
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> builtins.str:
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        return pulumi.get(self, "version")


@pulumi.output_type
class Mk8sAzureProviderNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsForwarder":
            suggest = "dns_forwarder"
        elif key == "podNetwork":
            suggest = "pod_network"
        elif key == "serviceNetwork":
            suggest = "service_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAzureProviderNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAzureProviderNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAzureProviderNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_forwarder: Optional[builtins.str] = None,
                 pod_network: Optional[builtins.str] = None,
                 service_network: Optional[builtins.str] = None):
        """
        :param builtins.str dns_forwarder: DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        :param builtins.str pod_network: The CIDR of the pod network.
        :param builtins.str service_network: The CIDR of the service network.
        """
        if dns_forwarder is not None:
            pulumi.set(__self__, "dns_forwarder", dns_forwarder)
        if pod_network is not None:
            pulumi.set(__self__, "pod_network", pod_network)
        if service_network is not None:
            pulumi.set(__self__, "service_network", service_network)

    @property
    @pulumi.getter(name="dnsForwarder")
    def dns_forwarder(self) -> Optional[builtins.str]:
        """
        DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        """
        return pulumi.get(self, "dns_forwarder")

    @property
    @pulumi.getter(name="podNetwork")
    def pod_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the pod network.
        """
        return pulumi.get(self, "pod_network")

    @property
    @pulumi.getter(name="serviceNetwork")
    def service_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the service network.
        """
        return pulumi.get(self, "service_network")


@pulumi.output_type
class Mk8sAzureProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSize":
            suggest = "boot_disk_size"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "overrideImage":
            suggest = "override_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sAzureProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sAzureProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sAzureProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size: builtins.int,
                 name: builtins.str,
                 size: builtins.str,
                 subnet_id: builtins.str,
                 zones: Sequence[builtins.int],
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 override_image: Optional['outputs.Mk8sAzureProviderNodePoolOverrideImage'] = None,
                 taints: Optional[Sequence['outputs.Mk8sAzureProviderNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sAzureProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "boot_disk_size", boot_disk_size)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "zones", zones)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if override_image is not None:
            pulumi.set(__self__, "override_image", override_image)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="bootDiskSize")
    def boot_disk_size(self) -> builtins.int:
        return pulumi.get(self, "boot_disk_size")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> builtins.str:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[builtins.int]:
        return pulumi.get(self, "zones")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="overrideImage")
    def override_image(self) -> Optional['outputs.Mk8sAzureProviderNodePoolOverrideImage']:
        return pulumi.get(self, "override_image")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sAzureProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sAzureProviderNodePoolOverrideImage(dict):
    def __init__(__self__, *,
                 recommended: Optional[builtins.str] = None,
                 reference: Optional['outputs.Mk8sAzureProviderNodePoolOverrideImageReference'] = None):
        if recommended is not None:
            pulumi.set(__self__, "recommended", recommended)
        if reference is not None:
            pulumi.set(__self__, "reference", reference)

    @property
    @pulumi.getter
    def recommended(self) -> Optional[builtins.str]:
        return pulumi.get(self, "recommended")

    @property
    @pulumi.getter
    def reference(self) -> Optional['outputs.Mk8sAzureProviderNodePoolOverrideImageReference']:
        return pulumi.get(self, "reference")


@pulumi.output_type
class Mk8sAzureProviderNodePoolOverrideImageReference(dict):
    def __init__(__self__, *,
                 offer: builtins.str,
                 publisher: builtins.str,
                 sku: builtins.str,
                 version: builtins.str):
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def offer(self) -> builtins.str:
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter
    def publisher(self) -> builtins.str:
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        return pulumi.get(self, "version")


@pulumi.output_type
class Mk8sAzureProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sDigitalOceanProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKeys":
            suggest = "ssh_keys"
        elif key == "tokenSecretLink":
            suggest = "token_secret_link"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "digitalOceanTags":
            suggest = "digital_ocean_tags"
        elif key == "extraSshKeys":
            suggest = "extra_ssh_keys"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"
        elif key == "reservedIps":
            suggest = "reserved_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sDigitalOceanProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sDigitalOceanProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sDigitalOceanProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: builtins.str,
                 region: builtins.str,
                 ssh_keys: Sequence[builtins.str],
                 token_secret_link: builtins.str,
                 vpc_id: builtins.str,
                 autoscaler: Optional['outputs.Mk8sDigitalOceanProviderAutoscaler'] = None,
                 digital_ocean_tags: Optional[Sequence[builtins.str]] = None,
                 extra_ssh_keys: Optional[Sequence[builtins.str]] = None,
                 networking: Optional['outputs.Mk8sDigitalOceanProviderNetworking'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sDigitalOceanProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None,
                 reserved_ips: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str image: Default image for all nodes.
        :param builtins.str region: Region to deploy nodes to.
        :param Sequence[builtins.str] ssh_keys: SSH key name for accessing deployed nodes.
        :param builtins.str token_secret_link: Link to a secret holding personal access token.
        :param builtins.str vpc_id: ID of the Hetzner network to deploy nodes to.
        :param Sequence[builtins.str] digital_ocean_tags: Extra tags to attach to droplets.
        :param Sequence[builtins.str] extra_ssh_keys: Extra SSH keys to provision for user root that are not registered in the DigitalOcean.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        :param Sequence[builtins.str] reserved_ips: Optional set of IPs to assign as extra IPs for nodes of the cluster.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ssh_keys", ssh_keys)
        pulumi.set(__self__, "token_secret_link", token_secret_link)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if digital_ocean_tags is not None:
            pulumi.set(__self__, "digital_ocean_tags", digital_ocean_tags)
        if extra_ssh_keys is not None:
            pulumi.set(__self__, "extra_ssh_keys", extra_ssh_keys)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        Default image for all nodes.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region to deploy nodes to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Sequence[builtins.str]:
        """
        SSH key name for accessing deployed nodes.
        """
        return pulumi.get(self, "ssh_keys")

    @property
    @pulumi.getter(name="tokenSecretLink")
    def token_secret_link(self) -> builtins.str:
        """
        Link to a secret holding personal access token.
        """
        return pulumi.get(self, "token_secret_link")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        ID of the Hetzner network to deploy nodes to.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sDigitalOceanProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter(name="digitalOceanTags")
    def digital_ocean_tags(self) -> Optional[Sequence[builtins.str]]:
        """
        Extra tags to attach to droplets.
        """
        return pulumi.get(self, "digital_ocean_tags")

    @property
    @pulumi.getter(name="extraSshKeys")
    def extra_ssh_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        Extra SSH keys to provision for user root that are not registered in the DigitalOcean.
        """
        return pulumi.get(self, "extra_ssh_keys")

    @property
    @pulumi.getter
    def networking(self) -> Optional['outputs.Mk8sDigitalOceanProviderNetworking']:
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sDigitalOceanProviderNodePool']]:
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")

    @property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[Sequence[builtins.str]]:
        """
        Optional set of IPs to assign as extra IPs for nodes of the cluster.
        """
        return pulumi.get(self, "reserved_ips")


@pulumi.output_type
class Mk8sDigitalOceanProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sDigitalOceanProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sDigitalOceanProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sDigitalOceanProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sDigitalOceanProviderNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsForwarder":
            suggest = "dns_forwarder"
        elif key == "podNetwork":
            suggest = "pod_network"
        elif key == "serviceNetwork":
            suggest = "service_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sDigitalOceanProviderNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sDigitalOceanProviderNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sDigitalOceanProviderNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_forwarder: Optional[builtins.str] = None,
                 pod_network: Optional[builtins.str] = None,
                 service_network: Optional[builtins.str] = None):
        """
        :param builtins.str dns_forwarder: DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        :param builtins.str pod_network: The CIDR of the pod network.
        :param builtins.str service_network: The CIDR of the service network.
        """
        if dns_forwarder is not None:
            pulumi.set(__self__, "dns_forwarder", dns_forwarder)
        if pod_network is not None:
            pulumi.set(__self__, "pod_network", pod_network)
        if service_network is not None:
            pulumi.set(__self__, "service_network", service_network)

    @property
    @pulumi.getter(name="dnsForwarder")
    def dns_forwarder(self) -> Optional[builtins.str]:
        """
        DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        """
        return pulumi.get(self, "dns_forwarder")

    @property
    @pulumi.getter(name="podNetwork")
    def pod_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the pod network.
        """
        return pulumi.get(self, "pod_network")

    @property
    @pulumi.getter(name="serviceNetwork")
    def service_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the service network.
        """
        return pulumi.get(self, "service_network")


@pulumi.output_type
class Mk8sDigitalOceanProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropletSize":
            suggest = "droplet_size"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "overrideImage":
            suggest = "override_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sDigitalOceanProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sDigitalOceanProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sDigitalOceanProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 droplet_size: builtins.str,
                 name: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 override_image: Optional[builtins.str] = None,
                 taints: Optional[Sequence['outputs.Mk8sDigitalOceanProviderNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sDigitalOceanProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "droplet_size", droplet_size)
        pulumi.set(__self__, "name", name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if override_image is not None:
            pulumi.set(__self__, "override_image", override_image)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="dropletSize")
    def droplet_size(self) -> builtins.str:
        return pulumi.get(self, "droplet_size")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="overrideImage")
    def override_image(self) -> Optional[builtins.str]:
        return pulumi.get(self, "override_image")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sDigitalOceanProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sDigitalOceanProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sEphemeralProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodePools":
            suggest = "node_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sEphemeralProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sEphemeralProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sEphemeralProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 node_pools: Optional[Sequence['outputs.Mk8sEphemeralProviderNodePool']] = None):
        """
        :param builtins.str location: Control Plane location that will host the K8s components. Prefer one that is closest to where the nodes are running.
        :param Sequence['Mk8sEphemeralProviderNodePoolArgs'] node_pools: List of node pools.
        """
        pulumi.set(__self__, "location", location)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Control Plane location that will host the K8s components. Prefer one that is closest to where the nodes are running.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sEphemeralProviderNodePool']]:
        """
        List of node pools.
        """
        return pulumi.get(self, "node_pools")


@pulumi.output_type
class Mk8sEphemeralProviderNodePool(dict):
    def __init__(__self__, *,
                 arch: builtins.str,
                 count: builtins.int,
                 cpu: builtins.str,
                 memory: builtins.str,
                 name: builtins.str,
                 flavor: Optional[builtins.str] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 taints: Optional[Sequence['outputs.Mk8sEphemeralProviderNodePoolTaint']] = None):
        """
        :param builtins.str arch: CPU architecture of the nodes.
        :param builtins.int count: Number of nodes to deploy.
        :param builtins.str cpu: Allocated CPU.
        :param builtins.str memory: Allocated memory.
        :param builtins.str flavor: Linux distro to use for ephemeral nodes.
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sEphemeralProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "arch", arch)
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def arch(self) -> builtins.str:
        """
        CPU architecture of the nodes.
        """
        return pulumi.get(self, "arch")

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        Number of nodes to deploy.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def cpu(self) -> builtins.str:
        """
        Allocated CPU.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def memory(self) -> builtins.str:
        """
        Allocated memory.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def flavor(self) -> Optional[builtins.str]:
        """
        Linux distro to use for ephemeral nodes.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sEphemeralProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sEphemeralProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sFirewall(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceCidr":
            suggest = "source_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sFirewall. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sFirewall.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sFirewall.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_cidr: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "source_cidr", source_cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> builtins.str:
        return pulumi.get(self, "source_cidr")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class Mk8sGenericProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodePools":
            suggest = "node_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sGenericProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sGenericProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sGenericProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 networking: Optional['outputs.Mk8sGenericProviderNetworking'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sGenericProviderNodePool']] = None):
        """
        :param builtins.str location: Control Plane location that will host the K8s components. Prefer one that is closest to where the nodes are running.
        :param Sequence['Mk8sGenericProviderNodePoolArgs'] node_pools: List of node pools.
        """
        pulumi.set(__self__, "location", location)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Control Plane location that will host the K8s components. Prefer one that is closest to where the nodes are running.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def networking(self) -> Optional['outputs.Mk8sGenericProviderNetworking']:
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sGenericProviderNodePool']]:
        """
        List of node pools.
        """
        return pulumi.get(self, "node_pools")


@pulumi.output_type
class Mk8sGenericProviderNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsForwarder":
            suggest = "dns_forwarder"
        elif key == "podNetwork":
            suggest = "pod_network"
        elif key == "serviceNetwork":
            suggest = "service_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sGenericProviderNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sGenericProviderNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sGenericProviderNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_forwarder: Optional[builtins.str] = None,
                 pod_network: Optional[builtins.str] = None,
                 service_network: Optional[builtins.str] = None):
        """
        :param builtins.str dns_forwarder: DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        :param builtins.str pod_network: The CIDR of the pod network.
        :param builtins.str service_network: The CIDR of the service network.
        """
        if dns_forwarder is not None:
            pulumi.set(__self__, "dns_forwarder", dns_forwarder)
        if pod_network is not None:
            pulumi.set(__self__, "pod_network", pod_network)
        if service_network is not None:
            pulumi.set(__self__, "service_network", service_network)

    @property
    @pulumi.getter(name="dnsForwarder")
    def dns_forwarder(self) -> Optional[builtins.str]:
        """
        DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        """
        return pulumi.get(self, "dns_forwarder")

    @property
    @pulumi.getter(name="podNetwork")
    def pod_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the pod network.
        """
        return pulumi.get(self, "pod_network")

    @property
    @pulumi.getter(name="serviceNetwork")
    def service_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the service network.
        """
        return pulumi.get(self, "service_network")


@pulumi.output_type
class Mk8sGenericProviderNodePool(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 taints: Optional[Sequence['outputs.Mk8sGenericProviderNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sGenericProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "name", name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sGenericProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sGenericProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sHetznerProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "tokenSecretLink":
            suggest = "token_secret_link"
        elif key == "dedicatedServerNodePools":
            suggest = "dedicated_server_node_pools"
        elif key == "firewallId":
            suggest = "firewall_id"
        elif key == "floatingIpSelector":
            suggest = "floating_ip_selector"
        elif key == "hetznerLabels":
            suggest = "hetzner_labels"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"
        elif key == "sshKey":
            suggest = "ssh_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sHetznerProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sHetznerProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sHetznerProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_id: builtins.str,
                 region: builtins.str,
                 token_secret_link: builtins.str,
                 autoscaler: Optional['outputs.Mk8sHetznerProviderAutoscaler'] = None,
                 dedicated_server_node_pools: Optional[Sequence['outputs.Mk8sHetznerProviderDedicatedServerNodePool']] = None,
                 firewall_id: Optional[builtins.str] = None,
                 floating_ip_selector: Optional[Mapping[str, builtins.str]] = None,
                 hetzner_labels: Optional[Mapping[str, builtins.str]] = None,
                 image: Optional[builtins.str] = None,
                 networking: Optional['outputs.Mk8sHetznerProviderNetworking'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sHetznerProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None,
                 ssh_key: Optional[builtins.str] = None):
        """
        :param builtins.str network_id: ID of the Hetzner network to deploy nodes to.
        :param builtins.str region: Hetzner region to deploy nodes to.
        :param builtins.str token_secret_link: Link to a secret holding Hetzner access key.
        :param Sequence['Mk8sHetznerProviderDedicatedServerNodePoolArgs'] dedicated_server_node_pools: Node pools that can configure dedicated Hetzner servers.
        :param builtins.str firewall_id: Optional firewall rule to attach to all nodes.
        :param Mapping[str, builtins.str] floating_ip_selector: If supplied, nodes will get assigned a random floating ip matching the selector.
        :param Mapping[str, builtins.str] hetzner_labels: Extra labels to attach to servers.
        :param builtins.str image: Default image for all nodes.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        :param builtins.str ssh_key: SSH key name for accessing deployed nodes.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "token_secret_link", token_secret_link)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if dedicated_server_node_pools is not None:
            pulumi.set(__self__, "dedicated_server_node_pools", dedicated_server_node_pools)
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if floating_ip_selector is not None:
            pulumi.set(__self__, "floating_ip_selector", floating_ip_selector)
        if hetzner_labels is not None:
            pulumi.set(__self__, "hetzner_labels", hetzner_labels)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        ID of the Hetzner network to deploy nodes to.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Hetzner region to deploy nodes to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tokenSecretLink")
    def token_secret_link(self) -> builtins.str:
        """
        Link to a secret holding Hetzner access key.
        """
        return pulumi.get(self, "token_secret_link")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sHetznerProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter(name="dedicatedServerNodePools")
    def dedicated_server_node_pools(self) -> Optional[Sequence['outputs.Mk8sHetznerProviderDedicatedServerNodePool']]:
        """
        Node pools that can configure dedicated Hetzner servers.
        """
        return pulumi.get(self, "dedicated_server_node_pools")

    @property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[builtins.str]:
        """
        Optional firewall rule to attach to all nodes.
        """
        return pulumi.get(self, "firewall_id")

    @property
    @pulumi.getter(name="floatingIpSelector")
    def floating_ip_selector(self) -> Optional[Mapping[str, builtins.str]]:
        """
        If supplied, nodes will get assigned a random floating ip matching the selector.
        """
        return pulumi.get(self, "floating_ip_selector")

    @property
    @pulumi.getter(name="hetznerLabels")
    def hetzner_labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Extra labels to attach to servers.
        """
        return pulumi.get(self, "hetzner_labels")

    @property
    @pulumi.getter
    def image(self) -> Optional[builtins.str]:
        """
        Default image for all nodes.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def networking(self) -> Optional['outputs.Mk8sHetznerProviderNetworking']:
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sHetznerProviderNodePool']]:
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[builtins.str]:
        """
        SSH key name for accessing deployed nodes.
        """
        return pulumi.get(self, "ssh_key")


@pulumi.output_type
class Mk8sHetznerProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sHetznerProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sHetznerProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sHetznerProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sHetznerProviderDedicatedServerNodePool(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 taints: Optional[Sequence['outputs.Mk8sHetznerProviderDedicatedServerNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sHetznerProviderDedicatedServerNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "name", name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sHetznerProviderDedicatedServerNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sHetznerProviderDedicatedServerNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sHetznerProviderNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsForwarder":
            suggest = "dns_forwarder"
        elif key == "podNetwork":
            suggest = "pod_network"
        elif key == "serviceNetwork":
            suggest = "service_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sHetznerProviderNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sHetznerProviderNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sHetznerProviderNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_forwarder: Optional[builtins.str] = None,
                 pod_network: Optional[builtins.str] = None,
                 service_network: Optional[builtins.str] = None):
        """
        :param builtins.str dns_forwarder: DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        :param builtins.str pod_network: The CIDR of the pod network.
        :param builtins.str service_network: The CIDR of the service network.
        """
        if dns_forwarder is not None:
            pulumi.set(__self__, "dns_forwarder", dns_forwarder)
        if pod_network is not None:
            pulumi.set(__self__, "pod_network", pod_network)
        if service_network is not None:
            pulumi.set(__self__, "service_network", service_network)

    @property
    @pulumi.getter(name="dnsForwarder")
    def dns_forwarder(self) -> Optional[builtins.str]:
        """
        DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        """
        return pulumi.get(self, "dns_forwarder")

    @property
    @pulumi.getter(name="podNetwork")
    def pod_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the pod network.
        """
        return pulumi.get(self, "pod_network")

    @property
    @pulumi.getter(name="serviceNetwork")
    def service_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the service network.
        """
        return pulumi.get(self, "service_network")


@pulumi.output_type
class Mk8sHetznerProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverType":
            suggest = "server_type"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "overrideImage":
            suggest = "override_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sHetznerProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sHetznerProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sHetznerProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 server_type: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 override_image: Optional[builtins.str] = None,
                 taints: Optional[Sequence['outputs.Mk8sHetznerProviderNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sHetznerProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "server_type", server_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if override_image is not None:
            pulumi.set(__self__, "override_image", override_image)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> builtins.str:
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="overrideImage")
    def override_image(self) -> Optional[builtins.str]:
        return pulumi.get(self, "override_image")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sHetznerProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sHetznerProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sLambdalabsProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshKey":
            suggest = "ssh_key"
        elif key == "tokenSecretLink":
            suggest = "token_secret_link"
        elif key == "fileSystems":
            suggest = "file_systems"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"
        elif key == "unmanagedNodePools":
            suggest = "unmanaged_node_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sLambdalabsProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sLambdalabsProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sLambdalabsProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: builtins.str,
                 ssh_key: builtins.str,
                 token_secret_link: builtins.str,
                 autoscaler: Optional['outputs.Mk8sLambdalabsProviderAutoscaler'] = None,
                 file_systems: Optional[Sequence[builtins.str]] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sLambdalabsProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None,
                 unmanaged_node_pools: Optional[Sequence['outputs.Mk8sLambdalabsProviderUnmanagedNodePool']] = None):
        """
        :param builtins.str region: Region where the cluster nodes will live.
        :param builtins.str ssh_key: SSH key name for accessing deployed nodes.
        :param builtins.str token_secret_link: Link to a secret holding Lambdalabs access key.
        :param Sequence['Mk8sLambdalabsProviderNodePoolArgs'] node_pools: List of node pools.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "ssh_key", ssh_key)
        pulumi.set(__self__, "token_secret_link", token_secret_link)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if file_systems is not None:
            pulumi.set(__self__, "file_systems", file_systems)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)
        if unmanaged_node_pools is not None:
            pulumi.set(__self__, "unmanaged_node_pools", unmanaged_node_pools)

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region where the cluster nodes will live.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> builtins.str:
        """
        SSH key name for accessing deployed nodes.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter(name="tokenSecretLink")
    def token_secret_link(self) -> builtins.str:
        """
        Link to a secret holding Lambdalabs access key.
        """
        return pulumi.get(self, "token_secret_link")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sLambdalabsProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter(name="fileSystems")
    def file_systems(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "file_systems")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sLambdalabsProviderNodePool']]:
        """
        List of node pools.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")

    @property
    @pulumi.getter(name="unmanagedNodePools")
    def unmanaged_node_pools(self) -> Optional[Sequence['outputs.Mk8sLambdalabsProviderUnmanagedNodePool']]:
        return pulumi.get(self, "unmanaged_node_pools")


@pulumi.output_type
class Mk8sLambdalabsProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sLambdalabsProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sLambdalabsProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sLambdalabsProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sLambdalabsProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sLambdalabsProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sLambdalabsProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sLambdalabsProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: builtins.str,
                 name: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 taints: Optional[Sequence['outputs.Mk8sLambdalabsProviderNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sLambdalabsProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "name", name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> builtins.str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sLambdalabsProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sLambdalabsProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sLambdalabsProviderUnmanagedNodePool(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 taints: Optional[Sequence['outputs.Mk8sLambdalabsProviderUnmanagedNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sLambdalabsProviderUnmanagedNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "name", name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sLambdalabsProviderUnmanagedNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sLambdalabsProviderUnmanagedNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sLinodeProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenSecretLink":
            suggest = "token_secret_link"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "authorizedKeys":
            suggest = "authorized_keys"
        elif key == "authorizedUsers":
            suggest = "authorized_users"
        elif key == "firewallId":
            suggest = "firewall_id"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sLinodeProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sLinodeProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sLinodeProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: builtins.str,
                 region: builtins.str,
                 token_secret_link: builtins.str,
                 vpc_id: builtins.str,
                 authorized_keys: Optional[Sequence[builtins.str]] = None,
                 authorized_users: Optional[Sequence[builtins.str]] = None,
                 autoscaler: Optional['outputs.Mk8sLinodeProviderAutoscaler'] = None,
                 firewall_id: Optional[builtins.str] = None,
                 networking: Optional['outputs.Mk8sLinodeProviderNetworking'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sLinodeProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None):
        """
        :param builtins.str image: Default image for all nodes.
        :param builtins.str region: Region where the cluster nodes will live.
        :param builtins.str token_secret_link: Link to a secret holding Linode access key.
        :param builtins.str vpc_id: The vpc where nodes will be deployed. Supports SSM.
        :param builtins.str firewall_id: Optional firewall rule to attach to all nodes.
        :param Sequence['Mk8sLinodeProviderNodePoolArgs'] node_pools: List of node pools.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "token_secret_link", token_secret_link)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if authorized_keys is not None:
            pulumi.set(__self__, "authorized_keys", authorized_keys)
        if authorized_users is not None:
            pulumi.set(__self__, "authorized_users", authorized_users)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if firewall_id is not None:
            pulumi.set(__self__, "firewall_id", firewall_id)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        Default image for all nodes.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region where the cluster nodes will live.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tokenSecretLink")
    def token_secret_link(self) -> builtins.str:
        """
        Link to a secret holding Linode access key.
        """
        return pulumi.get(self, "token_secret_link")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> builtins.str:
        """
        The vpc where nodes will be deployed. Supports SSM.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="authorizedKeys")
    def authorized_keys(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "authorized_keys")

    @property
    @pulumi.getter(name="authorizedUsers")
    def authorized_users(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "authorized_users")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sLinodeProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> Optional[builtins.str]:
        """
        Optional firewall rule to attach to all nodes.
        """
        return pulumi.get(self, "firewall_id")

    @property
    @pulumi.getter
    def networking(self) -> Optional['outputs.Mk8sLinodeProviderNetworking']:
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sLinodeProviderNodePool']]:
        """
        List of node pools.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")


@pulumi.output_type
class Mk8sLinodeProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sLinodeProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sLinodeProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sLinodeProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sLinodeProviderNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsForwarder":
            suggest = "dns_forwarder"
        elif key == "podNetwork":
            suggest = "pod_network"
        elif key == "serviceNetwork":
            suggest = "service_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sLinodeProviderNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sLinodeProviderNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sLinodeProviderNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_forwarder: Optional[builtins.str] = None,
                 pod_network: Optional[builtins.str] = None,
                 service_network: Optional[builtins.str] = None):
        """
        :param builtins.str dns_forwarder: DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        :param builtins.str pod_network: The CIDR of the pod network.
        :param builtins.str service_network: The CIDR of the service network.
        """
        if dns_forwarder is not None:
            pulumi.set(__self__, "dns_forwarder", dns_forwarder)
        if pod_network is not None:
            pulumi.set(__self__, "pod_network", pod_network)
        if service_network is not None:
            pulumi.set(__self__, "service_network", service_network)

    @property
    @pulumi.getter(name="dnsForwarder")
    def dns_forwarder(self) -> Optional[builtins.str]:
        """
        DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        """
        return pulumi.get(self, "dns_forwarder")

    @property
    @pulumi.getter(name="podNetwork")
    def pod_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the pod network.
        """
        return pulumi.get(self, "pod_network")

    @property
    @pulumi.getter(name="serviceNetwork")
    def service_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the service network.
        """
        return pulumi.get(self, "service_network")


@pulumi.output_type
class Mk8sLinodeProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverType":
            suggest = "server_type"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "overrideImage":
            suggest = "override_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sLinodeProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sLinodeProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sLinodeProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 server_type: builtins.str,
                 subnet_id: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 override_image: Optional[builtins.str] = None,
                 taints: Optional[Sequence['outputs.Mk8sLinodeProviderNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sLinodeProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if override_image is not None:
            pulumi.set(__self__, "override_image", override_image)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> builtins.str:
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="overrideImage")
    def override_image(self) -> Optional[builtins.str]:
        return pulumi.get(self, "override_image")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sLinodeProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sLinodeProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sOblivusProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenSecretLink":
            suggest = "token_secret_link"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"
        elif key == "sshKeys":
            suggest = "ssh_keys"
        elif key == "unmanagedNodePools":
            suggest = "unmanaged_node_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sOblivusProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sOblivusProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sOblivusProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datacenter: builtins.str,
                 token_secret_link: builtins.str,
                 autoscaler: Optional['outputs.Mk8sOblivusProviderAutoscaler'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sOblivusProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None,
                 ssh_keys: Optional[Sequence[builtins.str]] = None,
                 unmanaged_node_pools: Optional[Sequence['outputs.Mk8sOblivusProviderUnmanagedNodePool']] = None):
        """
        :param builtins.str token_secret_link: Link to a secret holding Oblivus access key.
        :param Sequence['Mk8sOblivusProviderNodePoolArgs'] node_pools: List of node pools.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        pulumi.set(__self__, "datacenter", datacenter)
        pulumi.set(__self__, "token_secret_link", token_secret_link)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if unmanaged_node_pools is not None:
            pulumi.set(__self__, "unmanaged_node_pools", unmanaged_node_pools)

    @property
    @pulumi.getter
    def datacenter(self) -> builtins.str:
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="tokenSecretLink")
    def token_secret_link(self) -> builtins.str:
        """
        Link to a secret holding Oblivus access key.
        """
        return pulumi.get(self, "token_secret_link")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sOblivusProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sOblivusProviderNodePool']]:
        """
        List of node pools.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "ssh_keys")

    @property
    @pulumi.getter(name="unmanagedNodePools")
    def unmanaged_node_pools(self) -> Optional[Sequence['outputs.Mk8sOblivusProviderUnmanagedNodePool']]:
        return pulumi.get(self, "unmanaged_node_pools")


@pulumi.output_type
class Mk8sOblivusProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sOblivusProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sOblivusProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sOblivusProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sOblivusProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sOblivusProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sOblivusProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sOblivusProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flavor: builtins.str,
                 name: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 taints: Optional[Sequence['outputs.Mk8sOblivusProviderNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sOblivusProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "name", name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def flavor(self) -> builtins.str:
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sOblivusProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sOblivusProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sOblivusProviderUnmanagedNodePool(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 taints: Optional[Sequence['outputs.Mk8sOblivusProviderUnmanagedNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sOblivusProviderUnmanagedNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "name", name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sOblivusProviderUnmanagedNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sOblivusProviderUnmanagedNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sPaperspaceProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkId":
            suggest = "network_id"
        elif key == "tokenSecretLink":
            suggest = "token_secret_link"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"
        elif key == "sharedDrives":
            suggest = "shared_drives"
        elif key == "unmanagedNodePools":
            suggest = "unmanaged_node_pools"
        elif key == "userIds":
            suggest = "user_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sPaperspaceProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sPaperspaceProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sPaperspaceProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_id: builtins.str,
                 region: builtins.str,
                 token_secret_link: builtins.str,
                 autoscaler: Optional['outputs.Mk8sPaperspaceProviderAutoscaler'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sPaperspaceProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None,
                 shared_drives: Optional[Sequence[builtins.str]] = None,
                 unmanaged_node_pools: Optional[Sequence['outputs.Mk8sPaperspaceProviderUnmanagedNodePool']] = None,
                 user_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str region: Region where the cluster nodes will live.
        :param builtins.str token_secret_link: Link to a secret holding Paperspace access key.
        :param Sequence['Mk8sPaperspaceProviderNodePoolArgs'] node_pools: List of node pools.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "token_secret_link", token_secret_link)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)
        if shared_drives is not None:
            pulumi.set(__self__, "shared_drives", shared_drives)
        if unmanaged_node_pools is not None:
            pulumi.set(__self__, "unmanaged_node_pools", unmanaged_node_pools)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region where the cluster nodes will live.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tokenSecretLink")
    def token_secret_link(self) -> builtins.str:
        """
        Link to a secret holding Paperspace access key.
        """
        return pulumi.get(self, "token_secret_link")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sPaperspaceProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sPaperspaceProviderNodePool']]:
        """
        List of node pools.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")

    @property
    @pulumi.getter(name="sharedDrives")
    def shared_drives(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "shared_drives")

    @property
    @pulumi.getter(name="unmanagedNodePools")
    def unmanaged_node_pools(self) -> Optional[Sequence['outputs.Mk8sPaperspaceProviderUnmanagedNodePool']]:
        return pulumi.get(self, "unmanaged_node_pools")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "user_ids")


@pulumi.output_type
class Mk8sPaperspaceProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sPaperspaceProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sPaperspaceProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sPaperspaceProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sPaperspaceProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "machineType":
            suggest = "machine_type"
        elif key == "publicIpType":
            suggest = "public_ip_type"
        elif key == "bootDiskSize":
            suggest = "boot_disk_size"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sPaperspaceProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sPaperspaceProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sPaperspaceProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 machine_type: builtins.str,
                 name: builtins.str,
                 public_ip_type: builtins.str,
                 boot_disk_size: Optional[builtins.int] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 taints: Optional[Sequence['outputs.Mk8sPaperspaceProviderNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sPaperspaceProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_ip_type", public_ip_type)
        if boot_disk_size is not None:
            pulumi.set(__self__, "boot_disk_size", boot_disk_size)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> builtins.str:
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicIpType")
    def public_ip_type(self) -> builtins.str:
        return pulumi.get(self, "public_ip_type")

    @property
    @pulumi.getter(name="bootDiskSize")
    def boot_disk_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "boot_disk_size")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sPaperspaceProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sPaperspaceProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sPaperspaceProviderUnmanagedNodePool(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 taints: Optional[Sequence['outputs.Mk8sPaperspaceProviderUnmanagedNodePoolTaint']] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence['Mk8sPaperspaceProviderUnmanagedNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        """
        pulumi.set(__self__, "name", name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sPaperspaceProviderUnmanagedNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class Mk8sPaperspaceProviderUnmanagedNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class Mk8sStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addOns":
            suggest = "add_ons"
        elif key == "homeLocation":
            suggest = "home_location"
        elif key == "oidcProviderUrl":
            suggest = "oidc_provider_url"
        elif key == "serverUrl":
            suggest = "server_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_ons: Optional[Sequence['outputs.Mk8sStatusAddOn']] = None,
                 home_location: Optional[builtins.str] = None,
                 oidc_provider_url: Optional[builtins.str] = None,
                 server_url: Optional[builtins.str] = None):
        if add_ons is not None:
            pulumi.set(__self__, "add_ons", add_ons)
        if home_location is not None:
            pulumi.set(__self__, "home_location", home_location)
        if oidc_provider_url is not None:
            pulumi.set(__self__, "oidc_provider_url", oidc_provider_url)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)

    @property
    @pulumi.getter(name="addOns")
    def add_ons(self) -> Optional[Sequence['outputs.Mk8sStatusAddOn']]:
        return pulumi.get(self, "add_ons")

    @property
    @pulumi.getter(name="homeLocation")
    def home_location(self) -> Optional[builtins.str]:
        return pulumi.get(self, "home_location")

    @property
    @pulumi.getter(name="oidcProviderUrl")
    def oidc_provider_url(self) -> Optional[builtins.str]:
        return pulumi.get(self, "oidc_provider_url")

    @property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[builtins.str]:
        return pulumi.get(self, "server_url")


@pulumi.output_type
class Mk8sStatusAddOn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsEcrs":
            suggest = "aws_ecrs"
        elif key == "awsEfs":
            suggest = "aws_efs"
        elif key == "awsElbs":
            suggest = "aws_elbs"
        elif key == "awsWorkloadIdentities":
            suggest = "aws_workload_identities"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatusAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatusAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatusAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_ecrs: Optional[Sequence['outputs.Mk8sStatusAddOnAwsEcr']] = None,
                 aws_efs: Optional[Sequence['outputs.Mk8sStatusAddOnAwsEf']] = None,
                 aws_elbs: Optional[Sequence['outputs.Mk8sStatusAddOnAwsElb']] = None,
                 aws_workload_identities: Optional[Sequence['outputs.Mk8sStatusAddOnAwsWorkloadIdentity']] = None,
                 dashboards: Optional[Sequence['outputs.Mk8sStatusAddOnDashboard']] = None,
                 logs: Optional[Sequence['outputs.Mk8sStatusAddOnLog']] = None,
                 metrics: Optional[Sequence['outputs.Mk8sStatusAddOnMetric']] = None):
        if aws_ecrs is not None:
            pulumi.set(__self__, "aws_ecrs", aws_ecrs)
        if aws_efs is not None:
            pulumi.set(__self__, "aws_efs", aws_efs)
        if aws_elbs is not None:
            pulumi.set(__self__, "aws_elbs", aws_elbs)
        if aws_workload_identities is not None:
            pulumi.set(__self__, "aws_workload_identities", aws_workload_identities)
        if dashboards is not None:
            pulumi.set(__self__, "dashboards", dashboards)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter(name="awsEcrs")
    def aws_ecrs(self) -> Optional[Sequence['outputs.Mk8sStatusAddOnAwsEcr']]:
        return pulumi.get(self, "aws_ecrs")

    @property
    @pulumi.getter(name="awsEfs")
    def aws_efs(self) -> Optional[Sequence['outputs.Mk8sStatusAddOnAwsEf']]:
        return pulumi.get(self, "aws_efs")

    @property
    @pulumi.getter(name="awsElbs")
    def aws_elbs(self) -> Optional[Sequence['outputs.Mk8sStatusAddOnAwsElb']]:
        return pulumi.get(self, "aws_elbs")

    @property
    @pulumi.getter(name="awsWorkloadIdentities")
    def aws_workload_identities(self) -> Optional[Sequence['outputs.Mk8sStatusAddOnAwsWorkloadIdentity']]:
        return pulumi.get(self, "aws_workload_identities")

    @property
    @pulumi.getter
    def dashboards(self) -> Optional[Sequence['outputs.Mk8sStatusAddOnDashboard']]:
        return pulumi.get(self, "dashboards")

    @property
    @pulumi.getter
    def logs(self) -> Optional[Sequence['outputs.Mk8sStatusAddOnLog']]:
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence['outputs.Mk8sStatusAddOnMetric']]:
        return pulumi.get(self, "metrics")


@pulumi.output_type
class Mk8sStatusAddOnAwsEcr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustPolicy":
            suggest = "trust_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatusAddOnAwsEcr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatusAddOnAwsEcr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatusAddOnAwsEcr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trust_policy: Optional[builtins.str] = None):
        if trust_policy is not None:
            pulumi.set(__self__, "trust_policy", trust_policy)

    @property
    @pulumi.getter(name="trustPolicy")
    def trust_policy(self) -> Optional[builtins.str]:
        return pulumi.get(self, "trust_policy")


@pulumi.output_type
class Mk8sStatusAddOnAwsEf(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustPolicy":
            suggest = "trust_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatusAddOnAwsEf. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatusAddOnAwsEf.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatusAddOnAwsEf.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trust_policy: Optional[builtins.str] = None):
        if trust_policy is not None:
            pulumi.set(__self__, "trust_policy", trust_policy)

    @property
    @pulumi.getter(name="trustPolicy")
    def trust_policy(self) -> Optional[builtins.str]:
        return pulumi.get(self, "trust_policy")


@pulumi.output_type
class Mk8sStatusAddOnAwsElb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustPolicy":
            suggest = "trust_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatusAddOnAwsElb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatusAddOnAwsElb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatusAddOnAwsElb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trust_policy: Optional[builtins.str] = None):
        if trust_policy is not None:
            pulumi.set(__self__, "trust_policy", trust_policy)

    @property
    @pulumi.getter(name="trustPolicy")
    def trust_policy(self) -> Optional[builtins.str]:
        return pulumi.get(self, "trust_policy")


@pulumi.output_type
class Mk8sStatusAddOnAwsWorkloadIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oidcProviderConfigs":
            suggest = "oidc_provider_configs"
        elif key == "trustPolicy":
            suggest = "trust_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatusAddOnAwsWorkloadIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatusAddOnAwsWorkloadIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatusAddOnAwsWorkloadIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oidc_provider_configs: Optional[Sequence['outputs.Mk8sStatusAddOnAwsWorkloadIdentityOidcProviderConfig']] = None,
                 trust_policy: Optional[builtins.str] = None):
        if oidc_provider_configs is not None:
            pulumi.set(__self__, "oidc_provider_configs", oidc_provider_configs)
        if trust_policy is not None:
            pulumi.set(__self__, "trust_policy", trust_policy)

    @property
    @pulumi.getter(name="oidcProviderConfigs")
    def oidc_provider_configs(self) -> Optional[Sequence['outputs.Mk8sStatusAddOnAwsWorkloadIdentityOidcProviderConfig']]:
        return pulumi.get(self, "oidc_provider_configs")

    @property
    @pulumi.getter(name="trustPolicy")
    def trust_policy(self) -> Optional[builtins.str]:
        return pulumi.get(self, "trust_policy")


@pulumi.output_type
class Mk8sStatusAddOnAwsWorkloadIdentityOidcProviderConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerUrl":
            suggest = "provider_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatusAddOnAwsWorkloadIdentityOidcProviderConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatusAddOnAwsWorkloadIdentityOidcProviderConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatusAddOnAwsWorkloadIdentityOidcProviderConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audience: Optional[builtins.str] = None,
                 provider_url: Optional[builtins.str] = None):
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if provider_url is not None:
            pulumi.set(__self__, "provider_url", provider_url)

    @property
    @pulumi.getter
    def audience(self) -> Optional[builtins.str]:
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter(name="providerUrl")
    def provider_url(self) -> Optional[builtins.str]:
        return pulumi.get(self, "provider_url")


@pulumi.output_type
class Mk8sStatusAddOnDashboard(dict):
    def __init__(__self__, *,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str url: Access to dashboard.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        Access to dashboard.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class Mk8sStatusAddOnLog(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lokiAddress":
            suggest = "loki_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatusAddOnLog. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatusAddOnLog.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatusAddOnLog.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 loki_address: Optional[builtins.str] = None):
        """
        :param builtins.str loki_address: Loki endpoint to query logs from.
        """
        if loki_address is not None:
            pulumi.set(__self__, "loki_address", loki_address)

    @property
    @pulumi.getter(name="lokiAddress")
    def loki_address(self) -> Optional[builtins.str]:
        """
        Loki endpoint to query logs from.
        """
        return pulumi.get(self, "loki_address")


@pulumi.output_type
class Mk8sStatusAddOnMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prometheusEndpoint":
            suggest = "prometheus_endpoint"
        elif key == "remoteWriteConfig":
            suggest = "remote_write_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sStatusAddOnMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sStatusAddOnMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sStatusAddOnMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 prometheus_endpoint: Optional[builtins.str] = None,
                 remote_write_config: Optional[builtins.str] = None):
        if prometheus_endpoint is not None:
            pulumi.set(__self__, "prometheus_endpoint", prometheus_endpoint)
        if remote_write_config is not None:
            pulumi.set(__self__, "remote_write_config", remote_write_config)

    @property
    @pulumi.getter(name="prometheusEndpoint")
    def prometheus_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "prometheus_endpoint")

    @property
    @pulumi.getter(name="remoteWriteConfig")
    def remote_write_config(self) -> Optional[builtins.str]:
        return pulumi.get(self, "remote_write_config")


@pulumi.output_type
class Mk8sTritonProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "privateNetworkId":
            suggest = "private_network_id"
        elif key == "firewallEnabled":
            suggest = "firewall_enabled"
        elif key == "loadBalancer":
            suggest = "load_balancer"
        elif key == "nodePools":
            suggest = "node_pools"
        elif key == "preInstallScript":
            suggest = "pre_install_script"
        elif key == "sshKeys":
            suggest = "ssh_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sTritonProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sTritonProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sTritonProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: builtins.str,
                 location: builtins.str,
                 private_network_id: builtins.str,
                 autoscaler: Optional['outputs.Mk8sTritonProviderAutoscaler'] = None,
                 connection: Optional['outputs.Mk8sTritonProviderConnection'] = None,
                 firewall_enabled: Optional[builtins.bool] = None,
                 load_balancer: Optional['outputs.Mk8sTritonProviderLoadBalancer'] = None,
                 networking: Optional['outputs.Mk8sTritonProviderNetworking'] = None,
                 node_pools: Optional[Sequence['outputs.Mk8sTritonProviderNodePool']] = None,
                 pre_install_script: Optional[builtins.str] = None,
                 ssh_keys: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str image_id: Default image for all nodes.
        :param builtins.str location: Control Plane location that will host the K8s components. Prefer one that is closest to the Triton datacenter.
        :param builtins.str private_network_id: ID of the private Fabric/Network.
        :param builtins.bool firewall_enabled: Enable firewall for the instances deployed.
        :param Sequence['Mk8sTritonProviderNodePoolArgs'] node_pools: List of node pools.
        :param builtins.str pre_install_script: Optional shell script that will be run before K8s is installed. Supports SSM.
        :param Sequence[builtins.str] ssh_keys: Extra SSH keys to provision for user root.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "private_network_id", private_network_id)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if firewall_enabled is not None:
            pulumi.set(__self__, "firewall_enabled", firewall_enabled)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pre_install_script is not None:
            pulumi.set(__self__, "pre_install_script", pre_install_script)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        """
        Default image for all nodes.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Control Plane location that will host the K8s components. Prefer one that is closest to the Triton datacenter.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> builtins.str:
        """
        ID of the private Fabric/Network.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter
    def autoscaler(self) -> Optional['outputs.Mk8sTritonProviderAutoscaler']:
        return pulumi.get(self, "autoscaler")

    @property
    @pulumi.getter
    def connection(self) -> Optional['outputs.Mk8sTritonProviderConnection']:
        return pulumi.get(self, "connection")

    @property
    @pulumi.getter(name="firewallEnabled")
    def firewall_enabled(self) -> Optional[builtins.bool]:
        """
        Enable firewall for the instances deployed.
        """
        return pulumi.get(self, "firewall_enabled")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.Mk8sTritonProviderLoadBalancer']:
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter
    def networking(self) -> Optional['outputs.Mk8sTritonProviderNetworking']:
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence['outputs.Mk8sTritonProviderNodePool']]:
        """
        List of node pools.
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="preInstallScript")
    def pre_install_script(self) -> Optional[builtins.str]:
        """
        Optional shell script that will be run before K8s is installed. Supports SSM.
        """
        return pulumi.get(self, "pre_install_script")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        Extra SSH keys to provision for user root.
        """
        return pulumi.get(self, "ssh_keys")


@pulumi.output_type
class Mk8sTritonProviderAutoscaler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "unneededTime":
            suggest = "unneeded_time"
        elif key == "unreadyTime":
            suggest = "unready_time"
        elif key == "utilizationThreshold":
            suggest = "utilization_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sTritonProviderAutoscaler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sTritonProviderAutoscaler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sTritonProviderAutoscaler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expanders: Optional[Sequence[builtins.str]] = None,
                 unneeded_time: Optional[builtins.str] = None,
                 unready_time: Optional[builtins.str] = None,
                 utilization_threshold: Optional[builtins.float] = None):
        if expanders is not None:
            pulumi.set(__self__, "expanders", expanders)
        if unneeded_time is not None:
            pulumi.set(__self__, "unneeded_time", unneeded_time)
        if unready_time is not None:
            pulumi.set(__self__, "unready_time", unready_time)
        if utilization_threshold is not None:
            pulumi.set(__self__, "utilization_threshold", utilization_threshold)

    @property
    @pulumi.getter
    def expanders(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "expanders")

    @property
    @pulumi.getter(name="unneededTime")
    def unneeded_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unneeded_time")

    @property
    @pulumi.getter(name="unreadyTime")
    def unready_time(self) -> Optional[builtins.str]:
        return pulumi.get(self, "unready_time")

    @property
    @pulumi.getter(name="utilizationThreshold")
    def utilization_threshold(self) -> Optional[builtins.float]:
        return pulumi.get(self, "utilization_threshold")


@pulumi.output_type
class Mk8sTritonProviderConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateKeySecretLink":
            suggest = "private_key_secret_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sTritonProviderConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sTritonProviderConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sTritonProviderConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account: builtins.str,
                 private_key_secret_link: builtins.str,
                 url: builtins.str,
                 user: Optional[builtins.str] = None):
        """
        :param builtins.str private_key_secret_link: Link to a SSH or opaque secret.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "private_key_secret_link", private_key_secret_link)
        pulumi.set(__self__, "url", url)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def account(self) -> builtins.str:
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="privateKeySecretLink")
    def private_key_secret_link(self) -> builtins.str:
        """
        Link to a SSH or opaque secret.
        """
        return pulumi.get(self, "private_key_secret_link")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        return pulumi.get(self, "user")


@pulumi.output_type
class Mk8sTritonProviderLoadBalancer(dict):
    def __init__(__self__, *,
                 gateway: Optional['outputs.Mk8sTritonProviderLoadBalancerGateway'] = None,
                 manual: Optional['outputs.Mk8sTritonProviderLoadBalancerManual'] = None):
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if manual is not None:
            pulumi.set(__self__, "manual", manual)

    @property
    @pulumi.getter
    def gateway(self) -> Optional['outputs.Mk8sTritonProviderLoadBalancerGateway']:
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def manual(self) -> Optional['outputs.Mk8sTritonProviderLoadBalancerManual']:
        return pulumi.get(self, "manual")


@pulumi.output_type
class Mk8sTritonProviderLoadBalancerGateway(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class Mk8sTritonProviderLoadBalancerManual(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cnsInternalDomain":
            suggest = "cns_internal_domain"
        elif key == "cnsPublicDomain":
            suggest = "cns_public_domain"
        elif key == "imageId":
            suggest = "image_id"
        elif key == "packageId":
            suggest = "package_id"
        elif key == "privateNetworkIds":
            suggest = "private_network_ids"
        elif key == "publicNetworkId":
            suggest = "public_network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sTritonProviderLoadBalancerManual. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sTritonProviderLoadBalancerManual.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sTritonProviderLoadBalancerManual.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cns_internal_domain: builtins.str,
                 cns_public_domain: builtins.str,
                 image_id: builtins.str,
                 package_id: builtins.str,
                 private_network_ids: Sequence[builtins.str],
                 public_network_id: builtins.str,
                 count: Optional[builtins.int] = None,
                 logging: Optional['outputs.Mk8sTritonProviderLoadBalancerManualLogging'] = None,
                 metadata: Optional[Mapping[str, builtins.str]] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Sequence[builtins.str] private_network_ids: If set, machine will also get a public IP.
        :param builtins.str public_network_id: If set, machine will also get a public IP.
        :param Mapping[str, builtins.str] metadata: Extra tags to attach to instances from a node pool.
        :param Mapping[str, builtins.str] tags: Extra tags to attach to instances from a node pool.
        """
        pulumi.set(__self__, "cns_internal_domain", cns_internal_domain)
        pulumi.set(__self__, "cns_public_domain", cns_public_domain)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "package_id", package_id)
        pulumi.set(__self__, "private_network_ids", private_network_ids)
        pulumi.set(__self__, "public_network_id", public_network_id)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cnsInternalDomain")
    def cns_internal_domain(self) -> builtins.str:
        return pulumi.get(self, "cns_internal_domain")

    @property
    @pulumi.getter(name="cnsPublicDomain")
    def cns_public_domain(self) -> builtins.str:
        return pulumi.get(self, "cns_public_domain")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> builtins.str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="packageId")
    def package_id(self) -> builtins.str:
        return pulumi.get(self, "package_id")

    @property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> Sequence[builtins.str]:
        """
        If set, machine will also get a public IP.
        """
        return pulumi.get(self, "private_network_ids")

    @property
    @pulumi.getter(name="publicNetworkId")
    def public_network_id(self) -> builtins.str:
        """
        If set, machine will also get a public IP.
        """
        return pulumi.get(self, "public_network_id")

    @property
    @pulumi.getter
    def count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def logging(self) -> Optional['outputs.Mk8sTritonProviderLoadBalancerManualLogging']:
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Extra tags to attach to instances from a node pool.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Extra tags to attach to instances from a node pool.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class Mk8sTritonProviderLoadBalancerManualLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalSyslog":
            suggest = "external_syslog"
        elif key == "nodePort":
            suggest = "node_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sTritonProviderLoadBalancerManualLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sTritonProviderLoadBalancerManualLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sTritonProviderLoadBalancerManualLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_syslog: Optional[builtins.str] = None,
                 node_port: Optional[builtins.int] = None):
        if external_syslog is not None:
            pulumi.set(__self__, "external_syslog", external_syslog)
        if node_port is not None:
            pulumi.set(__self__, "node_port", node_port)

    @property
    @pulumi.getter(name="externalSyslog")
    def external_syslog(self) -> Optional[builtins.str]:
        return pulumi.get(self, "external_syslog")

    @property
    @pulumi.getter(name="nodePort")
    def node_port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "node_port")


@pulumi.output_type
class Mk8sTritonProviderNetworking(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsForwarder":
            suggest = "dns_forwarder"
        elif key == "podNetwork":
            suggest = "pod_network"
        elif key == "serviceNetwork":
            suggest = "service_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sTritonProviderNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sTritonProviderNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sTritonProviderNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_forwarder: Optional[builtins.str] = None,
                 pod_network: Optional[builtins.str] = None,
                 service_network: Optional[builtins.str] = None):
        """
        :param builtins.str dns_forwarder: DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        :param builtins.str pod_network: The CIDR of the pod network.
        :param builtins.str service_network: The CIDR of the service network.
        """
        if dns_forwarder is not None:
            pulumi.set(__self__, "dns_forwarder", dns_forwarder)
        if pod_network is not None:
            pulumi.set(__self__, "pod_network", pod_network)
        if service_network is not None:
            pulumi.set(__self__, "service_network", service_network)

    @property
    @pulumi.getter(name="dnsForwarder")
    def dns_forwarder(self) -> Optional[builtins.str]:
        """
        DNS forwarder used by the cluster. Can be a space-delimited list of dns servers. Default is /etc/resolv.conf when not specified.
        """
        return pulumi.get(self, "dns_forwarder")

    @property
    @pulumi.getter(name="podNetwork")
    def pod_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the pod network.
        """
        return pulumi.get(self, "pod_network")

    @property
    @pulumi.getter(name="serviceNetwork")
    def service_network(self) -> Optional[builtins.str]:
        """
        The CIDR of the service network.
        """
        return pulumi.get(self, "service_network")


@pulumi.output_type
class Mk8sTritonProviderNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packageId":
            suggest = "package_id"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "overrideImageId":
            suggest = "override_image_id"
        elif key == "privateNetworkIds":
            suggest = "private_network_ids"
        elif key == "publicNetworkId":
            suggest = "public_network_id"
        elif key == "tritonTags":
            suggest = "triton_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Mk8sTritonProviderNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Mk8sTritonProviderNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Mk8sTritonProviderNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 package_id: builtins.str,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None,
                 override_image_id: Optional[builtins.str] = None,
                 private_network_ids: Optional[Sequence[builtins.str]] = None,
                 public_network_id: Optional[builtins.str] = None,
                 taints: Optional[Sequence['outputs.Mk8sTritonProviderNodePoolTaint']] = None,
                 triton_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] labels: Labels to attach to nodes of a node pool.
        :param Sequence[builtins.str] private_network_ids: More private networks to join.
        :param builtins.str public_network_id: If set, machine will also get a public IP.
        :param Sequence['Mk8sTritonProviderNodePoolTaintArgs'] taints: Taint for the nodes of a pool.
        :param Mapping[str, builtins.str] triton_tags: Extra tags to attach to instances from a node pool.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_id", package_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if override_image_id is not None:
            pulumi.set(__self__, "override_image_id", override_image_id)
        if private_network_ids is not None:
            pulumi.set(__self__, "private_network_ids", private_network_ids)
        if public_network_id is not None:
            pulumi.set(__self__, "public_network_id", public_network_id)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if triton_tags is not None:
            pulumi.set(__self__, "triton_tags", triton_tags)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageId")
    def package_id(self) -> builtins.str:
        return pulumi.get(self, "package_id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Labels to attach to nodes of a node pool.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="overrideImageId")
    def override_image_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "override_image_id")

    @property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        More private networks to join.
        """
        return pulumi.get(self, "private_network_ids")

    @property
    @pulumi.getter(name="publicNetworkId")
    def public_network_id(self) -> Optional[builtins.str]:
        """
        If set, machine will also get a public IP.
        """
        return pulumi.get(self, "public_network_id")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.Mk8sTritonProviderNodePoolTaint']]:
        """
        Taint for the nodes of a pool.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="tritonTags")
    def triton_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Extra tags to attach to instances from a node pool.
        """
        return pulumi.get(self, "triton_tags")


@pulumi.output_type
class Mk8sTritonProviderNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class OrgAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainAutoMembers":
            suggest = "domain_auto_members"
        elif key == "samlOnly":
            suggest = "saml_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_auto_members: Sequence[builtins.str],
                 saml_only: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] domain_auto_members: List of domains which will auto-provision users when authenticating using SAML.
        :param builtins.bool saml_only: Enforce SAML only authentication.
        """
        pulumi.set(__self__, "domain_auto_members", domain_auto_members)
        if saml_only is not None:
            pulumi.set(__self__, "saml_only", saml_only)

    @property
    @pulumi.getter(name="domainAutoMembers")
    def domain_auto_members(self) -> Sequence[builtins.str]:
        """
        List of domains which will auto-provision users when authenticating using SAML.
        """
        return pulumi.get(self, "domain_auto_members")

    @property
    @pulumi.getter(name="samlOnly")
    def saml_only(self) -> Optional[builtins.bool]:
        """
        Enforce SAML only authentication.
        """
        return pulumi.get(self, "saml_only")


@pulumi.output_type
class OrgLoggingCloudWatchLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"
        elif key == "streamName":
            suggest = "stream_name"
        elif key == "extractFields":
            suggest = "extract_fields"
        elif key == "retentionDays":
            suggest = "retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgLoggingCloudWatchLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgLoggingCloudWatchLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgLoggingCloudWatchLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials: builtins.str,
                 group_name: builtins.str,
                 region: builtins.str,
                 stream_name: builtins.str,
                 extract_fields: Optional[Mapping[str, builtins.str]] = None,
                 retention_days: Optional[builtins.int] = None):
        """
        :param builtins.str credentials: Full Link to a secret of type `opaque`.
        :param builtins.str group_name: A container for log streams with common settings like retention. Used to categorize logs by application or service type.
        :param builtins.str region: Valid AWS region.
        :param builtins.str stream_name: A sequence of log events from the same source within a log group. Typically represents individual instances of services or applications.
        :param Mapping[str, builtins.str] extract_fields: Enable custom data extraction from log entries for enhanced querying and analysis.
        :param builtins.int retention_days: Length, in days, for how log data is kept before it is automatically deleted.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "stream_name", stream_name)
        if extract_fields is not None:
            pulumi.set(__self__, "extract_fields", extract_fields)
        if retention_days is not None:
            pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full Link to a secret of type `opaque`.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> builtins.str:
        """
        A container for log streams with common settings like retention. Used to categorize logs by application or service type.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Valid AWS region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> builtins.str:
        """
        A sequence of log events from the same source within a log group. Typically represents individual instances of services or applications.
        """
        return pulumi.get(self, "stream_name")

    @property
    @pulumi.getter(name="extractFields")
    def extract_fields(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Enable custom data extraction from log entries for enhanced querying and analysis.
        """
        return pulumi.get(self, "extract_fields")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[builtins.int]:
        """
        Length, in days, for how log data is kept before it is automatically deleted.
        """
        return pulumi.get(self, "retention_days")


@pulumi.output_type
class OrgLoggingCoralogixLogging(dict):
    def __init__(__self__, *,
                 cluster: builtins.str,
                 credentials: builtins.str,
                 app: Optional[builtins.str] = None,
                 subsystem: Optional[builtins.str] = None):
        """
        :param builtins.str cluster: Coralogix cluster URI.
        :param builtins.str credentials: Full link to referenced Opaque Secret.
        :param builtins.str app: App name to be displayed in Coralogix dashboard.
        :param builtins.str subsystem: Subsystem name to be displayed in Coralogix dashboard.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "credentials", credentials)
        if app is not None:
            pulumi.set(__self__, "app", app)
        if subsystem is not None:
            pulumi.set(__self__, "subsystem", subsystem)

    @property
    @pulumi.getter
    def cluster(self) -> builtins.str:
        """
        Coralogix cluster URI.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full link to referenced Opaque Secret.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def app(self) -> Optional[builtins.str]:
        """
        App name to be displayed in Coralogix dashboard.
        """
        return pulumi.get(self, "app")

    @property
    @pulumi.getter
    def subsystem(self) -> Optional[builtins.str]:
        """
        Subsystem name to be displayed in Coralogix dashboard.
        """
        return pulumi.get(self, "subsystem")


@pulumi.output_type
class OrgLoggingDatadogLogging(dict):
    def __init__(__self__, *,
                 credentials: builtins.str,
                 host: builtins.str):
        """
        :param builtins.str credentials: Full link to referenced Opaque Secret.
        :param builtins.str host: Datadog host URI.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full link to referenced Opaque Secret.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Datadog host URI.
        """
        return pulumi.get(self, "host")


@pulumi.output_type
class OrgLoggingElasticLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticCloud":
            suggest = "elastic_cloud"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgLoggingElasticLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgLoggingElasticLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgLoggingElasticLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws: Optional['outputs.OrgLoggingElasticLoggingAws'] = None,
                 elastic_cloud: Optional['outputs.OrgLoggingElasticLoggingElasticCloud'] = None,
                 generic: Optional['outputs.OrgLoggingElasticLoggingGeneric'] = None):
        """
        :param 'OrgLoggingElasticLoggingAwsArgs' aws: For targeting Amazon Web Services (AWS) ElasticSearch.
        :param 'OrgLoggingElasticLoggingElasticCloudArgs' elastic_cloud: For targeting Elastic Cloud.
        :param 'OrgLoggingElasticLoggingGenericArgs' generic: For targeting generic Elastic Search providers.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if elastic_cloud is not None:
            pulumi.set(__self__, "elastic_cloud", elastic_cloud)
        if generic is not None:
            pulumi.set(__self__, "generic", generic)

    @property
    @pulumi.getter
    def aws(self) -> Optional['outputs.OrgLoggingElasticLoggingAws']:
        """
        For targeting Amazon Web Services (AWS) ElasticSearch.
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter(name="elasticCloud")
    def elastic_cloud(self) -> Optional['outputs.OrgLoggingElasticLoggingElasticCloud']:
        """
        For targeting Elastic Cloud.
        """
        return pulumi.get(self, "elastic_cloud")

    @property
    @pulumi.getter
    def generic(self) -> Optional['outputs.OrgLoggingElasticLoggingGeneric']:
        """
        For targeting generic Elastic Search providers.
        """
        return pulumi.get(self, "generic")


@pulumi.output_type
class OrgLoggingElasticLoggingAws(dict):
    def __init__(__self__, *,
                 credentials: builtins.str,
                 host: builtins.str,
                 index: builtins.str,
                 port: builtins.int,
                 region: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str credentials: Full Link to a secret of type `aws`.
        :param builtins.str host: A valid AWS ElasticSearch hostname (must end with es.amazonaws.com).
        :param builtins.str index: Logging Index.
        :param builtins.int port: Port. Default: 443
        :param builtins.str region: Valid AWS region.
        :param builtins.str type: Logging Type.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full Link to a secret of type `aws`.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        A valid AWS ElasticSearch hostname (must end with es.amazonaws.com).
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def index(self) -> builtins.str:
        """
        Logging Index.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port. Default: 443
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Valid AWS region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Logging Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OrgLoggingElasticLoggingElasticCloud(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudId":
            suggest = "cloud_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgLoggingElasticLoggingElasticCloud. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgLoggingElasticLoggingElasticCloud.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgLoggingElasticLoggingElasticCloud.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_id: builtins.str,
                 credentials: builtins.str,
                 index: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str cloud_id: [Cloud ID](https://www.elastic.co/guide/en/cloud/current/ec-cloud-id.html)
        :param builtins.str credentials: Full Link to a secret of type `userpass`.
        :param builtins.str index: Logging Index.
        :param builtins.str type: Logging Type.
        """
        pulumi.set(__self__, "cloud_id", cloud_id)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> builtins.str:
        """
        [Cloud ID](https://www.elastic.co/guide/en/cloud/current/ec-cloud-id.html)
        """
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full Link to a secret of type `userpass`.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def index(self) -> builtins.str:
        """
        Logging Index.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Logging Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OrgLoggingElasticLoggingGeneric(dict):
    def __init__(__self__, *,
                 credentials: builtins.str,
                 host: builtins.str,
                 index: builtins.str,
                 path: builtins.str,
                 port: builtins.int,
                 type: builtins.str):
        """
        :param builtins.str credentials: Full Link to a secret of type `userpass`.
        :param builtins.str host: A valid Elastic Search provider hostname.
        :param builtins.str index: Logging Index.
        :param builtins.str path: Logging path.
        :param builtins.int port: Port. Default: 443
        :param builtins.str type: Logging Type.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full Link to a secret of type `userpass`.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        A valid Elastic Search provider hostname.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def index(self) -> builtins.str:
        """
        Logging Index.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Logging path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port. Default: 443
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Logging Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OrgLoggingFluentdLogging(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str host: The hostname or IP address of a remote log storage system.
        :param builtins.int port: Port. Default: 24224
        """
        pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        The hostname or IP address of a remote log storage system.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Port. Default: 24224
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class OrgLoggingLogzioLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listenerHost":
            suggest = "listener_host"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgLoggingLogzioLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgLoggingLogzioLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgLoggingLogzioLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials: builtins.str,
                 listener_host: builtins.str):
        """
        :param builtins.str credentials: Full link to referenced Opaque Secret.
        :param builtins.str listener_host: Logzio listener host URI.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "listener_host", listener_host)

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full link to referenced Opaque Secret.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="listenerHost")
    def listener_host(self) -> builtins.str:
        """
        Logzio listener host URI.
        """
        return pulumi.get(self, "listener_host")


@pulumi.output_type
class OrgLoggingS3Logging(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 credentials: builtins.str,
                 region: builtins.str,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: Name of S3 bucket.
        :param builtins.str credentials: Full link to referenced AWS Secret.
        :param builtins.str region: AWS region where bucket is located.
        :param builtins.str prefix: Bucket path prefix. Default: "/".
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "region", region)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Name of S3 bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full link to referenced AWS Secret.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        AWS region where bucket is located.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        Bucket path prefix. Default: "/".
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class OrgLoggingStackdriverLogging(dict):
    def __init__(__self__, *,
                 credentials: builtins.str,
                 location: builtins.str):
        """
        :param builtins.str credentials: Full Link to a secret of type `opaque`.
        :param builtins.str location: A Google Cloud Provider region.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def credentials(self) -> builtins.str:
        """
        Full Link to a secret of type `opaque`.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        A Google Cloud Provider region.
        """
        return pulumi.get(self, "location")


@pulumi.output_type
class OrgLoggingSyslogLogging(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 port: builtins.int,
                 format: Optional[builtins.str] = None,
                 mode: Optional[builtins.str] = None,
                 severity: Optional[builtins.int] = None):
        """
        :param builtins.str host: Hostname of Syslog Endpoint.
        :param builtins.int port: Port of Syslog Endpoint.
        :param builtins.str format: Log Format. Valid values: RFC3164 or RFC5424.
        :param builtins.str mode: Log Mode. Valid values: TCP, TLS, or UDP.
        :param builtins.int severity: Severity Level. See documentation for details. Valid values: 0 to 7.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        Hostname of Syslog Endpoint.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port of Syslog Endpoint.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def format(self) -> Optional[builtins.str]:
        """
        Log Format. Valid values: RFC3164 or RFC5424.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        Log Mode. Valid values: TCP, TLS, or UDP.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def severity(self) -> Optional[builtins.int]:
        """
        Severity Level. See documentation for details. Valid values: 0 to 7.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class OrgObservability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAlertEmails":
            suggest = "default_alert_emails"
        elif key == "logsRetentionDays":
            suggest = "logs_retention_days"
        elif key == "metricsRetentionDays":
            suggest = "metrics_retention_days"
        elif key == "tracesRetentionDays":
            suggest = "traces_retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgObservability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgObservability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgObservability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_alert_emails: Optional[Sequence[builtins.str]] = None,
                 logs_retention_days: Optional[builtins.int] = None,
                 metrics_retention_days: Optional[builtins.int] = None,
                 traces_retention_days: Optional[builtins.int] = None):
        """
        :param Sequence[builtins.str] default_alert_emails: These emails are configured as alert recipients in Grafana when the 'grafana-default-email' contact delivery type is 'Email'.
        :param builtins.int logs_retention_days: Log retention days. Default: 30
        :param builtins.int metrics_retention_days: Metrics retention days. Default: 30
        :param builtins.int traces_retention_days: Traces retention days. Default: 30
        """
        if default_alert_emails is not None:
            pulumi.set(__self__, "default_alert_emails", default_alert_emails)
        if logs_retention_days is not None:
            pulumi.set(__self__, "logs_retention_days", logs_retention_days)
        if metrics_retention_days is not None:
            pulumi.set(__self__, "metrics_retention_days", metrics_retention_days)
        if traces_retention_days is not None:
            pulumi.set(__self__, "traces_retention_days", traces_retention_days)

    @property
    @pulumi.getter(name="defaultAlertEmails")
    def default_alert_emails(self) -> Optional[Sequence[builtins.str]]:
        """
        These emails are configured as alert recipients in Grafana when the 'grafana-default-email' contact delivery type is 'Email'.
        """
        return pulumi.get(self, "default_alert_emails")

    @property
    @pulumi.getter(name="logsRetentionDays")
    def logs_retention_days(self) -> Optional[builtins.int]:
        """
        Log retention days. Default: 30
        """
        return pulumi.get(self, "logs_retention_days")

    @property
    @pulumi.getter(name="metricsRetentionDays")
    def metrics_retention_days(self) -> Optional[builtins.int]:
        """
        Metrics retention days. Default: 30
        """
        return pulumi.get(self, "metrics_retention_days")

    @property
    @pulumi.getter(name="tracesRetentionDays")
    def traces_retention_days(self) -> Optional[builtins.int]:
        """
        Traces retention days. Default: 30
        """
        return pulumi.get(self, "traces_retention_days")


@pulumi.output_type
class OrgSecurity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "threatDetection":
            suggest = "threat_detection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 threat_detection: Optional['outputs.OrgSecurityThreatDetection'] = None):
        if threat_detection is not None:
            pulumi.set(__self__, "threat_detection", threat_detection)

    @property
    @pulumi.getter(name="threatDetection")
    def threat_detection(self) -> Optional['outputs.OrgSecurityThreatDetection']:
        return pulumi.get(self, "threat_detection")


@pulumi.output_type
class OrgSecurityThreatDetection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumSeverity":
            suggest = "minimum_severity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgSecurityThreatDetection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgSecurityThreatDetection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgSecurityThreatDetection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 minimum_severity: Optional[builtins.str] = None,
                 syslog: Optional['outputs.OrgSecurityThreatDetectionSyslog'] = None):
        """
        :param builtins.bool enabled: Indicates whether threat detection should be forwarded or not.
        :param builtins.str minimum_severity: Any threats with this severity and more severe will be sent. Others will be ignored. Valid values: `warning`, `error`, or `critical`.
        :param 'OrgSecurityThreatDetectionSyslogArgs' syslog: Configuration for syslog forwarding.
        """
        pulumi.set(__self__, "enabled", enabled)
        if minimum_severity is not None:
            pulumi.set(__self__, "minimum_severity", minimum_severity)
        if syslog is not None:
            pulumi.set(__self__, "syslog", syslog)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Indicates whether threat detection should be forwarded or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="minimumSeverity")
    def minimum_severity(self) -> Optional[builtins.str]:
        """
        Any threats with this severity and more severe will be sent. Others will be ignored. Valid values: `warning`, `error`, or `critical`.
        """
        return pulumi.get(self, "minimum_severity")

    @property
    @pulumi.getter
    def syslog(self) -> Optional['outputs.OrgSecurityThreatDetectionSyslog']:
        """
        Configuration for syslog forwarding.
        """
        return pulumi.get(self, "syslog")


@pulumi.output_type
class OrgSecurityThreatDetectionSyslog(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 port: builtins.int,
                 transport: Optional[builtins.str] = None):
        """
        :param builtins.str host: The hostname to send syslog messages to.
        :param builtins.int port: The port to send syslog messages to.
        :param builtins.str transport: The transport-layer protocol to send the syslog messages over. If TCP is chosen, messages will be sent with TLS. Default: `tcp`.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        if transport is not None:
            pulumi.set(__self__, "transport", transport)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        The hostname to send syslog messages to.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port to send syslog messages to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def transport(self) -> Optional[builtins.str]:
        """
        The transport-layer protocol to send the syslog messages over. If TCP is chosen, messages will be sent with TLS. Default: `tcp`.
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class OrgStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountLink":
            suggest = "account_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_link: Optional[builtins.str] = None,
                 active: Optional[builtins.bool] = None):
        """
        :param builtins.str account_link: The link of the account the org belongs to.
        :param builtins.bool active: Indicates whether the org is active or not.
        """
        if account_link is not None:
            pulumi.set(__self__, "account_link", account_link)
        if active is not None:
            pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter(name="accountLink")
    def account_link(self) -> Optional[builtins.str]:
        """
        The link of the account the org belongs to.
        """
        return pulumi.get(self, "account_link")

    @property
    @pulumi.getter
    def active(self) -> Optional[builtins.bool]:
        """
        Indicates whether the org is active or not.
        """
        return pulumi.get(self, "active")


@pulumi.output_type
class OrgTracingControlplaneTracing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTags":
            suggest = "custom_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgTracingControlplaneTracing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgTracingControlplaneTracing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgTracingControlplaneTracing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sampling: builtins.float,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "sampling", sampling)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class OrgTracingLightstepTracing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTags":
            suggest = "custom_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgTracingLightstepTracing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgTracingLightstepTracing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgTracingLightstepTracing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: builtins.str,
                 sampling: builtins.float,
                 credentials: Optional[builtins.str] = None,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str endpoint: Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param builtins.str credentials: Full link to referenced Opaque Secret.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "sampling", sampling)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter
    def credentials(self) -> Optional[builtins.str]:
        """
        Full link to referenced Opaque Secret.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class OrgTracingOtelTracing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customTags":
            suggest = "custom_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrgTracingOtelTracing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrgTracingOtelTracing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrgTracingOtelTracing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: builtins.str,
                 sampling: builtins.float,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str endpoint: Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "sampling", sampling)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class PolicyBinding(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalLinks":
            suggest = "principal_links"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyBinding. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyBinding.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyBinding.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permissions: Sequence[builtins.str],
                 principal_links: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] permissions: List of permissions to allow.
        :param Sequence[builtins.str] principal_links: List of the principals this binding will be applied to. Principal links format: `group/GROUP_NAME`, `user/USER_EMAIL`, `gvc/GVC_NAME/identity/IDENTITY_NAME`, `serviceaccount/SERVICE_ACCOUNT_NAME`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal_links", principal_links)

    @property
    @pulumi.getter
    def permissions(self) -> Sequence[builtins.str]:
        """
        List of permissions to allow.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="principalLinks")
    def principal_links(self) -> Sequence[builtins.str]:
        """
        List of the principals this binding will be applied to. Principal links format: `group/GROUP_NAME`, `user/USER_EMAIL`, `gvc/GVC_NAME/identity/IDENTITY_NAME`, `serviceaccount/SERVICE_ACCOUNT_NAME`.
        """
        return pulumi.get(self, "principal_links")


@pulumi.output_type
class PolicyTargetQuery(dict):
    def __init__(__self__, *,
                 fetch: Optional[builtins.str] = None,
                 spec: Optional['outputs.PolicyTargetQuerySpec'] = None):
        """
        :param builtins.str fetch: Type of fetch. Specify either: `links` or `items`. Default: `items`.
        """
        if fetch is not None:
            pulumi.set(__self__, "fetch", fetch)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def fetch(self) -> Optional[builtins.str]:
        """
        Type of fetch. Specify either: `links` or `items`. Default: `items`.
        """
        return pulumi.get(self, "fetch")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.PolicyTargetQuerySpec']:
        return pulumi.get(self, "spec")


@pulumi.output_type
class PolicyTargetQuerySpec(dict):
    def __init__(__self__, *,
                 match: Optional[builtins.str] = None,
                 terms: Optional[Sequence['outputs.PolicyTargetQuerySpecTerm']] = None):
        """
        :param builtins.str match: Type of match. Available values: `all`, `any`, `none`. Default: `all`.
        :param Sequence['PolicyTargetQuerySpecTermArgs'] terms: Terms can only contain one of the following attributes: `property`, `rel`, `tag`.
        """
        if match is not None:
            pulumi.set(__self__, "match", match)
        if terms is not None:
            pulumi.set(__self__, "terms", terms)

    @property
    @pulumi.getter
    def match(self) -> Optional[builtins.str]:
        """
        Type of match. Available values: `all`, `any`, `none`. Default: `all`.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def terms(self) -> Optional[Sequence['outputs.PolicyTargetQuerySpecTerm']]:
        """
        Terms can only contain one of the following attributes: `property`, `rel`, `tag`.
        """
        return pulumi.get(self, "terms")


@pulumi.output_type
class PolicyTargetQuerySpecTerm(dict):
    def __init__(__self__, *,
                 op: Optional[builtins.str] = None,
                 property: Optional[builtins.str] = None,
                 rel: Optional[builtins.str] = None,
                 tag: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str op: Type of query operation. Available values: `=`, `>`, `>=`, `<`, `<=`, `!=`, `exists`, `!exists`. Default: `=`.
        :param builtins.str property: Property to use for query evaluation.
        :param builtins.str rel: Relation to use for query evaluation.
        :param builtins.str tag: Tag key to use for query evaluation.
        :param builtins.str value: Testing value for query evaluation.
        """
        if op is not None:
            pulumi.set(__self__, "op", op)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if rel is not None:
            pulumi.set(__self__, "rel", rel)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def op(self) -> Optional[builtins.str]:
        """
        Type of query operation. Available values: `=`, `>`, `>=`, `<`, `<=`, `!=`, `exists`, `!exists`. Default: `=`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def rel(self) -> Optional[builtins.str]:
        """
        Relation to use for query evaluation.
        """
        return pulumi.get(self, "rel")

    @property
    @pulumi.getter
    def tag(self) -> Optional[builtins.str]:
        """
        Tag key to use for query evaluation.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Testing value for query evaluation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> Optional[builtins.str]:
        """
        Property to use for query evaluation.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class SecretAws(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretAws. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretAws.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretAws.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: builtins.str,
                 secret_key: builtins.str,
                 external_id: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Access Key provided by AWS.
        :param builtins.str secret_key: Secret Key provided by AWS.
        :param builtins.str external_id: AWS IAM Role External ID.
        :param builtins.str role_arn: Role ARN provided by AWS.
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "secret_key", secret_key)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Access Key provided by AWS.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Secret Key provided by AWS.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        AWS IAM Role External ID.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Role ARN provided by AWS.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class SecretAzureConnector(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 url: builtins.str):
        """
        :param builtins.str code: Code/Key to authenticate to deployment URL.
        :param builtins.str url: Deployment URL.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        Code/Key to authenticate to deployment URL.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Deployment URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class SecretEcr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretEcr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretEcr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretEcr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: builtins.str,
                 repos: Sequence[builtins.str],
                 secret_key: builtins.str,
                 external_id: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Access Key provided by AWS.
        :param Sequence[builtins.str] repos: List of ECR repositories.
        :param builtins.str secret_key: Secret Key provided by AWS.
        :param builtins.str external_id: AWS IAM Role External ID. Used when setting up cross-account access to your ECR repositories.
        :param builtins.str role_arn: Role ARN provided by AWS.
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "repos", repos)
        pulumi.set(__self__, "secret_key", secret_key)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Access Key provided by AWS.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def repos(self) -> Sequence[builtins.str]:
        """
        List of ECR repositories.
        """
        return pulumi.get(self, "repos")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Secret Key provided by AWS.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        AWS IAM Role External ID. Used when setting up cross-account access to your ECR repositories.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Role ARN provided by AWS.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class SecretKeypair(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKey":
            suggest = "secret_key"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretKeypair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretKeypair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretKeypair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key: builtins.str,
                 passphrase: Optional[builtins.str] = None,
                 public_key: Optional[builtins.str] = None):
        """
        :param builtins.str secret_key: Secret/Private Key.
        :param builtins.str passphrase: Passphrase for private key.
        :param builtins.str public_key: Public Key.
        """
        pulumi.set(__self__, "secret_key", secret_key)
        if passphrase is not None:
            pulumi.set(__self__, "passphrase", passphrase)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Secret/Private Key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def passphrase(self) -> Optional[builtins.str]:
        """
        Passphrase for private key.
        """
        return pulumi.get(self, "passphrase")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[builtins.str]:
        """
        Public Key.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class SecretNatsAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretNatsAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretNatsAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretNatsAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: builtins.str,
                 private_key: builtins.str):
        """
        :param builtins.str account_id: Account ID.
        :param builtins.str private_key: Private Key.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> builtins.str:
        """
        Private Key.
        """
        return pulumi.get(self, "private_key")


@pulumi.output_type
class SecretOpaque(dict):
    def __init__(__self__, *,
                 payload: builtins.str,
                 encoding: Optional[builtins.str] = None):
        """
        :param builtins.str payload: Plain text or base64 encoded string. Use `encoding` attribute to specify encoding.
        :param builtins.str encoding: Available encodings: `plain`, `base64`. Default: `plain`.
        """
        pulumi.set(__self__, "payload", payload)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter
    def payload(self) -> builtins.str:
        """
        Plain text or base64 encoded string. Use `encoding` attribute to specify encoding.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[builtins.str]:
        """
        Available encodings: `plain`, `base64`. Default: `plain`.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class SecretTls(dict):
    def __init__(__self__, *,
                 cert: builtins.str,
                 key: builtins.str,
                 chain: Optional[builtins.str] = None):
        """
        :param builtins.str cert: Public Certificate.
        :param builtins.str key: Private Certificate.
        :param builtins.str chain: Chain Certificate.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "key", key)
        if chain is not None:
            pulumi.set(__self__, "chain", chain)

    @property
    @pulumi.getter
    def cert(self) -> builtins.str:
        """
        Public Certificate.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Private Certificate.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def chain(self) -> Optional[builtins.str]:
        """
        Chain Certificate.
        """
        return pulumi.get(self, "chain")


@pulumi.output_type
class SecretUserpass(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 username: builtins.str,
                 encoding: Optional[builtins.str] = None):
        """
        :param builtins.str password: Password.
        :param builtins.str username: Username.
        :param builtins.str encoding: Available encodings: `plain`, `base64`. Default: `plain`.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def encoding(self) -> Optional[builtins.str]:
        """
        Available encodings: `plain`, `base64`. Default: `plain`.
        """
        return pulumi.get(self, "encoding")


@pulumi.output_type
class VolumeSetAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minFreePercentage":
            suggest = "min_free_percentage"
        elif key == "scalingFactor":
            suggest = "scaling_factor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSetAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSetAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSetAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: Optional[builtins.int] = None,
                 min_free_percentage: Optional[builtins.int] = None,
                 scaling_factor: Optional[builtins.float] = None):
        """
        :param builtins.int max_capacity: The maximum size in GB for a volume in this set. A volume cannot grow to be bigger than this value. Minimum value: `10`.
        :param builtins.int min_free_percentage: The guaranteed free space on the volume as a percentage of the volume's total size. Control Plane will try to maintain at least that many percent free by scaling up the total size. Minimum percentage: `1`. Maximum Percentage: `100`.
        :param builtins.float scaling_factor: When scaling is necessary, then `new_capacity = current_capacity * storageScalingFactor`. Minimum value: `1.1`.
        """
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_free_percentage is not None:
            pulumi.set(__self__, "min_free_percentage", min_free_percentage)
        if scaling_factor is not None:
            pulumi.set(__self__, "scaling_factor", scaling_factor)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[builtins.int]:
        """
        The maximum size in GB for a volume in this set. A volume cannot grow to be bigger than this value. Minimum value: `10`.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minFreePercentage")
    def min_free_percentage(self) -> Optional[builtins.int]:
        """
        The guaranteed free space on the volume as a percentage of the volume's total size. Control Plane will try to maintain at least that many percent free by scaling up the total size. Minimum percentage: `1`. Maximum Percentage: `100`.
        """
        return pulumi.get(self, "min_free_percentage")

    @property
    @pulumi.getter(name="scalingFactor")
    def scaling_factor(self) -> Optional[builtins.float]:
        """
        When scaling is necessary, then `new_capacity = current_capacity * storageScalingFactor`. Minimum value: `1.1`.
        """
        return pulumi.get(self, "scaling_factor")


@pulumi.output_type
class VolumeSetMountOptions(dict):
    def __init__(__self__, *,
                 resources: Optional['outputs.VolumeSetMountOptionsResources'] = None):
        """
        :param 'VolumeSetMountOptionsResourcesArgs' resources: For volume sets using the shared file system, this object specifies the CPU and memory resources allotted to each mount point.
        """
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def resources(self) -> Optional['outputs.VolumeSetMountOptionsResources']:
        """
        For volume sets using the shared file system, this object specifies the CPU and memory resources allotted to each mount point.
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class VolumeSetMountOptionsResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCpu":
            suggest = "max_cpu"
        elif key == "maxMemory":
            suggest = "max_memory"
        elif key == "minCpu":
            suggest = "min_cpu"
        elif key == "minMemory":
            suggest = "min_memory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSetMountOptionsResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSetMountOptionsResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSetMountOptionsResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_cpu: Optional[builtins.str] = None,
                 max_memory: Optional[builtins.str] = None,
                 min_cpu: Optional[builtins.str] = None,
                 min_memory: Optional[builtins.str] = None):
        if max_cpu is not None:
            pulumi.set(__self__, "max_cpu", max_cpu)
        if max_memory is not None:
            pulumi.set(__self__, "max_memory", max_memory)
        if min_cpu is not None:
            pulumi.set(__self__, "min_cpu", min_cpu)
        if min_memory is not None:
            pulumi.set(__self__, "min_memory", min_memory)

    @property
    @pulumi.getter(name="maxCpu")
    def max_cpu(self) -> Optional[builtins.str]:
        return pulumi.get(self, "max_cpu")

    @property
    @pulumi.getter(name="maxMemory")
    def max_memory(self) -> Optional[builtins.str]:
        return pulumi.get(self, "max_memory")

    @property
    @pulumi.getter(name="minCpu")
    def min_cpu(self) -> Optional[builtins.str]:
        return pulumi.get(self, "min_cpu")

    @property
    @pulumi.getter(name="minMemory")
    def min_memory(self) -> Optional[builtins.str]:
        return pulumi.get(self, "min_memory")


@pulumi.output_type
class VolumeSetSnapshots(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createFinalSnapshot":
            suggest = "create_final_snapshot"
        elif key == "retentionDuration":
            suggest = "retention_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSetSnapshots. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSetSnapshots.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSetSnapshots.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_final_snapshot: Optional[builtins.bool] = None,
                 retention_duration: Optional[builtins.str] = None,
                 schedule: Optional[builtins.str] = None):
        """
        :param builtins.bool create_final_snapshot: If true, a volume snapshot will be created immediately before deletion of any volume in this set. Default: `true`
        :param builtins.str retention_duration: The default retention period for volume snapshots. This string should contain a floating point number followed by either d, h, or m. For example, "10d" would retain snapshots for 10 days.
        :param builtins.str schedule: A standard cron schedule expression used to determine when a snapshot will be taken. (i.e., `0 * * * *` Every hour). Note: snapshots cannot be scheduled more often than once per hour.
        """
        if create_final_snapshot is not None:
            pulumi.set(__self__, "create_final_snapshot", create_final_snapshot)
        if retention_duration is not None:
            pulumi.set(__self__, "retention_duration", retention_duration)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)

    @property
    @pulumi.getter(name="createFinalSnapshot")
    def create_final_snapshot(self) -> Optional[builtins.bool]:
        """
        If true, a volume snapshot will be created immediately before deletion of any volume in this set. Default: `true`
        """
        return pulumi.get(self, "create_final_snapshot")

    @property
    @pulumi.getter(name="retentionDuration")
    def retention_duration(self) -> Optional[builtins.str]:
        """
        The default retention period for volume snapshots. This string should contain a floating point number followed by either d, h, or m. For example, "10d" would retain snapshots for 10 days.
        """
        return pulumi.get(self, "retention_duration")

    @property
    @pulumi.getter
    def schedule(self) -> Optional[builtins.str]:
        """
        A standard cron schedule expression used to determine when a snapshot will be taken. (i.e., `0 * * * *` Every hour). Note: snapshots cannot be scheduled more often than once per hour.
        """
        return pulumi.get(self, "schedule")


@pulumi.output_type
class VolumeSetStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindingId":
            suggest = "binding_id"
        elif key == "parentId":
            suggest = "parent_id"
        elif key == "usedByWorkload":
            suggest = "used_by_workload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeSetStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeSetStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeSetStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 binding_id: Optional[builtins.str] = None,
                 locations: Optional[Sequence[builtins.str]] = None,
                 parent_id: Optional[builtins.str] = None,
                 used_by_workload: Optional[builtins.str] = None):
        """
        :param builtins.str binding_id: Uniquely identifies the connection between the volume set and its workload. Every time a new connection is made, a new id is generated (e.g., If a workload is updated to remove the volume set, then updated again to reattach it, the volume set will have a new binding id).
        :param Sequence[builtins.str] locations: Contains a list of actual volumes grouped by location.
        :param builtins.str parent_id: The GVC ID.
        :param builtins.str used_by_workload: The url of the workload currently using this volume set (if any).
        """
        if binding_id is not None:
            pulumi.set(__self__, "binding_id", binding_id)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if used_by_workload is not None:
            pulumi.set(__self__, "used_by_workload", used_by_workload)

    @property
    @pulumi.getter(name="bindingId")
    def binding_id(self) -> Optional[builtins.str]:
        """
        Uniquely identifies the connection between the volume set and its workload. Every time a new connection is made, a new id is generated (e.g., If a workload is updated to remove the volume set, then updated again to reattach it, the volume set will have a new binding id).
        """
        return pulumi.get(self, "binding_id")

    @property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[builtins.str]]:
        """
        Contains a list of actual volumes grouped by location.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[builtins.str]:
        """
        The GVC ID.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="usedByWorkload")
    def used_by_workload(self) -> Optional[builtins.str]:
        """
        The url of the workload currently using this volume set (if any).
        """
        return pulumi.get(self, "used_by_workload")


@pulumi.output_type
class WorkloadContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gpuCustom":
            suggest = "gpu_custom"
        elif key == "gpuNvidia":
            suggest = "gpu_nvidia"
        elif key == "inheritEnv":
            suggest = "inherit_env"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "minCpu":
            suggest = "min_cpu"
        elif key == "minMemory":
            suggest = "min_memory"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: builtins.str,
                 name: builtins.str,
                 args: Optional[Sequence[builtins.str]] = None,
                 command: Optional[builtins.str] = None,
                 cpu: Optional[builtins.str] = None,
                 env: Optional[Mapping[str, builtins.str]] = None,
                 gpu_custom: Optional['outputs.WorkloadContainerGpuCustom'] = None,
                 gpu_nvidia: Optional['outputs.WorkloadContainerGpuNvidia'] = None,
                 inherit_env: Optional[builtins.bool] = None,
                 lifecycle: Optional['outputs.WorkloadContainerLifecycle'] = None,
                 liveness_probe: Optional['outputs.WorkloadContainerLivenessProbe'] = None,
                 memory: Optional[builtins.str] = None,
                 metrics: Optional['outputs.WorkloadContainerMetrics'] = None,
                 min_cpu: Optional[builtins.str] = None,
                 min_memory: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 ports: Optional[Sequence['outputs.WorkloadContainerPort']] = None,
                 readiness_probe: Optional['outputs.WorkloadContainerReadinessProbe'] = None,
                 volumes: Optional[Sequence['outputs.WorkloadContainerVolume']] = None,
                 working_directory: Optional[builtins.str] = None):
        """
        :param builtins.str image: The full image and tag path.
        :param builtins.str name: Name of the container.
        :param Sequence[builtins.str] args: Command line arguments passed to the container at runtime. Replaces the CMD arguments of the running container. It is an ordered list.
        :param builtins.str command: Override the entry point.
        :param builtins.str cpu: Reserved CPU of the workload when capacityAI is disabled. Maximum CPU when CapacityAI is enabled. Default: "50m".
        :param Mapping[str, builtins.str] env: Name-Value list of environment variables.
        :param 'WorkloadContainerGpuNvidiaArgs' gpu_nvidia: GPUs manufactured by NVIDIA, which are specialized hardware accelerators used to offload and accelerate computationally intensive tasks within the workload.
        :param builtins.bool inherit_env: Enables inheritance of GVC environment variables. A variable in spec.env will override a GVC variable with the same name.
        :param 'WorkloadContainerLifecycleArgs' lifecycle: Lifecycle [Reference Page](https://docs.controlplane.com/reference/workload#lifecycle).
        :param 'WorkloadContainerLivenessProbeArgs' liveness_probe: Liveness Probe
        :param builtins.str memory: Reserved memory of the workload when capacityAI is disabled. Maximum memory when CapacityAI is enabled. Default: "128Mi".
        :param 'WorkloadContainerMetricsArgs' metrics: [Reference Page](https://docs.controlplane.com/reference/workload#metrics).
        :param builtins.str min_cpu: Minimum CPU when capacity AI is enabled.
        :param builtins.str min_memory: Minimum memory when capacity AI is enabled.
        :param builtins.int port: The port the container exposes. Only one container is allowed to specify a port. Min: `80`. Max: `65535`. Used by `serverless` Workload type. **DEPRECATED - Use `ports`.**
        :param Sequence['WorkloadContainerPortArgs'] ports: Communication endpoints used by the workload to send and receive network traffic.
        :param 'WorkloadContainerReadinessProbeArgs' readiness_probe: Readiness Probe
        :param Sequence['WorkloadContainerVolumeArgs'] volumes: Mount Object Store (S3, GCS, AzureBlob) buckets as file system.
        :param builtins.str working_directory: Override the working directory. Must be an absolute path.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if gpu_custom is not None:
            pulumi.set(__self__, "gpu_custom", gpu_custom)
        if gpu_nvidia is not None:
            pulumi.set(__self__, "gpu_nvidia", gpu_nvidia)
        if inherit_env is not None:
            pulumi.set(__self__, "inherit_env", inherit_env)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if min_cpu is not None:
            pulumi.set(__self__, "min_cpu", min_cpu)
        if min_memory is not None:
            pulumi.set(__self__, "min_memory", min_memory)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe is not None:
            pulumi.set(__self__, "readiness_probe", readiness_probe)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        The full image and tag path.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the container.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[builtins.str]]:
        """
        Command line arguments passed to the container at runtime. Replaces the CMD arguments of the running container. It is an ordered list.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[builtins.str]:
        """
        Override the entry point.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.str]:
        """
        Reserved CPU of the workload when capacityAI is disabled. Maximum CPU when CapacityAI is enabled. Default: "50m".
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def env(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Name-Value list of environment variables.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="gpuCustom")
    def gpu_custom(self) -> Optional['outputs.WorkloadContainerGpuCustom']:
        return pulumi.get(self, "gpu_custom")

    @property
    @pulumi.getter(name="gpuNvidia")
    def gpu_nvidia(self) -> Optional['outputs.WorkloadContainerGpuNvidia']:
        """
        GPUs manufactured by NVIDIA, which are specialized hardware accelerators used to offload and accelerate computationally intensive tasks within the workload.
        """
        return pulumi.get(self, "gpu_nvidia")

    @property
    @pulumi.getter(name="inheritEnv")
    def inherit_env(self) -> Optional[builtins.bool]:
        """
        Enables inheritance of GVC environment variables. A variable in spec.env will override a GVC variable with the same name.
        """
        return pulumi.get(self, "inherit_env")

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional['outputs.WorkloadContainerLifecycle']:
        """
        Lifecycle [Reference Page](https://docs.controlplane.com/reference/workload#lifecycle).
        """
        return pulumi.get(self, "lifecycle")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.WorkloadContainerLivenessProbe']:
        """
        Liveness Probe
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.str]:
        """
        Reserved memory of the workload when capacityAI is disabled. Maximum memory when CapacityAI is enabled. Default: "128Mi".
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def metrics(self) -> Optional['outputs.WorkloadContainerMetrics']:
        """
        [Reference Page](https://docs.controlplane.com/reference/workload#metrics).
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="minCpu")
    def min_cpu(self) -> Optional[builtins.str]:
        """
        Minimum CPU when capacity AI is enabled.
        """
        return pulumi.get(self, "min_cpu")

    @property
    @pulumi.getter(name="minMemory")
    def min_memory(self) -> Optional[builtins.str]:
        """
        Minimum memory when capacity AI is enabled.
        """
        return pulumi.get(self, "min_memory")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'port' attribute will be deprecated in the next major version. Use the 'ports' attribute instead.""")
    def port(self) -> Optional[builtins.int]:
        """
        The port the container exposes. Only one container is allowed to specify a port. Min: `80`. Max: `65535`. Used by `serverless` Workload type. **DEPRECATED - Use `ports`.**
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.WorkloadContainerPort']]:
        """
        Communication endpoints used by the workload to send and receive network traffic.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> Optional['outputs.WorkloadContainerReadinessProbe']:
        """
        Readiness Probe
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.WorkloadContainerVolume']]:
        """
        Mount Object Store (S3, GCS, AzureBlob) buckets as file system.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[builtins.str]:
        """
        Override the working directory. Must be an absolute path.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class WorkloadContainerGpuCustom(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeClass":
            suggest = "runtime_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerGpuCustom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerGpuCustom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerGpuCustom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 quantity: builtins.int,
                 resource: builtins.str,
                 runtime_class: Optional[builtins.str] = None):
        """
        :param builtins.int quantity: Number of GPUs.
        """
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "resource", resource)
        if runtime_class is not None:
            pulumi.set(__self__, "runtime_class", runtime_class)

    @property
    @pulumi.getter
    def quantity(self) -> builtins.int:
        """
        Number of GPUs.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def resource(self) -> builtins.str:
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="runtimeClass")
    def runtime_class(self) -> Optional[builtins.str]:
        return pulumi.get(self, "runtime_class")


@pulumi.output_type
class WorkloadContainerGpuNvidia(dict):
    def __init__(__self__, *,
                 model: builtins.str,
                 quantity: builtins.int):
        """
        :param builtins.str model: GPU Model (i.e.: t4)
        :param builtins.int quantity: Number of GPUs.
        """
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def model(self) -> builtins.str:
        """
        GPU Model (i.e.: t4)
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def quantity(self) -> builtins.int:
        """
        Number of GPUs.
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class WorkloadContainerLifecycle(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStart":
            suggest = "post_start"
        elif key == "preStop":
            suggest = "pre_stop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerLifecycle. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerLifecycle.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerLifecycle.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_start: Optional['outputs.WorkloadContainerLifecyclePostStart'] = None,
                 pre_stop: Optional['outputs.WorkloadContainerLifecyclePreStop'] = None):
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional['outputs.WorkloadContainerLifecyclePostStart']:
        return pulumi.get(self, "post_start")

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional['outputs.WorkloadContainerLifecyclePreStop']:
        return pulumi.get(self, "pre_stop")


@pulumi.output_type
class WorkloadContainerLifecyclePostStart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerLifecyclePostStart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerLifecyclePostStart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerLifecyclePostStart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: Optional['outputs.WorkloadContainerLifecyclePostStartExec'] = None):
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional['outputs.WorkloadContainerLifecyclePostStartExec']:
        return pulumi.get(self, "exec_")


@pulumi.output_type
class WorkloadContainerLifecyclePostStartExec(dict):
    def __init__(__self__, *,
                 commands: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] commands: Command and arguments executed immediately after the container is created.
        """
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[builtins.str]:
        """
        Command and arguments executed immediately after the container is created.
        """
        return pulumi.get(self, "commands")


@pulumi.output_type
class WorkloadContainerLifecyclePreStop(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerLifecyclePreStop. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerLifecyclePreStop.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerLifecyclePreStop.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: Optional['outputs.WorkloadContainerLifecyclePreStopExec'] = None):
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional['outputs.WorkloadContainerLifecyclePreStopExec']:
        return pulumi.get(self, "exec_")


@pulumi.output_type
class WorkloadContainerLifecyclePreStopExec(dict):
    def __init__(__self__, *,
                 commands: Sequence[builtins.str]):
        """
        :param Sequence[builtins.str] commands: Command and arguments executed immediately before the container is stopped.
        """
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[builtins.str]:
        """
        Command and arguments executed immediately before the container is stopped.
        """
        return pulumi.get(self, "commands")


@pulumi.output_type
class WorkloadContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: Optional['outputs.WorkloadContainerLivenessProbeExec'] = None,
                 failure_threshold: Optional[builtins.int] = None,
                 grpc: Optional['outputs.WorkloadContainerLivenessProbeGrpc'] = None,
                 http_get: Optional['outputs.WorkloadContainerLivenessProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[builtins.int] = None,
                 period_seconds: Optional[builtins.int] = None,
                 success_threshold: Optional[builtins.int] = None,
                 tcp_socket: Optional['outputs.WorkloadContainerLivenessProbeTcpSocket'] = None,
                 timeout_seconds: Optional[builtins.int] = None):
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional['outputs.WorkloadContainerLivenessProbeExec']:
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[builtins.int]:
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.WorkloadContainerLivenessProbeGrpc']:
        return pulumi.get(self, "grpc")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.WorkloadContainerLivenessProbeHttpGet']:
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[builtins.int]:
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.WorkloadContainerLivenessProbeTcpSocket']:
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class WorkloadContainerLivenessProbeExec(dict):
    def __init__(__self__, *,
                 commands: Sequence[builtins.str]):
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "commands")


@pulumi.output_type
class WorkloadContainerLivenessProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[builtins.int] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class WorkloadContainerLivenessProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerLivenessProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerLivenessProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerLivenessProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Mapping[str, builtins.str]] = None,
                 path: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 scheme: Optional[builtins.str] = None):
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[builtins.str]:
        return pulumi.get(self, "scheme")


@pulumi.output_type
class WorkloadContainerLivenessProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[builtins.int] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class WorkloadContainerMetrics(dict):
    def __init__(__self__, *,
                 path: builtins.str,
                 port: builtins.int):
        """
        :param builtins.str path: Path from container emitting custom metrics.
        :param builtins.int port: Port from container emitting custom metrics.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Path from container emitting custom metrics.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        Port from container emitting custom metrics.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class WorkloadContainerPort(dict):
    def __init__(__self__, *,
                 number: builtins.int,
                 protocol: Optional[builtins.str] = None):
        """
        :param builtins.int number: Port to expose.
        :param builtins.str protocol: Protocol. Choice of: `http`, `http2`, `tcp`, or `grpc`.
        """
        pulumi.set(__self__, "number", number)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def number(self) -> builtins.int:
        """
        Port to expose.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        Protocol. Choice of: `http`, `http2`, `tcp`, or `grpc`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class WorkloadContainerReadinessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerReadinessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerReadinessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerReadinessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: Optional['outputs.WorkloadContainerReadinessProbeExec'] = None,
                 failure_threshold: Optional[builtins.int] = None,
                 grpc: Optional['outputs.WorkloadContainerReadinessProbeGrpc'] = None,
                 http_get: Optional['outputs.WorkloadContainerReadinessProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[builtins.int] = None,
                 period_seconds: Optional[builtins.int] = None,
                 success_threshold: Optional[builtins.int] = None,
                 tcp_socket: Optional['outputs.WorkloadContainerReadinessProbeTcpSocket'] = None,
                 timeout_seconds: Optional[builtins.int] = None):
        if exec_ is not None:
            pulumi.set(__self__, "exec_", exec_)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> Optional['outputs.WorkloadContainerReadinessProbeExec']:
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[builtins.int]:
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.WorkloadContainerReadinessProbeGrpc']:
        return pulumi.get(self, "grpc")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.WorkloadContainerReadinessProbeHttpGet']:
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[builtins.int]:
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.WorkloadContainerReadinessProbeTcpSocket']:
        return pulumi.get(self, "tcp_socket")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class WorkloadContainerReadinessProbeExec(dict):
    def __init__(__self__, *,
                 commands: Sequence[builtins.str]):
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "commands")


@pulumi.output_type
class WorkloadContainerReadinessProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[builtins.int] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class WorkloadContainerReadinessProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerReadinessProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerReadinessProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerReadinessProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Mapping[str, builtins.str]] = None,
                 path: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 scheme: Optional[builtins.str] = None):
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[builtins.str]:
        return pulumi.get(self, "scheme")


@pulumi.output_type
class WorkloadContainerReadinessProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[builtins.int] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        return pulumi.get(self, "port")


@pulumi.output_type
class WorkloadContainerVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recoveryPolicy":
            suggest = "recovery_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadContainerVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadContainerVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadContainerVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: builtins.str,
                 uri: builtins.str,
                 recovery_policy: Optional[builtins.str] = None):
        """
        :param builtins.str path: File path added to workload pointing to the volume.
        :param builtins.str uri: URI of a volume hosted at Control Plane (Volume Set) or at a cloud provider (AWS, Azure, GCP).
        :param builtins.str recovery_policy: Only applicable to persistent volumes, this determines what Control Plane will do when creating a new workload replica if a corresponding volume exists. Available Values: `retain`, `recycle`. Default: `retain`. **DEPRECATED - No longer being used.**
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "uri", uri)
        if recovery_policy is not None:
            pulumi.set(__self__, "recovery_policy", recovery_policy)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        File path added to workload pointing to the volume.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        URI of a volume hosted at Control Plane (Volume Set) or at a cloud provider (AWS, Azure, GCP).
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="recoveryPolicy")
    def recovery_policy(self) -> Optional[builtins.str]:
        """
        Only applicable to persistent volumes, this determines what Control Plane will do when creating a new workload replica if a corresponding volume exists. Available Values: `retain`, `recycle`. Default: `retain`. **DEPRECATED - No longer being used.**
        """
        return pulumi.get(self, "recovery_policy")


@pulumi.output_type
class WorkloadFirewallSpec(dict):
    def __init__(__self__, *,
                 external: Optional['outputs.WorkloadFirewallSpecExternal'] = None,
                 internal: Optional['outputs.WorkloadFirewallSpecInternal'] = None):
        """
        :param 'WorkloadFirewallSpecExternalArgs' external: The external firewall is used to control inbound and outbound access to the workload for public-facing traffic.
        :param 'WorkloadFirewallSpecInternalArgs' internal: The internal firewall is used to control access between workloads.
        """
        if external is not None:
            pulumi.set(__self__, "external", external)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)

    @property
    @pulumi.getter
    def external(self) -> Optional['outputs.WorkloadFirewallSpecExternal']:
        """
        The external firewall is used to control inbound and outbound access to the workload for public-facing traffic.
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def internal(self) -> Optional['outputs.WorkloadFirewallSpecInternal']:
        """
        The internal firewall is used to control access between workloads.
        """
        return pulumi.get(self, "internal")


@pulumi.output_type
class WorkloadFirewallSpecExternal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundAllowCidrs":
            suggest = "inbound_allow_cidrs"
        elif key == "inboundBlockedCidrs":
            suggest = "inbound_blocked_cidrs"
        elif key == "outboundAllowCidrs":
            suggest = "outbound_allow_cidrs"
        elif key == "outboundAllowHostnames":
            suggest = "outbound_allow_hostnames"
        elif key == "outboundAllowPorts":
            suggest = "outbound_allow_ports"
        elif key == "outboundBlockedCidrs":
            suggest = "outbound_blocked_cidrs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadFirewallSpecExternal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadFirewallSpecExternal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadFirewallSpecExternal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http: Optional['outputs.WorkloadFirewallSpecExternalHttp'] = None,
                 inbound_allow_cidrs: Optional[Sequence[builtins.str]] = None,
                 inbound_blocked_cidrs: Optional[Sequence[builtins.str]] = None,
                 outbound_allow_cidrs: Optional[Sequence[builtins.str]] = None,
                 outbound_allow_hostnames: Optional[Sequence[builtins.str]] = None,
                 outbound_allow_ports: Optional[Sequence['outputs.WorkloadFirewallSpecExternalOutboundAllowPort']] = None,
                 outbound_blocked_cidrs: Optional[Sequence[builtins.str]] = None):
        """
        :param 'WorkloadFirewallSpecExternalHttpArgs' http: Firewall options for HTTP workloads.
        :param Sequence[builtins.str] inbound_allow_cidrs: The list of ipv4/ipv6 addresses or cidr blocks that are allowed to access this workload. No external access is allowed by default. Specify '0.0.0.0/0' to allow access to the public internet.
        :param Sequence[builtins.str] inbound_blocked_cidrs: The list of ipv4/ipv6 addresses or cidr blocks that are NOT allowed to access this workload. Addresses in the allow list will only be allowed if they do not exist in this list.
        :param Sequence[builtins.str] outbound_allow_cidrs: The list of ipv4/ipv6 addresses or cidr blocks that this workload is allowed reach. No outbound access is allowed by default. Specify '0.0.0.0/0' to allow outbound access to the public internet.
        :param Sequence[builtins.str] outbound_allow_hostnames: The list of public hostnames that this workload is allowed to reach. No outbound access is allowed by default. A wildcard `*` is allowed on the prefix of the hostname only, ex: `*.amazonaws.com`. Use `outboundAllowCIDR` to allow access to all external websites.
        :param Sequence['WorkloadFirewallSpecExternalOutboundAllowPortArgs'] outbound_allow_ports: Allow outbound access to specific ports and protocols. When not specified, communication to address ranges in outboundAllowCIDR is allowed on all ports and communication to names in outboundAllowHostname is allowed on ports 80/443.
        :param Sequence[builtins.str] outbound_blocked_cidrs: The list of ipv4/ipv6 addresses or cidr blocks that this workload is NOT allowed to reach. Addresses in the allow list will only be allowed if they do not exist in this list.
        """
        if http is not None:
            pulumi.set(__self__, "http", http)
        if inbound_allow_cidrs is not None:
            pulumi.set(__self__, "inbound_allow_cidrs", inbound_allow_cidrs)
        if inbound_blocked_cidrs is not None:
            pulumi.set(__self__, "inbound_blocked_cidrs", inbound_blocked_cidrs)
        if outbound_allow_cidrs is not None:
            pulumi.set(__self__, "outbound_allow_cidrs", outbound_allow_cidrs)
        if outbound_allow_hostnames is not None:
            pulumi.set(__self__, "outbound_allow_hostnames", outbound_allow_hostnames)
        if outbound_allow_ports is not None:
            pulumi.set(__self__, "outbound_allow_ports", outbound_allow_ports)
        if outbound_blocked_cidrs is not None:
            pulumi.set(__self__, "outbound_blocked_cidrs", outbound_blocked_cidrs)

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.WorkloadFirewallSpecExternalHttp']:
        """
        Firewall options for HTTP workloads.
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter(name="inboundAllowCidrs")
    def inbound_allow_cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of ipv4/ipv6 addresses or cidr blocks that are allowed to access this workload. No external access is allowed by default. Specify '0.0.0.0/0' to allow access to the public internet.
        """
        return pulumi.get(self, "inbound_allow_cidrs")

    @property
    @pulumi.getter(name="inboundBlockedCidrs")
    def inbound_blocked_cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of ipv4/ipv6 addresses or cidr blocks that are NOT allowed to access this workload. Addresses in the allow list will only be allowed if they do not exist in this list.
        """
        return pulumi.get(self, "inbound_blocked_cidrs")

    @property
    @pulumi.getter(name="outboundAllowCidrs")
    def outbound_allow_cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of ipv4/ipv6 addresses or cidr blocks that this workload is allowed reach. No outbound access is allowed by default. Specify '0.0.0.0/0' to allow outbound access to the public internet.
        """
        return pulumi.get(self, "outbound_allow_cidrs")

    @property
    @pulumi.getter(name="outboundAllowHostnames")
    def outbound_allow_hostnames(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of public hostnames that this workload is allowed to reach. No outbound access is allowed by default. A wildcard `*` is allowed on the prefix of the hostname only, ex: `*.amazonaws.com`. Use `outboundAllowCIDR` to allow access to all external websites.
        """
        return pulumi.get(self, "outbound_allow_hostnames")

    @property
    @pulumi.getter(name="outboundAllowPorts")
    def outbound_allow_ports(self) -> Optional[Sequence['outputs.WorkloadFirewallSpecExternalOutboundAllowPort']]:
        """
        Allow outbound access to specific ports and protocols. When not specified, communication to address ranges in outboundAllowCIDR is allowed on all ports and communication to names in outboundAllowHostname is allowed on ports 80/443.
        """
        return pulumi.get(self, "outbound_allow_ports")

    @property
    @pulumi.getter(name="outboundBlockedCidrs")
    def outbound_blocked_cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of ipv4/ipv6 addresses or cidr blocks that this workload is NOT allowed to reach. Addresses in the allow list will only be allowed if they do not exist in this list.
        """
        return pulumi.get(self, "outbound_blocked_cidrs")


@pulumi.output_type
class WorkloadFirewallSpecExternalHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundHeaderFilters":
            suggest = "inbound_header_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadFirewallSpecExternalHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadFirewallSpecExternalHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadFirewallSpecExternalHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inbound_header_filters: Optional[Sequence['outputs.WorkloadFirewallSpecExternalHttpInboundHeaderFilter']] = None):
        """
        :param Sequence['WorkloadFirewallSpecExternalHttpInboundHeaderFilterArgs'] inbound_header_filters: A list of header filters for HTTP workloads.
        """
        if inbound_header_filters is not None:
            pulumi.set(__self__, "inbound_header_filters", inbound_header_filters)

    @property
    @pulumi.getter(name="inboundHeaderFilters")
    def inbound_header_filters(self) -> Optional[Sequence['outputs.WorkloadFirewallSpecExternalHttpInboundHeaderFilter']]:
        """
        A list of header filters for HTTP workloads.
        """
        return pulumi.get(self, "inbound_header_filters")


@pulumi.output_type
class WorkloadFirewallSpecExternalHttpInboundHeaderFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "blockedValues":
            suggest = "blocked_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadFirewallSpecExternalHttpInboundHeaderFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadFirewallSpecExternalHttpInboundHeaderFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadFirewallSpecExternalHttpInboundHeaderFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 allowed_values: Optional[Sequence[builtins.str]] = None,
                 blocked_values: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str key: The header to match for.
        :param Sequence[builtins.str] allowed_values: A list of regular expressions to match for allowed header values. Headers that do not match ANY of these values will be filtered and will not reach the workload.
        :param Sequence[builtins.str] blocked_values: A list of regular expressions to match for blocked header values. Headers that match ANY of these values will be filtered and will not reach the workload.
        """
        pulumi.set(__self__, "key", key)
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if blocked_values is not None:
            pulumi.set(__self__, "blocked_values", blocked_values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The header to match for.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of regular expressions to match for allowed header values. Headers that do not match ANY of these values will be filtered and will not reach the workload.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="blockedValues")
    def blocked_values(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of regular expressions to match for blocked header values. Headers that match ANY of these values will be filtered and will not reach the workload.
        """
        return pulumi.get(self, "blocked_values")


@pulumi.output_type
class WorkloadFirewallSpecExternalOutboundAllowPort(dict):
    def __init__(__self__, *,
                 number: builtins.int,
                 protocol: builtins.str):
        """
        :param builtins.int number: Port number. Max: 65000
        :param builtins.str protocol: Either `http`, `https` or `tcp`.
        """
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def number(self) -> builtins.int:
        """
        Port number. Max: 65000
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        Either `http`, `https` or `tcp`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class WorkloadFirewallSpecInternal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inboundAllowType":
            suggest = "inbound_allow_type"
        elif key == "inboundAllowWorkloads":
            suggest = "inbound_allow_workloads"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadFirewallSpecInternal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadFirewallSpecInternal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadFirewallSpecInternal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inbound_allow_type: Optional[builtins.str] = None,
                 inbound_allow_workloads: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str inbound_allow_type: Used to control the internal firewall configuration and mutual tls. Allowed Values: "none", "same-gvc", "same-org", "workload-list".
        :param Sequence[builtins.str] inbound_allow_workloads: A list of specific workloads which are allowed to access this workload internally. This list is only used if the 'inboundAllowType' is set to 'workload-list'.
        """
        if inbound_allow_type is not None:
            pulumi.set(__self__, "inbound_allow_type", inbound_allow_type)
        if inbound_allow_workloads is not None:
            pulumi.set(__self__, "inbound_allow_workloads", inbound_allow_workloads)

    @property
    @pulumi.getter(name="inboundAllowType")
    def inbound_allow_type(self) -> Optional[builtins.str]:
        """
        Used to control the internal firewall configuration and mutual tls. Allowed Values: "none", "same-gvc", "same-org", "workload-list".
        """
        return pulumi.get(self, "inbound_allow_type")

    @property
    @pulumi.getter(name="inboundAllowWorkloads")
    def inbound_allow_workloads(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of specific workloads which are allowed to access this workload internally. This list is only used if the 'inboundAllowType' is set to 'workload-list'.
        """
        return pulumi.get(self, "inbound_allow_workloads")


@pulumi.output_type
class WorkloadJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDeadlineSeconds":
            suggest = "active_deadline_seconds"
        elif key == "concurrencyPolicy":
            suggest = "concurrency_policy"
        elif key == "historyLimit":
            suggest = "history_limit"
        elif key == "restartPolicy":
            suggest = "restart_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule: builtins.str,
                 active_deadline_seconds: Optional[builtins.int] = None,
                 concurrency_policy: Optional[builtins.str] = None,
                 history_limit: Optional[builtins.int] = None,
                 restart_policy: Optional[builtins.str] = None):
        """
        :param builtins.str schedule: A standard cron [schedule expression](https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#schedule-syntax) used to determine when your job should execute.
        :param builtins.int active_deadline_seconds: The maximum number of seconds Control Plane will wait for the job to complete. If a job does not succeed or fail in the allotted time, Control Plane will stop the job, moving it into the Removed status.
        :param builtins.str concurrency_policy: Either 'Forbid' or 'Replace'. This determines what Control Plane will do when the schedule requires a job to start, while a prior instance of the job is still running. Enum: [ Forbid, Replace ] Default: `Forbid`.
        :param builtins.int history_limit: The maximum number of completed job instances to display. This should be an integer between 1 and 10. Default: `5`.
        :param builtins.str restart_policy: Either 'OnFailure' or 'Never'. This determines what Control Plane will do when a job instance fails. Enum: [ OnFailure, Never ] Default: `Never`.
        """
        pulumi.set(__self__, "schedule", schedule)
        if active_deadline_seconds is not None:
            pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        if concurrency_policy is not None:
            pulumi.set(__self__, "concurrency_policy", concurrency_policy)
        if history_limit is not None:
            pulumi.set(__self__, "history_limit", history_limit)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)

    @property
    @pulumi.getter
    def schedule(self) -> builtins.str:
        """
        A standard cron [schedule expression](https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#schedule-syntax) used to determine when your job should execute.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> Optional[builtins.int]:
        """
        The maximum number of seconds Control Plane will wait for the job to complete. If a job does not succeed or fail in the allotted time, Control Plane will stop the job, moving it into the Removed status.
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter(name="concurrencyPolicy")
    def concurrency_policy(self) -> Optional[builtins.str]:
        """
        Either 'Forbid' or 'Replace'. This determines what Control Plane will do when the schedule requires a job to start, while a prior instance of the job is still running. Enum: [ Forbid, Replace ] Default: `Forbid`.
        """
        return pulumi.get(self, "concurrency_policy")

    @property
    @pulumi.getter(name="historyLimit")
    def history_limit(self) -> Optional[builtins.int]:
        """
        The maximum number of completed job instances to display. This should be an integer between 1 and 10. Default: `5`.
        """
        return pulumi.get(self, "history_limit")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[builtins.str]:
        """
        Either 'OnFailure' or 'Never'. This determines what Control Plane will do when a job instance fails. Enum: [ OnFailure, Never ] Default: `Never`.
        """
        return pulumi.get(self, "restart_policy")


@pulumi.output_type
class WorkloadLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoLocation":
            suggest = "geo_location"
        elif key == "replicaDirect":
            suggest = "replica_direct"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 direct: Optional['outputs.WorkloadLoadBalancerDirect'] = None,
                 geo_location: Optional['outputs.WorkloadLoadBalancerGeoLocation'] = None,
                 replica_direct: Optional[builtins.bool] = None):
        """
        :param 'WorkloadLoadBalancerDirectArgs' direct: Direct load balancers are created in each location that a workload is running in and are configured for the standard endpoints of the workload. Customers are responsible for configuring the workload with certificates if TLS is required.
        :param builtins.bool replica_direct: When enabled, individual replicas of the workload can be reached directly using the subdomain prefix replica-<index>. For example, replica-0.my-workload.my-gvc.cpln.local or replica-0.my-workload-<gvc-alias>.cpln.app - Can only be used with stateful workloads.
        """
        if direct is not None:
            pulumi.set(__self__, "direct", direct)
        if geo_location is not None:
            pulumi.set(__self__, "geo_location", geo_location)
        if replica_direct is not None:
            pulumi.set(__self__, "replica_direct", replica_direct)

    @property
    @pulumi.getter
    def direct(self) -> Optional['outputs.WorkloadLoadBalancerDirect']:
        """
        Direct load balancers are created in each location that a workload is running in and are configured for the standard endpoints of the workload. Customers are responsible for configuring the workload with certificates if TLS is required.
        """
        return pulumi.get(self, "direct")

    @property
    @pulumi.getter(name="geoLocation")
    def geo_location(self) -> Optional['outputs.WorkloadLoadBalancerGeoLocation']:
        return pulumi.get(self, "geo_location")

    @property
    @pulumi.getter(name="replicaDirect")
    def replica_direct(self) -> Optional[builtins.bool]:
        """
        When enabled, individual replicas of the workload can be reached directly using the subdomain prefix replica-<index>. For example, replica-0.my-workload.my-gvc.cpln.local or replica-0.my-workload-<gvc-alias>.cpln.app - Can only be used with stateful workloads.
        """
        return pulumi.get(self, "replica_direct")


@pulumi.output_type
class WorkloadLoadBalancerDirect(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 ipset: Optional[builtins.str] = None,
                 ports: Optional[Sequence['outputs.WorkloadLoadBalancerDirectPort']] = None):
        """
        :param builtins.bool enabled: When disabled, this load balancer will be stopped.
        :param Sequence['WorkloadLoadBalancerDirectPortArgs'] ports: List of ports that will be exposed by this load balancer.
        """
        pulumi.set(__self__, "enabled", enabled)
        if ipset is not None:
            pulumi.set(__self__, "ipset", ipset)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        When disabled, this load balancer will be stopped.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def ipset(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ipset")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.WorkloadLoadBalancerDirectPort']]:
        """
        List of ports that will be exposed by this load balancer.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class WorkloadLoadBalancerDirectPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalPort":
            suggest = "external_port"
        elif key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadLoadBalancerDirectPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadLoadBalancerDirectPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadLoadBalancerDirectPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_port: builtins.int,
                 protocol: builtins.str,
                 container_port: Optional[builtins.int] = None,
                 scheme: Optional[builtins.str] = None):
        """
        :param builtins.int external_port: The port that is available publicly.
        :param builtins.str protocol: The protocol that is exposed publicly.
        :param builtins.int container_port: The port on the container tha will receive this traffic.
        :param builtins.str scheme: Overrides the default `https` url scheme that will be used for links in the UI and status.
        """
        pulumi.set(__self__, "external_port", external_port)
        pulumi.set(__self__, "protocol", protocol)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter(name="externalPort")
    def external_port(self) -> builtins.int:
        """
        The port that is available publicly.
        """
        return pulumi.get(self, "external_port")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        The protocol that is exposed publicly.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port on the container tha will receive this traffic.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def scheme(self) -> Optional[builtins.str]:
        """
        Overrides the default `https` url scheme that will be used for links in the UI and status.
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class WorkloadLoadBalancerGeoLocation(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 headers: Optional['outputs.WorkloadLoadBalancerGeoLocationHeaders'] = None):
        """
        :param builtins.bool enabled: When enabled, geo location headers will be included on inbound http requests. Existing headers will be replaced.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        When enabled, geo location headers will be included on inbound http requests. Existing headers will be replaced.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def headers(self) -> Optional['outputs.WorkloadLoadBalancerGeoLocationHeaders']:
        return pulumi.get(self, "headers")


@pulumi.output_type
class WorkloadLoadBalancerGeoLocationHeaders(dict):
    def __init__(__self__, *,
                 asn: Optional[builtins.str] = None,
                 city: Optional[builtins.str] = None,
                 country: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None):
        """
        :param builtins.str asn: The geo asn header.
        :param builtins.str city: The geo city header.
        :param builtins.str country: The geo country header.
        :param builtins.str region: The geo region header.
        """
        if asn is not None:
            pulumi.set(__self__, "asn", asn)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def asn(self) -> Optional[builtins.str]:
        """
        The geo asn header.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter
    def city(self) -> Optional[builtins.str]:
        """
        The geo city header.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def country(self) -> Optional[builtins.str]:
        """
        The geo country header.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The geo region header.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class WorkloadLocalOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityAi":
            suggest = "capacity_ai"
        elif key == "multiZone":
            suggest = "multi_zone"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadLocalOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadLocalOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadLocalOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: builtins.str,
                 autoscaling: Optional['outputs.WorkloadLocalOptionAutoscaling'] = None,
                 capacity_ai: Optional[builtins.bool] = None,
                 debug: Optional[builtins.bool] = None,
                 multi_zone: Optional['outputs.WorkloadLocalOptionMultiZone'] = None,
                 suspend: Optional[builtins.bool] = None,
                 timeout_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str location: Valid only for `local_options`. Override options for a specific location.
        :param 'WorkloadLocalOptionAutoscalingArgs' autoscaling: Auto-scaling adjusts horizontal scaling based on a set strategy, target value, and possibly a metric percentile.
        :param builtins.bool capacity_ai: Capacity AI. Default: `true`.
        :param builtins.bool debug: Debug mode. Default: `false`.
        :param builtins.bool suspend: Workload suspend. Default: `false`.
        :param builtins.int timeout_seconds: Timeout in seconds. Default: `5`.
        """
        pulumi.set(__self__, "location", location)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if capacity_ai is not None:
            pulumi.set(__self__, "capacity_ai", capacity_ai)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if multi_zone is not None:
            pulumi.set(__self__, "multi_zone", multi_zone)
        if suspend is not None:
            pulumi.set(__self__, "suspend", suspend)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Valid only for `local_options`. Override options for a specific location.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional['outputs.WorkloadLocalOptionAutoscaling']:
        """
        Auto-scaling adjusts horizontal scaling based on a set strategy, target value, and possibly a metric percentile.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="capacityAi")
    def capacity_ai(self) -> Optional[builtins.bool]:
        """
        Capacity AI. Default: `true`.
        """
        return pulumi.get(self, "capacity_ai")

    @property
    @pulumi.getter
    def debug(self) -> Optional[builtins.bool]:
        """
        Debug mode. Default: `false`.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter(name="multiZone")
    def multi_zone(self) -> Optional['outputs.WorkloadLocalOptionMultiZone']:
        return pulumi.get(self, "multi_zone")

    @property
    @pulumi.getter
    def suspend(self) -> Optional[builtins.bool]:
        """
        Workload suspend. Default: `false`.
        """
        return pulumi.get(self, "suspend")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        """
        Timeout in seconds. Default: `5`.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class WorkloadLocalOptionAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrency":
            suggest = "max_concurrency"
        elif key == "maxScale":
            suggest = "max_scale"
        elif key == "metricPercentile":
            suggest = "metric_percentile"
        elif key == "minScale":
            suggest = "min_scale"
        elif key == "scaleToZeroDelay":
            suggest = "scale_to_zero_delay"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadLocalOptionAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadLocalOptionAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadLocalOptionAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrency: Optional[builtins.int] = None,
                 max_scale: Optional[builtins.int] = None,
                 metric: Optional[builtins.str] = None,
                 metric_percentile: Optional[builtins.str] = None,
                 min_scale: Optional[builtins.int] = None,
                 multis: Optional[Sequence['outputs.WorkloadLocalOptionAutoscalingMulti']] = None,
                 scale_to_zero_delay: Optional[builtins.int] = None,
                 target: Optional[builtins.int] = None):
        """
        :param builtins.int max_concurrency: A hard maximum for the number of concurrent requests allowed to a replica. If no replicas are available to fulfill the request then it will be queued until a replica with capacity is available and delivered as soon as one is available again. Capacity can be available from requests completing or when a new replica is available from scale out.Min: `0`. Max: `1000`. Default `0`.
        :param builtins.int max_scale: The maximum allowed number of replicas. Min: `0`. Default `5`.
        :param builtins.str metric: Valid values: `concurrency`, `cpu`, `memory`, `rps`, `latency` or `disabled`.
        :param builtins.str metric_percentile: For metrics represented as a distribution (e.g. latency) a percentile within the distribution must be chosen as the target.
        :param builtins.int min_scale: The minimum allowed number of replicas. Control Plane can scale the workload down to 0 when there is no traffic and scale up immediately to fulfill new requests. Min: `0`. Max: `max_scale`. Default `1`.
        :param builtins.int scale_to_zero_delay: The amount of time (in seconds) with no requests received before a workload is scaled to 0. Min: `30`. Max: `3600`. Default: `300`.
        :param builtins.int target: Control Plane will scale the number of replicas for this deployment up/down in order to be as close as possible to the target metric across all replicas of a deployment. Min: `1`. Max: `20000`. Default: `95`.
        """
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if metric_percentile is not None:
            pulumi.set(__self__, "metric_percentile", metric_percentile)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if multis is not None:
            pulumi.set(__self__, "multis", multis)
        if scale_to_zero_delay is not None:
            pulumi.set(__self__, "scale_to_zero_delay", scale_to_zero_delay)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[builtins.int]:
        """
        A hard maximum for the number of concurrent requests allowed to a replica. If no replicas are available to fulfill the request then it will be queued until a replica with capacity is available and delivered as soon as one is available again. Capacity can be available from requests completing or when a new replica is available from scale out.Min: `0`. Max: `1000`. Default `0`.
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[builtins.int]:
        """
        The maximum allowed number of replicas. Min: `0`. Default `5`.
        """
        return pulumi.get(self, "max_scale")

    @property
    @pulumi.getter
    def metric(self) -> Optional[builtins.str]:
        """
        Valid values: `concurrency`, `cpu`, `memory`, `rps`, `latency` or `disabled`.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="metricPercentile")
    def metric_percentile(self) -> Optional[builtins.str]:
        """
        For metrics represented as a distribution (e.g. latency) a percentile within the distribution must be chosen as the target.
        """
        return pulumi.get(self, "metric_percentile")

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[builtins.int]:
        """
        The minimum allowed number of replicas. Control Plane can scale the workload down to 0 when there is no traffic and scale up immediately to fulfill new requests. Min: `0`. Max: `max_scale`. Default `1`.
        """
        return pulumi.get(self, "min_scale")

    @property
    @pulumi.getter
    def multis(self) -> Optional[Sequence['outputs.WorkloadLocalOptionAutoscalingMulti']]:
        return pulumi.get(self, "multis")

    @property
    @pulumi.getter(name="scaleToZeroDelay")
    def scale_to_zero_delay(self) -> Optional[builtins.int]:
        """
        The amount of time (in seconds) with no requests received before a workload is scaled to 0. Min: `30`. Max: `3600`. Default: `300`.
        """
        return pulumi.get(self, "scale_to_zero_delay")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.int]:
        """
        Control Plane will scale the number of replicas for this deployment up/down in order to be as close as possible to the target metric across all replicas of a deployment. Min: `1`. Max: `20000`. Default: `95`.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class WorkloadLocalOptionAutoscalingMulti(dict):
    def __init__(__self__, *,
                 metric: Optional[builtins.str] = None,
                 target: Optional[builtins.int] = None):
        """
        :param builtins.str metric: Valid values: `cpu` or `memory`.
        :param builtins.int target: Control Plane will scale the number of replicas for this deployment up/down in order to be as close as possible to the target metric across all replicas of a deployment. Min: `1`. Max: `20000`.
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def metric(self) -> Optional[builtins.str]:
        """
        Valid values: `cpu` or `memory`.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.int]:
        """
        Control Plane will scale the number of replicas for this deployment up/down in order to be as close as possible to the target metric across all replicas of a deployment. Min: `1`. Max: `20000`.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class WorkloadLocalOptionMultiZone(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class WorkloadOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityAi":
            suggest = "capacity_ai"
        elif key == "multiZone":
            suggest = "multi_zone"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: Optional['outputs.WorkloadOptionsAutoscaling'] = None,
                 capacity_ai: Optional[builtins.bool] = None,
                 debug: Optional[builtins.bool] = None,
                 multi_zone: Optional['outputs.WorkloadOptionsMultiZone'] = None,
                 suspend: Optional[builtins.bool] = None,
                 timeout_seconds: Optional[builtins.int] = None):
        """
        :param 'WorkloadOptionsAutoscalingArgs' autoscaling: Auto-scaling adjusts horizontal scaling based on a set strategy, target value, and possibly a metric percentile.
        :param builtins.bool capacity_ai: Capacity AI. Default: `true`.
        :param builtins.bool debug: Debug mode. Default: `false`.
        :param builtins.bool suspend: Workload suspend. Default: `false`.
        :param builtins.int timeout_seconds: Timeout in seconds. Default: `5`.
        """
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if capacity_ai is not None:
            pulumi.set(__self__, "capacity_ai", capacity_ai)
        if debug is not None:
            pulumi.set(__self__, "debug", debug)
        if multi_zone is not None:
            pulumi.set(__self__, "multi_zone", multi_zone)
        if suspend is not None:
            pulumi.set(__self__, "suspend", suspend)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional['outputs.WorkloadOptionsAutoscaling']:
        """
        Auto-scaling adjusts horizontal scaling based on a set strategy, target value, and possibly a metric percentile.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="capacityAi")
    def capacity_ai(self) -> Optional[builtins.bool]:
        """
        Capacity AI. Default: `true`.
        """
        return pulumi.get(self, "capacity_ai")

    @property
    @pulumi.getter
    def debug(self) -> Optional[builtins.bool]:
        """
        Debug mode. Default: `false`.
        """
        return pulumi.get(self, "debug")

    @property
    @pulumi.getter(name="multiZone")
    def multi_zone(self) -> Optional['outputs.WorkloadOptionsMultiZone']:
        return pulumi.get(self, "multi_zone")

    @property
    @pulumi.getter
    def suspend(self) -> Optional[builtins.bool]:
        """
        Workload suspend. Default: `false`.
        """
        return pulumi.get(self, "suspend")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        """
        Timeout in seconds. Default: `5`.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class WorkloadOptionsAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrency":
            suggest = "max_concurrency"
        elif key == "maxScale":
            suggest = "max_scale"
        elif key == "metricPercentile":
            suggest = "metric_percentile"
        elif key == "minScale":
            suggest = "min_scale"
        elif key == "scaleToZeroDelay":
            suggest = "scale_to_zero_delay"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadOptionsAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadOptionsAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadOptionsAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrency: Optional[builtins.int] = None,
                 max_scale: Optional[builtins.int] = None,
                 metric: Optional[builtins.str] = None,
                 metric_percentile: Optional[builtins.str] = None,
                 min_scale: Optional[builtins.int] = None,
                 multis: Optional[Sequence['outputs.WorkloadOptionsAutoscalingMulti']] = None,
                 scale_to_zero_delay: Optional[builtins.int] = None,
                 target: Optional[builtins.int] = None):
        """
        :param builtins.int max_concurrency: A hard maximum for the number of concurrent requests allowed to a replica. If no replicas are available to fulfill the request then it will be queued until a replica with capacity is available and delivered as soon as one is available again. Capacity can be available from requests completing or when a new replica is available from scale out.Min: `0`. Max: `1000`. Default `0`.
        :param builtins.int max_scale: The maximum allowed number of replicas. Min: `0`. Default `5`.
        :param builtins.str metric: Valid values: `concurrency`, `cpu`, `memory`, `rps`, `latency` or `disabled`.
        :param builtins.str metric_percentile: For metrics represented as a distribution (e.g. latency) a percentile within the distribution must be chosen as the target.
        :param builtins.int min_scale: The minimum allowed number of replicas. Control Plane can scale the workload down to 0 when there is no traffic and scale up immediately to fulfill new requests. Min: `0`. Max: `max_scale`. Default `1`.
        :param builtins.int scale_to_zero_delay: The amount of time (in seconds) with no requests received before a workload is scaled to 0. Min: `30`. Max: `3600`. Default: `300`.
        :param builtins.int target: Control Plane will scale the number of replicas for this deployment up/down in order to be as close as possible to the target metric across all replicas of a deployment. Min: `1`. Max: `20000`. Default: `95`.
        """
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if metric_percentile is not None:
            pulumi.set(__self__, "metric_percentile", metric_percentile)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if multis is not None:
            pulumi.set(__self__, "multis", multis)
        if scale_to_zero_delay is not None:
            pulumi.set(__self__, "scale_to_zero_delay", scale_to_zero_delay)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[builtins.int]:
        """
        A hard maximum for the number of concurrent requests allowed to a replica. If no replicas are available to fulfill the request then it will be queued until a replica with capacity is available and delivered as soon as one is available again. Capacity can be available from requests completing or when a new replica is available from scale out.Min: `0`. Max: `1000`. Default `0`.
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[builtins.int]:
        """
        The maximum allowed number of replicas. Min: `0`. Default `5`.
        """
        return pulumi.get(self, "max_scale")

    @property
    @pulumi.getter
    def metric(self) -> Optional[builtins.str]:
        """
        Valid values: `concurrency`, `cpu`, `memory`, `rps`, `latency` or `disabled`.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="metricPercentile")
    def metric_percentile(self) -> Optional[builtins.str]:
        """
        For metrics represented as a distribution (e.g. latency) a percentile within the distribution must be chosen as the target.
        """
        return pulumi.get(self, "metric_percentile")

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[builtins.int]:
        """
        The minimum allowed number of replicas. Control Plane can scale the workload down to 0 when there is no traffic and scale up immediately to fulfill new requests. Min: `0`. Max: `max_scale`. Default `1`.
        """
        return pulumi.get(self, "min_scale")

    @property
    @pulumi.getter
    def multis(self) -> Optional[Sequence['outputs.WorkloadOptionsAutoscalingMulti']]:
        return pulumi.get(self, "multis")

    @property
    @pulumi.getter(name="scaleToZeroDelay")
    def scale_to_zero_delay(self) -> Optional[builtins.int]:
        """
        The amount of time (in seconds) with no requests received before a workload is scaled to 0. Min: `30`. Max: `3600`. Default: `300`.
        """
        return pulumi.get(self, "scale_to_zero_delay")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.int]:
        """
        Control Plane will scale the number of replicas for this deployment up/down in order to be as close as possible to the target metric across all replicas of a deployment. Min: `1`. Max: `20000`. Default: `95`.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class WorkloadOptionsAutoscalingMulti(dict):
    def __init__(__self__, *,
                 metric: Optional[builtins.str] = None,
                 target: Optional[builtins.int] = None):
        """
        :param builtins.str metric: Valid values: `cpu` or `memory`.
        :param builtins.int target: Control Plane will scale the number of replicas for this deployment up/down in order to be as close as possible to the target metric across all replicas of a deployment. Min: `1`. Max: `20000`.
        """
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def metric(self) -> Optional[builtins.str]:
        """
        Valid values: `cpu` or `memory`.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.int]:
        """
        Control Plane will scale the number of replicas for this deployment up/down in order to be as close as possible to the target metric across all replicas of a deployment. Min: `1`. Max: `20000`.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class WorkloadOptionsMultiZone(dict):
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class WorkloadRequestRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retryOns":
            suggest = "retry_ons"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadRequestRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadRequestRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadRequestRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attempts: Optional[builtins.int] = None,
                 retry_ons: Optional[Sequence[builtins.str]] = None):
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)
        if retry_ons is not None:
            pulumi.set(__self__, "retry_ons", retry_ons)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[builtins.int]:
        return pulumi.get(self, "attempts")

    @property
    @pulumi.getter(name="retryOns")
    def retry_ons(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "retry_ons")


@pulumi.output_type
class WorkloadRolloutOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSurgeReplicas":
            suggest = "max_surge_replicas"
        elif key == "maxUnavailableReplicas":
            suggest = "max_unavailable_replicas"
        elif key == "minReadySeconds":
            suggest = "min_ready_seconds"
        elif key == "scalingPolicy":
            suggest = "scaling_policy"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadRolloutOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadRolloutOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadRolloutOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_surge_replicas: Optional[builtins.str] = None,
                 max_unavailable_replicas: Optional[builtins.str] = None,
                 min_ready_seconds: Optional[builtins.int] = None,
                 scaling_policy: Optional[builtins.str] = None,
                 termination_grace_period_seconds: Optional[builtins.int] = None):
        """
        :param builtins.str max_surge_replicas: The number of replicas that can be created above the desired amount of replicas during an update.
        :param builtins.str max_unavailable_replicas: The number of replicas that can be unavailable during the update process.
        :param builtins.int min_ready_seconds: The minimum number of seconds a container must run without crashing to be considered available.
        :param builtins.str scaling_policy: The strategies used to update applications and services deployed. Valid values: `OrderedReady` (Updates workloads in a rolling fashion, taking down old ones and bringing up new ones incrementally, ensuring that the service remains available during the update.), `Parallel` (Causes all pods affected by a scaling operation to be created or destroyed simultaneously. This does not affect update operations.). Default: `OrderedReady`.
        :param builtins.int termination_grace_period_seconds: The amount of time in seconds a workload has to gracefully terminate before forcefully terminating it. This includes the time it takes for the preStop hook to run.
        """
        if max_surge_replicas is not None:
            pulumi.set(__self__, "max_surge_replicas", max_surge_replicas)
        if max_unavailable_replicas is not None:
            pulumi.set(__self__, "max_unavailable_replicas", max_unavailable_replicas)
        if min_ready_seconds is not None:
            pulumi.set(__self__, "min_ready_seconds", min_ready_seconds)
        if scaling_policy is not None:
            pulumi.set(__self__, "scaling_policy", scaling_policy)
        if termination_grace_period_seconds is not None:
            pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)

    @property
    @pulumi.getter(name="maxSurgeReplicas")
    def max_surge_replicas(self) -> Optional[builtins.str]:
        """
        The number of replicas that can be created above the desired amount of replicas during an update.
        """
        return pulumi.get(self, "max_surge_replicas")

    @property
    @pulumi.getter(name="maxUnavailableReplicas")
    def max_unavailable_replicas(self) -> Optional[builtins.str]:
        """
        The number of replicas that can be unavailable during the update process.
        """
        return pulumi.get(self, "max_unavailable_replicas")

    @property
    @pulumi.getter(name="minReadySeconds")
    def min_ready_seconds(self) -> Optional[builtins.int]:
        """
        The minimum number of seconds a container must run without crashing to be considered available.
        """
        return pulumi.get(self, "min_ready_seconds")

    @property
    @pulumi.getter(name="scalingPolicy")
    def scaling_policy(self) -> Optional[builtins.str]:
        """
        The strategies used to update applications and services deployed. Valid values: `OrderedReady` (Updates workloads in a rolling fashion, taking down old ones and bringing up new ones incrementally, ensuring that the service remains available during the update.), `Parallel` (Causes all pods affected by a scaling operation to be created or destroyed simultaneously. This does not affect update operations.). Default: `OrderedReady`.
        """
        return pulumi.get(self, "scaling_policy")

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> Optional[builtins.int]:
        """
        The amount of time in seconds a workload has to gracefully terminate before forcefully terminating it. This includes the time it takes for the preStop hook to run.
        """
        return pulumi.get(self, "termination_grace_period_seconds")


@pulumi.output_type
class WorkloadSecurityOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemGroupId":
            suggest = "file_system_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadSecurityOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadSecurityOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadSecurityOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_group_id: Optional[builtins.int] = None):
        """
        :param builtins.int file_system_group_id: The group id assigned to any mounted volume.
        """
        if file_system_group_id is not None:
            pulumi.set(__self__, "file_system_group_id", file_system_group_id)

    @property
    @pulumi.getter(name="fileSystemGroupId")
    def file_system_group_id(self) -> Optional[builtins.int]:
        """
        The group id assigned to any mounted volume.
        """
        return pulumi.get(self, "file_system_group_id")


@pulumi.output_type
class WorkloadSidecar(dict):
    def __init__(__self__, *,
                 envoy: builtins.str):
        pulumi.set(__self__, "envoy", envoy)

    @property
    @pulumi.getter
    def envoy(self) -> builtins.str:
        return pulumi.get(self, "envoy")


@pulumi.output_type
class WorkloadStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalEndpoint":
            suggest = "canonical_endpoint"
        elif key == "currentReplicaCount":
            suggest = "current_replica_count"
        elif key == "healthChecks":
            suggest = "health_checks"
        elif key == "internalName":
            suggest = "internal_name"
        elif key == "loadBalancers":
            suggest = "load_balancers"
        elif key == "parentId":
            suggest = "parent_id"
        elif key == "resolvedImages":
            suggest = "resolved_images"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_endpoint: Optional[builtins.str] = None,
                 current_replica_count: Optional[builtins.int] = None,
                 endpoint: Optional[builtins.str] = None,
                 health_checks: Optional[Sequence['outputs.WorkloadStatusHealthCheck']] = None,
                 internal_name: Optional[builtins.str] = None,
                 load_balancers: Optional[Sequence['outputs.WorkloadStatusLoadBalancer']] = None,
                 parent_id: Optional[builtins.str] = None,
                 resolved_images: Optional[Sequence['outputs.WorkloadStatusResolvedImage']] = None):
        """
        :param builtins.str canonical_endpoint: Canonical endpoint for the workload.
        :param builtins.int current_replica_count: Current amount of replicas deployed.
        :param builtins.str endpoint: Endpoint for the workload.
        :param Sequence['WorkloadStatusHealthCheckArgs'] health_checks: Current health status.
        :param builtins.str internal_name: Internal hostname for the workload. Used for service-to-service requests.
        :param builtins.str parent_id: ID of the parent object.
        :param Sequence['WorkloadStatusResolvedImageArgs'] resolved_images: Resolved images for workloads with dynamic tags enabled.
        """
        if canonical_endpoint is not None:
            pulumi.set(__self__, "canonical_endpoint", canonical_endpoint)
        if current_replica_count is not None:
            pulumi.set(__self__, "current_replica_count", current_replica_count)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if internal_name is not None:
            pulumi.set(__self__, "internal_name", internal_name)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if resolved_images is not None:
            pulumi.set(__self__, "resolved_images", resolved_images)

    @property
    @pulumi.getter(name="canonicalEndpoint")
    def canonical_endpoint(self) -> Optional[builtins.str]:
        """
        Canonical endpoint for the workload.
        """
        return pulumi.get(self, "canonical_endpoint")

    @property
    @pulumi.getter(name="currentReplicaCount")
    def current_replica_count(self) -> Optional[builtins.int]:
        """
        Current amount of replicas deployed.
        """
        return pulumi.get(self, "current_replica_count")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        """
        Endpoint for the workload.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[Sequence['outputs.WorkloadStatusHealthCheck']]:
        """
        Current health status.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter(name="internalName")
    def internal_name(self) -> Optional[builtins.str]:
        """
        Internal hostname for the workload. Used for service-to-service requests.
        """
        return pulumi.get(self, "internal_name")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[Sequence['outputs.WorkloadStatusLoadBalancer']]:
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[builtins.str]:
        """
        ID of the parent object.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="resolvedImages")
    def resolved_images(self) -> Optional[Sequence['outputs.WorkloadStatusResolvedImage']]:
        """
        Resolved images for workloads with dynamic tags enabled.
        """
        return pulumi.get(self, "resolved_images")


@pulumi.output_type
class WorkloadStatusHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastChecked":
            suggest = "last_checked"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadStatusHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadStatusHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadStatusHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: Optional[builtins.bool] = None,
                 code: Optional[builtins.int] = None,
                 failures: Optional[builtins.int] = None,
                 last_checked: Optional[builtins.str] = None,
                 message: Optional[builtins.str] = None,
                 success: Optional[builtins.bool] = None,
                 successes: Optional[builtins.int] = None):
        """
        :param builtins.bool active: Active boolean for the associated workload.
        :param builtins.int code: Current output code for the associated workload.
        :param builtins.int failures: Failure integer for the associated workload.
        :param builtins.str last_checked: Timestamp in UTC of the last health check.
        :param builtins.str message: Current health status for the associated workload.
        :param builtins.bool success: Success boolean for the associated workload.
        :param builtins.int successes: Success integer for the associated workload.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if code is not None:
            pulumi.set(__self__, "code", code)
        if failures is not None:
            pulumi.set(__self__, "failures", failures)
        if last_checked is not None:
            pulumi.set(__self__, "last_checked", last_checked)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if success is not None:
            pulumi.set(__self__, "success", success)
        if successes is not None:
            pulumi.set(__self__, "successes", successes)

    @property
    @pulumi.getter
    def active(self) -> Optional[builtins.bool]:
        """
        Active boolean for the associated workload.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def code(self) -> Optional[builtins.int]:
        """
        Current output code for the associated workload.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def failures(self) -> Optional[builtins.int]:
        """
        Failure integer for the associated workload.
        """
        return pulumi.get(self, "failures")

    @property
    @pulumi.getter(name="lastChecked")
    def last_checked(self) -> Optional[builtins.str]:
        """
        Timestamp in UTC of the last health check.
        """
        return pulumi.get(self, "last_checked")

    @property
    @pulumi.getter
    def message(self) -> Optional[builtins.str]:
        """
        Current health status for the associated workload.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def success(self) -> Optional[builtins.bool]:
        """
        Success boolean for the associated workload.
        """
        return pulumi.get(self, "success")

    @property
    @pulumi.getter
    def successes(self) -> Optional[builtins.int]:
        """
        Success integer for the associated workload.
        """
        return pulumi.get(self, "successes")


@pulumi.output_type
class WorkloadStatusLoadBalancer(dict):
    def __init__(__self__, *,
                 origin: Optional[builtins.str] = None,
                 url: Optional[builtins.str] = None):
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def origin(self) -> Optional[builtins.str]:
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        return pulumi.get(self, "url")


@pulumi.output_type
class WorkloadStatusResolvedImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessages":
            suggest = "error_messages"
        elif key == "resolvedAt":
            suggest = "resolved_at"
        elif key == "resolvedForVersion":
            suggest = "resolved_for_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadStatusResolvedImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadStatusResolvedImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadStatusResolvedImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_messages: Optional[Sequence[builtins.str]] = None,
                 images: Optional[Sequence['outputs.WorkloadStatusResolvedImageImage']] = None,
                 resolved_at: Optional[builtins.str] = None,
                 resolved_for_version: Optional[builtins.int] = None):
        """
        :param Sequence['WorkloadStatusResolvedImageImageArgs'] images: A list of images that were resolved.
        :param builtins.str resolved_at: UTC Time when the images were resolved.
        :param builtins.int resolved_for_version: Workload version the images were resolved for.
        """
        if error_messages is not None:
            pulumi.set(__self__, "error_messages", error_messages)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if resolved_at is not None:
            pulumi.set(__self__, "resolved_at", resolved_at)
        if resolved_for_version is not None:
            pulumi.set(__self__, "resolved_for_version", resolved_for_version)

    @property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "error_messages")

    @property
    @pulumi.getter
    def images(self) -> Optional[Sequence['outputs.WorkloadStatusResolvedImageImage']]:
        """
        A list of images that were resolved.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="resolvedAt")
    def resolved_at(self) -> Optional[builtins.str]:
        """
        UTC Time when the images were resolved.
        """
        return pulumi.get(self, "resolved_at")

    @property
    @pulumi.getter(name="resolvedForVersion")
    def resolved_for_version(self) -> Optional[builtins.int]:
        """
        Workload version the images were resolved for.
        """
        return pulumi.get(self, "resolved_for_version")


@pulumi.output_type
class WorkloadStatusResolvedImageImage(dict):
    def __init__(__self__, *,
                 digest: Optional[builtins.str] = None,
                 manifests: Optional[Sequence['outputs.WorkloadStatusResolvedImageImageManifest']] = None):
        """
        :param builtins.str digest: A unique SHA256 hash value that identifies a specific image content. This digest serves as a fingerprint of the image's content, ensuring the image you pull or run is exactly what you expect, without any modifications or corruptions.
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if manifests is not None:
            pulumi.set(__self__, "manifests", manifests)

    @property
    @pulumi.getter
    def digest(self) -> Optional[builtins.str]:
        """
        A unique SHA256 hash value that identifies a specific image content. This digest serves as a fingerprint of the image's content, ensuring the image you pull or run is exactly what you expect, without any modifications or corruptions.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def manifests(self) -> Optional[Sequence['outputs.WorkloadStatusResolvedImageImageManifest']]:
        return pulumi.get(self, "manifests")


@pulumi.output_type
class WorkloadStatusResolvedImageImageManifest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mediaType":
            suggest = "media_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadStatusResolvedImageImageManifest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadStatusResolvedImageImageManifest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadStatusResolvedImageImageManifest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 digest: Optional[builtins.str] = None,
                 image: Optional[builtins.str] = None,
                 media_type: Optional[builtins.str] = None,
                 platform: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str digest: A SHA256 hash that uniquely identifies the specific image manifest.
        :param builtins.str image: The name and tag of the resolved image.
        :param builtins.str media_type: The MIME type used in the Docker Registry HTTP API to specify the format of the data being sent or received. Docker uses media types to distinguish between different kinds of JSON objects and binary data formats within the registry protocol, enabling the Docker client and registry to understand and process different components of Docker images correctly.
        :param Mapping[str, builtins.str] platform: Key-value map of strings. The combination of the operating system and architecture for which the image is built.
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter
    def digest(self) -> Optional[builtins.str]:
        """
        A SHA256 hash that uniquely identifies the specific image manifest.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def image(self) -> Optional[builtins.str]:
        """
        The name and tag of the resolved image.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[builtins.str]:
        """
        The MIME type used in the Docker Registry HTTP API to specify the format of the data being sent or received. Docker uses media types to distinguish between different kinds of JSON objects and binary data formats within the registry protocol, enabling the Docker client and registry to understand and process different components of Docker images correctly.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter
    def platform(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of strings. The combination of the operating system and architecture for which the image is built.
        """
        return pulumi.get(self, "platform")


@pulumi.output_type
class GetGvcControlplaneTracingResult(dict):
    def __init__(__self__, *,
                 sampling: builtins.float,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "sampling", sampling)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class GetGvcLightstepTracingResult(dict):
    def __init__(__self__, *,
                 endpoint: builtins.str,
                 sampling: builtins.float,
                 credentials: Optional[builtins.str] = None,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str endpoint: Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param builtins.str credentials: Full link to referenced Opaque Secret.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "sampling", sampling)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter
    def credentials(self) -> Optional[builtins.str]:
        """
        Full link to referenced Opaque Secret.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class GetGvcLoadBalancerResult(dict):
    def __init__(__self__, *,
                 trusted_proxies: builtins.int,
                 dedicated: Optional[builtins.bool] = None,
                 ipset: Optional[builtins.str] = None,
                 multi_zone: Optional['outputs.GetGvcLoadBalancerMultiZoneResult'] = None,
                 redirect: Optional['outputs.GetGvcLoadBalancerRedirectResult'] = None):
        """
        :param builtins.int trusted_proxies: Controls the address used for request logging and for setting the X-Envoy-External-Address header. If set to 1, then the last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If set to 2, then the second to last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If the XFF header does not have at least two addresses or does not exist then the source client IP address will be used instead.
        :param builtins.bool dedicated: Creates a dedicated load balancer in each location and enables additional Domain features: custom ports, protocols and wildcard hostnames. Charges apply for each location.
        :param builtins.str ipset: The link or the name of the IP Set that will be used for this load balancer.
        :param 'GetGvcLoadBalancerRedirectArgs' redirect: Specify the url to be redirected to for different http status codes.
        """
        pulumi.set(__self__, "trusted_proxies", trusted_proxies)
        if dedicated is not None:
            pulumi.set(__self__, "dedicated", dedicated)
        if ipset is not None:
            pulumi.set(__self__, "ipset", ipset)
        if multi_zone is not None:
            pulumi.set(__self__, "multi_zone", multi_zone)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)

    @property
    @pulumi.getter(name="trustedProxies")
    def trusted_proxies(self) -> builtins.int:
        """
        Controls the address used for request logging and for setting the X-Envoy-External-Address header. If set to 1, then the last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If set to 2, then the second to last address in an existing X-Forwarded-For header will be used in place of the source client IP address. If the XFF header does not have at least two addresses or does not exist then the source client IP address will be used instead.
        """
        return pulumi.get(self, "trusted_proxies")

    @property
    @pulumi.getter
    def dedicated(self) -> Optional[builtins.bool]:
        """
        Creates a dedicated load balancer in each location and enables additional Domain features: custom ports, protocols and wildcard hostnames. Charges apply for each location.
        """
        return pulumi.get(self, "dedicated")

    @property
    @pulumi.getter
    def ipset(self) -> Optional[builtins.str]:
        """
        The link or the name of the IP Set that will be used for this load balancer.
        """
        return pulumi.get(self, "ipset")

    @property
    @pulumi.getter(name="multiZone")
    def multi_zone(self) -> Optional['outputs.GetGvcLoadBalancerMultiZoneResult']:
        return pulumi.get(self, "multi_zone")

    @property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.GetGvcLoadBalancerRedirectResult']:
        """
        Specify the url to be redirected to for different http status codes.
        """
        return pulumi.get(self, "redirect")


@pulumi.output_type
class GetGvcLoadBalancerMultiZoneResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetGvcLoadBalancerRedirectResult(dict):
    def __init__(__self__, *,
                 class_: Optional['outputs.GetGvcLoadBalancerRedirectClassResult'] = None):
        """
        :param 'GetGvcLoadBalancerRedirectClassArgs' class_: Specify the redirect url for all status codes in a class.
        """
        if class_ is not None:
            pulumi.set(__self__, "class_", class_)

    @property
    @pulumi.getter(name="class")
    def class_(self) -> Optional['outputs.GetGvcLoadBalancerRedirectClassResult']:
        """
        Specify the redirect url for all status codes in a class.
        """
        return pulumi.get(self, "class_")


@pulumi.output_type
class GetGvcLoadBalancerRedirectClassResult(dict):
    def __init__(__self__, *,
                 status401: Optional[builtins.str] = None,
                 status5xx: Optional[builtins.str] = None):
        """
        :param builtins.str status401: An optional url redirect for 401 responses. Supports envoy format strings to include request information. E.g. https://your-oauth-server/oauth2/authorize?return_to=%REQ(:path)%&client_id=your-client-id
        :param builtins.str status5xx: Specify the redirect url for any 500 level status code.
        """
        if status401 is not None:
            pulumi.set(__self__, "status401", status401)
        if status5xx is not None:
            pulumi.set(__self__, "status5xx", status5xx)

    @property
    @pulumi.getter
    def status401(self) -> Optional[builtins.str]:
        """
        An optional url redirect for 401 responses. Supports envoy format strings to include request information. E.g. https://your-oauth-server/oauth2/authorize?return_to=%REQ(:path)%&client_id=your-client-id
        """
        return pulumi.get(self, "status401")

    @property
    @pulumi.getter
    def status5xx(self) -> Optional[builtins.str]:
        """
        Specify the redirect url for any 500 level status code.
        """
        return pulumi.get(self, "status5xx")


@pulumi.output_type
class GetGvcOtelTracingResult(dict):
    def __init__(__self__, *,
                 endpoint: builtins.str,
                 sampling: builtins.float,
                 custom_tags: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str endpoint: Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        :param builtins.float sampling: Determines what percentage of requests should be traced.
        :param Mapping[str, builtins.str] custom_tags: Key-value map of custom tags.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "sampling", sampling)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)

    @property
    @pulumi.getter
    def endpoint(self) -> builtins.str:
        """
        Tracing Endpoint Workload. Either the canonical endpoint or internal endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def sampling(self) -> builtins.float:
        """
        Determines what percentage of requests should be traced.
        """
        return pulumi.get(self, "sampling")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value map of custom tags.
        """
        return pulumi.get(self, "custom_tags")


@pulumi.output_type
class GetGvcSidecarResult(dict):
    def __init__(__self__, *,
                 envoy: builtins.str):
        pulumi.set(__self__, "envoy", envoy)

    @property
    @pulumi.getter
    def envoy(self) -> builtins.str:
        return pulumi.get(self, "envoy")


@pulumi.output_type
class GetImageManifestResult(dict):
    def __init__(__self__, *,
                 configs: Sequence['outputs.GetImageManifestConfigResult'],
                 layers: Sequence['outputs.GetImageManifestLayerResult'],
                 media_type: builtins.str,
                 schema_version: builtins.int):
        """
        :param Sequence['GetImageManifestConfigArgs'] configs: The config is a JSON blob that contains the image configuration data which includes environment variables, default command to run, and other settings necessary to run the container based on this image.
        :param Sequence['GetImageManifestLayerArgs'] layers: Layers lists the digests of the image's layers. These layers are filesystem changes or additions made in each step of the Docker image's creation process. The layers are stored separately and pulled as needed, which allows for efficient storage and transfer of images. Each layer is represented by a SHA256 digest, ensuring the integrity and authenticity of the image.
        :param builtins.str media_type: Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        :param builtins.int schema_version: The version of the Docker Image Manifest format.
        """
        pulumi.set(__self__, "configs", configs)
        pulumi.set(__self__, "layers", layers)
        pulumi.set(__self__, "media_type", media_type)
        pulumi.set(__self__, "schema_version", schema_version)

    @property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetImageManifestConfigResult']:
        """
        The config is a JSON blob that contains the image configuration data which includes environment variables, default command to run, and other settings necessary to run the container based on this image.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter
    def layers(self) -> Sequence['outputs.GetImageManifestLayerResult']:
        """
        Layers lists the digests of the image's layers. These layers are filesystem changes or additions made in each step of the Docker image's creation process. The layers are stored separately and pulled as needed, which allows for efficient storage and transfer of images. Each layer is represented by a SHA256 digest, ensuring the integrity and authenticity of the image.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> builtins.str:
        """
        Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> builtins.int:
        """
        The version of the Docker Image Manifest format.
        """
        return pulumi.get(self, "schema_version")


@pulumi.output_type
class GetImageManifestConfigResult(dict):
    def __init__(__self__, *,
                 digest: builtins.str,
                 media_type: builtins.str,
                 size: builtins.int):
        """
        :param builtins.str digest: A unique SHA256 hash used to identify a specific image version within the image registry.
        :param builtins.str media_type: Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        :param builtins.int size: The size of the image or layer in bytes. This helps in estimating the space required and the download time.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "media_type", media_type)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        A unique SHA256 hash used to identify a specific image version within the image registry.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> builtins.str:
        """
        Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The size of the image or layer in bytes. This helps in estimating the space required and the download time.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetImageManifestLayerResult(dict):
    def __init__(__self__, *,
                 digest: builtins.str,
                 media_type: builtins.str,
                 size: builtins.int):
        """
        :param builtins.str digest: A unique SHA256 hash used to identify a specific image version within the image registry.
        :param builtins.str media_type: Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        :param builtins.int size: The size of the image or layer in bytes. This helps in estimating the space required and the download time.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "media_type", media_type)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        A unique SHA256 hash used to identify a specific image version within the image registry.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> builtins.str:
        """
        Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The size of the image or layer in bytes. This helps in estimating the space required and the download time.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 cpln_id: builtins.str,
                 digest: builtins.str,
                 manifests: Sequence['outputs.GetImagesImageManifestResult'],
                 name: builtins.str,
                 repository: builtins.str,
                 self_link: builtins.str,
                 tag: builtins.str,
                 tags: Mapping[str, builtins.str]):
        """
        :param builtins.str cpln_id: The ID, in GUID format, of the image.
        :param builtins.str digest: A unique SHA256 hash used to identify a specific image version within the image registry.
        :param Sequence['GetImagesImageManifestArgs'] manifests: The manifest provides configuration and layers information about the image. It plays a crucial role in the Docker image distribution system, enabling image creation, verification, and replication in a consistent and secure manner.
        :param builtins.str name: Name of the image.
        :param builtins.str repository: Respository name of the image.
        :param builtins.str self_link: Full link to this resource. Can be referenced by other resources.
        :param builtins.str tag: Tag of the image.
        :param Mapping[str, builtins.str] tags: Key-value map of resource tags.
        """
        pulumi.set(__self__, "cpln_id", cpln_id)
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "manifests", manifests)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "repository", repository)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> builtins.str:
        """
        The ID, in GUID format, of the image.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        A unique SHA256 hash used to identify a specific image version within the image registry.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def manifests(self) -> Sequence['outputs.GetImagesImageManifestResult']:
        """
        The manifest provides configuration and layers information about the image. It plays a crucial role in the Docker image distribution system, enabling image creation, verification, and replication in a consistent and secure manner.
        """
        return pulumi.get(self, "manifests")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def repository(self) -> builtins.str:
        """
        Respository name of the image.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tag(self) -> builtins.str:
        """
        Tag of the image.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetImagesImageManifestResult(dict):
    def __init__(__self__, *,
                 configs: Sequence['outputs.GetImagesImageManifestConfigResult'],
                 layers: Sequence['outputs.GetImagesImageManifestLayerResult'],
                 media_type: builtins.str,
                 schema_version: builtins.int):
        """
        :param Sequence['GetImagesImageManifestConfigArgs'] configs: The config is a JSON blob that contains the image configuration data which includes environment variables, default command to run, and other settings necessary to run the container based on this image.
        :param Sequence['GetImagesImageManifestLayerArgs'] layers: Layers lists the digests of the image's layers. These layers are filesystem changes or additions made in each step of the Docker image's creation process. The layers are stored separately and pulled as needed, which allows for efficient storage and transfer of images. Each layer is represented by a SHA256 digest, ensuring the integrity and authenticity of the image.
        :param builtins.str media_type: Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        :param builtins.int schema_version: The version of the Docker Image Manifest format.
        """
        pulumi.set(__self__, "configs", configs)
        pulumi.set(__self__, "layers", layers)
        pulumi.set(__self__, "media_type", media_type)
        pulumi.set(__self__, "schema_version", schema_version)

    @property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetImagesImageManifestConfigResult']:
        """
        The config is a JSON blob that contains the image configuration data which includes environment variables, default command to run, and other settings necessary to run the container based on this image.
        """
        return pulumi.get(self, "configs")

    @property
    @pulumi.getter
    def layers(self) -> Sequence['outputs.GetImagesImageManifestLayerResult']:
        """
        Layers lists the digests of the image's layers. These layers are filesystem changes or additions made in each step of the Docker image's creation process. The layers are stored separately and pulled as needed, which allows for efficient storage and transfer of images. Each layer is represented by a SHA256 digest, ensuring the integrity and authenticity of the image.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> builtins.str:
        """
        Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> builtins.int:
        """
        The version of the Docker Image Manifest format.
        """
        return pulumi.get(self, "schema_version")


@pulumi.output_type
class GetImagesImageManifestConfigResult(dict):
    def __init__(__self__, *,
                 digest: builtins.str,
                 media_type: builtins.str,
                 size: builtins.int):
        """
        :param builtins.str digest: A unique SHA256 hash used to identify a specific image version within the image registry.
        :param builtins.str media_type: Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        :param builtins.int size: The size of the image or layer in bytes. This helps in estimating the space required and the download time.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "media_type", media_type)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        A unique SHA256 hash used to identify a specific image version within the image registry.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> builtins.str:
        """
        Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The size of the image or layer in bytes. This helps in estimating the space required and the download time.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetImagesImageManifestLayerResult(dict):
    def __init__(__self__, *,
                 digest: builtins.str,
                 media_type: builtins.str,
                 size: builtins.int):
        """
        :param builtins.str digest: A unique SHA256 hash used to identify a specific image version within the image registry.
        :param builtins.str media_type: Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        :param builtins.int size: The size of the image or layer in bytes. This helps in estimating the space required and the download time.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "media_type", media_type)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def digest(self) -> builtins.str:
        """
        A unique SHA256 hash used to identify a specific image version within the image registry.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> builtins.str:
        """
        Specifies the type of the content represented in the manifest, allowing Docker clients and registries to understand how to handle the document correctly.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The size of the image or layer in bytes. This helps in estimating the space required and the download time.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetImagesQueryResult(dict):
    def __init__(__self__, *,
                 fetch: builtins.str,
                 spec: Optional['outputs.GetImagesQuerySpecResult'] = None):
        """
        :param builtins.str fetch: Type of fetch. Specify either: `links` or `items`. Default: `items`.
        :param 'GetImagesQuerySpecArgs' spec: The specification of the query.
        """
        pulumi.set(__self__, "fetch", fetch)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def fetch(self) -> builtins.str:
        """
        Type of fetch. Specify either: `links` or `items`. Default: `items`.
        """
        return pulumi.get(self, "fetch")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.GetImagesQuerySpecResult']:
        """
        The specification of the query.
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class GetImagesQuerySpecResult(dict):
    def __init__(__self__, *,
                 match: builtins.str,
                 terms: Optional[Sequence['outputs.GetImagesQuerySpecTermResult']] = None):
        """
        :param builtins.str match: Type of match. Available values: `all`, `any`, `none`. Default: `all`.
        :param Sequence['GetImagesQuerySpecTermArgs'] terms: Terms can only contain one of the following attributes: `property`, `rel`, `tag`.
        """
        pulumi.set(__self__, "match", match)
        if terms is not None:
            pulumi.set(__self__, "terms", terms)

    @property
    @pulumi.getter
    def match(self) -> builtins.str:
        """
        Type of match. Available values: `all`, `any`, `none`. Default: `all`.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def terms(self) -> Optional[Sequence['outputs.GetImagesQuerySpecTermResult']]:
        """
        Terms can only contain one of the following attributes: `property`, `rel`, `tag`.
        """
        return pulumi.get(self, "terms")


@pulumi.output_type
class GetImagesQuerySpecTermResult(dict):
    def __init__(__self__, *,
                 op: builtins.str,
                 property: Optional[builtins.str] = None,
                 rel: Optional[builtins.str] = None,
                 tag: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str op: Type of query operation. Available values: `=`, `>`, `>=`, `<`, `<=`, `!=`, `exists`, `!exists`. Default: `=`.
        :param builtins.str property: Property to use for query evaluation.
        :param builtins.str rel: Relation to use for query evaluation.
        :param builtins.str tag: Tag key to use for query evaluation.
        :param builtins.str value: Testing value for query evaluation.
        """
        pulumi.set(__self__, "op", op)
        if property is not None:
            pulumi.set(__self__, "property", property)
        if rel is not None:
            pulumi.set(__self__, "rel", rel)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def op(self) -> builtins.str:
        """
        Type of query operation. Available values: `=`, `>`, `>=`, `<`, `<=`, `!=`, `exists`, `!exists`. Default: `=`.
        """
        return pulumi.get(self, "op")

    @property
    @pulumi.getter
    def rel(self) -> Optional[builtins.str]:
        """
        Relation to use for query evaluation.
        """
        return pulumi.get(self, "rel")

    @property
    @pulumi.getter
    def tag(self) -> Optional[builtins.str]:
        """
        Tag key to use for query evaluation.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        Testing value for query evaluation.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def property(self) -> Optional[builtins.str]:
        """
        Property to use for query evaluation.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class GetLocationGeoResult(dict):
    def __init__(__self__, *,
                 city: builtins.str,
                 continent: builtins.str,
                 country: builtins.str,
                 lat: builtins.float,
                 lon: builtins.float,
                 state: builtins.str):
        """
        :param builtins.str city: City of the location.
        :param builtins.str continent: Continent of the location.
        :param builtins.str country: Country of the location.
        :param builtins.float lat: Latitude of the location.
        :param builtins.float lon: Longitude of the location.
        :param builtins.str state: State of the location.
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "continent", continent)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "lat", lat)
        pulumi.set(__self__, "lon", lon)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        City of the location.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def continent(self) -> builtins.str:
        """
        Continent of the location.
        """
        return pulumi.get(self, "continent")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country of the location.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def lat(self) -> builtins.float:
        """
        Latitude of the location.
        """
        return pulumi.get(self, "lat")

    @property
    @pulumi.getter
    def lon(self) -> builtins.float:
        """
        Longitude of the location.
        """
        return pulumi.get(self, "lon")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the location.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetLocationsLocationResult(dict):
    def __init__(__self__, *,
                 cloud_provider: builtins.str,
                 cpln_id: builtins.str,
                 description: builtins.str,
                 enabled: builtins.bool,
                 geos: Sequence['outputs.GetLocationsLocationGeoResult'],
                 ip_ranges: Sequence[builtins.str],
                 name: builtins.str,
                 region: builtins.str,
                 self_link: builtins.str,
                 tags: Mapping[str, builtins.str]):
        """
        :param builtins.str cloud_provider: Cloud Provider of the location.
        :param builtins.str cpln_id: The ID, in GUID format, of the location.
        :param builtins.str description: Description of the location.
        :param builtins.bool enabled: Indication if location is enabled.
        :param Sequence[builtins.str] ip_ranges: A list of IP ranges of the location.
        :param builtins.str name: Name of the location.
        :param builtins.str region: Region of the location.
        :param builtins.str self_link: Full link to this resource. Can be referenced by other resources.
        :param Mapping[str, builtins.str] tags: Key-value map of resource tags.
        """
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        pulumi.set(__self__, "cpln_id", cpln_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "geos", geos)
        pulumi.set(__self__, "ip_ranges", ip_ranges)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> builtins.str:
        """
        Cloud Provider of the location.
        """
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter(name="cplnId")
    def cpln_id(self) -> builtins.str:
        """
        The ID, in GUID format, of the location.
        """
        return pulumi.get(self, "cpln_id")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the location.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Indication if location is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def geos(self) -> Sequence['outputs.GetLocationsLocationGeoResult']:
        return pulumi.get(self, "geos")

    @property
    @pulumi.getter(name="ipRanges")
    def ip_ranges(self) -> Sequence[builtins.str]:
        """
        A list of IP ranges of the location.
        """
        return pulumi.get(self, "ip_ranges")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the location.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Region of the location.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        """
        Full link to this resource. Can be referenced by other resources.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Key-value map of resource tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetLocationsLocationGeoResult(dict):
    def __init__(__self__, *,
                 city: builtins.str,
                 continent: builtins.str,
                 country: builtins.str,
                 lat: builtins.float,
                 lon: builtins.float,
                 state: builtins.str):
        """
        :param builtins.str city: City of the location.
        :param builtins.str continent: Continent of the location.
        :param builtins.str country: Country of the location.
        :param builtins.float lat: Latitude of the location.
        :param builtins.float lon: Longitude of the location.
        :param builtins.str state: State of the location.
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "continent", continent)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "lat", lat)
        pulumi.set(__self__, "lon", lon)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def city(self) -> builtins.str:
        """
        City of the location.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def continent(self) -> builtins.str:
        """
        Continent of the location.
        """
        return pulumi.get(self, "continent")

    @property
    @pulumi.getter
    def country(self) -> builtins.str:
        """
        Country of the location.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def lat(self) -> builtins.float:
        """
        Latitude of the location.
        """
        return pulumi.get(self, "lat")

    @property
    @pulumi.getter
    def lon(self) -> builtins.float:
        """
        Longitude of the location.
        """
        return pulumi.get(self, "lon")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        State of the location.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetOrgAuthConfigResult(dict):
    def __init__(__self__, *,
                 domain_auto_members: Sequence[builtins.str],
                 saml_only: builtins.bool):
        """
        :param Sequence[builtins.str] domain_auto_members: List of domains which will auto-provision users when authenticating using SAML.
        :param builtins.bool saml_only: Enforce SAML only authentication.
        """
        pulumi.set(__self__, "domain_auto_members", domain_auto_members)
        pulumi.set(__self__, "saml_only", saml_only)

    @property
    @pulumi.getter(name="domainAutoMembers")
    def domain_auto_members(self) -> Sequence[builtins.str]:
        """
        List of domains which will auto-provision users when authenticating using SAML.
        """
        return pulumi.get(self, "domain_auto_members")

    @property
    @pulumi.getter(name="samlOnly")
    def saml_only(self) -> builtins.bool:
        """
        Enforce SAML only authentication.
        """
        return pulumi.get(self, "saml_only")


@pulumi.output_type
class GetOrgObservabilityResult(dict):
    def __init__(__self__, *,
                 default_alert_emails: Sequence[builtins.str],
                 logs_retention_days: builtins.int,
                 metrics_retention_days: builtins.int,
                 traces_retention_days: builtins.int):
        """
        :param Sequence[builtins.str] default_alert_emails: These emails are configured as alert recipients in Grafana when the 'grafana-default-email' contact delivery type is 'Email'.
        :param builtins.int logs_retention_days: Log retention days. Default: 30
        :param builtins.int metrics_retention_days: Metrics retention days. Default: 30
        :param builtins.int traces_retention_days: Traces retention days. Default: 30
        """
        pulumi.set(__self__, "default_alert_emails", default_alert_emails)
        pulumi.set(__self__, "logs_retention_days", logs_retention_days)
        pulumi.set(__self__, "metrics_retention_days", metrics_retention_days)
        pulumi.set(__self__, "traces_retention_days", traces_retention_days)

    @property
    @pulumi.getter(name="defaultAlertEmails")
    def default_alert_emails(self) -> Sequence[builtins.str]:
        """
        These emails are configured as alert recipients in Grafana when the 'grafana-default-email' contact delivery type is 'Email'.
        """
        return pulumi.get(self, "default_alert_emails")

    @property
    @pulumi.getter(name="logsRetentionDays")
    def logs_retention_days(self) -> builtins.int:
        """
        Log retention days. Default: 30
        """
        return pulumi.get(self, "logs_retention_days")

    @property
    @pulumi.getter(name="metricsRetentionDays")
    def metrics_retention_days(self) -> builtins.int:
        """
        Metrics retention days. Default: 30
        """
        return pulumi.get(self, "metrics_retention_days")

    @property
    @pulumi.getter(name="tracesRetentionDays")
    def traces_retention_days(self) -> builtins.int:
        """
        Traces retention days. Default: 30
        """
        return pulumi.get(self, "traces_retention_days")


@pulumi.output_type
class GetOrgSecurityResult(dict):
    def __init__(__self__, *,
                 threat_detection: Optional['outputs.GetOrgSecurityThreatDetectionResult'] = None):
        if threat_detection is not None:
            pulumi.set(__self__, "threat_detection", threat_detection)

    @property
    @pulumi.getter(name="threatDetection")
    def threat_detection(self) -> Optional['outputs.GetOrgSecurityThreatDetectionResult']:
        return pulumi.get(self, "threat_detection")


@pulumi.output_type
class GetOrgSecurityThreatDetectionResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 minimum_severity: Optional[builtins.str] = None,
                 syslog: Optional['outputs.GetOrgSecurityThreatDetectionSyslogResult'] = None):
        """
        :param builtins.bool enabled: Indicates whether threat detection should be forwarded or not.
        :param builtins.str minimum_severity: Any threats with this severity and more severe will be sent. Others will be ignored. Valid values: `warning`, `error`, or `critical`.
        :param 'GetOrgSecurityThreatDetectionSyslogArgs' syslog: Configuration for syslog forwarding.
        """
        pulumi.set(__self__, "enabled", enabled)
        if minimum_severity is not None:
            pulumi.set(__self__, "minimum_severity", minimum_severity)
        if syslog is not None:
            pulumi.set(__self__, "syslog", syslog)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Indicates whether threat detection should be forwarded or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="minimumSeverity")
    def minimum_severity(self) -> Optional[builtins.str]:
        """
        Any threats with this severity and more severe will be sent. Others will be ignored. Valid values: `warning`, `error`, or `critical`.
        """
        return pulumi.get(self, "minimum_severity")

    @property
    @pulumi.getter
    def syslog(self) -> Optional['outputs.GetOrgSecurityThreatDetectionSyslogResult']:
        """
        Configuration for syslog forwarding.
        """
        return pulumi.get(self, "syslog")


@pulumi.output_type
class GetOrgSecurityThreatDetectionSyslogResult(dict):
    def __init__(__self__, *,
                 host: builtins.str,
                 port: builtins.int,
                 transport: builtins.str):
        """
        :param builtins.str host: The hostname to send syslog messages to.
        :param builtins.int port: The port to send syslog messages to.
        :param builtins.str transport: The transport-layer protocol to send the syslog messages over. If TCP is chosen, messages will be sent with TLS. Default: `tcp`.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "transport", transport)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        The hostname to send syslog messages to.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The port to send syslog messages to.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def transport(self) -> builtins.str:
        """
        The transport-layer protocol to send the syslog messages over. If TCP is chosen, messages will be sent with TLS. Default: `tcp`.
        """
        return pulumi.get(self, "transport")


@pulumi.output_type
class GetOrgStatusResult(dict):
    def __init__(__self__, *,
                 account_link: builtins.str,
                 active: builtins.bool):
        """
        :param builtins.str account_link: The link of the account the org belongs to.
        :param builtins.bool active: Indicates whether the org is active or not.
        """
        pulumi.set(__self__, "account_link", account_link)
        pulumi.set(__self__, "active", active)

    @property
    @pulumi.getter(name="accountLink")
    def account_link(self) -> builtins.str:
        """
        The link of the account the org belongs to.
        """
        return pulumi.get(self, "account_link")

    @property
    @pulumi.getter
    def active(self) -> builtins.bool:
        """
        Indicates whether the org is active or not.
        """
        return pulumi.get(self, "active")


@pulumi.output_type
class GetSecretAwResult(dict):
    def __init__(__self__, *,
                 access_key: builtins.str,
                 external_id: builtins.str,
                 role_arn: builtins.str,
                 secret_key: builtins.str):
        """
        :param builtins.str access_key: Access Key provided by AWS.
        :param builtins.str external_id: AWS IAM Role External ID.
        :param builtins.str role_arn: Role ARN provided by AWS.
        :param builtins.str secret_key: Secret Key provided by AWS.
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Access Key provided by AWS.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> builtins.str:
        """
        AWS IAM Role External ID.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        Role ARN provided by AWS.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Secret Key provided by AWS.
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class GetSecretAzureConnectorResult(dict):
    def __init__(__self__, *,
                 code: builtins.str,
                 url: builtins.str):
        """
        :param builtins.str code: Code/Key to authenticate to deployment URL.
        :param builtins.str url: Deployment URL.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        Code/Key to authenticate to deployment URL.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Deployment URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetSecretEcrResult(dict):
    def __init__(__self__, *,
                 access_key: builtins.str,
                 repos: Sequence[builtins.str],
                 role_arn: builtins.str,
                 secret_key: builtins.str,
                 external_id: Optional[builtins.str] = None):
        """
        :param builtins.str access_key: Access Key provided by AWS.
        :param Sequence[builtins.str] repos: List of ECR repositories.
        :param builtins.str role_arn: Role ARN provided by AWS.
        :param builtins.str secret_key: Secret Key provided by AWS.
        :param builtins.str external_id: AWS IAM Role External ID. Used when setting up cross-account access to your ECR repositories.
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "repos", repos)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "secret_key", secret_key)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> builtins.str:
        """
        Access Key provided by AWS.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def repos(self) -> Sequence[builtins.str]:
        """
        List of ECR repositories.
        """
        return pulumi.get(self, "repos")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        Role ARN provided by AWS.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Secret Key provided by AWS.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[builtins.str]:
        """
        AWS IAM Role External ID. Used when setting up cross-account access to your ECR repositories.
        """
        return pulumi.get(self, "external_id")


@pulumi.output_type
class GetSecretKeypairResult(dict):
    def __init__(__self__, *,
                 passphrase: builtins.str,
                 public_key: builtins.str,
                 secret_key: builtins.str):
        """
        :param builtins.str passphrase: Passphrase for private key.
        :param builtins.str public_key: Public Key.
        :param builtins.str secret_key: Secret/Private Key.
        """
        pulumi.set(__self__, "passphrase", passphrase)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter
    def passphrase(self) -> builtins.str:
        """
        Passphrase for private key.
        """
        return pulumi.get(self, "passphrase")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> builtins.str:
        """
        Public Key.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> builtins.str:
        """
        Secret/Private Key.
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class GetSecretNatsAccountResult(dict):
    def __init__(__self__, *,
                 account_id: builtins.str,
                 private_key: builtins.str):
        """
        :param builtins.str account_id: Account ID.
        :param builtins.str private_key: Private Key.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> builtins.str:
        """
        Private Key.
        """
        return pulumi.get(self, "private_key")


@pulumi.output_type
class GetSecretOpaqueResult(dict):
    def __init__(__self__, *,
                 encoding: builtins.str,
                 payload: builtins.str):
        """
        :param builtins.str encoding: Available encodings: `plain`, `base64`. Default: `plain`.
        :param builtins.str payload: Plain text or base64 encoded string. Use `encoding` attribute to specify encoding.
        """
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter
    def encoding(self) -> builtins.str:
        """
        Available encodings: `plain`, `base64`. Default: `plain`.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def payload(self) -> builtins.str:
        """
        Plain text or base64 encoded string. Use `encoding` attribute to specify encoding.
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class GetSecretTlResult(dict):
    def __init__(__self__, *,
                 cert: builtins.str,
                 chain: builtins.str,
                 key: builtins.str):
        """
        :param builtins.str cert: Public Certificate.
        :param builtins.str chain: Chain Certificate.
        :param builtins.str key: Private Certificate.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "chain", chain)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def cert(self) -> builtins.str:
        """
        Public Certificate.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def chain(self) -> builtins.str:
        """
        Chain Certificate.
        """
        return pulumi.get(self, "chain")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Private Certificate.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetSecretUserpassResult(dict):
    def __init__(__self__, *,
                 encoding: builtins.str,
                 password: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str encoding: Available encodings: `plain`, `base64`. Default: `plain`.
        :param builtins.str password: Password.
        :param builtins.str username: Username.
        """
        pulumi.set(__self__, "encoding", encoding)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def encoding(self) -> builtins.str:
        """
        Available encodings: `plain`, `base64`. Default: `plain`.
        """
        return pulumi.get(self, "encoding")

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Username.
        """
        return pulumi.get(self, "username")


