/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import org.reldb.rel.exceptions.DatabaseFormatVersionException;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.interpreter.ClassPathHack;
import org.reldb.rel.v0.interpreter.Instance;
import org.reldb.rel.v0.interpreter.Interpreter;
import org.reldb.rel.v0.interpreter.ParseExceptionPrinter;
import org.reldb.rel.v0.languages.tutoriald.parser.ParseException;
import org.reldb.rel.v0.languages.tutoriald.parser.TokenMgrError;
import org.reldb.rel.v0.version.Version;

public class Rel {
    private Interpreter interpreter;
    private Instance instance;
    private PipedInputStream input;
    private PrintStream output;

    private static void buildClasspath() throws IOException {
        ClassPathHack.addFile(Version.getBerkeleyDbJarFilename());
        ClassPathHack.addFile("relshared.jar");
        ClassPathHack.addFile("ecj-4.4.2.jar");
    }

    public static void main(String[] args) throws IOException {
        Rel.buildClasspath();
        Instance.main(args);
    }

    public static void backup(String databaseDir, String backupFileName) throws IOException, ParseException, DatabaseFormatVersionException {
        Rel.buildClasspath();
        PrintStream output = new PrintStream(backupFileName);
        Instance instance = new Instance(databaseDir, false, output);
        Interpreter interpreter = new Interpreter(instance.getDatabase(), output);
        interpreter.interpret("BACKUP;");
        output.close();
        instance.dbclose();
    }

    public static void convertToLatestFormat(String databaseDir, PrintStream conversionOutput, String[] additionalJars) throws DatabaseFormatVersionException, IOException {
        Rel.buildClasspath();
        Instance.convertToLatestFormat(databaseDir, conversionOutput, additionalJars);
    }

    public Rel(String databaseDir, boolean createDbAllowed, String[] additionalJars) throws IOException, DatabaseFormatVersionException {
        Rel.buildClasspath();
        this.input = new PipedInputStream();
        PipedOutputStream pipeOutput = new PipedOutputStream(this.input);
        this.output = new PrintStream(pipeOutput, true);
        this.instance = new Instance(databaseDir, createDbAllowed, this.output, additionalJars);
        this.interpreter = new Interpreter(this.instance.getDatabase(), this.output);
        this.instance.announceActive(this.output);
        this.output.println("<EOT>");
    }

    public InputStream getServerResponseInputStream() throws IOException {
        return this.input;
    }

    private void send(Action action) throws IOException, ExceptionFatal {
        try {
            action.execute();
        }
        catch (ParseException pe) {
            this.interpreter.reset();
            this.output.println("ERROR: " + ParseExceptionPrinter.getParseExceptionMessage(pe));
        }
        catch (TokenMgrError tme) {
            this.interpreter.reset();
            this.output.println("ERROR: " + tme.getMessage());
        }
        catch (ExceptionSemantic es) {
            this.interpreter.reset();
            this.output.println("ERROR: " + es.getMessage());
        }
        catch (ExceptionFatal et) {
            this.interpreter.reset();
            this.output.println("ERROR: " + et.getMessage());
            et.printStackTrace(this.output);
            et.printStackTrace();
            throw et;
        }
        catch (Throwable t) {
            this.interpreter.reset();
            this.output.println("ERROR: " + t);
            t.printStackTrace(this.output);
            t.printStackTrace();
            throw t;
        }
        this.output.println("<EOT>");
    }

    public void sendEvaluate(final String source) throws IOException {
        this.send(new Action(){

            @Override
            public void execute() throws ParseException {
                Rel.this.interpreter.evaluate(source).toStream(Rel.this.output);
                Rel.this.output.println();
            }
        });
    }

    public void sendExecute(final String source) throws IOException {
        this.send(new Action(){

            @Override
            public void execute() throws ParseException {
                Rel.this.interpreter.interpret(source);
                Rel.this.output.println("\nOk.");
            }
        });
    }

    public void reset() {
        this.interpreter.reset();
        this.output.println();
        this.output.println("Cancel.");
    }

    public void close() {
        this.output.close();
    }

    private static abstract class Action {
        private Action() {
        }

        public abstract void execute() throws ParseException;
    }
}

