/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.external;

public abstract class BytestreamOutput {
    public abstract void put(int var1);

    private final void putUnsignedByte(int val) {
        this.put(val);
    }

    public void put(byte[] b) {
        int i = 0;
        while (i < b.length) {
            this.putUnsignedByte(b[i]);
            ++i;
        }
    }

    public void put(byte[] b, int offset, int length) {
        int count = 0;
        int i = offset;
        while (i < b.length && count++ < length) {
            this.putUnsignedByte(b[i]);
            ++i;
        }
    }

    private final void putUnsignedShort(short val) {
        this.putUnsignedByte((byte)(val >>> 8));
        this.putUnsignedByte((byte)val);
    }

    private final void putUnsignedInt(int val) {
        this.putUnsignedByte((byte)(val >>> 24));
        this.putUnsignedByte((byte)(val >>> 16));
        this.putUnsignedByte((byte)(val >>> 8));
        this.putUnsignedByte((byte)val);
    }

    private final void putUnsignedLong(long val) {
        this.putUnsignedByte((byte)(val >>> 56));
        this.putUnsignedByte((byte)(val >>> 48));
        this.putUnsignedByte((byte)(val >>> 40));
        this.putUnsignedByte((byte)(val >>> 32));
        this.putUnsignedByte((byte)(val >>> 24));
        this.putUnsignedByte((byte)(val >>> 16));
        this.putUnsignedByte((byte)(val >>> 8));
        this.putUnsignedByte((byte)val);
    }

    public final void putString(String val) {
        this.put(val.getBytes());
        this.putUnsignedByte(0);
    }

    public final void putbytes(byte[] b) {
        this.putInt(b.length);
        this.put(b);
    }

    public final void putChar(char val) {
        this.putUnsignedByte((byte)(val >>> 8));
        this.putUnsignedByte((byte)val);
    }

    public final void putChar(Character val) {
        this.putChar(val.charValue());
    }

    public final void putBoolean(boolean val) {
        this.putUnsignedByte((byte)(val ? 1 : 0));
    }

    public final void putBoolean(Boolean val) {
        this.putBoolean((boolean)val);
    }

    public final void putByte(int b) {
        b = b < 0 ? (b &= 0x7F) : (b |= 0xFFFFFF80);
        this.putUnsignedByte(b);
    }

    public final void putByte(Byte b) {
        this.putByte((int)b.byteValue());
    }

    public final void putShort(int s) {
        s = s < 0 ? (s &= Short.MAX_VALUE) : (s |= Short.MIN_VALUE);
        this.putUnsignedShort((short)s);
    }

    public final void putShort(Short s) {
        this.putShort((int)s.shortValue());
    }

    public final void putInt(long val) {
        val = val < 0L ? (val &= Integer.MAX_VALUE) : (val |= Integer.MIN_VALUE);
        this.putUnsignedInt((int)val);
    }

    public final void putInteger(Integer i) {
        this.putInt(i.intValue());
    }

    public final void putLong(long val) {
        val = val < 0L ? (val &= Long.MAX_VALUE) : (val |= Long.MIN_VALUE);
        this.putUnsignedLong(val);
    }

    public final void putLong(Long val) {
        this.putLong((long)val);
    }

    public final void putFloat(float val) {
        this.putUnsignedInt(Float.floatToIntBits(val));
    }

    public final void putFloat(Float val) {
        this.putFloat(val.floatValue());
    }

    public final void putDouble(double val) {
        this.putUnsignedLong(Double.doubleToLongBits(val));
    }

    public final void putDouble(Double val) {
        this.putDouble((double)val);
    }
}

