/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.external;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.external.BytestreamOutputArray;

public class DirClassLoader
extends ClassLoader {
    private static HashMap<String, Class<?>> loaded = new HashMap();
    private String dir;

    public DirClassLoader(String dir) {
        this.dir = dir;
    }

    public void unload(String name) {
        loaded.remove(name);
    }

    @Override
    public Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            Class<?> c = loaded.get(name);
            if (c == null) {
                byte[] b = this.loadClassData(name);
                c = this.defineClass(name, b, 0, b.length);
                loaded.put(name, c);
            }
            return c;
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findClass(name);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private File getClassFileName(String name) {
        name = name.replace('.', File.separatorChar);
        if (this.dir.endsWith(File.separator)) {
            return new File(String.valueOf(this.dir) + name + ".class");
        }
        return new File(String.valueOf(this.dir) + File.separator + name + ".class");
    }

    private byte[] loadClassData(String name) {
        File f = this.getClassFileName(name);
        BytestreamOutputArray bytes = new BytestreamOutputArray();
        try {
            int read;
            FileInputStream reader = new FileInputStream(f);
            byte[] b = new byte[65535];
            while ((read = reader.read(b)) >= 0) {
                bytes.put(b, 0, read);
            }
            reader.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new ExceptionFatal("RS0290: File " + f + " not found.");
        }
        catch (IOException ioe) {
            throw new ExceptionFatal("RS0291: Error reading " + f + ": " + ioe.toString());
        }
        return bytes.getBytes();
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        return new DirClassLoader(this.dir).loadClass(name);
    }
}

