/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.external;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinition;
import org.reldb.rel.v0.generator.OperatorDefinitionNative;
import org.reldb.rel.v0.generator.OperatorDefinitionNativeFunctionExternal;
import org.reldb.rel.v0.generator.OperatorDefinitionNativeProcedureExternal;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeOperator;
import org.reldb.rel.v0.types.builtin.TypeBoolean;
import org.reldb.rel.v0.types.builtin.TypeCharacter;
import org.reldb.rel.v0.types.builtin.TypeInteger;
import org.reldb.rel.v0.types.builtin.TypeRational;
import org.reldb.rel.v0.version.Version;

public class ForeignCompilerJava {
    private Generator generator;
    private boolean verbose;
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static String relCoreJar = null;

    public ForeignCompilerJava(Generator generator, boolean verbose) {
        this.generator = generator;
        this.verbose = verbose;
    }

    private synchronized String getLocalWebStartRelJarName() {
        if (relCoreJar != null) {
            return relCoreJar;
        }
        try {
            Enumeration<URL> e = this.getClass().getClassLoader().getResources(MANIFEST);
            while (e.hasMoreElements()) {
                String relCoreJarName;
                URL url = e.nextElement();
                if (!url.getFile().contains(Version.getCoreJarFilename()) || (relCoreJarName = ForeignCompilerJava.getLocalJarFilename(url)) == null) continue;
                relCoreJar = relCoreJarName;
                return relCoreJar;
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return null;
    }

    private static String getLocalJarFilename(URL remoteManifestFileName) {
        String urlStrManifest = remoteManifestFileName.getFile();
        String urlStrJar = urlStrManifest.substring(0, urlStrManifest.length() - MANIFEST.length() - 2);
        InputStream inputStreamJar = null;
        FileOutputStream fosJar = null;
        try {
            int bytesRead;
            URL urlJar = new URL(urlStrJar);
            inputStreamJar = urlJar.openStream();
            String strippedName = urlStrJar;
            int dotIndex = strippedName.lastIndexOf(46);
            if (dotIndex >= 0) {
                strippedName = strippedName.substring(0, dotIndex);
                strippedName = strippedName.replace("/", File.separator);
                int slashIndex = (strippedName = strippedName.replace("\\", File.separator)).lastIndexOf(File.separator);
                if (slashIndex >= 0) {
                    strippedName = strippedName.substring(slashIndex + 1);
                }
            }
            File tempJar = File.createTempFile(strippedName, ".jar");
            tempJar.deleteOnExit();
            fosJar = new FileOutputStream(tempJar);
            byte[] ba = new byte[1024];
            while ((bytesRead = inputStreamJar.read(ba)) >= 0) {
                fosJar.write(ba, 0, bytesRead);
            }
            String string = tempJar.getAbsolutePath();
            return string;
        }
        catch (Exception ioe) {
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
        finally {
            try {
                if (inputStreamJar != null) {
                    inputStreamJar.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fosJar != null) {
                    fosJar.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private String getPackagePrefix() {
        String thisPackageName = this.getClass().getPackage().getName();
        String relPackageName = thisPackageName.replace(".external", "");
        return relPackageName;
    }

    private static final String cleanClassPath(String s) {
        s = File.separatorChar == '/' ? s.replace('\\', '/') : s.replace('/', '\\');
        String outstr = "";
        StringTokenizer st = new StringTokenizer(s, File.pathSeparator);
        while (st.hasMoreElements()) {
            String element = (String)st.nextElement();
            File f = new File(element);
            if (!f.exists() || element.contains("deploy.jar")) continue;
            String fname = f.toString();
            if (fname.indexOf(32) >= 0) {
                fname = String.valueOf('\"') + fname + '\"';
            }
            outstr = String.valueOf(outstr) + (outstr.length() > 0 ? File.pathSeparator : "") + fname;
        }
        return outstr;
    }

    private String getLocalClasspath(RelDatabase database) {
        String classPath = String.valueOf(System.getProperty("user.dir")) + File.pathSeparatorChar + Version.getCoreJarFilename() + File.pathSeparatorChar + database.getJavaUserSourcePath() + File.pathSeparatorChar + database.getHomeDir();
        if (database.getAdditionalJarsForJavaCompilerClasspath() != null) {
            String[] stringArray = database.getAdditionalJarsForJavaCompilerClasspath();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.notify("ForeignCompilerJava: extra jar for classpath: " + path);
                classPath = String.valueOf(classPath) + File.pathSeparator + path;
                ++n2;
            }
        } else {
            this.notify("ForeignCompilerJava: no extra jars for classpath");
        }
        this.notify("ForeignCompilerJava: raw classpath is " + classPath);
        return classPath;
    }

    private static final String getJavaTypeForType(Generator generator, Type t) {
        if (t == null) {
            return "void";
        }
        return t.getValueClassname(generator);
    }

    private static final String getJavaPopForType(Generator generator, Type t) {
        if (t == null) {
            throw new ExceptionFatal("RS0292: Got null type in getJavaPopForType()");
        }
        return "(" + ForeignCompilerJava.getJavaTypeForType(generator, t) + ")context.pop()";
    }

    private static final String getJavaMethodParmsForParameters(Generator generator, OperatorSignature os) {
        String s = "Context context";
        int i = 0;
        while (i < os.getParmCount()) {
            s = String.valueOf(s) + ", " + ForeignCompilerJava.getJavaTypeForType(generator, os.getParameterType(i)) + " " + os.getParameterName(i);
            ++i;
        }
        return s;
    }

    private void compileForeignCode(RelDatabase database, PrintStream stream, String className, String src) {
        File sourcef;
        File resourceDir;
        ByteArrayOutputStream messageStream = new ByteArrayOutputStream();
        ByteArrayOutputStream warningStream = new ByteArrayOutputStream();
        String warningSetting = new String("allDeprecation,allJavadoc,assertIdentifier,charConcat,conditionAssign,constructorName,deprecation,emptyBlock,fieldHiding,finalBound,finally,indirectStatic,intfNonInherited,javadoc,localHiding,maskedCatchBlocks,noEffectAssign,pkgDefaultMethod,serial,semicolon,specialParamHiding,staticReceiver,syntheticAccess,unqualifiedField,unnecessaryElse,uselessTypeCheck,unsafe,unusedArgument,unusedImport,unusedLocal,unusedPrivate,unusedThrown");
        String classpath = String.valueOf(ForeignCompilerJava.cleanClassPath(System.getProperty("java.class.path"))) + File.pathSeparatorChar + ForeignCompilerJava.cleanClassPath(this.getLocalClasspath(database));
        String webclasspath = this.getLocalWebStartRelJarName();
        if (webclasspath != null) {
            classpath = String.valueOf(classpath) + File.pathSeparatorChar + webclasspath;
        }
        if (!(resourceDir = new File(database.getJavaUserSourcePath())).exists()) {
            resourceDir.mkdirs();
        }
        try {
            sourcef = new File(String.valueOf(database.getJavaUserSourcePath()) + File.separator + ForeignCompilerJava.getStrippedClassname(className) + ".java");
            PrintStream sourcePS = new PrintStream(new FileOutputStream(sourcef));
            sourcePS.print(src);
            sourcePS.close();
        }
        catch (IOException ioe) {
            throw new ExceptionFatal("RS0293: Unable to save Java source: " + ioe.toString());
        }
        this.notify("ForeignCompilerJava: classpath = " + classpath);
        boolean compiled = BatchCompiler.compile((String)("-1.8 -source 1.8 -warn:" + warningSetting + " " + "-cp " + classpath + " " + sourcef), (PrintWriter)new PrintWriter(messageStream), (PrintWriter)new PrintWriter(warningStream), (CompilationProgress)new CompilationProgress(){

            public void begin(int arg0) {
            }

            public void done() {
            }

            public boolean isCanceled() {
                return false;
            }

            public void setTaskName(String arg0) {
                ForeignCompilerJava.this.notify(arg0);
            }

            public void worked(int arg0, int arg1) {
            }
        });
        String compilerMessages = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(messageStream.toByteArray())));
        while (true) {
            String str = null;
            try {
                str = br.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (str == null) break;
            compilerMessages = String.valueOf(compilerMessages) + str + '\n';
        }
        BufferedReader brWarnings = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(warningStream.toByteArray())));
        while (true) {
            String str = null;
            try {
                str = brWarnings.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (str == null) break;
            compilerMessages = String.valueOf(compilerMessages) + str + '\n';
        }
        if (!compiled) {
            throw new ExceptionSemantic("RS0005: Compilation failed due to errors: \n" + compilerMessages + "\n");
        }
    }

    private static String getStrippedName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot >= 0) {
            return name.substring(lastDot + 1);
        }
        return name;
    }

    private static String getStrippedClassname(String name) {
        return ForeignCompilerJava.getStrippedName(name);
    }

    private Type getTypeForClassName(Generator generator, String className) {
        if (className.equals(String.valueOf(this.getPackagePrefix()) + ".values.ValueBoolean")) {
            return TypeBoolean.getInstance();
        }
        if (className.equals(String.valueOf(this.getPackagePrefix()) + ".values.ValueCharacter")) {
            return TypeCharacter.getInstance();
        }
        if (className.equals(String.valueOf(this.getPackagePrefix()) + ".values.ValueInteger")) {
            return TypeInteger.getInstance();
        }
        if (className.equals(String.valueOf(this.getPackagePrefix()) + ".values.ValueRational")) {
            return TypeRational.getInstance();
        }
        if (className.equals(String.valueOf(this.getPackagePrefix()) + ".values.ValueObject")) {
            return TypeInteger.getInstance();
        }
        if (className.equals(String.valueOf(this.getPackagePrefix()) + ".values.ValueOperator")) {
            return TypeOperator.getInstance();
        }
        return generator.locateType(ForeignCompilerJava.getStrippedClassname(className));
    }

    private void notify(String s) {
        if (this.verbose) {
            System.out.println(s);
        }
    }

    private Type getTypeForClass(Class<?> c) {
        return this.getTypeForClassName(this.generator, c.getName());
    }

    private void addSelectorForClass(Class<?> c, Constructor<?> con) {
        String name = this.getTypeForClass(c).getValueClassname(this.generator);
        OperatorSignature sig = new OperatorSignature(name);
        Class<?>[] rawParameters = con.getParameterTypes();
        if (rawParameters.length == 0) {
            return;
        }
        sig.setReturnType(this.getTypeForClass(c));
        if (sig.getReturnType() == null) {
            throw new ExceptionSemantic("RS0006:  Unable to create selector for TYPE " + c.getName());
        }
        String arguments = "context.getGenerator()";
        if (!rawParameters[0].toString().equals("class " + Generator.class.getCanonicalName())) {
            this.notify("x Constructor " + con + " of " + c + " not implemented as OPERATOR due to missing first parameter of type " + Generator.class.getCanonicalName());
            return;
        }
        int i = 1;
        while (i < rawParameters.length) {
            if (rawParameters[i].isPrimitive()) {
                this.notify("x Constructor " + con + " of " + c + " not implemented as selector due to primitive parameter type.");
                return;
            }
            Type t = this.getTypeForClass(rawParameters[i]);
            if (t == null) {
                this.notify("x Constructor " + con + " of " + c + " not implemented as selector due to unrecognised parameter type " + rawParameters[i].toString());
                return;
            }
            String parmName = "p" + i;
            sig.addParameter("p" + i, t);
            arguments = String.valueOf(arguments) + (arguments.length() > 0 ? ", " : "") + parmName;
            ++i;
        }
        String language = "Java";
        String typeName = ForeignCompilerJava.getStrippedClassname(c.getName());
        String src = "return new " + typeName + "(" + arguments + ");";
        this.notify("* Constructor " + con + " of " + c + " implemented as selector OPERATOR " + sig);
        OperatorDefinition newOp = this.compileForeignOperator(sig, language, src);
        newOp.setCreatedByType(typeName);
        newOp.getReferences().addReferenceToType(typeName);
        this.generator.addOperator(newOp);
    }

    private void addOperatorForClass(Class<?> c, Method m) {
        String name = Modifier.isStatic(m.getModifiers()) ? m.getName() : "THE_" + m.getName();
        OperatorSignature sig = new OperatorSignature(name);
        Class<?>[] rawParameters = m.getParameterTypes();
        Class<?> rawReturnType = m.getReturnType();
        if (rawReturnType.isPrimitive()) {
            this.notify("x Method " + m + " of " + c + " not implemented as OPERATOR due to primitive return type.");
            return;
        }
        Type returnType = this.getTypeForClass(rawReturnType);
        if (returnType == null) {
            this.notify("x Method " + m + " of " + c + " not implemented as OPERATOR due to unrecognised return type.");
            return;
        }
        sig.setReturnType(returnType);
        Type instanceType = this.getTypeForClass(c);
        if (instanceType == null) {
            throw new ExceptionSemantic("RS0007: Java type " + c + " not recognised.");
        }
        String arguments = "context.getGenerator()";
        if (!Modifier.isStatic(m.getModifiers())) {
            sig.addParameter("px", this.getTypeForClass(c));
        } else if (!rawParameters[0].toString().equals("class " + Generator.class.getCanonicalName())) {
            this.notify("x Method " + m + " of " + c + " not implemented as OPERATOR due to missing first parameter of type " + Generator.class.getCanonicalName());
            return;
        }
        int i = 1;
        while (i < rawParameters.length) {
            String parmName = "p" + i;
            if (rawParameters[i].isPrimitive()) {
                this.notify("x Method " + m + " of " + c + " not implemented as OPERATOR due to primitive parameter type.");
                return;
            }
            Type t = this.getTypeForClass(rawParameters[i]);
            if (t == null) {
                this.notify("x Method " + m + " of " + c + " not implemented as OPERATOR due to unrecognised parameter type " + rawParameters[i].toString());
                return;
            }
            sig.addParameter(parmName, t);
            arguments = String.valueOf(arguments) + (arguments.length() > 0 ? ", " : "") + parmName;
            ++i;
        }
        String language = "Java";
        String typeName = ForeignCompilerJava.getStrippedClassname(c.getName());
        String returnStr = returnType == null ? "" : "return ";
        String src = Modifier.isStatic(m.getModifiers()) ? String.valueOf(returnStr) + typeName + "." + m.getName() + "(" + arguments + ");" : String.valueOf(returnStr) + "px." + m.getName() + "(" + arguments + ");";
        this.notify("* Method " + m + " of " + c + " implemented as OPERATOR " + sig);
        OperatorDefinition newOp = this.compileForeignOperator(sig, language, src);
        newOp.setCreatedByType(typeName);
        newOp.getReferences().addReferenceToType(typeName);
        this.generator.addOperator(newOp);
    }

    private void addOperatorsForClass(Class<?> c) {
        try {
            Executable[] executableArray = c.getDeclaredConstructors();
            int n = executableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = executableArray[n2];
                this.addSelectorForClass(c, constructor);
                ++n2;
            }
            executableArray = c.getDeclaredMethods();
            n = executableArray.length;
            n2 = 0;
            while (n2 < n) {
                Executable method = executableArray[n2];
                this.addOperatorForClass(c, (Method)method);
                ++n2;
            }
        }
        catch (Throwable t) {
            throw new ExceptionSemantic("RS0008: Unable to add operators for " + c.getName() + ": " + t.toString());
        }
    }

    public void compileForeignType(String name, String language, String src) {
        if (!language.equals("Java")) {
            throw new ExceptionSemantic("RS0009: " + language + " is not recognised as a foreign language.");
        }
        String body = src.replace("\n", "\n\t");
        src = "package " + RelDatabase.getRelUserCodePackage() + ";\n\n" + "import " + this.getPackagePrefix() + ".vm.*;\n" + "import " + this.getPackagePrefix() + ".types.*;\n" + "import " + this.getPackagePrefix() + ".types.builtin.*;\n" + "import " + this.getPackagePrefix() + ".types.userdefined.*;\n" + "import " + this.getPackagePrefix() + ".values.*;\n" + "import " + this.getPackagePrefix() + ".generator.Generator;\n\n" + "public class " + name + " extends ValueTypeJava {\n" + body + "\n}";
        this.compileForeignCode(this.generator.getDatabase(), this.generator.getPrintStream(), name, src);
        try {
            Class<?> typeClass = this.generator.getDatabase().loadClass(name);
            if (typeClass == null) {
                throw new ExceptionSemantic("RS0010: Despite having been compiled, " + name + " could not be loaded.");
            }
            this.notify("> Java class " + typeClass.getName() + " loaded to implement type " + name);
            Constructor<?> ctor = typeClass.getConstructor(Generator.class);
            if (ctor == null) {
                throw new ExceptionSemantic("RS0011: Unable to find a constructor of the form " + name + "(Generator generator)");
            }
            this.generator.addTypeInProgress(name, (Type)ctor.newInstance(this.generator));
            this.addOperatorsForClass(typeClass);
        }
        catch (Throwable thrown) {
            throw new ExceptionSemantic("RS0012: Creation of type " + name + " failed: " + thrown.toString());
        }
    }

    public OperatorDefinition compileForeignOperator(OperatorSignature signature, String language, String src) {
        if (!language.equals("Java")) {
            throw new ExceptionSemantic("RS0013: " + language + " is not recognised as a foreign language.");
        }
        String comp = "package " + RelDatabase.getRelUserCodePackage() + ";\n\n" + "import " + this.getPackagePrefix() + ".types.*;\n" + "import " + this.getPackagePrefix() + ".types.builtin.*;\n" + "import " + this.getPackagePrefix() + ".types.userdefined.*;\n" + "import " + this.getPackagePrefix() + ".values.*;\n" + "import " + this.getPackagePrefix() + ".vm.Context;\n\n" + "public class " + ForeignCompilerJava.getStrippedClassname(signature.getClassSignature()) + " {\n" + "\tprivate static final " + ForeignCompilerJava.getJavaTypeForType(this.generator, signature.getReturnType()) + " " + "do_" + ForeignCompilerJava.getStrippedName(signature.getName()) + "(" + ForeignCompilerJava.getJavaMethodParmsForParameters(this.generator, signature) + ") {\n" + "\t\t" + src.replace("\n", "\n\t\t") + "\n\t}\n\n" + "\tpublic static final void execute(Context context) {\n";
        String args = "context";
        Type[] parmTypes = signature.getParameterTypes();
        int i = parmTypes.length - 1;
        while (i >= 0) {
            comp = String.valueOf(comp) + "\t\t" + ForeignCompilerJava.getJavaTypeForType(this.generator, parmTypes[i]) + " " + "p" + i + " = " + ForeignCompilerJava.getJavaPopForType(this.generator, parmTypes[i]) + ";\n";
            args = String.valueOf(args) + ", p" + (parmTypes.length - i - 1);
            --i;
        }
        comp = signature.getReturnType() != null ? String.valueOf(comp) + "\t\tcontext.push(do_" + ForeignCompilerJava.getStrippedName(signature.getName()) + "(" + args + "));\n" : String.valueOf(comp) + "\tdo_" + ForeignCompilerJava.getStrippedName(signature.getName()) + "(" + args + ");\n";
        comp = String.valueOf(comp) + "\t}\n}";
        this.compileForeignCode(this.generator.getDatabase(), this.generator.getPrintStream(), signature.getClassSignature(), comp);
        this.notify("> Java class " + signature.getClassSignature() + " compiled to implement OPERATOR " + signature);
        Method method = this.generator.getDatabase().getMethod(signature);
        OperatorDefinitionNative o = signature.getReturnType() != null ? new OperatorDefinitionNativeFunctionExternal(signature, method) : new OperatorDefinitionNativeProcedureExternal(signature, method);
        o.setSourceCode(String.valueOf(signature.getOperatorDeclaration()) + " " + language + " FOREIGN " + src + "\nEND OPERATOR;");
        return o;
    }
}

