/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.SlotScoped;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.vm.CellMutableFactory;
import org.reldb.rel.v0.vm.instructions.core.OpVariableGet;
import org.reldb.rel.v0.vm.instructions.core.OpVariableInitialise;

public class Constant
extends SlotScoped {
    private boolean initialised = false;
    private static CellMutableFactory variableFactory = new CellMutableFactory();

    public Constant(int depth, int offset, Type type) {
        super(depth, offset, type);
    }

    @Override
    public void compileGet(Generator generator) {
        if (!this.initialised) {
            throw new ExceptionSemantic("RS0014: Attempt to access uninitialised constant.");
        }
        generator.compileInstruction(new OpVariableGet(this.getDepth(), this.getOffset()));
    }

    @Override
    public void compileSet(Generator generator) {
        if (this.initialised) {
            throw new ExceptionSemantic("RS0015: Attempt to assign a value to a constant.");
        }
    }

    @Override
    public void compileInitialise(Generator generator) {
        generator.compileInstruction(new OpVariableInitialise(this.getDepth(), this.getOffset(), variableFactory));
        this.initialised = true;
    }
}

