/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import java.util.TreeMap;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;

public class EnvironmentSettings {
    private TreeMap<String, Attribute> attributes = new TreeMap();
    private static EnvironmentSettings environmentSetter = null;

    private EnvironmentSettings() {
        Attribute verboseExternalCompilation = new Attribute("VerboseExternalCompilation");
        new Value(verboseExternalCompilation, "On", "Verbose compilation of external operators and types."){

            @Override
            void setter(Generator generator) {
                generator.setVerboseExternalCompilation(true);
            }
        };
        new Value(verboseExternalCompilation, "Off", "Silent compilation of external operators and types. (Default)"){

            @Override
            void setter(Generator generator) {
                generator.setVerboseExternalCompilation(false);
            }
        };
        Attribute verboseRelvarUpdates = new Attribute("VerboseRelvarUpdates");
        new Value(verboseRelvarUpdates, "On", "Updates to relvars will report number of tuples updated. (Default)"){

            @Override
            void setter(Generator generator) {
                generator.setVerboseRelvarUpdates(true);
            }
        };
        new Value(verboseRelvarUpdates, "Off", "Updates to relvars will not report number of tuples updated."){

            @Override
            void setter(Generator generator) {
                generator.setVerboseRelvarUpdates(false);
            }
        };
    }

    private String getUsage() {
        String out = "";
        for (Attribute attribute : this.attributes.values()) {
            out = String.valueOf(out) + attribute.getUsage();
        }
        return "\n" + out;
    }

    private Attribute findAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public static void set(Generator generator, String attribute, String value) {
        Attribute a;
        if (environmentSetter == null) {
            environmentSetter = new EnvironmentSettings();
        }
        if ((a = environmentSetter.findAttribute(attribute)) == null) {
            throw new ExceptionSemantic("RS0016: Unknown attribute '" + attribute + "'.  Available attributes are: " + environmentSetter.getUsage());
        }
        Value v = a.findValue(value);
        if (v == null) {
            throw new ExceptionSemantic("RS0017: Unknown value '" + value + "'.  Available values are: " + a.getUsage());
        }
        v.setter(generator);
    }

    private class Attribute {
        private String name;
        private TreeMap<String, Value> values = new TreeMap();

        Attribute(String name) {
            this.name = name;
            EnvironmentSettings.this.attributes.put(name, this);
        }

        void add(Value value) {
            this.values.put(value.getValue(), value);
        }

        String getName() {
            return this.name;
        }

        Value findValue(String valueName) {
            return this.values.get(valueName);
        }

        String getUsage() {
            String out = "";
            for (Value value : this.values.values()) {
                out = String.valueOf(out) + "\n" + this.getName() + " " + value.getValue() + ": " + value.getDescription();
            }
            return out;
        }
    }

    private static abstract class Value {
        private String value;
        private String description;

        Value(Attribute attribute, String value, String description) {
            this.value = value;
            this.description = description;
            attribute.add(this);
        }

        String getValue() {
            return this.value;
        }

        String getDescription() {
            return this.description;
        }

        abstract void setter(Generator var1);
    }
}

