/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.debuginfo.DebugInfo;
import org.reldb.rel.v0.external.ForeignCompilerJava;
import org.reldb.rel.v0.generator.EnvironmentSettings;
import org.reldb.rel.v0.generator.OperatorDefinition;
import org.reldb.rel.v0.generator.OperatorDefinitionNativeFunction;
import org.reldb.rel.v0.generator.OperatorDefinitionRel;
import org.reldb.rel.v0.generator.OperatorInvocation;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.generator.References;
import org.reldb.rel.v0.generator.SelectAttributes;
import org.reldb.rel.v0.generator.SelectOrder;
import org.reldb.rel.v0.generator.Slot;
import org.reldb.rel.v0.generator.SlotScoped;
import org.reldb.rel.v0.interpreter.TutorialDParser;
import org.reldb.rel.v0.languages.tutoriald.BaseASTNode;
import org.reldb.rel.v0.languages.tutoriald.parser.Token;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.Relvar;
import org.reldb.rel.v0.storage.relvars.RelvarCustomMetadata;
import org.reldb.rel.v0.storage.relvars.RelvarDefinition;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.storage.relvars.RelvarInProgress;
import org.reldb.rel.v0.storage.relvars.RelvarMetadata;
import org.reldb.rel.v0.storage.relvars.RelvarPrivate;
import org.reldb.rel.v0.storage.relvars.RelvarRealMetadata;
import org.reldb.rel.v0.storage.relvars.RelvarVirtualMetadata;
import org.reldb.rel.v0.storage.tables.TableExternal;
import org.reldb.rel.v0.types.Attribute;
import org.reldb.rel.v0.types.AttributeMap;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.JoinMap;
import org.reldb.rel.v0.types.OrderMap;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.TypeArray;
import org.reldb.rel.v0.types.TypeHeading;
import org.reldb.rel.v0.types.TypeOperator;
import org.reldb.rel.v0.types.TypeRelation;
import org.reldb.rel.v0.types.TypeTuple;
import org.reldb.rel.v0.types.builtin.TypeBoolean;
import org.reldb.rel.v0.types.builtin.TypeCharacter;
import org.reldb.rel.v0.types.builtin.TypeInteger;
import org.reldb.rel.v0.types.userdefined.DerivedPossrep;
import org.reldb.rel.v0.types.userdefined.Possrep;
import org.reldb.rel.v0.types.userdefined.PossrepComponent;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAlpha;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRational;
import org.reldb.rel.v0.values.ValueRelationLiteral;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Instruction;
import org.reldb.rel.v0.vm.NativeFunction;
import org.reldb.rel.v0.vm.Operator;
import org.reldb.rel.v0.vm.instructions.array.OpArrayAppend;
import org.reldb.rel.v0.vm.instructions.array.OpArrayFor;
import org.reldb.rel.v0.vm.instructions.array.OpArrayGet;
import org.reldb.rel.v0.vm.instructions.array.OpArrayProject;
import org.reldb.rel.v0.vm.instructions.array.OpArraySet;
import org.reldb.rel.v0.vm.instructions.array.OpArrayToArray;
import org.reldb.rel.v0.vm.instructions.array.OpArrayToRelation;
import org.reldb.rel.v0.vm.instructions.core.OpAdd;
import org.reldb.rel.v0.vm.instructions.core.OpAverage;
import org.reldb.rel.v0.vm.instructions.core.OpBranchIfFalse;
import org.reldb.rel.v0.vm.instructions.core.OpConcatenate;
import org.reldb.rel.v0.vm.instructions.core.OpDuplicate;
import org.reldb.rel.v0.vm.instructions.core.OpDuplicateUnder;
import org.reldb.rel.v0.vm.instructions.core.OpExactly;
import org.reldb.rel.v0.vm.instructions.core.OpGetTemporarilyUniqueInteger;
import org.reldb.rel.v0.vm.instructions.core.OpInvokeAnonymousEvaluate;
import org.reldb.rel.v0.vm.instructions.core.OpInvokeDynamicCall;
import org.reldb.rel.v0.vm.instructions.core.OpInvokeDynamicEvaluate;
import org.reldb.rel.v0.vm.instructions.core.OpJump;
import org.reldb.rel.v0.vm.instructions.core.OpLte;
import org.reldb.rel.v0.vm.instructions.core.OpOutput;
import org.reldb.rel.v0.vm.instructions.core.OpPop;
import org.reldb.rel.v0.vm.instructions.core.OpPreserveContextInValueOperator;
import org.reldb.rel.v0.vm.instructions.core.OpPushLiteral;
import org.reldb.rel.v0.vm.instructions.core.OpReturn;
import org.reldb.rel.v0.vm.instructions.core.OpReturnValue;
import org.reldb.rel.v0.vm.instructions.core.OpSwap;
import org.reldb.rel.v0.vm.instructions.core.OpWrite;
import org.reldb.rel.v0.vm.instructions.core.OpWriteRaw;
import org.reldb.rel.v0.vm.instructions.core.OpWriteln;
import org.reldb.rel.v0.vm.instructions.core.OpWritelnNoExpression;
import org.reldb.rel.v0.vm.instructions.ddl.OpAlterVarRealAlterKey;
import org.reldb.rel.v0.vm.instructions.ddl.OpAlterVarRealChangeAttributeType;
import org.reldb.rel.v0.vm.instructions.ddl.OpAlterVarRealDropAttribute;
import org.reldb.rel.v0.vm.instructions.ddl.OpAlterVarRealInsertAttributes;
import org.reldb.rel.v0.vm.instructions.ddl.OpAlterVarRealRenameAttribute;
import org.reldb.rel.v0.vm.instructions.ddl.OpCreateConstraint;
import org.reldb.rel.v0.vm.instructions.ddl.OpCreateExternalRelvar;
import org.reldb.rel.v0.vm.instructions.ddl.OpCreateOperator;
import org.reldb.rel.v0.vm.instructions.ddl.OpCreateRealRelvar;
import org.reldb.rel.v0.vm.instructions.ddl.OpCreateType;
import org.reldb.rel.v0.vm.instructions.ddl.OpCreateVirtualRelvar;
import org.reldb.rel.v0.vm.instructions.ddl.OpDropConstraint;
import org.reldb.rel.v0.vm.instructions.ddl.OpDropOperator;
import org.reldb.rel.v0.vm.instructions.ddl.OpDropRelvar;
import org.reldb.rel.v0.vm.instructions.ddl.OpDropType;
import org.reldb.rel.v0.vm.instructions.possrep.OpPossrepGetComponent;
import org.reldb.rel.v0.vm.instructions.possrep.OpPossrepSetComponent;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationDUnion;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationGetTuple;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationIMinus;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationIntersect;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationJoin;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationLiteralInsertTuple;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationMinus;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationProduct;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationPushLiteral;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationTClose;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationUngroup;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationUnion;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationWhere;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationWrite;
import org.reldb.rel.v0.vm.instructions.relation.OpRelationXunion;
import org.reldb.rel.v0.vm.instructions.relation.OpTupleInRelation;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarDeleteGivenExpression;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarDeleteWhere;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarGlobalGet;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarIDelete;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarInsert;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarInsertNoDuplicates;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarPurge;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarUpdate;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarUpdateWhere;
import org.reldb.rel.v0.vm.instructions.system.OpBackup;
import org.reldb.rel.v0.vm.instructions.system.OpCheckConstraintsAndCommitOrRollback;
import org.reldb.rel.v0.vm.instructions.system.OpExecute;
import org.reldb.rel.v0.vm.instructions.system.OpTransactionBegin;
import org.reldb.rel.v0.vm.instructions.system.OpTransactionCommit;
import org.reldb.rel.v0.vm.instructions.system.OpTransactionRollback;
import org.reldb.rel.v0.vm.instructions.tuple.OpTupleGetAttribute;
import org.reldb.rel.v0.vm.instructions.tuple.OpTupleJoin;
import org.reldb.rel.v0.vm.instructions.tuple.OpTupleJoinDisjoint;
import org.reldb.rel.v0.vm.instructions.tuple.OpTupleProject;
import org.reldb.rel.v0.vm.instructions.tuple.OpTuplePushLiteral;
import org.reldb.rel.v0.vm.instructions.tuple.OpTupleSetAttribute;
import org.reldb.rel.v0.vm.instructions.tupleIteratable.OpTupleIteratableMap;
import org.reldb.rel.v0.vm.instructions.tupleIteratable.OpTupleIteratableOrder;
import org.reldb.rel.v0.vm.instructions.tupleIteratable.OpTupleIteratableProject;

public class Generator {
    private String userRelvarOwner = "User";
    private boolean compiling = true;
    private boolean persistentOnly = false;
    private RelDatabase database;
    private TutorialDParser parser;
    private OperatorDefinition currentOperatorDefinition;
    private int interactiveOperatorNestingDepth;
    private int assignmentNestingLevel = 0;
    private int compilingOffNestingLevel = 0;
    private int persistentOnlyNestingLevel = 0;
    private PrintStream printStream;
    private References globalReferenceCollector = null;
    private HashMap<String, RelvarDefinition> relvarsInProgress = new HashMap();
    private HashMap<String, Type> typesInProgress = new HashMap();
    private boolean verboseExternalOperatorTypeGeneration = false;
    private boolean verboseRelvarUpdates = true;
    private int retrievingTypeCount = 0;
    private Type lastRetrievedType = null;
    private static boolean inSelectValue = false;
    private int parmNameSerialNumber = 0;
    private static int summarizeParmNameSerial = 0;
    private static int summarizeItemNameSerial = 0;
    private static int extendTupleNameSerial = 0;

    public Generator(RelDatabase database, PrintStream outputStream) {
        this.database = database;
        this.parser = null;
        this.printStream = outputStream;
        this.initialise();
    }

    private void initialise() {
        this.compiling = true;
        this.persistentOnly = false;
        this.assignmentNestingLevel = 0;
        this.compilingOffNestingLevel = 0;
        this.persistentOnlyNestingLevel = 0;
        this.currentOperatorDefinition = null;
        this.globalReferenceCollector = null;
        this.operatorDefinition("Root Operator Context");
        this.currentOperatorDefinition.setSpecial(true);
        this.interactiveOperatorNestingDepth = this.currentOperatorDefinition.getDepth();
    }

    public void reset() {
        this.database.rollbackTransactionIfThereIsOne();
        this.relvarsInProgress.clear();
        this.typesInProgress.clear();
        this.initialise();
    }

    public RelDatabase getDatabase() {
        return this.database;
    }

    public void setParser(TutorialDParser parser) {
        this.parser = parser;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void setOwner(String owner) {
        this.userRelvarOwner = owner;
    }

    public void beginCompilation() {
        this.operatorDefinition("Interactive Session");
        this.currentOperatorDefinition.setSpecial(true);
        this.interactiveOperatorNestingDepth = this.currentOperatorDefinition.getDepth();
    }

    public OperatorDefinition endCompilation() {
        OperatorDefinition mainOperatorDefinition = this.currentOperatorDefinition;
        this.endOperator();
        return mainOperatorDefinition;
    }

    public void setVerboseExternalCompilation(boolean b) {
        this.verboseExternalOperatorTypeGeneration = b;
    }

    public void setVerboseRelvarUpdates(boolean b) {
        this.verboseRelvarUpdates = b;
    }

    public boolean isVerboseRelvarUpdates() {
        return this.verboseRelvarUpdates;
    }

    public void setCompilingOn() {
        if (--this.compilingOffNestingLevel == 0) {
            this.compiling = true;
        }
    }

    public void setCompilingOff() {
        if (this.compilingOffNestingLevel++ == 0) {
            this.compiling = false;
        }
    }

    private DebugInfo getDebugInfo() {
        if (this.parser != null) {
            return new DebugInfo(this.parser.getCurrentNode(), this.getOperatorDefinitionLineReferenceStack(this.parser.getCurrentNode().first_token.beginLine));
        }
        return new DebugInfo("unknown location");
    }

    public void compileInstruction(Instruction instruction) {
        if (this.compiling) {
            this.currentOperatorDefinition.compile(this.getDebugInfo(), instruction);
        }
    }

    public void compileInstructionAt(Instruction instruction, int address) {
        if (this.compiling) {
            this.currentOperatorDefinition.compileAt(this.getDebugInfo(), instruction, address);
        }
    }

    private void compileCheckConstraintsAndCommitOrRollback() {
        this.compileInstruction(new OpCheckConstraintsAndCommitOrRollback());
    }

    private void beginAssignments() {
        this.compileTransactionBegin();
    }

    private void endAssignments() {
        this.compileCheckConstraintsAndCommitOrRollback();
    }

    public void beginAssignment() {
        if (this.assignmentNestingLevel++ == 0) {
            this.beginAssignments();
        }
    }

    public void endAssignment() {
        if (--this.assignmentNestingLevel == 0) {
            this.endAssignments();
        }
    }

    public void defineVariable(String varname, Type type) {
        this.currentOperatorDefinition.defineVariable(varname, type);
        this.compileVariableInitialise(varname);
    }

    public void defineConstant(String constname, Type type) {
        this.currentOperatorDefinition.defineConstant(constname, type);
        this.compileVariableInitialise(constname);
    }

    public void defineRelvarReal(String varname, RelvarHeading keydef, References references) {
        if (this.currentOperatorDefinition.getDepth() > this.interactiveOperatorNestingDepth) {
            throw new ExceptionSemantic("RS0018: REAL relation-valued variables may not be defined inside a user-defined operator.");
        }
        if (this.relvarsInProgress.containsKey(varname) || this.database.isRelvarExists(varname)) {
            throw new ExceptionSemantic("RS0019: " + varname + " already exists.");
        }
        RelvarDefinition relvar = new RelvarDefinition(varname, new RelvarRealMetadata(this.database, keydef, this.userRelvarOwner), references);
        this.relvarsInProgress.put(varname, relvar);
        this.beginAssignment();
        this.compileInstruction(new OpCreateRealRelvar(this.relvarsInProgress, relvar));
        this.compileVariableInitialise(varname);
        this.endAssignment();
    }

    public void defineRelvarPublic(String varname, RelvarHeading expectedKeydef) {
        RelvarMetadata metadata = this.database.getRelvarMetadata(varname);
        if (metadata == null) {
            throw new ExceptionSemantic("RS0020: Relation-valued variable '" + varname + "' does not exist.");
        }
        TypeRelation actualRelvarType = new TypeRelation(metadata.getHeadingDefinition(this.database).getHeading());
        if (!expectedKeydef.getHeading().canAccept(actualRelvarType.getHeading())) {
            throw new ExceptionSemantic("RS0021: Expected relation-valued variable '" + varname + "' to be " + new TypeRelation(expectedKeydef.getHeading()) + " but got " + actualRelvarType);
        }
        this.compileInstruction(new OpRelvarGlobalGet(varname, expectedKeydef));
        this.compileInstruction(new OpPop());
    }

    public void defineRelvarPrivate(String varname, RelvarHeading keydef) {
        this.currentOperatorDefinition.defineRelvarPrivate(this.database, varname, keydef);
        this.compileVariableInitialise(varname);
    }

    public void defineRelvarVirtual(String varname, String sourceCode, RelvarHeading keydef, References references) {
        if (this.currentOperatorDefinition.getDepth() > this.interactiveOperatorNestingDepth) {
            throw new ExceptionSemantic("RS0021: VIRTUAL relation-valued variables may not be defined inside a user-defined operator.");
        }
        if (this.relvarsInProgress.containsKey(varname) || this.database.isRelvarExists(varname)) {
            throw new ExceptionSemantic("RS0022: " + varname + " already exists.");
        }
        RelvarDefinition relvar = new RelvarDefinition(varname, new RelvarVirtualMetadata(this.database, sourceCode, keydef, this.userRelvarOwner), references);
        this.relvarsInProgress.put(varname, relvar);
        this.beginAssignment();
        this.compileInstruction(new OpCreateVirtualRelvar(this.relvarsInProgress, relvar));
        this.endAssignment();
    }

    public void defineRelvarExternal(String varname, String externalRelvarType, String externalRelvarSpecification, String duplicates) {
        TableExternal.DuplicateHandling handler = TableExternal.DuplicateHandling.AUTOKEY;
        if (duplicates.compareToIgnoreCase("DUP_REMOVE") == 0) {
            handler = TableExternal.DuplicateHandling.DUP_REMOVE;
        } else if (duplicates.compareToIgnoreCase("DUP_COUNT") == 0) {
            handler = TableExternal.DuplicateHandling.DUP_COUNT;
        } else if (duplicates.compareToIgnoreCase("AUTOKEY") == 0) {
            handler = TableExternal.DuplicateHandling.AUTOKEY;
        } else {
            throw new ExceptionSemantic("RS0023: Expected DUP_REMOVE or DUP_COUNT, found: " + duplicates);
        }
        if (this.currentOperatorDefinition.getDepth() > this.interactiveOperatorNestingDepth) {
            throw new ExceptionSemantic("RS0024: EXTERNAL relation-valued variables may not be defined inside a user-defined operator.");
        }
        if (this.relvarsInProgress.containsKey(varname) || this.database.isRelvarExists(varname)) {
            throw new ExceptionSemantic("RS0025: " + varname + " already exists.");
        }
        boolean typeIsRegistered = false;
        ArrayList<String> customTypes = this.database.getAllCustomTypes();
        for (String type : customTypes) {
            if (externalRelvarType.compareToIgnoreCase(type) != 0) continue;
            typeIsRegistered = true;
            try {
                RelvarDefinition relvar = new RelvarDefinition(varname, (RelvarCustomMetadata)Class.forName("Relplugins.relvars." + type.toUpperCase() + ".Relvar" + type.toUpperCase() + "Metadata").getConstructors()[0].newInstance(new Object[]{this.database, this.userRelvarOwner, externalRelvarSpecification, handler}), new References());
                this.relvarsInProgress.put(varname, relvar);
                this.beginAssignment();
                this.compileInstruction(new OpCreateExternalRelvar(this.relvarsInProgress, relvar));
                this.endAssignment();
            }
            catch (NoClassDefFoundError e) {
                throw new ExceptionSemantic("RS0026: " + e.toString());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                throw new ExceptionSemantic("RS0027: Loaded class has thrown an exception");
            }
            catch (ClassNotFoundException e) {
                throw new ExceptionSemantic("RS0028: class relvar " + type.toUpperCase() + " metadata expected but not found. Check if file exists and the name is correct");
            }
            catch (ClassCastException e) {
                throw new ExceptionSemantic("RS0029: Relvar " + type.toUpperCase() + " metadata does not extend RelvarCustomMetadata");
            }
        }
        if (!typeIsRegistered) {
            throw new ExceptionSemantic("RS0030: EXTERNAL relvar type '" + externalRelvarType + "' is not recognised.");
        }
    }

    public void dropRelvar(String varName) {
        if (!this.database.isRelvarExists(varName)) {
            throw new ExceptionSemantic("RS0031: " + varName + " is not defined.");
        }
        this.beginAssignment();
        this.compileInstruction(new OpDropRelvar(varName));
        this.endAssignment();
    }

    public Value getTypeOf(Heading heading, String headingIn) {
        Heading metaHeading = new Heading();
        metaHeading.add("AttrName", TypeCharacter.getInstance());
        metaHeading.add("AttrType", this.findType("TypeInfo"));
        ValueRelationLiteral attributes = new ValueRelationLiteral(this);
        for (Attribute attribute : heading.getAttributes()) {
            Value[] values = new Value[]{ValueCharacter.select(this, attribute.getName()), this.getTypeOf(attribute.getType())};
            ValueTuple metadataTuple = new ValueTuple(this, values);
            attributes.insert(metadataTuple);
        }
        ValueCharacter kind = ValueCharacter.select(this, headingIn);
        TypeAlpha typeNonScalar = (TypeAlpha)this.findType("NonScalar");
        ValueAlpha value = new ValueAlpha(this, typeNonScalar, new Value[]{kind, attributes}, 0);
        return value;
    }

    public Value getTypeOf(Type typeOfExpression) {
        if (typeOfExpression instanceof TypeHeading) {
            if (typeOfExpression instanceof TypeTuple) {
                Heading heading = ((TypeTuple)typeOfExpression).getHeading();
                return this.getTypeOf(heading, "TUPLE");
            }
            if (typeOfExpression instanceof TypeRelation) {
                Heading heading = ((TypeRelation)typeOfExpression).getHeading();
                return this.getTypeOf(heading, "RELATION");
            }
            if (typeOfExpression instanceof TypeArray) {
                Heading heading = ((TypeArray)typeOfExpression).getElementType().getHeading();
                return this.getTypeOf(heading, "ARRAY");
            }
            Heading heading = ((TypeRelation)typeOfExpression).getHeading();
            return this.getTypeOf(heading, typeOfExpression.getSignature());
        }
        ValueCharacter scalarSignature = ValueCharacter.select(this, typeOfExpression.getSignature());
        TypeAlpha typeScalar = (TypeAlpha)this.findType("Scalar");
        ValueAlpha value = new ValueAlpha(this, typeScalar, new Value[]{scalarSignature}, 0);
        return value;
    }

    public void addTypeInProgress(String typeName, Type type) {
        this.typesInProgress.put(typeName, type);
    }

    public void createTypeExternal(String typeName, String language, String source, References references) {
        if (this.database.isTypeExists(this, typeName)) {
            throw new ExceptionSemantic("RS0032: TYPE " + typeName + " already exists.");
        }
        new ForeignCompilerJava(this, this.verboseExternalOperatorTypeGeneration).compileForeignType(typeName, language, source);
        source = "TYPE " + typeName + " Java FOREIGN " + source + "\nEND TYPE;";
        this.beginAssignment();
        this.compileInstruction(new OpCreateType(typeName, source, this.userRelvarOwner, "Java", references, null));
        this.endAssignment();
    }

    public void beginTypeRetrieval() {
        ++this.retrievingTypeCount;
    }

    public Type endTypeRetrieval() {
        --this.retrievingTypeCount;
        return this.lastRetrievedType;
    }

    public void createTypeInternalForwardReference(TypeAlpha udt) {
        String typeName = udt.getTypeName();
        if (this.retrievingTypeCount == 0 && this.database.isTypeExists(this, typeName)) {
            throw new ExceptionSemantic("RS0033: TYPE " + typeName + " already exists.");
        }
        this.addTypeInProgress(udt.getTypeName(), udt);
    }

    private boolean isSbyC(TypeAlpha udt) {
        if (udt.hasSpecialisationConstraint()) {
            return true;
        }
        for (TypeAlpha subtype : udt.getSubtypes()) {
            if (!this.isSbyC(subtype)) continue;
            return true;
        }
        return false;
    }

    public TypeAlpha findMST(TypeAlpha udt, ValueAlpha value) {
        while (true) {
            try {
                for (TypeAlpha subtype : udt.getSubtypes()) {
                    if (!subtype.checkSpecialisationConstraint(this, value, this.database)) continue;
                    return this.findMST(subtype, value);
                }
                return udt;
            }
            catch (ConcurrentModificationException cme) {
                System.out.println("Generator: Attempting to recover from concurrent modification exception in findMST() caused by type(s) being loaded.");
                continue;
            }
            break;
        }
    }

    public ValueAlpha selectValue(TypeAlpha udt, ValueAlpha value) {
        if (inSelectValue) {
            return value;
        }
        inSelectValue = true;
        if (this.isSbyC(udt)) {
            value.setMST(this.findMST(udt, value));
        }
        inSelectValue = false;
        return value;
    }

    private void createTypeOperators(final TypeAlpha udt, String owner) {
        final String typeName = udt.getTypeName();
        if (udt.getPossrepCount() == 0) {
            if (udt.isSubtype() && udt.getSupertype().isBuiltin()) {
                References selectorReferenceToType = new References();
                selectorReferenceToType.addReferenceToType(typeName);
                selectorReferenceToType.addReferenceToType(udt.getSupertype().getTypeName());
                OperatorSignature selectorSignature = new OperatorSignature(typeName);
                selectorSignature.setReturnType(udt);
                selectorSignature.addParameterType(udt.getSupertype());
                new OperatorAssociatedWithType(this, typeName, owner, selectorSignature, selectorReferenceToType){

                    @Override
                    public Value evaluate(Value[] arguments) {
                        if (!((ValueAlpha)arguments[0]).getTypeName().equals(typeName)) {
                            throw new ExceptionSemantic("RS0034: Selector failed.  Argument is not of type '" + typeName + "'.");
                        }
                        return arguments[0];
                    }
                };
            }
        } else {
            int possrepAt = 0;
            while (possrepAt < udt.getPossrepCount()) {
                final int possrepNumber = possrepAt;
                final Possrep possrep = udt.getPossrep(possrepNumber);
                String selectorName = possrep.getName() == null ? typeName : possrep.getName();
                final OperatorSignature selectorSignature = new OperatorSignature(selectorName);
                selectorSignature.setReturnType(udt);
                References selectorReferenceToType = new References();
                selectorReferenceToType.addReferenceToType(typeName);
                int componentAt = 0;
                while (componentAt < possrep.getComponentCount()) {
                    PossrepComponent component = possrep.getComponent(componentAt);
                    selectorSignature.addParameter(component.getName(), component.getType());
                    selectorReferenceToType.addReferenceToType(component.getType().getSignature());
                    References theReferenceToType = new References();
                    theReferenceToType.addReferenceToType(typeName);
                    theReferenceToType.addReferenceToType(component.getType().getSignature());
                    final String theOperatorName = "THE_" + component.getName();
                    OperatorSignature theSignature = new OperatorSignature(theOperatorName);
                    theSignature.addParameter("%p0", udt);
                    theSignature.setReturnType(component.getType());
                    final int componentIndex = component.getComponentIndex();
                    new OperatorAssociatedWithType(this, typeName, owner, theSignature, theReferenceToType){

                        @Override
                        public Value evaluate(Value[] arguments) {
                            Value value = ((ValueAlpha)arguments[0]).getComponentValue(componentIndex);
                            if (value == null) {
                                throw new ExceptionSemantic("RS0036: The value for '" + theOperatorName + "' is undefined.");
                            }
                            return value;
                        }
                    };
                    ++componentAt;
                }
                if (!(possrep instanceof DerivedPossrep)) {
                    new OperatorAssociatedWithType(this, typeName, owner, selectorSignature, selectorReferenceToType){

                        @Override
                        public Value evaluate(Value[] arguments) {
                            ValueAlpha value = typeName.equals("CHARACTER") ? ValueCharacter.select(this, arguments[0].stringValue()) : (typeName.equals("BOOLEAN") ? ValueBoolean.select(this, arguments[0].booleanValue()) : (typeName.equals("INTEGER") ? ValueInteger.select(this, arguments[0].longValue()) : (typeName.equals("RATIONAL") ? ValueRational.select(this, arguments[0].doubleValue()) : new ValueAlpha(this, udt, arguments, possrepNumber))));
                            if (!possrep.checkConstraint(this, value, database)) {
                                throw new ExceptionSemantic("RS0037: Selector " + selectorSignature.toRelLookupString() + " violates POSSREP constraint in type '" + typeName + "'.");
                            }
                            possrep.runInitialiser(this, value, database);
                            if (this.isSbyC(udt)) {
                                if (!udt.checkSpecialisationConstraint(this, value, database)) {
                                    throw new ExceptionSemantic("RS0038: Selector " + selectorSignature.toRelLookupString() + " violates specialisation constraint in type '" + typeName + "'.");
                                }
                                value.setMST(this.findMST(udt, value));
                            }
                            return value;
                        }
                    };
                }
                ++possrepAt;
            }
        }
        References isReferenceToType = new References();
        isReferenceToType.addReferenceToType(typeName);
        OperatorSignature isSignature = new OperatorSignature("IS_" + typeName);
        isSignature.addParameter("%p0", udt.getRootType());
        isSignature.setReturnType(TypeBoolean.getInstance());
        new OperatorAssociatedWithType(this, typeName, owner, isSignature, isReferenceToType){

            @Override
            public Value evaluate(Value[] arguments) {
                if (this.isSbyC(udt)) {
                    return ValueBoolean.select(this, ((ValueAlpha)arguments[0]).getTypeName().equals(typeName));
                }
                Type type = ((ValueAlpha)arguments[0]).getType(this.getDatabase());
                return ValueBoolean.select(this, udt.canAccept(type));
            }
        };
        References treatReferenceToType = new References();
        treatReferenceToType.addReferenceToType(typeName);
        final String treatName = "TREAT_AS_" + typeName;
        OperatorSignature treatSignature = new OperatorSignature(treatName);
        treatSignature.addParameter("%p0", udt.getRootType());
        treatSignature.setReturnType(udt);
        new OperatorAssociatedWithType(this, typeName, owner, treatSignature, treatReferenceToType){

            @Override
            public Value evaluate(Value[] arguments) {
                if (this.isSbyC(udt)) {
                    if (!((ValueAlpha)arguments[0]).getTypeName().equals(typeName)) {
                        throw new ExceptionSemantic("RS0039: " + treatName + " failed.  Argument is not of type '" + typeName + "'.");
                    }
                    return arguments[0];
                }
                Type type = ((ValueAlpha)arguments[0]).getType(this.getDatabase());
                if (!udt.canAccept(type)) {
                    throw new ExceptionSemantic("RS0396: " + treatName + " failed.  Argument is not of type '" + typeName + "'.");
                }
                return arguments[0];
            }
        };
    }

    public Type createTypeInternal(TypeAlpha udt, String source, References references) {
        String typeName = udt.getTypeName();
        if (!(udt.getPossrepCount() != 0 || udt.isUnion() || udt.isSubtype() && udt.getSupertype().isBuiltin())) {
            throw new ExceptionSemantic("RS0040: A non-UNION type must define at least one POSSREP or be an immediate subtype of a built-in type.");
        }
        if (udt.getPossrepCount() > 1) {
            udt.checkPossrepInitialisation();
        }
        if (this.retrievingTypeCount == 0) {
            if (this.database.isTypeExists(this, typeName)) {
                throw new ExceptionSemantic("RS0041: TYPE " + typeName + " already exists.");
            }
            source = "TYPE " + typeName + " " + source + ";";
            this.beginAssignment();
            String superTypeName = udt.isSubtype() ? udt.getSupertype().getSignature() : null;
            this.compileInstruction(new OpCreateType(typeName, source, this.userRelvarOwner, "Rel", references, superTypeName));
            this.endAssignment();
        }
        this.createTypeOperators(udt, this.userRelvarOwner);
        this.lastRetrievedType = udt;
        return udt;
    }

    public void createTypeBuiltin(TypeAlpha udt) {
        String typeName = udt.getTypeName();
        this.createTypeOperators(udt, "Rel");
        if (this.retrievingTypeCount == 0) {
            this.beginAssignment();
            this.compileInstruction(new OpCreateType(typeName, "", "Rel", "System", new References(), null));
            this.endAssignment();
        }
    }

    public void dropType(String typeName) {
        if (!this.database.isTypeExists(this, typeName)) {
            throw new ExceptionSemantic("RS0042: TYPE " + typeName + " does not exist.");
        }
        this.beginAssignment();
        this.compileInstruction(new OpDropType(typeName));
        this.endAssignment();
    }

    private void checkRelvarIsGlobalPersistent(String varname) {
        RelvarMetadata metadata = this.database.getRelvarMetadata(varname);
        if (!(metadata instanceof RelvarRealMetadata)) {
            throw new ExceptionSemantic("RS0418: To ALTER VAR " + varname + ", it must be a REAL relvar.");
        }
    }

    public RelvarHeading alterVarRealRename(String varname, RelvarHeading relvarHeading, String oldAttributeName, String newAttributeName) {
        this.checkRelvarIsGlobalPersistent(varname);
        relvarHeading.renameAttribute(oldAttributeName, newAttributeName);
        this.beginAssignment();
        this.compileInstruction(new OpAlterVarRealRenameAttribute(varname, oldAttributeName, newAttributeName));
        this.endAssignment();
        return relvarHeading;
    }

    public RelvarHeading alterVarRealChangeType(String varname, RelvarHeading relvarHeading, String attributeName, Type newType) {
        this.checkRelvarIsGlobalPersistent(varname);
        relvarHeading.changeTypeAttribute(attributeName, newType);
        this.beginAssignment();
        this.compileInstruction(new OpAlterVarRealChangeAttributeType(varname, attributeName, newType));
        this.endAssignment();
        return relvarHeading;
    }

    public RelvarHeading alterVarRealInsertAttributes(String varname, RelvarHeading relvarHeading, Heading heading) {
        this.checkRelvarIsGlobalPersistent(varname);
        relvarHeading.insertAttributes(heading);
        this.beginAssignment();
        this.compileInstruction(new OpAlterVarRealInsertAttributes(varname, heading));
        this.endAssignment();
        return relvarHeading;
    }

    public RelvarHeading alterVarRealDropAttribute(String varname, RelvarHeading relvarHeading, String attributeName) {
        this.checkRelvarIsGlobalPersistent(varname);
        relvarHeading.dropAttribute(attributeName);
        this.beginAssignment();
        this.compileInstruction(new OpAlterVarRealDropAttribute(varname, attributeName));
        this.endAssignment();
        return relvarHeading;
    }

    public void alterVarRealAlterKey(String varname, RelvarHeading keydefs) {
        this.checkRelvarIsGlobalPersistent(varname);
        this.beginAssignment();
        this.compileInstruction(new OpAlterVarRealAlterKey(varname, keydefs));
        this.endAssignment();
    }

    public Operator beginConstraintDefinition() {
        this.setPersistentOnlyOn();
        OperatorDefinition constraintOperator = this.beginAnonymousOperator();
        this.setDeclaredReturnType(TypeBoolean.getInstance());
        return constraintOperator.getOperator();
    }

    public void endConstraintDefinition() {
        this.endOperator();
        this.setPersistentOnlyOff();
    }

    public void createConstraint(String constraintName, String sourceCode, Operator operator, References references) {
        if (this.database.isConstraintExists(constraintName)) {
            throw new ExceptionSemantic("RS0049: CONSTRAINT " + constraintName + " already exists.");
        }
        this.beginAssignment();
        this.compileInstruction(new OpCreateConstraint(constraintName, sourceCode, operator, this.userRelvarOwner, references));
        this.endAssignment();
    }

    public void dropConstraint(String constraintName) {
        if (!this.database.isConstraintExists(constraintName)) {
            throw new ExceptionSemantic("RS0050: CONSTRAINT " + constraintName + " does not exist.");
        }
        this.beginAssignment();
        this.compileInstruction(new OpDropConstraint(constraintName));
        this.endAssignment();
    }

    public void setGlobalReferenceCollector(References referenceCollector) {
        this.globalReferenceCollector = referenceCollector;
    }

    public Type locateType(String typeName) {
        Type type = this.typesInProgress.get(typeName);
        if (type == null) {
            type = this.database.loadType(this, typeName);
        }
        if (type != null && this.globalReferenceCollector != null) {
            this.globalReferenceCollector.addReferenceToType(typeName);
        }
        return type;
    }

    public Type findType(String typeName) {
        Type type = this.locateType(typeName);
        if (type == null) {
            ExceptionSemantic e = new ExceptionSemantic("RS0052: Type '" + typeName + "' has not been defined.");
            e.printStackTrace();
            throw e;
        }
        return type;
    }

    private Type[] possibleTypes(Type type) {
        if (type instanceof TypeAlpha) {
            Type[] subTypes = ((TypeAlpha)type).getSubtypes().toArray(new Type[0]);
            Type[] superTypes = ((TypeAlpha)type).getSupertypes().toArray(new Type[0]);
            Type[] allTypes = new Type[subTypes.length + superTypes.length + 1];
            allTypes[0] = type;
            System.arraycopy(subTypes, 0, allTypes, 1, subTypes.length);
            System.arraycopy(superTypes, 0, allTypes, subTypes.length + 1, superTypes.length);
            return allTypes;
        }
        return new Type[]{type};
    }

    private void addTypeSignatures(HashSet<OperatorSignature> invocations, OperatorSignature invocationSignature) {
        int parmCount = invocationSignature.getParmCount();
        Type[][] parameterTypes = new Type[parmCount][];
        Type returnType = invocationSignature.getReturnType();
        String name = invocationSignature.getName();
        int[] permuter = new int[parmCount];
        int i = 0;
        while (i < parmCount) {
            Type type = invocationSignature.getParameterType(i);
            parameterTypes[i] = this.possibleTypes(type);
            permuter[i] = 0;
            ++i;
        }
        block1: while (true) {
            OperatorSignature signature = new OperatorSignature(name);
            signature.setReturnType(returnType);
            int j = 0;
            while (j < parmCount) {
                signature.addParameterType(parameterTypes[j][permuter[j]]);
                ++j;
            }
            invocations.add(signature);
            j = 0;
            do {
                if (permuter[j] < parameterTypes[j].length - 1) {
                    int n = j;
                    permuter[n] = permuter[n] + 1;
                    continue block1;
                }
                permuter[j] = 0;
            } while (++j < parmCount);
            break;
        }
    }

    public HashSet<OperatorSignature> getPossibleTargetSignatures(OperatorDefinition startingOperator, OperatorSignature invocationSignature) {
        HashSet<OperatorSignature> invocations = new HashSet<OperatorSignature>();
        this.addTypeSignatures(invocations, invocationSignature);
        HashSet<OperatorSignature> sigs = new HashSet<OperatorSignature>();
        for (OperatorSignature invocation : invocations) {
            this.database.getPossibleTargetSignatures(sigs, this, invocation);
            startingOperator.getPossibleTargetOperators(sigs, invocation);
        }
        return sigs;
    }

    public OperatorDefinition locateOperator(OperatorDefinition startingOperator, OperatorSignature signature) {
        OperatorDefinition fn = startingOperator.getOperator(signature);
        if (fn == null) {
            fn = this.database.loadOperator(this, signature);
            if (fn == null) {
                return null;
            }
            if (this.globalReferenceCollector != null) {
                this.globalReferenceCollector.addReferenceToOperator(signature.toRelLookupString());
            }
        }
        return fn;
    }

    public OperatorDefinition locateOperator(OperatorSignature signature) {
        return this.locateOperator(this.currentOperatorDefinition, signature);
    }

    public OperatorInvocation findOperator(OperatorSignature signature) {
        if (signature.isPossiblyDynamicDispatch()) {
            return new OperatorInvocation(signature);
        }
        OperatorDefinition fn = this.locateOperator(signature);
        if (fn == null) {
            throw new ExceptionSemantic("RS0053: Operator '" + signature + "' has not been defined.");
        }
        return new OperatorInvocation(fn);
    }

    public Type compileEvaluate(OperatorDefinition operator) {
        return operator.compileEvaluate(this);
    }

    private void compileCall(OperatorDefinition operator) {
        operator.compileCall(this);
    }

    public Type compileEvaluate(OperatorSignature signature) {
        OperatorInvocation invocation = this.findOperator(signature);
        if (invocation.useDynamicDispatch()) {
            Type lastFoundReturnType = null;
            HashSet<OperatorSignature> possibleInvocations = this.getPossibleTargetSignatures(this.currentOperatorDefinition, signature);
            for (OperatorSignature searchFor : possibleInvocations) {
                OperatorDefinition operator = this.locateOperator(searchFor);
                if (operator == null) continue;
                Type returnType = operator.getDeclaredReturnType();
                if (returnType != null && lastFoundReturnType != null && !lastFoundReturnType.canAccept(returnType)) {
                    throw new ExceptionSemantic("RS0054: Operator " + searchFor + " is a possible invocation target but returns type " + returnType + " which is incompatible with " + lastFoundReturnType);
                }
                if (returnType == null) continue;
                lastFoundReturnType = returnType;
            }
            if (lastFoundReturnType == null) {
                throw new ExceptionSemantic("RS0055: Could not find operator " + signature);
            }
            this.compileInstruction(new OpInvokeDynamicEvaluate(this, invocation.getOperatorSignature()));
            return lastFoundReturnType;
        }
        OperatorDefinition operator = invocation.getStaticOperatorDefinition();
        return this.compileEvaluate(operator);
    }

    public void compileEvaluateAnonymous() {
        this.compileInstruction(new OpInvokeAnonymousEvaluate());
    }

    public void compileCall(OperatorSignature signature) {
        OperatorInvocation invocation = this.findOperator(signature);
        if (invocation.useDynamicDispatch()) {
            this.compileInstruction(new OpInvokeDynamicCall(this, invocation.getOperatorSignature()));
        } else {
            OperatorDefinition operator = invocation.getStaticOperatorDefinition();
            this.compileCall(operator);
        }
    }

    public void setPersistentOnlyOn() {
        if (this.persistentOnlyNestingLevel++ == 0) {
            this.persistentOnly = true;
        }
    }

    public void setPersistentOnlyOff() {
        if (--this.persistentOnlyNestingLevel == 0) {
            this.persistentOnly = false;
        }
    }

    public Slot findReference(String refname) {
        Slot slot = this.currentOperatorDefinition.getReference(refname);
        if (slot == null) {
            slot = this.database.openGlobalRelvar(refname);
            if (slot == null) {
                RelvarDefinition pendingRelvar = this.relvarsInProgress.get(refname);
                if (pendingRelvar == null) {
                    throw new ExceptionSemantic("RS0056: '" + refname + "' has not been defined.");
                }
                slot = new RelvarInProgress(refname, this.database, pendingRelvar.getRelvarMetadata());
            }
            if (this.globalReferenceCollector != null) {
                this.globalReferenceCollector.addReferenceToRelvar(refname);
            }
        } else if (this.persistentOnly && slot instanceof SlotScoped && ((SlotScoped)slot).getDepth() <= this.interactiveOperatorNestingDepth) {
            throw new ExceptionSemantic("RS0057: In this context, transient global variables like " + refname + " may not be referenced.");
        }
        return slot;
    }

    public void compileRelvarInsert(Slot slot, String relvarName, TypeRelation expressionType) {
        if (slot.isParameter()) {
            throw new ExceptionSemantic("RS0397: Parameter is not updateable.");
        }
        slot.compileGet(this);
        this.compileInstruction(new OpRelvarInsert());
    }

    public void compileRelvarInsertNoDuplicates(Slot slot, String relvarName, TypeRelation expressionType) {
        if (slot.isParameter()) {
            throw new ExceptionSemantic("RS0398: Parameter is not updateable.");
        }
        slot.compileGet(this);
        this.compileInstruction(new OpRelvarInsertNoDuplicates());
    }

    public void compileRelvarPurge(Slot slot, String relvarName) {
        if (slot.isParameter()) {
            throw new ExceptionSemantic("RS0399: Parameter is not updateable.");
        }
        slot.compileGet(this);
        this.compileInstruction(new OpRelvarPurge());
    }

    public void compileTransactionBegin() {
        this.compileInstruction(new OpTransactionBegin());
    }

    public void compileTransactionCommit() {
        this.compileInstruction(new OpTransactionCommit());
    }

    public void compileTransactionRollback() {
        this.compileInstruction(new OpTransactionRollback());
    }

    public void compileRelvarIDelete(Slot slot, String identifier) {
        if (slot.isParameter()) {
            throw new ExceptionSemantic("RS0401: Parameter is not updateable.");
        }
        slot.compileGet(this);
        this.compileInstruction(new OpRelvarIDelete());
    }

    public Type compileReformat(Type destinationType, Type sourceType) {
        if (!destinationType.requiresReformatOf(sourceType)) {
            return destinationType;
        }
        if (destinationType instanceof TypeArray && sourceType instanceof TypeArray) {
            TypeTuple sourceElementType = ((TypeArray)sourceType).getElementType();
            TypeTuple destinationElementType = ((TypeArray)destinationType).getElementType();
            if (!destinationType.requiresReformatOf(sourceType)) {
                return destinationType;
            }
            AttributeMap reformatMap = new AttributeMap(((TypeHeading)destinationElementType).getHeading(), ((TypeHeading)sourceElementType).getHeading());
            this.compileInstruction(new OpArrayProject(reformatMap));
        } else {
            AttributeMap reformatMap = new AttributeMap(((TypeHeading)destinationType).getHeading(), ((TypeHeading)sourceType).getHeading());
            if (destinationType instanceof TypeTuple && sourceType instanceof TypeTuple) {
                this.compileInstruction(new OpTupleProject(reformatMap));
            } else if (destinationType instanceof TypeRelation && sourceType instanceof TypeRelation) {
                this.compileInstruction(new OpTupleIteratableProject(reformatMap));
            } else {
                throw new ExceptionFatal("RS0299: compileReformat doesn't know how to deal with a " + destinationType + " and a " + sourceType);
            }
        }
        return destinationType;
    }

    private void compileLoadArrayFromRelation(String identifier, Slot slot, TypeArray expressionType) {
        TypeArray arrayVarType = (TypeArray)slot.getType();
        TypeTuple targetContainedType = arrayVarType.getElementType();
        if (!(targetContainedType instanceof TypeTuple)) {
            throw new ExceptionSemantic("RS0062: 'LOAD " + identifier + "' should reference an ARRAY of TUPLEs, but references an ARRAY of " + targetContainedType);
        }
        TypeTuple sourceContainedType = expressionType.getElementType();
        if (!targetContainedType.canAccept(sourceContainedType)) {
            throw new ExceptionSemantic("RS0063: 'LOAD " + identifier + "' expected an ARRAY of " + targetContainedType + " but got an ARRAY of " + sourceContainedType);
        }
        this.compileReformat(arrayVarType, expressionType);
        this.compileInstruction(new OpArrayToArray());
        this.compileSet(identifier);
    }

    private void compileLoadRelationFromArray(String identifier, Slot slot, TypeArray expressionType) {
        this.compileInstruction(new OpArrayToRelation());
        TypeTuple containedType = expressionType.getElementType();
        if (!(containedType instanceof TypeTuple)) {
            throw new ExceptionSemantic("RS0064: 'LOAD " + identifier + "' should reference an ARRAY of TUPLEs, but references an ARRAY of " + containedType);
        }
        Heading sourceHeading = containedType.getHeading();
        TypeRelation source = new TypeRelation(sourceHeading);
        TypeRelation target = (TypeRelation)slot.getType();
        Heading targetHeading = target.getHeading();
        if (!target.canAccept(source)) {
            throw new ExceptionSemantic("RS0065: 'LOAD " + identifier + "' expected an ARRAY with TUPLEs of heading " + targetHeading + " but got " + sourceHeading);
        }
        this.compileReformat(target, source);
        this.compileSet(identifier);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compileLoad(String identifier, Type expressionType) {
        Slot slot = this.findReference(identifier);
        if (slot.getType() instanceof TypeRelation) {
            if (!(expressionType instanceof TypeArray)) throw new ExceptionSemantic("RS0066: 'LOAD " + identifier + " FROM ...' expected an expression of type ARRAY, but got " + expressionType);
            this.compileLoadRelationFromArray(identifier, slot, (TypeArray)expressionType);
            return;
        } else {
            if (!(slot.getType() instanceof TypeArray)) throw new ExceptionSemantic("RS0068: 'LOAD " + identifier + "', should reference a RELATION-valued variable or an ARRAY variable, but references a variable of type " + slot.getType());
            if (!(expressionType instanceof TypeArray)) throw new ExceptionSemantic("RS0067: 'LOAD " + identifier + " FROM ...' expected an expression of type ARRAY (usually via ORDER), but got " + expressionType);
            this.compileLoadArrayFromRelation(identifier, slot, (TypeArray)expressionType);
        }
    }

    public TypeRelation compileSmallDivide(TypeRelation r1, TypeRelation r2, TypeRelation r3) {
        String r1Name = "%r1";
        String r2Name = "%r2";
        String r3Name = "%r3";
        Heading A1 = r1.getHeading().intersect(r3.getHeading());
        Heading A2 = r2.getHeading().intersect(r3.getHeading());
        Heading A1A2 = A1.union(A2);
        OperatorDefinition div = this.beginAnonymousOperator();
        this.beginParameterDefinitions();
        this.defineOperatorParameter("%r1", r1);
        this.defineOperatorParameter("%r2", r2);
        this.defineOperatorParameter("%r3", r3);
        this.endParameterDefinitions();
        this.compileGet("%r1");
        TypeRelation r1p = this.compileRelationProject(r1, new SelectAttributes(A1));
        this.compileDuplicate();
        this.compileGet("%r2");
        TypeRelation r2p = this.compileRelationProject(r2, new SelectAttributes(A2));
        TypeRelation r1r2joined = this.compileRelationJoin(r1p, r2p);
        this.compileGet("%r3");
        TypeRelation r3p = this.compileRelationProject(r3, new SelectAttributes(A1A2));
        TypeRelation minusResult = this.compileRelationMinus(r1r2joined, r3p);
        TypeRelation rightResult = this.compileRelationProject(minusResult, new SelectAttributes(A1));
        TypeRelation finalResult = this.compileRelationMinus(r1p, rightResult);
        this.setDeclaredReturnType(finalResult);
        this.compileReturnValue(finalResult);
        this.endOperator();
        return (TypeRelation)this.compileEvaluate(div);
    }

    public TypeRelation compileGreatDivide(TypeRelation r1, TypeRelation r2, TypeRelation r3, TypeRelation r4) {
        String r1Name = "%r1";
        String r2Name = "%r2";
        String r3Name = "%r3";
        String r4Name = "%r4";
        String r1pName = "%r1p";
        String r4pName = "%r4p";
        Heading A1 = r1.getHeading().intersect(r3.getHeading());
        Heading A2 = r2.getHeading().intersect(r4.getHeading());
        Heading A3 = r3.getHeading().intersect(r4.getHeading());
        Heading A1A2 = A1.union(A2);
        Heading A1A3 = A1.union(A3);
        Heading A2A3 = A2.union(A3);
        OperatorDefinition div = this.beginAnonymousOperator();
        this.beginParameterDefinitions();
        this.defineOperatorParameter("%r1", r1);
        this.defineOperatorParameter("%r2", r2);
        this.defineOperatorParameter("%r3", r3);
        this.defineOperatorParameter("%r4", r4);
        this.endParameterDefinitions();
        With with = new With();
        this.compileGet("%r1");
        TypeRelation r1pType = this.compileRelationProject(r1, new SelectAttributes(A1));
        with.addWithItem(r1pType, "%r1p");
        this.compileGet("%r4");
        TypeRelation r4pType = this.compileRelationProject(r4, new SelectAttributes(A2A3));
        with.addWithItem(r4pType, "%r4p");
        this.compileGet("%r1p");
        this.compileGet("%r2");
        TypeRelation r2Project = this.compileRelationProject(r2, new SelectAttributes(A2));
        TypeRelation leftJoin = this.compileRelationJoin(r1pType, r2Project);
        this.compileGet("%r1p");
        this.compileGet("%r4p");
        TypeRelation middleJoin = this.compileRelationJoin(r1pType, r4pType);
        this.compileGet("%r3");
        TypeRelation r3Project = this.compileRelationProject(r3, new SelectAttributes(A1A3));
        this.compileGet("%r4p");
        TypeRelation rightJoin = this.compileRelationJoin(r3Project, r4pType);
        TypeRelation firstMinus = this.compileRelationMinus(middleJoin, rightJoin);
        TypeRelation rightProject = this.compileRelationProject(firstMinus, new SelectAttributes(A1A2));
        TypeRelation finalResult = this.compileRelationMinus(leftJoin, rightProject);
        with.endWith(finalResult);
        this.setDeclaredReturnType(finalResult);
        this.compileReturnValue(finalResult);
        this.endOperator();
        return (TypeRelation)this.compileEvaluate(div);
    }

    public TypeRelation compileRelationProject(TypeRelation operand, SelectAttributes attributes) {
        if (attributes.isEverything()) {
            return operand;
        }
        Heading destination = operand.getHeading().project(attributes);
        this.compileInstruction(new OpTupleIteratableProject(new AttributeMap(destination, operand.getHeading())));
        return new TypeRelation(destination);
    }

    public TypeArray compileArrayProject(TypeArray operand, SelectAttributes attributes) {
        if (attributes.isEverything()) {
            return operand;
        }
        Heading destination = operand.getHeading().project(attributes);
        this.compileInstruction(new OpTupleIteratableProject(new AttributeMap(destination, operand.getHeading())));
        return new TypeArray(destination);
    }

    public Type compileTClose(Type expressionType) {
        if (!(expressionType instanceof TypeRelation)) {
            throw new ExceptionSemantic("RS0070: TCLOSE expected RELATION but got " + expressionType);
        }
        Heading exprHeading = ((TypeRelation)expressionType).getHeading();
        if (exprHeading.getDegree() != 2) {
            throw new ExceptionSemantic("RS0071: TCLOSE expected RELATION of degree 2, but degree is " + exprHeading.getDegree());
        }
        if (!exprHeading.getAttributes().get(0).getType().getSignature().equals(exprHeading.getAttributes().get(1).getType().getSignature())) {
            throw new ExceptionSemantic("RS0072: TCLOSE expected both attributes of the RELATION to be the same type, but they aren't.");
        }
        this.compileInstruction(new OpRelationTClose());
        return expressionType;
    }

    private void testLeftCanAcceptRight(Type leftType, Type rightType) {
        if (!leftType.canAccept(rightType)) {
            throw new ExceptionSemantic("RS0073: " + leftType + " is not compatible with " + rightType);
        }
    }

    public TypeRelation compileRelationUnion(TypeRelation leftType, TypeRelation rightType) {
        this.testLeftCanAcceptRight(leftType, rightType);
        this.compileReformat(leftType, rightType);
        this.compileInstruction(new OpRelationUnion());
        return leftType;
    }

    public TypeRelation compileRelationXunion(TypeRelation leftType, TypeRelation rightType) {
        this.testLeftCanAcceptRight(leftType, rightType);
        this.compileReformat(leftType, rightType);
        this.compileInstruction(new OpRelationXunion());
        return leftType;
    }

    public TypeRelation compileRelationDUnion(TypeRelation leftType, TypeRelation rightType) {
        this.testLeftCanAcceptRight(leftType, rightType);
        this.compileReformat(leftType, rightType);
        this.compileInstruction(new OpRelationDUnion());
        return leftType;
    }

    public TypeRelation compileRelationIntersect(TypeRelation leftType, TypeRelation rightType) {
        this.testLeftCanAcceptRight(leftType, rightType);
        this.compileReformat(leftType, rightType);
        this.compileInstruction(new OpRelationIntersect());
        return leftType;
    }

    public TypeRelation compileRelationMinus(TypeRelation leftType, TypeRelation rightType) {
        this.testLeftCanAcceptRight(leftType, rightType);
        this.compileReformat(leftType, rightType);
        this.compileInstruction(new OpRelationMinus());
        return leftType;
    }

    public TypeRelation compileRelationIMinus(TypeRelation leftType, TypeRelation rightType) {
        this.testLeftCanAcceptRight(leftType, rightType);
        this.compileReformat(leftType, rightType);
        this.compileInstruction(new OpRelationIMinus());
        return leftType;
    }

    public TypeRelation compileRelationJoin(TypeRelation leftType, TypeRelation rightType) {
        Heading left = leftType.getHeading();
        Heading right = rightType.getHeading();
        Heading intersect = left.intersect(right);
        Heading result = left.union(right);
        if (intersect.getDegree() == 0) {
            this.compileInstruction(new OpRelationProduct());
        } else {
            this.compileInstruction(new OpRelationJoin(new JoinMap(result, left, right)));
        }
        return new TypeRelation(result);
    }

    public TypeRelation compileRelationTimes(TypeRelation leftType, TypeRelation rightType) {
        Heading left = leftType.getHeading();
        Heading right = rightType.getHeading();
        Heading intersect = left.intersect(right);
        Heading result = left.union(right);
        if (intersect.getDegree() != 0) {
            throw new ExceptionSemantic("RS0074: Attempt to perform TIMES on operands with attributes in common.  Perhaps you want to use JOIN or RENAME?");
        }
        this.compileInstruction(new OpRelationProduct());
        return new TypeRelation(result);
    }

    public TypeRelation compileRelationCompose(TypeRelation leftType, TypeRelation rightType) {
        Heading intersect = leftType.getHeading().intersect(rightType.getHeading());
        if (intersect.getDegree() == 0) {
            this.compileInstruction(new OpRelationProduct());
            return new TypeRelation(leftType.getHeading().unionDisjoint(rightType.getHeading()));
        }
        TypeRelation joinType = this.compileRelationJoin(leftType, rightType);
        TypeRelation composeType = new TypeRelation(joinType.getHeading().minus(intersect));
        this.compileReformat(composeType, joinType);
        return composeType;
    }

    public TypeRelation compileRelationSemijoin(TypeRelation leftType, TypeRelation rightType) {
        this.compileReformat(leftType, this.compileRelationJoin(leftType, rightType));
        return leftType;
    }

    public TypeRelation compileRelationSemiminus(TypeRelation leftType, TypeRelation rightType) {
        this.compileDuplicateUnder();
        return this.compileRelationMinus(leftType, this.compileRelationSemijoin(leftType, rightType));
    }

    private Heading endTupleIteratableExtend(Extend extend) {
        String sourceParameterName = "%source";
        extend.endExtendDefinition();
        Heading extendedHeading = extend.sourceHeading.unionDisjoint(extend.extendedHeading);
        OperatorDefinition mapOp = this.beginAnonymousOperator();
        this.beginParameterDefinitions();
        this.defineOperatorParameter("%source", new TypeTuple(extend.sourceHeading));
        this.endParameterDefinitions();
        this.setDeclaredReturnType(new TypeTuple(extendedHeading));
        this.compileGet("%source");
        this.compilePush(new ValueTuple(this, new TypeTuple(extend.extendedHeading)));
        this.compileEvaluate(extend.extendOp);
        this.compileReturnValue(this.getDeclaredReturnType());
        this.endOperator();
        this.compileInstruction(new OpTupleIteratableMap(mapOp.getOperator()));
        return extendedHeading;
    }

    public TypeRelation endRelationExtend(Extend extend) {
        Heading extendedHeading = this.endTupleIteratableExtend(extend);
        return new TypeRelation(extendedHeading);
    }

    public TypeArray endArrayExtend(Extend extend) {
        Heading extendedHeading = this.endTupleIteratableExtend(extend);
        return new TypeArray(extendedHeading);
    }

    public TypeRelation compileRelationWrap(TypeRelation sourceType, SelectAttributes selection, String name) {
        String sourceParameterName = "%source";
        OperatorDefinition mapOp = this.beginAnonymousOperator();
        this.beginParameterDefinitions();
        this.defineOperatorParameter("%source", new TypeTuple(sourceType.getHeading()));
        this.endParameterDefinitions();
        this.setDeclaredReturnType(new TypeTuple(sourceType.getHeading()));
        this.compileGet("%source");
        TypeTuple tupleType = this.compileTupleWrap(new TypeTuple(sourceType.getHeading()), selection, name);
        this.compileReturnValue(this.getDeclaredReturnType());
        this.endOperator();
        this.compileInstruction(new OpTupleIteratableMap(mapOp.getOperator()));
        return new TypeRelation(tupleType.getHeading());
    }

    public TypeRelation compileRelationUnwrap(TypeRelation operand, String attributeName) {
        String sourceParameterName = "%source";
        OperatorDefinition mapOp = this.beginAnonymousOperator();
        this.beginParameterDefinitions();
        this.defineOperatorParameter("%source", new TypeTuple(operand.getHeading()));
        this.endParameterDefinitions();
        this.setDeclaredReturnType(new TypeTuple(operand.getHeading()));
        this.compileGet("%source");
        TypeTuple tupleType = this.compileTupleUnwrap(new TypeTuple(operand.getHeading()), attributeName);
        this.compileReturnValue(this.getDeclaredReturnType());
        this.endOperator();
        this.compileInstruction(new OpTupleIteratableMap(mapOp.getOperator()));
        return new TypeRelation(tupleType.getHeading());
    }

    public TypeRelation compileRelationGroup(TypeRelation sourceType, SelectAttributes itemList, String name) {
        String parmName = "%r";
        if (itemList.isAllBut()) {
            itemList.makeNamesExplicit(sourceType.getHeading());
            itemList.setAllBut(true);
        } else {
            itemList.setAllBut(!itemList.isAllBut());
        }
        Heading excludeHeading = sourceType.getHeading().project(itemList);
        OperatorDefinition groupOp = this.beginAnonymousOperator();
        this.beginParameterDefinitions();
        this.defineOperatorParameter("%r", sourceType);
        this.endParameterDefinitions();
        TypeRelation parmType = (TypeRelation)this.compileGet("%r");
        Extend extend = new Extend(parmType.getHeading());
        RelationDefinition extendRelation = new RelationDefinition(null);
        TupleDefinition extendRelationTuple = new TupleDefinition();
        for (Attribute attribute : excludeHeading.getAttributes()) {
            this.compileGet(attribute.getName());
            extendRelationTuple.setTupleAttribute(attribute.getName(), attribute.getType());
        }
        TypeTuple tupleType = extendRelationTuple.endTuple();
        extendRelation.addTupleToRelation(tupleType);
        TypeRelation leftType = extendRelation.endRelation();
        TypeRelation rightType = (TypeRelation)this.compileGet("%r");
        TypeRelation composeResult = this.compileRelationCompose(leftType, rightType);
        extend.addExtendItem(name, composeResult);
        TypeRelation extendResult = this.endRelationExtend(extend);
        TypeRelation result = this.compileRelationProject(extendResult, itemList);
        this.setDeclaredReturnType(result);
        this.compileReturnValue(result);
        this.endOperator();
        return (TypeRelation)this.compileEvaluate(groupOp);
    }

    public TypeRelation compileRelationUngroup(TypeRelation sourceType, String attributeName) {
        Heading sourceHeading = sourceType.getHeading();
        Attribute rvAttribute = sourceHeading.getAttribute(attributeName);
        if (rvAttribute == null) {
            throw new ExceptionSemantic("RS0075: Attribute '" + attributeName + "' not found in " + sourceType);
        }
        Type rvaType = rvAttribute.getType();
        if (!(rvaType instanceof TypeRelation)) {
            throw new ExceptionSemantic("RS0076: Expected attribute '" + attributeName + "' to be a relation, but got " + rvaType);
        }
        Heading rvaHeading = ((TypeRelation)rvaType).getHeading();
        if (sourceHeading.intersect(rvaHeading).getDegree() > 0) {
            throw new ExceptionSemantic("RS0077: Relation-valued attribute '" + attributeName + "' shares attributes with " + sourceType);
        }
        Heading resultType = sourceHeading.unionDisjoint(rvaHeading);
        AttributeMap sourceMap = new AttributeMap(sourceHeading, resultType);
        AttributeMap rvaMap = new AttributeMap(rvaHeading, resultType);
        int indexofRVA = sourceHeading.getIndexOf(attributeName);
        int resultDegree = resultType.getDegree();
        this.compileInstruction(new OpRelationUngroup(sourceMap, rvaMap, indexofRVA, resultDegree));
        SelectAttributes excludeRVA = new SelectAttributes();
        excludeRVA.add(attributeName);
        excludeRVA.setAllBut(true);
        sourceType = this.compileRelationProject(new TypeRelation(resultType), excludeRVA);
        return sourceType;
    }

    public TypeArray compileOrder(TypeHeading sourceType, SelectOrder orderItems) {
        Heading sourceHeading = sourceType.getHeading();
        this.compileInstruction(new OpTupleIteratableOrder(new OrderMap(sourceHeading, orderItems)));
        return new TypeArray(sourceHeading);
    }

    public TypeRelation compileArrayUnorder(TypeArray sourceType) {
        Heading sourceHeading = sourceType.getHeading();
        this.compileInstruction(new OpArrayToRelation());
        return new TypeRelation(sourceHeading);
    }

    public TypeTuple compileRelationGetTuple(TypeRelation relationExpression) {
        this.compileInstruction(new OpRelationGetTuple());
        return new TypeTuple(relationExpression.getHeading());
    }

    public Type compileTupleGetAttribute(TypeTuple sourceType, String attributeName) {
        Heading source = sourceType.getHeading();
        int index = source.getIndexOf(attributeName);
        if (index == -1) {
            throw new ExceptionSemantic("RS0078: Attribute '" + attributeName + "' not found.");
        }
        this.compileInstruction(new OpTupleGetAttribute(index));
        return source.getAttributes().get(index).getType();
    }

    public TypeTuple compileTupleUnwrap(TypeTuple sourceType, String attributeName) {
        Attribute tupleAttribute = sourceType.getHeading().getAttribute(attributeName);
        if (tupleAttribute == null) {
            throw new ExceptionSemantic("RS0079: Attribute '" + attributeName + "' not in " + sourceType);
        }
        if (!(tupleAttribute.getType() instanceof TypeTuple)) {
            throw new ExceptionSemantic("RS0080: Expected attribute '" + tupleAttribute.getName() + "' to be a TUPLE but it is a " + tupleAttribute.getType());
        }
        Heading unwrappingAttributeHeading = new Heading();
        unwrappingAttributeHeading.add(tupleAttribute.getName(), tupleAttribute.getType());
        TypeTuple preservedAttributes = new TypeTuple(sourceType.getHeading().minus(unwrappingAttributeHeading));
        this.compileDuplicate();
        this.compileReformat(preservedAttributes, sourceType);
        this.compileSwap();
        this.compileInstruction(new OpTupleGetAttribute(sourceType.getHeading().getIndexOf(tupleAttribute.getName())));
        sourceType = this.compileTupleJoin(preservedAttributes, (TypeTuple)tupleAttribute.getType());
        return sourceType;
    }

    public TypeTuple compileTupleWrap(TypeTuple sourceType, SelectAttributes selection, String name) {
        TypeTuple wrappingAttributes = new TypeTuple(sourceType.getHeading().project(selection));
        SelectAttributes wrappedAttributeRemover = new SelectAttributes();
        wrappedAttributeRemover.setAllBut(true);
        wrappedAttributeRemover.add(wrappingAttributes.getHeading().getAttributes());
        this.compileDuplicate();
        TypeTuple wrappedAttributesRemoved = this.compileTupleProject(sourceType, wrappedAttributeRemover);
        this.compileSwap();
        this.compileReformat(wrappingAttributes, sourceType);
        TupleDefinition extendTuple = new TupleDefinition();
        extendTuple.setTupleAttribute(name, wrappingAttributes);
        TypeTuple wrappedAttribute = extendTuple.endTuple();
        return this.compileTupleJoin(wrappedAttributesRemoved, wrappedAttribute);
    }

    public TypeTuple compileTupleDUnion(TypeTuple leftType, TypeTuple rightType) {
        Heading right;
        Heading left = leftType.getHeading();
        if (left.intersect(right = rightType.getHeading()).getDegree() == 0) {
            this.compileInstruction(new OpTupleJoinDisjoint());
            return new TypeTuple(left.unionDisjoint(right));
        }
        throw new ExceptionSemantic("RS0081: Attempt to perform disjoint union on tuple types that have attributes in common.");
    }

    public TypeTuple compileTupleSemijoin(TypeTuple leftType, TypeTuple rightType) {
        return this.compileTupleIntersect(leftType, rightType);
    }

    public TypeTuple compileTupleSemiminus(TypeTuple leftType, TypeTuple rightType) {
        this.compileDuplicateUnder();
        return this.compileTupleMinus(leftType, this.compileTupleSemijoin(leftType, rightType));
    }

    public TypeTuple compileTupleCompose(TypeTuple leftType, TypeTuple rightType) {
        Heading intersect = leftType.getHeading().intersect(rightType.getHeading());
        if (intersect.getDegree() == 0) {
            this.compileInstruction(new OpTupleJoinDisjoint());
            return new TypeTuple(leftType.getHeading().unionDisjoint(rightType.getHeading()));
        }
        TypeTuple joinType = this.compileTupleJoin(leftType, rightType);
        TypeTuple composeType = new TypeTuple(joinType.getHeading().minus(intersect));
        this.compileReformat(composeType, joinType);
        return composeType;
    }

    public TypeTuple compileTupleMinus(TypeTuple leftType, TypeTuple rightType) {
        Heading right;
        Heading left = leftType.getHeading();
        Heading intersect = left.intersect(right = rightType.getHeading());
        if (intersect.getDegree() == 0) {
            this.compilePop();
            return leftType;
        }
        TypeTuple joinType = this.compileTupleJoin(leftType, rightType);
        TypeTuple minusType = new TypeTuple(left.minus(right));
        this.compileReformat(minusType, joinType);
        return minusType;
    }

    public TypeTuple compileTupleIMinus(TypeTuple leftType, TypeTuple rightType) {
        Heading right;
        Heading left = leftType.getHeading();
        Heading intersect = left.intersect(right = rightType.getHeading());
        if (intersect.getDegree() != right.getDegree()) {
            throw new ExceptionSemantic("RS0082: In I_MINUS, the right operand must be a subset of the left operand.");
        }
        TypeTuple joinType = this.compileTupleJoin(leftType, rightType);
        TypeTuple minusType = new TypeTuple(left.minus(right));
        this.compileReformat(minusType, joinType);
        return minusType;
    }

    public TypeTuple compileTupleIntersect(TypeTuple leftType, TypeTuple rightType) {
        TypeTuple intersectType = new TypeTuple(leftType.getHeading().intersect(rightType.getHeading()));
        if (intersectType.getHeading().getDegree() > 0) {
            TypeTuple joinType = this.compileTupleJoin(leftType, rightType);
            this.compileReformat(intersectType, joinType);
        } else {
            this.compilePop();
            this.compilePop();
            this.compilePush(intersectType.getDefaultValue(this));
        }
        return intersectType;
    }

    public TypeTuple endTupleExtend(Extend extend) {
        extend.endExtendDefinition();
        this.compilePush(new ValueTuple(this, new TypeTuple(extend.extendedHeading)));
        return (TypeTuple)this.compileEvaluate(extend.extendOp);
    }

    public TypeTuple compileTupleJoin(TypeTuple leftType, TypeTuple rightType) {
        Heading destination;
        Heading right;
        Heading left = leftType.getHeading();
        if (left.intersect(right = rightType.getHeading()).getDegree() > 0) {
            destination = left.union(right);
            this.compileInstruction(new OpTupleJoin(new JoinMap(destination, left, right)));
        } else {
            this.compileInstruction(new OpTupleJoinDisjoint());
            destination = left.unionDisjoint(right);
        }
        return new TypeTuple(destination);
    }

    public TypeTuple compileTupleProject(TypeTuple sourceType, SelectAttributes attributes) {
        if (attributes.isEverything()) {
            return sourceType;
        }
        Heading destination = sourceType.getHeading().project(attributes);
        this.compileInstruction(new OpTupleProject(new AttributeMap(destination, sourceType.getHeading())));
        return new TypeTuple(destination);
    }

    private void operatorDefinition(String fnname) {
        Token token;
        BaseASTNode node;
        int startLine = 0;
        if (this.parser != null && (node = this.parser.getCurrentNode()) != null && (token = node.first_token) != null) {
            startLine = token.beginLine;
        }
        this.currentOperatorDefinition = new OperatorDefinitionRel(startLine, fnname, this.currentOperatorDefinition);
    }

    public void addOperator(OperatorDefinition op) {
        this.parser.addOperator(op);
    }

    public OperatorDefinition beginAnonymousOperator() {
        this.operatorDefinition(null);
        this.currentOperatorDefinition.setSpecial(true);
        return this.currentOperatorDefinition;
    }

    public void beginOperator(String fnname) {
        this.operatorDefinition(fnname);
    }

    public OperatorDefinition getCurrentOperatorDefinition() {
        return this.currentOperatorDefinition;
    }

    public String getOperatorDefinitionLineReferenceStack(int lineNumber) {
        StringBuffer out = new StringBuffer();
        OperatorDefinition current = this.currentOperatorDefinition;
        while (true) {
            if (!current.isSpecial()) {
                out.append("\tIn " + current.getSignature().toString() + " line " + (lineNumber - current.getStartLine() + 1));
            }
            if ((current = current.getParentOperatorDefinition()) == null) break;
            out.append('\n');
        }
        return out.toString();
    }

    public OperatorSignature getCurrentDefinitionSignature() {
        return this.currentOperatorDefinition.getSignature();
    }

    public void setDeclaredReturnType(Type type) {
        this.currentOperatorDefinition.setDeclaredReturnType(type);
    }

    public Type getDeclaredReturnType() {
        return this.currentOperatorDefinition.getDeclaredReturnType();
    }

    public void compileReturnValue(Type returnType) {
        if (!this.currentOperatorDefinition.hasReturnDeclaration()) {
            throw new ExceptionSemantic("RS0083: Operator " + this.currentOperatorDefinition.getSignature() + " has not declared a return type but has defined a return expression.");
        }
        if (returnType instanceof TypeOperator) {
            this.compileInstruction(new OpPreserveContextInValueOperator());
        }
        this.compileInstruction(new OpReturnValue());
        this.currentOperatorDefinition.setDefinedReturnValue(true);
    }

    public void compileReturn() {
        if (this.currentOperatorDefinition.hasReturnDeclaration()) {
            throw new ExceptionSemantic("RS0084: Operator " + this.currentOperatorDefinition.getSignature() + " has declared a return type, but the RETURN statement is missing an expression of that type.");
        }
        this.compileInstruction(new OpReturn());
    }

    public void beginParameterDefinitions() {
    }

    public void defineOperatorParameter(String name, Type type) {
        this.currentOperatorDefinition.defineParameter(name, type);
    }

    public void endParameterDefinitions() {
        this.currentOperatorDefinition.getParentOperatorDefinition().defineOperator(this.currentOperatorDefinition);
    }

    public void endOperator() {
        if (this.currentOperatorDefinition.hasReturnDeclaration()) {
            if (!this.currentOperatorDefinition.hasDefinedReturnValue()) {
                throw new ExceptionSemantic("RS0085: Operator " + this.currentOperatorDefinition.getSignature() + " has declared a return type, but contains no RETURN statement of that type.");
            }
            this.compilePush(this.currentOperatorDefinition.getDeclaredReturnType().getDefaultValue(this));
            this.compileInstruction(new OpReturnValue());
        } else {
            this.compileInstruction(new OpReturn());
        }
        this.currentOperatorDefinition = this.currentOperatorDefinition.getParentOperatorDefinition();
    }

    public boolean isTopLevelOperator(OperatorDefinition definition) {
        return definition.getDepth() == this.interactiveOperatorNestingDepth + 1;
    }

    public void persistOperator(OperatorDefinition operator) {
        if (this.database.isOperatorExists(operator.getSignature())) {
            throw new ExceptionSemantic("RS0086: OPERATOR " + operator.getSignature() + " is already in the database.");
        }
        if (operator.getOwner() == null || operator.getOwner().isEmpty()) {
            operator.setOwner(this.userRelvarOwner);
        }
        this.beginAssignment();
        this.compileInstruction(new OpCreateOperator(operator));
        this.endAssignment();
    }

    public void dropOperator(OperatorSignature signature) {
        if (!this.database.isOperatorExists(signature)) {
            throw new ExceptionSemantic("RS0087: OPERATOR " + signature + " does not exist.");
        }
        String operatorGenerationTypeName = this.database.getOperatorGenerationTypeName(signature);
        if (operatorGenerationTypeName != null && operatorGenerationTypeName.length() > 0) {
            throw new ExceptionSemantic("RS0088: OPERATOR " + signature + " was generated by TYPE " + operatorGenerationTypeName + " and may not be dropped directly.");
        }
        this.beginAssignment();
        this.compileInstruction(new OpDropOperator(signature));
        this.endAssignment();
    }

    public Type compileGet(Slot slot) {
        slot.compileGet(this);
        return slot.getType();
    }

    public Type compileGet(String refname) {
        return this.compileGet(this.findReference(refname));
    }

    public Type compileSet(Slot slot) {
        slot.compileSet(this);
        return slot.getType();
    }

    public Type compileSet(String refname) {
        return this.compileSet(this.findReference(refname));
    }

    public void compileVariableInitialise(Slot slot) {
        slot.compileInitialise(this);
    }

    public void compileVariableInitialise(String refname) {
        this.compileVariableInitialise(this.findReference(refname));
    }

    public void compileArrayGet() {
        this.compileInstruction(new OpArrayGet());
    }

    public void compileArraySet() {
        this.compileInstruction(new OpArraySet());
    }

    public void compileArrayAppend() {
        this.compileInstruction(new OpArrayAppend());
    }

    public void compileExactly(int countOfBooleanExpressions) {
        this.compileInstruction(new OpExactly(countOfBooleanExpressions));
    }

    public void compileNadicAverage(int countOfExpressions) {
        this.compileInstruction(new OpAverage(countOfExpressions));
    }

    public Type compileOperatorInvocation(String opName, Type parmType, Type returnType) {
        OperatorSignature signature = new OperatorSignature(opName);
        signature.addParameterType(parmType);
        signature.setReturnType(returnType);
        this.compileEvaluate(signature);
        return returnType;
    }

    public Type compileOperatorInvocation(String opName, Type leftParmType, Type rightParmType, Type returnType) {
        OperatorSignature signature = new OperatorSignature(opName);
        signature.addParameterType(leftParmType);
        signature.addParameterType(rightParmType);
        signature.setReturnType(returnType);
        this.compileEvaluate(signature);
        return returnType;
    }

    private Type compileComparisonOperatorInvocation(String opName, Type leftType, Type rightType, Type returnType) {
        if (!leftType.canAccept(rightType)) {
            throw new ExceptionSemantic("RS0388: " + leftType + " is not the same type as " + rightType + ".");
        }
        this.compileReformat(leftType, rightType);
        return this.compileOperatorInvocation(opName, leftType, rightType, returnType);
    }

    public Type compileEQ(Type leftType, Type rightType) {
        return this.compileComparisonOperatorInvocation("OP_EQUALS", leftType, rightType, TypeBoolean.getInstance());
    }

    public Type compileNEQ(Type leftType, Type rightType) {
        return this.compileComparisonOperatorInvocation("OP_NOTEQUALS", leftType, rightType, TypeBoolean.getInstance());
    }

    public Type compileGTE(Type leftType, Type rightType) {
        if (leftType instanceof TypeTuple || rightType instanceof TypeTuple) {
            throw new ExceptionSemantic("RS0089: Ordinal comparison operators not supported by TUPLE.");
        }
        return this.compileComparisonOperatorInvocation("OP_GREATERTHANOREQUALS", leftType, rightType, TypeBoolean.getInstance());
    }

    public Type compileLTE(Type leftType, Type rightType) {
        if (leftType instanceof TypeTuple || rightType instanceof TypeTuple) {
            throw new ExceptionSemantic("RS0090: Ordinal comparison operators not supported by TUPLE.");
        }
        return this.compileComparisonOperatorInvocation("OP_LESSTHANOREQUALS", leftType, rightType, TypeBoolean.getInstance());
    }

    public Type compileGT(Type leftType, Type rightType) {
        if (leftType instanceof TypeTuple || rightType instanceof TypeTuple) {
            throw new ExceptionSemantic("RS0091: Ordinal comparison operators not supported by TUPLE.");
        }
        return this.compileComparisonOperatorInvocation("OP_GREATERTHAN", leftType, rightType, TypeBoolean.getInstance());
    }

    public Type compileLT(Type leftType, Type rightType) {
        if (leftType instanceof TypeTuple || rightType instanceof TypeTuple) {
            throw new ExceptionSemantic("RS0092: Ordinal comparison operators not supported by TUPLE.");
        }
        return this.compileComparisonOperatorInvocation("OP_LESSTHAN", leftType, rightType, TypeBoolean.getInstance());
    }

    public TypeBoolean compileTupleIn(TypeTuple leftType, TypeRelation rightType) {
        this.compileSwap();
        if (rightType.requiresReformatOf(new TypeRelation(leftType.getHeading()))) {
            this.compileInstruction(new OpTupleProject(new AttributeMap(leftType.getHeading(), rightType.getHeading())));
        }
        this.compileInstruction(new OpTupleInRelation());
        return TypeBoolean.getInstance();
    }

    public void compileConcatenate() {
        this.compileInstruction(new OpConcatenate());
    }

    public void compilePlus() {
        this.compileInstruction(new OpAdd());
    }

    public void compileLTE() {
        this.compileInstruction(new OpLte());
    }

    public void compilePop() {
        this.compileInstruction(new OpPop());
    }

    public void compileDuplicate() {
        this.compileInstruction(new OpDuplicate());
    }

    public void compileDuplicateUnder() {
        this.compileInstruction(new OpDuplicateUnder());
    }

    public void compileSwap() {
        this.compileInstruction(new OpSwap());
    }

    public void compilePush(Value v) {
        this.compileInstruction(new OpPushLiteral(v));
    }

    public void compilePushDelimitedString(String value) {
        this.compilePush(ValueCharacter.stripDelimited(this, value));
    }

    public void compilePush(String value) {
        this.compilePush(ValueCharacter.select(this, value));
    }

    public void compilePush(double value) {
        this.compilePush(ValueRational.select(this, value));
    }

    public void compilePush(long value) {
        this.compilePush(ValueInteger.select(this, value));
    }

    public void compilePush(boolean flag) {
        this.compilePush(ValueBoolean.select(this, flag));
    }

    public void announce(String s) {
        this.printStream.println(ValueCharacter.stripDelimitedString(s));
    }

    public void compileWrite(Type type) {
        this.compileInstruction(new OpWrite(type));
    }

    public void compileWriteln(Type type) {
        this.compileInstruction(new OpWriteln(type));
    }

    public void compileWritelnNoExpression() {
        this.compileInstruction(new OpWritelnNoExpression());
    }

    public void compileOutput(Type type) {
        this.compileInstruction(new OpOutput(type));
    }

    public void compileExecute() {
        this.compileInstruction(new OpExecute());
    }

    public void set(String attribute, String value) {
        EnvironmentSettings.set(this, attribute, value);
    }

    public void backup() {
        this.compileInstruction(new OpBackup());
    }

    public void compileWrite() {
        this.compileInstruction(new OpWriteRaw());
    }

    public void compileWriteRelation() {
        this.compileInstruction(new OpRelationWrite());
    }

    private abstract class AnonymousTupleOperator {
        private OperatorDefinition operator;
        private String name;

        AnonymousTupleOperator(TypeTuple sourceType, Type returnType) {
            StringBuilder stringBuilder = new StringBuilder("%tuple");
            Generator generator2 = Generator.this;
            int n = generator2.parmNameSerialNumber;
            generator2.parmNameSerialNumber = n + 1;
            this.name = stringBuilder.append(n).toString();
            this.operator = Generator.this.beginAnonymousOperator();
            Generator.this.beginParameterDefinitions();
            Generator.this.defineOperatorParameter(this.getTupleParameterName(), sourceType);
            Generator.this.endParameterDefinitions();
            Generator.this.setDeclaredReturnType(returnType);
            new TupleAttributeExposure(Generator.this, this.getTupleParameterName(), sourceType.getHeading()){

                @Override
                public void compileSet(Generator generator, Attribute attribute, int slotDepth, int operatorDepth, int offset) {
                    AnonymousTupleOperator.this.compileSet(generator, attribute, slotDepth, operatorDepth, offset);
                }
            };
        }

        String getTupleParameterName() {
            return this.name;
        }

        void end() {
            if (Generator.this.getDeclaredReturnType() != null) {
                Generator.this.compileReturnValue(Generator.this.getDeclaredReturnType());
            }
            Generator.this.endOperator();
        }

        Operator getOperator() {
            return this.operator.getOperator();
        }

        OperatorDefinition getOperatorDefinition() {
            return this.operator;
        }

        public abstract void compileSet(Generator var1, Attribute var2, int var3, int var4, int var5);
    }

    public class DeleteHandler {
        private TypeRelation operandType;
        private Slot reference;
        private AnonymousTupleOperator whereOperator;

        public DeleteHandler(String relvarName, TypeRelation operand) {
            this.reference = Generator.this.findReference(relvarName);
            if (!(this.reference instanceof Relvar || this.reference instanceof RelvarPrivate || this.reference.getType().toString().startsWith("RELATION"))) {
                throw new ExceptionSemantic("RS0059: Expected a relation-valued variable or attribute in DELETE but got " + this.reference.getType());
            }
            if (this.reference.isParameter()) {
                throw new ExceptionSemantic("RS0400: Parameter is not updateable.");
            }
            this.operandType = operand;
            this.whereOperator = null;
        }

        public void doWhere() {
            this.whereOperator = new TupleFilterOperator(new TypeTuple(this.operandType.getHeading()), "DELETE ... WHERE");
        }

        public TypeRelation endDeleteHandler(Type expressionType) {
            if (this.whereOperator != null) {
                this.whereOperator.end();
                this.reference.compileGet(Generator.this);
                Generator.this.compileInstruction(new OpRelvarDeleteWhere(this.whereOperator.getOperator()));
            } else {
                if (!this.operandType.canAccept(expressionType)) {
                    throw new ExceptionSemantic("RS0060: Expected expression of type " + this.operandType + " but got " + expressionType);
                }
                Generator.this.compileReformat(this.operandType, expressionType);
                this.reference.compileGet(Generator.this);
                Generator.this.compileInstruction(new OpRelvarDeleteGivenExpression());
            }
            return this.operandType;
        }
    }

    public class DoLoop {
        private int head;
        private int resolveThisForwardBranch;

        public DoLoop() {
            this.head = Generator.this.currentOperatorDefinition.getCP();
        }

        public void testDo() {
            this.resolveThisForwardBranch = Generator.this.currentOperatorDefinition.getCP();
            Generator.this.compileInstruction(new OpBranchIfFalse(0));
        }

        public void endDo() {
            Generator.this.compileInstruction(new OpJump(this.head));
            Generator.this.compileInstructionAt(new OpBranchIfFalse(Generator.this.currentOperatorDefinition.getCP()), this.resolveThisForwardBranch);
        }
    }

    public class Extend {
        private OperatorDefinition extendOp;
        private Heading sourceHeading;
        private Heading extendedHeading = new Heading();
        private String sourceTupleParmName;
        private String extendTupleParmName;

        public Extend(Heading sourceHeading) {
            this.sourceHeading = sourceHeading;
            this.sourceTupleParmName = "%source_tuple" + extendTupleNameSerial;
            this.extendTupleParmName = "%extend_tuple" + extendTupleNameSerial;
            extendTupleNameSerial = extendTupleNameSerial + 1;
            this.extendOp = Generator.this.beginAnonymousOperator();
            Generator.this.beginParameterDefinitions();
            Generator.this.defineOperatorParameter(this.sourceTupleParmName, new TypeTuple(sourceHeading));
            Generator.this.defineOperatorParameter(this.extendTupleParmName, TypeTuple.getEmptyTupleType());
            Generator.this.endParameterDefinitions();
            new TupleAttributeExposure(Generator.this, this.sourceTupleParmName, sourceHeading){

                @Override
                public void compileSet(Generator generator, Attribute attribute, int slotDepth, int operatorDepth, int offset) {
                    throw new ExceptionFatal("RS0300: Attempt to set original attribute '" + attribute.getName() + "' in EXTEND.");
                }
            };
        }

        public void addExtendItem(String identifier, Type expressionType) {
            final int depth = Generator.this.currentOperatorDefinition.getDepth();
            SlotScoped newSlot = new SlotScoped(depth, this.extendedHeading.getDegree(), expressionType){

                @Override
                public void compileGet(Generator generator) {
                    generator.compileGet(Extend.this.extendTupleParmName);
                    generator.compileInstruction(new OpTupleGetAttribute(this.getOffset()));
                }

                @Override
                public void compileSet(Generator generator) {
                    if (this.getDepth() != depth) {
                        throw new ExceptionSemantic("RS0069: EXTEND may only assign values to newly-defined attributes.");
                    }
                    generator.compileGet(Extend.this.extendTupleParmName);
                    generator.compileInstruction(new OpTupleSetAttribute(this.getOffset()));
                    generator.compileSet(Extend.this.extendTupleParmName);
                }

                @Override
                public void compileInitialise(Generator generator) {
                    throw new ExceptionFatal("RS0301: compileInitialise invoked on SlotScoped in addExtendItem().");
                }
            };
            Generator.this.currentOperatorDefinition.defineSlot(identifier, newSlot);
            Generator.this.compileSet(newSlot);
            this.extendedHeading.add(identifier, expressionType);
        }

        public void addExtendSerialiser(String attributeName) {
            Generator.this.compileInstruction(new OpGetTemporarilyUniqueInteger());
            this.addExtendItem(attributeName, TypeInteger.getInstance());
        }

        public Heading getExtendedHeading() {
            return this.sourceHeading.unionDisjoint(this.extendedHeading);
        }

        void endExtendDefinition() {
            Generator.this.setDeclaredReturnType(new TypeTuple(this.getExtendedHeading()));
            Generator.this.compileGet(this.sourceTupleParmName);
            Generator.this.compileGet(this.extendTupleParmName);
            Generator.this.compileInstruction(new OpTupleJoinDisjoint());
            Generator.this.compileReturnValue(Generator.this.getDeclaredReturnType());
            Generator.this.endOperator();
        }
    }

    public class ExternalOperator {
        private OperatorDefinition operator;

        public ExternalOperator(String fnname) {
            Generator.this.beginOperator(fnname);
            this.operator = Generator.this.getCurrentOperatorDefinition();
            if (!Generator.this.isTopLevelOperator(this.operator)) {
                throw new ExceptionSemantic("RS0051: FOREIGN operators may not be nested.");
            }
        }

        public void endExternalOperator(String externalLanguage, String sourcecode) {
            if (this.operator.getDeclaredReturnType() != null) {
                this.operator.setDefinedReturnValue(true);
            }
            this.operator = new ForeignCompilerJava(Generator.this, Generator.this.verboseExternalOperatorTypeGeneration).compileForeignOperator(Generator.this.getCurrentOperatorDefinition().getSignature(), externalLanguage, sourcecode);
            Generator.this.endOperator();
            Generator.this.currentOperatorDefinition.removeOperator(this.operator.getSignature());
            Generator.this.currentOperatorDefinition.defineOperator(this.operator);
            Generator.this.addOperator(this.operator);
        }
    }

    public class ForLoop {
        private TupleProcessOperator tupleOperator;

        public void beginForLoop(TypeArray array) {
            this.tupleOperator = new TupleProcessOperator(array.getElementType(), "FOR");
        }

        public void endForLoop() {
            this.tupleOperator.end();
            Generator.this.compileInstruction(new OpArrayFor(this.tupleOperator.getOperator()));
        }
    }

    public class IfStatement {
        private int resolveThisForwardBranch;
        private boolean conditional;

        public IfStatement() {
            this.resolveThisForwardBranch = Generator.this.currentOperatorDefinition.getCP();
            this.conditional = true;
            Generator.this.compileInstruction(new OpBranchIfFalse(0));
        }

        public void beginElse() {
            int pendingForwardBranch = this.resolveThisForwardBranch;
            this.resolveThisForwardBranch = Generator.this.currentOperatorDefinition.getCP();
            this.conditional = false;
            Generator.this.compileInstruction(new OpJump(0));
            Generator.this.compileInstructionAt(new OpBranchIfFalse(Generator.this.currentOperatorDefinition.getCP()), pendingForwardBranch);
        }

        public void endIf() {
            if (this.conditional) {
                Generator.this.compileInstructionAt(new OpBranchIfFalse(Generator.this.currentOperatorDefinition.getCP()), this.resolveThisForwardBranch);
            } else {
                Generator.this.compileInstructionAt(new OpJump(Generator.this.currentOperatorDefinition.getCP()), this.resolveThisForwardBranch);
            }
        }
    }

    public abstract class OperatorAssociatedWithType {
        public OperatorAssociatedWithType(String createdByType, String owner, OperatorSignature signature, References references) {
            NativeFunction fn = new NativeFunction(){

                @Override
                public Value evaluate(Value[] arguments) {
                    return OperatorAssociatedWithType.this.evaluate(arguments);
                }
            };
            OperatorDefinitionNativeFunction typeOperator = new OperatorDefinitionNativeFunction(signature, fn);
            typeOperator.setCreatedByType(createdByType);
            typeOperator.setLanguage("System");
            typeOperator.setReferences(references);
            typeOperator.setOwner(owner);
            if (Generator.this.retrievingTypeCount == 0) {
                Generator.this.persistOperator(typeOperator);
            }
            Generator.this.database.cacheOperator(typeOperator);
        }

        public abstract Value evaluate(Value[] var1);
    }

    private class PossrepComponentExposure {
        PossrepComponentExposure(TypeAlpha udt, final String sourceValueParameterName, Possrep possrep) {
            int index = 0;
            while (index < possrep.getComponentCount()) {
                int depth = Generator.this.currentOperatorDefinition.getDepth();
                final PossrepComponent component = possrep.getComponent(index);
                Generator.this.currentOperatorDefinition.defineSlot(component.getName(), new SlotScoped(depth, component.getComponentIndex(), component.getType()){

                    @Override
                    public void compileGet(Generator generator) {
                        generator.compileGet(sourceValueParameterName);
                        generator.compileInstruction(new OpPossrepGetComponent(component.getName(), this.getOffset()));
                    }

                    @Override
                    public void compileSet(Generator generator) {
                        throw new ExceptionFatal("RS0294: compileSet invoked on SlotScoped in PossrepComponentExposure.");
                    }

                    @Override
                    public void compileInitialise(Generator generator) {
                        throw new ExceptionFatal("RS0295: compileInitialise invoked on SlotScoped in PossrepComponentExposure.");
                    }
                });
                ++index;
            }
        }
    }

    public class PossrepConstraint {
        private Possrep possrep;
        private OperatorDefinition possrepConstraintFn;

        public PossrepConstraint(Possrep possrep) {
            this.possrep = possrep;
            Generator.this.setPersistentOnlyOn();
            this.possrepConstraintFn = Generator.this.beginAnonymousOperator();
            this.possrepConstraintFn.setDeclaredReturnType(TypeBoolean.getInstance());
            this.possrepConstraintFn.defineParameter("%p0", possrep.getType());
            new PossrepComponentExposure(possrep.getType(), "%p0", possrep);
        }

        public void endPossrepConstraint() {
            Generator.this.compileReturnValue(this.possrepConstraintFn.getDeclaredReturnType());
            Generator.this.endOperator();
            Generator.this.setPersistentOnlyOff();
            this.possrep.setConstraint(this.possrepConstraintFn.getOperator());
        }
    }

    public class PossrepInitialisation {
        private PossrepComponentExposureForInitialisation componentExposure;

        public PossrepInitialisation(TypeAlpha possreps, String possrepName) {
            if (possreps.getPossrepCount() <= 1) {
                throw new ExceptionSemantic("RS0046: INIT is not required if the number of POSSREPs is <= 1.");
            }
            Possrep possrep = possreps.locatePossrep(possrepName);
            if (possrep == null) {
                throw new ExceptionSemantic("RS0047: No POSSREP named " + possrepName + " was found.");
            }
            Generator.this.setPersistentOnlyOn();
            OperatorDefinition possrepInitProc = Generator.this.beginAnonymousOperator();
            possrepInitProc.defineParameter("p0", possrep.getType());
            this.componentExposure = new PossrepComponentExposureForInitialisation(possrep.getType(), "p0", possrep);
            possrep.setInitialiser(possrepInitProc.getOperator());
        }

        public void endPossrepInitialisation() {
            Generator.this.endOperator();
            Generator.this.setPersistentOnlyOff();
            HashSet<String> uninitialisedComponents = this.componentExposure.getUninitialisedComponents();
            if (uninitialisedComponents.size() > 0) {
                String s = "The following POSSREP components have not been INITialised:";
                for (String componentName : uninitialisedComponents) {
                    s = String.valueOf(s) + "\n\t" + componentName;
                }
                throw new ExceptionSemantic("RS0048: " + s);
            }
        }

        private class PossrepComponentExposureForInitialisation {
            private HashSet<String> componentsRequiringInitialisation = new HashSet();

            PossrepComponentExposureForInitialisation(TypeAlpha udt, final String sourceValueParameterName, final Possrep possrepToInitialise) {
                int possrepIndex = 0;
                while (possrepIndex < udt.getPossrepCount()) {
                    final Possrep possrep = udt.getPossrep(possrepIndex);
                    int componentIndex = 0;
                    while (componentIndex < possrep.getComponentCount()) {
                        int depth = Generator.this.currentOperatorDefinition.getDepth();
                        final String componentName = possrep.getComponent(componentIndex).getName();
                        if (possrep != possrepToInitialise) {
                            this.componentsRequiringInitialisation.add(componentName);
                        }
                        PossrepComponent component = possrep.getComponent(componentIndex);
                        Generator.this.currentOperatorDefinition.defineSlot(component.getName(), new SlotScoped(depth, component.getComponentIndex(), component.getType()){

                            @Override
                            public void compileGet(Generator generator) {
                                if (PossrepComponentExposureForInitialisation.this.componentsRequiringInitialisation.contains(componentName) && possrep != possrepToInitialise) {
                                    throw new ExceptionSemantic("RS0044: Component '" + componentName + "' has been referenced before being initialised.");
                                }
                                generator.compileGet(sourceValueParameterName);
                                generator.compileInstruction(new OpPossrepGetComponent(componentName, this.getOffset()));
                            }

                            @Override
                            public void compileSet(Generator generator) {
                                if (possrep == possrepToInitialise) {
                                    throw new ExceptionSemantic("RS0045: Component '" + componentName + "' cannot be assigned because it is set via the selector.");
                                }
                                generator.compileGet(sourceValueParameterName);
                                generator.compileInstruction(new OpPossrepSetComponent(this.getOffset()));
                                PossrepComponentExposureForInitialisation.this.componentsRequiringInitialisation.remove(componentName);
                            }

                            @Override
                            public void compileInitialise(Generator generator) {
                                throw new ExceptionFatal("RS0296: compileInitialise invoked on SlotScoped in PossrepComponentExposureForInitialisation.");
                            }
                        });
                        ++componentIndex;
                    }
                    ++possrepIndex;
                }
            }

            public HashSet<String> getUninitialisedComponents() {
                return this.componentsRequiringInitialisation;
            }
        }
    }

    public class RelationDefinition {
        private Heading heading;
        private boolean isHeadingExplicit = false;

        public RelationDefinition(Heading heading) {
            this.heading = heading;
            if (heading != null) {
                this.isHeadingExplicit = true;
            }
            Generator.this.compileInstruction(new OpRelationPushLiteral());
        }

        public void addTupleToRelation(TypeTuple tupleType) {
            Heading tupleHeading = tupleType.getHeading();
            if (this.heading == null) {
                this.heading = tupleHeading;
            } else if (!this.heading.canAccept(tupleHeading)) {
                this.heading = !this.isHeadingExplicit && tupleHeading.canAccept(this.heading) ? tupleHeading : this.heading.getMostSpecificCommonSupertype(tupleHeading);
            }
            Generator.this.compileReformat(new TypeTuple(this.heading), tupleType);
            Generator.this.compileInstruction(new OpRelationLiteralInsertTuple());
        }

        public TypeRelation endRelation() {
            return new TypeRelation(this.heading);
        }
    }

    public class RelationSubstitute {
        private AnonymousTupleOperator updateOp;
        private TypeRelation sourceType;

        public RelationSubstitute(TypeRelation sourceType) {
            this.sourceType = sourceType;
            this.updateOp = new TupleMapOperator(new TypeTuple(sourceType.getHeading()), "Relation UPDATE");
        }

        public TypeRelation endRelationSubstitute() {
            this.updateOp.end();
            Generator.this.compileInstruction(new OpTupleIteratableMap(this.updateOp.getOperator()));
            return this.sourceType;
        }
    }

    public class SpecialisationConstraint {
        private TypeAlpha udt;
        private OperatorDefinition specialisationConstraintFn;

        public SpecialisationConstraint(TypeAlpha udt) {
            if (!udt.isSubtype()) {
                throw new ExceptionSemantic("RS0043: A specialisation constraint may only be specified for subtypes.");
            }
            this.udt = udt;
            Generator.this.setPersistentOnlyOn();
            this.specialisationConstraintFn = Generator.this.beginAnonymousOperator();
            this.specialisationConstraintFn.setDeclaredReturnType(TypeBoolean.getInstance());
            this.specialisationConstraintFn.defineParameter(udt.getSupertype().getTypeName(), udt.getSupertype());
        }

        public void endSpecialisationConstraint() {
            Generator.this.compileReturnValue(this.specialisationConstraintFn.getDeclaredReturnType());
            Generator.this.endOperator();
            Generator.this.setPersistentOnlyOff();
            this.udt.setSpecialisationConstraint(this.specialisationConstraintFn.getOperator());
        }
    }

    public class Summarize {
        private OperatorDefinition summarizeOperator;
        private Extend outerExtend;
        private String r1ParmName = "%R1" + Generator.access$8();
        private String r2ParmName = "%R2" + Generator.access$8();
        private String yItemName = "%Y" + Generator.access$8();

        public Summarize(TypeRelation source, TypeRelation per) {
            summarizeParmNameSerial = summarizeParmNameSerial + 1;
            Heading common = source.getHeading().intersect(per.getHeading());
            this.summarizeOperator = Generator.this.beginAnonymousOperator();
            Generator.this.beginParameterDefinitions();
            Generator.this.defineOperatorParameter(this.r1ParmName, source);
            Generator.this.defineOperatorParameter(this.r2ParmName, per);
            Generator.this.endParameterDefinitions();
            Generator.this.compileGet(this.r2ParmName);
            this.outerExtend = new Extend(per.getHeading());
            Generator.this.compileGet(this.r1ParmName);
            RelationDefinition relDef = new RelationDefinition(common);
            TupleDefinition tupleDef = new TupleDefinition();
            for (Attribute attribute : common.getAttributes()) {
                Generator.this.compileGet(attribute.getName());
                tupleDef.setTupleAttribute(attribute.getName(), attribute.getType());
            }
            TypeTuple tupleType = tupleDef.endTuple();
            relDef.addTupleToRelation(tupleType);
            TypeRelation relationType = relDef.endRelation();
            TypeRelation typeOfY = Generator.this.compileRelationJoin(source, relationType);
            this.outerExtend.addExtendItem(this.yItemName, typeOfY);
        }

        public TypeRelation endSummarize() {
            TypeRelation extendType = Generator.this.endRelationExtend(this.outerExtend);
            SelectAttributes eliminateYProjector = new SelectAttributes();
            eliminateYProjector.add(this.yItemName);
            eliminateYProjector.setAllBut(true);
            TypeRelation result = Generator.this.compileRelationProject(extendType, eliminateYProjector);
            Generator.this.setDeclaredReturnType(result);
            Generator.this.compileReturnValue(result);
            Generator.this.endOperator();
            return (TypeRelation)Generator.this.compileEvaluate(this.summarizeOperator);
        }

        public class SummarizeItem {
            private Extend innerExtend;
            private TypeRelation typeOfY;
            private String extendAttributeName = "%X" + Generator.access$6();
            private boolean isDistinct;

            public SummarizeItem() {
                summarizeItemNameSerial = summarizeItemNameSerial + 1;
                this.typeOfY = (TypeRelation)Generator.this.compileGet(Summarize.this.yItemName);
            }

            public String getExtendAttributeName() {
                return this.extendAttributeName;
            }

            public TypeRelation getTypeOfY() {
                return this.typeOfY;
            }

            public void beginSummarizeItemExpression() {
                this.innerExtend = new Extend(this.typeOfY.getHeading());
            }

            public TypeRelation endSummarizeItemExpression(Type exprType, boolean distinct) {
                this.innerExtend.addExtendItem(this.extendAttributeName, exprType);
                TypeRelation forAggregateExpressionType = Generator.this.endRelationExtend(this.innerExtend);
                if (distinct) {
                    SelectAttributes distinctProjector = new SelectAttributes();
                    distinctProjector.add(this.extendAttributeName);
                    forAggregateExpressionType = Generator.this.compileRelationProject(forAggregateExpressionType, distinctProjector);
                }
                return forAggregateExpressionType;
            }

            public void endSummarizeItem(Type aggReturnType, String aggResultName) {
                Summarize.this.outerExtend.addExtendItem(aggResultName, aggReturnType);
            }

            public void setDistinct(boolean b) {
                this.isDistinct = b;
            }

            public boolean isDistinct() {
                return this.isDistinct;
            }
        }
    }

    private abstract class TupleAttributeExposure {
        TupleAttributeExposure(final String sourceTupleParameterName, Heading heading) {
            int index = 0;
            for (final Attribute attribute : heading.getAttributes()) {
                final int depth = Generator.this.currentOperatorDefinition.getDepth();
                Generator.this.currentOperatorDefinition.defineSlot(attribute.getName(), new SlotScoped(depth, index++, attribute.getType()){

                    @Override
                    public void compileGet(Generator generator) {
                        generator.compileGet(sourceTupleParameterName);
                        generator.compileInstruction(new OpTupleGetAttribute(this.getOffset()));
                    }

                    @Override
                    public void compileSet(Generator generator) {
                        TupleAttributeExposure.this.compileSet(generator, attribute, this.getDepth(), depth, this.getOffset());
                    }

                    @Override
                    public void compileInitialise(Generator generator) {
                        throw new ExceptionFatal("RS0297: compileInitialise invoked on SlotScoped in TupleAttributeExposure.");
                    }
                });
            }
        }

        abstract void compileSet(Generator var1, Attribute var2, int var3, int var4, int var5);
    }

    public class TupleDefinition {
        private Heading heading = new Heading();
        private boolean wildcard = false;

        public void setTupleAttribute(String name, Type type) {
            this.heading.add(name, type);
        }

        public TypeTuple endTuple() {
            if (this.wildcard) {
                OperatorDefinition currentOperator = Generator.this.getCurrentOperatorDefinition();
                while (currentOperator != null) {
                    OperatorSignature currentOperatorSignature = currentOperator.getSignature();
                    int parmCount = currentOperatorSignature.getParmCount();
                    int parm = 0;
                    while (parm < parmCount) {
                        String name = currentOperatorSignature.getParameterName(parm);
                        if (name.startsWith("%tuple") || name.startsWith("%source_tuple")) {
                            return (TypeTuple)Generator.this.compileGet(name);
                        }
                        ++parm;
                    }
                    currentOperator = currentOperator.getParentOperatorDefinition();
                }
            }
            Generator.this.compileInstruction(new OpTuplePushLiteral(this.heading.getDegree()));
            return new TypeTuple(this.heading);
        }

        public void setWildcard() {
            this.wildcard = true;
        }
    }

    private class TupleFilterOperator
    extends AnonymousTupleOperator {
        private String contextDescription;

        TupleFilterOperator(TypeTuple source, String contextDescription) {
            super(source, TypeBoolean.getInstance());
            this.contextDescription = contextDescription;
        }

        @Override
        public void compileSet(Generator generator, Attribute attribute, int slotDepth, int operatorDepth, int offset) {
            throw new ExceptionFatal("RS0298: Attempt to set attribute " + attribute.getName() + " in " + this.contextDescription + ".");
        }
    }

    private class TupleMapOperator
    extends AnonymousTupleOperator {
        private String contextDescription;

        TupleMapOperator(TypeTuple source, String contextDescription) {
            super(source, source);
            this.contextDescription = contextDescription;
        }

        @Override
        public void compileSet(Generator generator, Attribute attribute, int slotDepth, int operatorDepth, int offset) {
            if (slotDepth != operatorDepth) {
                throw new ExceptionSemantic("RS0058: " + this.contextDescription + " may only assign values to the most local tuple's attributes.");
            }
            generator.compileGet(this.getTupleParameterName());
            generator.compileInstruction(new OpTupleSetAttribute(offset));
            generator.compileSet(this.getTupleParameterName());
        }

        @Override
        void end() {
            Generator.this.compileGet(this.getTupleParameterName());
            super.end();
        }
    }

    private class TupleProcessOperator
    extends AnonymousTupleOperator {
        private String contextDescription;

        TupleProcessOperator(TypeTuple source, String contextDescription) {
            super(source, null);
            this.contextDescription = contextDescription;
        }

        @Override
        public void compileSet(Generator generator, Attribute attribute, int slotDepth, int operatorDepth, int offset) {
            throw new ExceptionFatal("RS0302: Attempt to set attribute '" + attribute.getName() + "' in " + this.contextDescription + ".");
        }
    }

    public class TupleSubstitute {
        private AnonymousTupleOperator updateOp;

        public TupleSubstitute(TypeTuple sourceType) {
            this.updateOp = new TupleMapOperator(sourceType, "Tuple UPDATE");
        }

        public TypeTuple endTupleSubstitute() {
            this.updateOp.end();
            return (TypeTuple)Generator.this.compileEvaluate(this.updateOp.getOperatorDefinition());
        }
    }

    public class UpdateWhere {
        private AnonymousTupleOperator tupleUpdateOp = null;
        private AnonymousTupleOperator tupleFilterOp = null;
        private TypeTuple sourceTupleType;
        private Slot reference;

        public UpdateWhere(String relvarName, TypeRelation sourceType) {
            this.reference = Generator.this.findReference(relvarName);
            if (!(this.reference instanceof Relvar || this.reference instanceof RelvarPrivate || this.reference.getType().toString().startsWith("RELATION"))) {
                throw new ExceptionSemantic("RS0061: Expected a relation-valued variable or attribute in UPDATE ... WHERE but got " + this.reference.getType());
            }
            if (this.reference.isParameter()) {
                throw new ExceptionSemantic("RS0402: Parameter is not updateable.");
            }
            this.sourceTupleType = new TypeTuple(sourceType.getHeading());
        }

        public void beginRelvarUpdateWhere() {
            this.tupleFilterOp = new TupleFilterOperator(this.sourceTupleType, "UPDATE ... WHERE");
        }

        public void endRelvarUpdateWhere() {
            this.tupleFilterOp.end();
        }

        public void beginRelvarUpdateAssignment() {
            this.tupleUpdateOp = new TupleMapOperator(this.sourceTupleType, "Tuple UPDATE");
        }

        public void endUpdateWhere() {
            this.tupleUpdateOp.end();
            this.reference.compileGet(Generator.this);
            if (this.tupleFilterOp != null) {
                Generator.this.compileInstruction(new OpRelvarUpdateWhere(this.tupleFilterOp.getOperator(), this.tupleUpdateOp.getOperator()));
            } else {
                Generator.this.compileInstruction(new OpRelvarUpdate(this.tupleUpdateOp.getOperator()));
            }
        }
    }

    public class Where {
        private TypeRelation operandType;
        private AnonymousTupleOperator whereOperator;

        public Where(TypeRelation operand) {
            this.operandType = operand;
            this.whereOperator = new TupleFilterOperator(new TypeTuple(operand.getHeading()), "WHERE");
        }

        public TypeRelation endWhere() {
            this.whereOperator.end();
            Generator.this.compileInstruction(new OpRelationWhere(this.whereOperator.getOperator()));
            return this.operandType;
        }
    }

    public class With {
        private OperatorDefinition withWrapper;

        public With() {
            this.withWrapper = Generator.this.beginAnonymousOperator();
        }

        public void addWithItem(Type expressionType, String introducedName) {
            Generator.this.defineConstant(introducedName, expressionType);
        }

        public Type endWith(Type expressionType) {
            Generator.this.setDeclaredReturnType(expressionType);
            Generator.this.compileReturnValue(expressionType);
            Generator.this.endOperator();
            return Generator.this.compileEvaluate(this.withWrapper);
        }
    }
}

