/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinitionNative;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.NativeFunction;
import org.reldb.rel.v0.vm.instructions.core.OpNativeFunction;

public class OperatorDefinitionNativeFunction
extends OperatorDefinitionNative {
    private NativeFunction operator;
    private String language = "Java";

    public OperatorDefinitionNativeFunction(String name, Type[] parameters, Type returnType, NativeFunction fn) {
        super(name, parameters);
        this.setDeclaredReturnType(returnType);
        this.operator = fn;
    }

    public OperatorDefinitionNativeFunction(OperatorSignature signature, NativeFunction fn) {
        this(signature.getName(), signature.getParameterTypes(), signature.getReturnType(), fn);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public void compileCall(Generator generator) {
        generator.compileInstruction(new OpNativeFunction(this.operator, this.getParmCount()));
        generator.compilePop();
    }

    @Override
    public Type compileEvaluate(Generator generator) {
        generator.compileInstruction(new OpNativeFunction(this.operator, this.getParmCount()));
        return this.getDeclaredReturnType();
    }

    @Override
    public void call(Context context) {
        new OpNativeFunction(this.operator, this.getParmCount()).execute(context);
        context.pop();
    }

    @Override
    public void evaluate(Context context) {
        new OpNativeFunction(this.operator, this.getParmCount()).execute(context);
    }
}

