/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import java.lang.reflect.Method;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinitionNative;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.instructions.system.OpJavaCall;

public class OperatorDefinitionNativeFunctionExternal
extends OperatorDefinitionNative {
    private Method method;

    public OperatorDefinitionNativeFunctionExternal(OperatorSignature sig, Method method) {
        super(sig.getName(), sig.getParameterTypes());
        this.setDeclaredReturnType(sig.getReturnType());
        this.method = method;
    }

    @Override
    public String getLanguage() {
        return "JavaF";
    }

    @Override
    public void compileCall(Generator generator) {
        generator.compileInstruction(new OpJavaCall(this.method));
        generator.compilePop();
    }

    @Override
    public Type compileEvaluate(Generator generator) {
        generator.compileInstruction(new OpJavaCall(this.method));
        return this.getDeclaredReturnType();
    }

    @Override
    public void call(Context context) {
        new OpJavaCall(this.method).execute(context);
        context.pop();
    }

    @Override
    public void evaluate(Context context) {
        new OpJavaCall(this.method).execute(context);
    }
}

