/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinitionNative;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.NativeProcedure;
import org.reldb.rel.v0.vm.instructions.core.OpNativeProcedure;

public class OperatorDefinitionNativeProcedure
extends OperatorDefinitionNative {
    private NativeProcedure operator;

    public OperatorDefinitionNativeProcedure(String name, Type[] parameters, NativeProcedure fn) {
        super(name, parameters);
        this.operator = fn;
    }

    @Override
    public String getLanguage() {
        return "JavaP";
    }

    @Override
    public void compileCall(Generator generator) {
        generator.compileInstruction(new OpNativeProcedure(this.operator, this.getParmCount()));
    }

    private void noEvaluate() {
        throw new ExceptionSemantic("RS0093: Attempt to evaluate " + this.getSignature() + " which does not have a return value.");
    }

    @Override
    public Type compileEvaluate(Generator generator) {
        this.noEvaluate();
        return null;
    }

    @Override
    public void call(Context context) {
        new OpNativeProcedure(this.operator, this.getParmCount()).execute(context);
    }

    @Override
    public void evaluate(Context context) {
        this.noEvaluate();
    }
}

