/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import java.lang.reflect.Method;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinitionNative;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.instructions.system.OpJavaCall;

public class OperatorDefinitionNativeProcedureExternal
extends OperatorDefinitionNative {
    private Method method;

    public OperatorDefinitionNativeProcedureExternal(OperatorSignature sig, Method method) {
        super(sig.getName(), sig.getParameterTypes());
        this.method = method;
    }

    @Override
    public String getLanguage() {
        return "JavaP";
    }

    private void noEvaluate() {
        throw new ExceptionSemantic("RS0094: Attempt to evaluate " + this.getSignature() + " which does not have a return value.");
    }

    @Override
    public void compileCall(Generator generator) {
        generator.compileInstruction(new OpJavaCall(this.method));
    }

    @Override
    public Type compileEvaluate(Generator generator) {
        this.noEvaluate();
        return null;
    }

    @Override
    public void call(Context context) {
        new OpJavaCall(this.method).execute(context);
    }

    @Override
    public void evaluate(Context context) {
        this.noEvaluate();
    }
}

