/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.debuginfo.DebugInfo;
import org.reldb.rel.v0.generator.Constant;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinition;
import org.reldb.rel.v0.generator.OperatorDefinitionAbstract;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.generator.Parameter;
import org.reldb.rel.v0.generator.Slot;
import org.reldb.rel.v0.generator.SlotScoped;
import org.reldb.rel.v0.generator.Variable;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Instruction;
import org.reldb.rel.v0.vm.Operator;
import org.reldb.rel.v0.vm.instructions.core.OpInvoke;

public class OperatorDefinitionRel
extends OperatorDefinitionAbstract {
    private OperatorDefinition parent;
    private Operator operator;
    private HashMap<OperatorSignature, OperatorDefinition> operators;
    private HashMap<String, Slot> slots;
    private int startLine;

    public OperatorDefinitionRel(int startLine, String operatorName, OperatorDefinition parentDefinition) {
        super(operatorName);
        this.startLine = startLine;
        this.parent = parentDefinition;
        this.operator = new Operator(this.parent == null ? 0 : this.parent.getDepth() + 1);
        this.operators = new HashMap();
        this.slots = new HashMap();
    }

    @Override
    public String getLanguage() {
        return "Rel";
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getDepth() {
        return this.operator.getDepth();
    }

    @Override
    public OperatorDefinition getParentOperatorDefinition() {
        return this.parent;
    }

    @Override
    public void compile(DebugInfo errorContext, Instruction o) {
        o.setDebugInfo(errorContext);
        this.operator.compile(o);
    }

    @Override
    public void compileAt(DebugInfo errorContext, Instruction o, int address) {
        o.setDebugInfo(errorContext);
        this.operator.compileAt(address, o);
    }

    @Override
    public int getCP() {
        return this.operator.size();
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public int getExecutableSize() {
        return this.operator.size();
    }

    @Override
    public boolean isDefined(String name) {
        return this.slots.containsKey(name);
    }

    private void checkDefined(String name) {
        if (this.isDefined(name)) {
            throw new ExceptionSemantic("RS0095: " + name + " is already defined in operator " + this.getSignature());
        }
    }

    @Override
    public void defineSlot(String name, SlotScoped slot) {
        this.checkDefined(name);
        this.slots.put(name, slot);
    }

    private void defineVariable(String name, SlotScoped slot) {
        this.defineSlot(name, slot);
        this.operator.setVariableCount(this.operator.getVariableCount() + 1);
    }

    @Override
    public void defineVariable(String name, Type type) {
        this.defineVariable(name, new Variable(this.operator.getDepth(), this.operator.getVariableCount(), type));
    }

    @Override
    public void defineConstant(String name, Type type) {
        this.defineVariable(name, new Constant(this.operator.getDepth(), this.operator.getVariableCount(), type));
    }

    @Override
    public void defineParameter(String name, Type type) {
        this.defineSlot(name, new Parameter(this.operator.getDepth(), this.operator.getParameterCount(), type));
        this.getSignature().addParameter(name, type);
        this.operator.setParameterCount(this.operator.getParameterCount() + 1);
    }

    @Override
    public void defineRelvarPrivate(RelDatabase database, String name, RelvarHeading keydef) {
        this.defineVariable(name, database.createPrivateRelvar(this.operator.getDepth(), this.operator.getVariableCount(), keydef));
    }

    @Override
    public Slot findReference(String name) {
        return this.slots.get(name);
    }

    @Override
    public Slot getReference(String name) {
        OperatorDefinition definition = this;
        while (definition != null) {
            Slot slot = definition.findReference(name);
            if (slot != null) {
                return slot;
            }
            definition = definition.getParentOperatorDefinition();
        }
        return null;
    }

    private boolean isOperatorDefined(OperatorSignature signature) {
        return this.operators.containsKey(signature);
    }

    @Override
    public void defineOperator(OperatorDefinition definition) {
        OperatorSignature signature = definition.getSignature();
        if (signature.isAnonymous()) {
            return;
        }
        if (this.isOperatorDefined(signature)) {
            throw new ExceptionSemantic("RS0096: Operator " + signature + " is already defined.");
        }
        this.operators.put(signature, definition);
    }

    @Override
    public void removeOperator(OperatorSignature signature) {
        this.operators.remove(signature);
    }

    @Override
    public OperatorDefinition findOperator(OperatorSignature signature) {
        return this.operators.get(signature);
    }

    @Override
    public OperatorDefinition getOperator(OperatorSignature signature) {
        OperatorDefinition definition = this;
        while (definition != null) {
            OperatorDefinition operator = definition.findOperator(signature);
            if (operator != null) {
                return operator;
            }
            definition = definition.getParentOperatorDefinition();
        }
        return null;
    }

    @Override
    public Iterator<OperatorDefinition> getOperators() {
        return this.operators.values().iterator();
    }

    @Override
    public void getPossibleTargetOperators(HashSet<OperatorSignature> targets, OperatorSignature invocationSignature) {
        OperatorDefinition definition = this;
        while (definition != null) {
            Iterator<OperatorDefinition> i = definition.getOperators();
            if (i != null) {
                while (i.hasNext()) {
                    OperatorDefinition operator = i.next();
                    OperatorSignature signature = operator.getSignature();
                    if (!signature.canBeInvokedBy(invocationSignature)) continue;
                    targets.add(signature);
                }
            }
            definition = definition.getParentOperatorDefinition();
        }
    }

    @Override
    public void compileCall(Generator generator) {
        generator.compileInstruction(new OpInvoke(this.getOperator()));
        if (this.hasReturnDeclaration()) {
            generator.compilePop();
        }
    }

    private void checkHasReturn() {
        if (!this.hasReturnDeclaration()) {
            throw new ExceptionSemantic("RS0097: Attempt to evaluate " + this.getSignature() + " which does not have a return value.");
        }
    }

    @Override
    public Type compileEvaluate(Generator generator) {
        generator.compileInstruction(new OpInvoke(this.getOperator()));
        this.checkHasReturn();
        return this.getDeclaredReturnType();
    }

    @Override
    public void call(Context context) {
        new OpInvoke(this.getOperator()).execute(context);
        if (this.hasReturnDeclaration()) {
            context.pop();
        }
    }

    @Override
    public void evaluate(Context context) {
        this.checkHasReturn();
        new OpInvoke(this.getOperator()).execute(context);
    }
}

