/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import java.util.Vector;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;

public class OperatorSignature
implements Comparable<OperatorSignature> {
    private Vector<Type> parameterTypes = new Vector();
    private Vector<String> parameterNames = null;
    private Type returnType;
    private String name;

    public OperatorSignature(String name) {
        this.name = name;
    }

    public boolean canBeInvokedBy(OperatorSignature signature) {
        if (this.name == null && signature.name != null) {
            return false;
        }
        if (this.name != null && signature.name == null) {
            return false;
        }
        if (this.name != null && signature.name != null && !this.name.equals(signature.name)) {
            return false;
        }
        if (this.parameterTypes.size() != signature.parameterTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < this.parameterTypes.size()) {
            if (!this.parameterTypes.get(i).canAccept(signature.parameterTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getInvocationDistance(OperatorSignature signature) {
        if (this.parameterTypes.size() != signature.parameterTypes.size()) {
            return Integer.MAX_VALUE;
        }
        int totalDistance = 0;
        int i = 0;
        while (i < this.parameterTypes.size()) {
            if (!signature.parameterTypes.get(i).canAccept(this.parameterTypes.get(i))) {
                return Integer.MAX_VALUE;
            }
            if (!(this.parameterTypes.get(i) instanceof TypeAlpha)) {
                totalDistance += 0;
            } else {
                TypeAlpha t = (TypeAlpha)signature.getParameterType(i);
                while (t != null && !t.getTypeName().equals(((TypeAlpha)this.parameterTypes.get(i)).getTypeName())) {
                    ++totalDistance;
                    t = t.getSupertype();
                }
            }
            ++i;
        }
        return totalDistance;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPossiblyDynamicDispatch() {
        for (Type parmType : this.parameterTypes) {
            if (!(parmType instanceof TypeAlpha)) continue;
            return true;
        }
        return false;
    }

    public void addParameter(String name, Type t) {
        if (name == null) {
            throw new ExceptionFatal("RS0303: Attempt to define null parameter name.");
        }
        if (t == null) {
            throw new ExceptionFatal("RS0304: Attempt to define null parameter type.");
        }
        if (this.parameterNames == null) {
            this.parameterNames = new Vector();
        }
        this.parameterNames.add(name);
        this.parameterTypes.add(t);
    }

    public void addParameterType(Type t) {
        this.parameterTypes.add(t);
        if (t == null) {
            throw new ExceptionFatal("RS0305: Attempt to define null parameter type.");
        }
    }

    public int getParmCount() {
        return this.parameterTypes.size();
    }

    /*
     * Unable to fully structure code
     */
    public void setParameterType(int index, Type t) {
        if (t != null) ** GOTO lbl5
        throw new ExceptionFatal("RS0306: Attempt to define null parameter type.");
lbl-1000:
        // 1 sources

        {
            this.parameterTypes.add(null);
lbl5:
            // 2 sources

            ** while (this.parameterTypes.size() <= index)
        }
lbl6:
        // 1 sources

        this.parameterTypes.set(index, t);
    }

    public Type getParameterType(int index) {
        return this.parameterTypes.get(index);
    }

    public String getParameterName(int index) {
        return this.parameterNames.get(index);
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes.toArray(new Type[0]);
    }

    public void setReturnType(Type type) {
        this.returnType = type;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public int compareTo(OperatorSignature o) {
        return this.toRelLookupString().compareToIgnoreCase(o.toRelLookupString());
    }

    public boolean equals(Object o) {
        return this.compareTo((OperatorSignature)o) == 0;
    }

    public int hashCode() {
        return this.toRelLookupString().hashCode();
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public String toString() {
        if (this.getReturnType() == null) {
            return this.toRelLookupString();
        }
        return String.valueOf(this.toRelLookupString()) + " RETURNS " + this.getReturnType().getSignature();
    }

    private String toFinalSignature(String parmSignature) {
        return String.valueOf(this.isAnonymous() ? "" : this.getName()) + "(" + parmSignature + ")";
    }

    public String toNativeLookupString() {
        String parmSignature = "";
        for (Type type : this.parameterTypes) {
            parmSignature = String.valueOf(parmSignature) + (parmSignature.length() == 0 ? type.getClass().getCanonicalName() : ", " + type.getClass().getCanonicalName());
        }
        return this.toFinalSignature(parmSignature);
    }

    public String toRelLookupString() {
        String parmSignature = "";
        for (Type type : this.parameterTypes) {
            parmSignature = String.valueOf(parmSignature) + (parmSignature.length() == 0 ? type.getSignature() : ", " + type.getSignature());
        }
        return this.toFinalSignature(parmSignature);
    }

    public String getOperatorDeclaration() {
        String parmSignature = "";
        int nameIndex = 0;
        for (Type type : this.parameterTypes) {
            String parmDef = String.valueOf(this.parameterNames.get(nameIndex)) + " " + type.getSignature();
            parmSignature = String.valueOf(parmSignature) + (parmSignature.length() == 0 ? parmDef : ", " + parmDef);
            ++nameIndex;
        }
        return "OPERATOR " + this.toFinalSignature(parmSignature) + (this.returnType != null ? " RETURNS " + this.returnType.getSignature() : "");
    }

    private static String classNameMung(String s) {
        char[] strbuf = s.toCharArray();
        int i = 0;
        while (i < strbuf.length) {
            if (!Character.isJavaIdentifierPart(strbuf[i])) {
                strbuf[i] = 95;
            }
            ++i;
        }
        return new String(strbuf);
    }

    public String getClassSignature() {
        String s = "op_" + this.getName() + "_";
        int i = 0;
        while (i < this.getParmCount()) {
            s = String.valueOf(s) + "_" + OperatorSignature.classNameMung(this.getParameterType(i).toString());
            ++i;
        }
        return s;
    }
}

