/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.generator;

import java.util.Vector;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.types.Attribute;
import org.reldb.rel.v0.types.Heading;

public class SelectAttributes {
    private Vector<String> names = new Vector();
    private boolean isAllBut = false;

    public SelectAttributes() {
    }

    public SelectAttributes(Heading heading) {
        this.add(heading.getAttributes());
    }

    public void setAllBut(boolean flag) {
        this.isAllBut = flag;
    }

    public boolean isAllBut() {
        return this.isAllBut;
    }

    public boolean isEverything() {
        return this.isAllBut && this.names.size() == 0;
    }

    public void makeNamesExplicit(Heading heading) {
        if (this.isAllBut) {
            Vector<String> newNames = new Vector<String>();
            for (Attribute attribute : heading.getAttributes()) {
                if (this.names.contains(attribute.getName())) continue;
                newNames.add(attribute.getName());
            }
            this.names = newNames;
            this.isAllBut = false;
        }
    }

    public boolean isASubsetOf(SelectAttributes key2) {
        if (this.getNames().size() == 0) {
            return true;
        }
        for (String attribute : this.getNames()) {
            if (key2.getNames().indexOf(attribute) >= 0) continue;
            return false;
        }
        return true;
    }

    public void add(String name) {
        if (this.names.contains(name)) {
            throw new ExceptionSemantic("RS0098: Duplicate reference to " + name + ".");
        }
        this.names.add(name);
    }

    public void add(Vector<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            this.add(attribute.getName());
        }
    }

    public Vector<String> getNames() {
        return this.names;
    }

    public void rename(String from, String to) {
        int i = 0;
        while (i < this.names.size()) {
            if (this.names.get(i).equals(from)) {
                if (this.names.contains(to)) {
                    throw new ExceptionSemantic("RS0437: Name '" + to + "' already exists.");
                }
                this.names.set(i, to);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(this.isAllBut ? "ALL BUT " : "");
        boolean atLeastOneProcessed = false;
        for (String name : this.names) {
            if (atLeastOneProcessed) {
                out.append(", ");
            } else {
                atLeastOneProcessed = true;
            }
            out.append(name);
        }
        return out.toString();
    }
}

