/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.interpreter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.debuginfo.DebugInfo;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinition;
import org.reldb.rel.v0.generator.OperatorDefinitionRel;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.interpreter.Evaluation;
import org.reldb.rel.v0.interpreter.TutorialDDebugger;
import org.reldb.rel.v0.interpreter.TutorialDParser;
import org.reldb.rel.v0.languages.tutoriald.parser.ParseException;
import org.reldb.rel.v0.languages.tutoriald.parser.TutorialD;
import org.reldb.rel.v0.languages.tutoriald.parser.TutorialDVisitor;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.values.ValueOperator;
import org.reldb.rel.v0.vm.Dumper;
import org.reldb.rel.v0.vm.VirtualMachine;

public class Interpreter {
    private Generator generator;
    private VirtualMachine vm;
    private boolean debugOnRun = false;
    private boolean debugAST = false;

    public Interpreter(RelDatabase database, PrintStream outputStream) {
        this.generator = new Generator(database, outputStream);
        this.vm = new VirtualMachine(this.generator, database, outputStream);
    }

    public void setDebugOnRun(boolean flag) {
        this.debugOnRun = flag;
    }

    public void setDebugAST(boolean flag) {
        this.debugAST = flag;
    }

    public void reset() {
        this.generator.reset();
        this.vm.reset();
    }

    public Generator getGenerator() {
        return this.generator;
    }

    private void beginCompile() {
        if (this.debugOnRun) {
            System.out.println("Compiling...");
        }
    }

    private void execute(OperatorDefinitionRel mainOperatorDefinition) {
        if (this.debugOnRun) {
            System.out.println("Compiled:");
            new Dumper().dumpMachineCode(mainOperatorDefinition.getOperator());
            System.out.println("Executing...");
        }
        if (mainOperatorDefinition != null) {
            this.vm.execute(mainOperatorDefinition.getOperator());
        } else {
            System.out.println("No execution performed.");
        }
    }

    private void run(TutorialD parseEngine, OperatorDefinitionRel mainOperatorDefinition) {
        try {
            this.execute(mainOperatorDefinition);
        }
        catch (ExceptionSemantic es) {
            throw new ExceptionSemantic(String.valueOf(es.getMessage()) + "\n" + this.vm.getCurrentInstruction().getDebugInfo().toString(), (Throwable)es);
        }
        catch (ExceptionFatal ef) {
            throw new ExceptionFatal(String.valueOf(ef.getMessage()) + "\n" + this.vm.getCurrentInstruction().getDebugInfo().toString(), (Throwable)ef);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal(String.valueOf(t.toString()) + "\n" + this.vm.getCurrentInstruction().getDebugInfo().toString(), t);
        }
    }

    private static DebugInfo getDebugInfo(Generator generator, TutorialDParser parser) {
        return new DebugInfo(parser.getCurrentNode(), generator.getOperatorDefinitionLineReferenceStack(parser.getCurrentNode().first_token.beginLine));
    }

    public static Evaluation evaluateExpression(RelDatabase database, String source, PrintStream outputStream) throws ParseException {
        return new Interpreter(database, outputStream).evaluate(source);
    }

    public static void executeStatement(RelDatabase database, String source, PrintStream outputStream) throws ParseException {
        new Interpreter(database, outputStream).interpret(source);
    }

    public static void executeStatementPrivileged(RelDatabase database, String source, String owner, PrintStream outputStream) throws ParseException {
        Interpreter interpreter = new Interpreter(database, outputStream);
        interpreter.getGenerator().setOwner(owner);
        interpreter.interpret(source);
    }

    public Evaluation evaluate(TutorialDVisitor parser, InputStream input) throws ParseException {
        this.beginCompile();
        TutorialD parseEngine = new TutorialD(input);
        parseEngine.setTabSize(4);
        OperatorDefinitionRel mainOperatorDefinition = null;
        try {
            mainOperatorDefinition = (OperatorDefinitionRel)parseEngine.evaluate().jjtAccept(parser, null);
        }
        catch (ExceptionSemantic es) {
            throw new ExceptionSemantic(String.valueOf(es.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, (TutorialDParser)parser).toString(), (Throwable)es);
        }
        catch (ExceptionFatal ef) {
            throw new ExceptionFatal(String.valueOf(ef.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, (TutorialDParser)parser).toString(), (Throwable)ef);
        }
        if (mainOperatorDefinition != null) {
            this.run(parseEngine, mainOperatorDefinition);
            if (this.vm.getStackCount() != 1) {
                throw new ExceptionFatal("Invalid count of values on the stack: " + this.vm.getStackCount());
            }
            return new Evaluation(this.vm.getCurrentContext(), mainOperatorDefinition.getDeclaredReturnType(), this.vm.pop());
        }
        System.out.println("No evaluation performed.");
        return null;
    }

    public void compileStatement(TutorialDVisitor parser, InputStream input) throws ParseException {
        this.beginCompile();
        TutorialD parseEngine = new TutorialD(input);
        parseEngine.setTabSize(4);
        try {
            parseEngine.statement().jjtAccept(parser, null);
        }
        catch (ExceptionSemantic es) {
            throw new ExceptionSemantic(String.valueOf(es.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, (TutorialDParser)parser).toString());
        }
        catch (ExceptionFatal ef) {
            throw new ExceptionFatal(String.valueOf(ef.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, (TutorialDParser)parser).toString());
        }
    }

    public void compileStatement(TutorialDVisitor parser, String input) throws ParseException {
        this.compileStatement(parser, new ByteArrayInputStream(input.getBytes()));
    }

    public void compileStatement(String input) throws ParseException {
        this.compileStatement((TutorialDVisitor)new TutorialDParser(this.generator), input);
    }

    public OperatorDefinition compileOperator(String input) throws ParseException {
        TutorialDParser parser = new TutorialDParser(this.generator);
        parser.beginOperatorsNonStorable();
        this.compileStatement((TutorialDVisitor)parser, input);
        parser.endOperatorsNonStorable();
        return parser.getLastPersistentOperatorDefinition();
    }

    public ValueOperator compileAnonymousOperator(String source) throws ParseException {
        TutorialDParser parser = new TutorialDParser(this.generator);
        return (ValueOperator)this.evaluate((TutorialDVisitor)parser, source).getValue();
    }

    public Type getOperatorReturnType(String input) throws ParseException {
        TutorialDParser parser = new TutorialDParser(this.generator);
        parser.beginOperatorsNonStorable();
        this.beginCompile();
        parser.endOperatorsNonStorable();
        TutorialD parseEngine = new TutorialD(new ByteArrayInputStream(input.getBytes()));
        parseEngine.setTabSize(4);
        try {
            return (Type)parseEngine.getoperatorreturntype().jjtAccept(parser, null);
        }
        catch (ExceptionSemantic es) {
            throw new ExceptionSemantic(String.valueOf(es.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, parser).toString());
        }
        catch (ExceptionFatal ef) {
            throw new ExceptionFatal(String.valueOf(ef.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, parser).toString());
        }
    }

    public Heading getHeading(String input) throws ParseException {
        TutorialDParser parser = new TutorialDParser(this.generator);
        this.beginCompile();
        TutorialD parseEngine = new TutorialD(new ByteArrayInputStream(input.getBytes()));
        parseEngine.setTabSize(4);
        try {
            return (Heading)parseEngine.getheading().jjtAccept(parser, null);
        }
        catch (ExceptionSemantic es) {
            throw new ExceptionSemantic(String.valueOf(es.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, parser).toString());
        }
        catch (ExceptionFatal ef) {
            throw new ExceptionFatal(String.valueOf(ef.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, parser).toString());
        }
    }

    public OperatorSignature getOperatorSignature(String input) throws ParseException {
        TutorialDParser parser = new TutorialDParser(this.generator);
        this.beginCompile();
        TutorialD parseEngine = new TutorialD(new ByteArrayInputStream(input.getBytes()));
        parseEngine.setTabSize(4);
        try {
            return (OperatorSignature)parseEngine.getsignature().jjtAccept(parser, null);
        }
        catch (ExceptionSemantic es) {
            throw new ExceptionSemantic(String.valueOf(es.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, parser).toString());
        }
        catch (ExceptionFatal ef) {
            throw new ExceptionFatal(String.valueOf(ef.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, parser).toString());
        }
    }

    public void interpret(TutorialDVisitor parser, InputStream input) throws ParseException {
        OperatorDefinitionRel mainOperatorDefinition;
        this.beginCompile();
        TutorialD parseEngine = new TutorialD(input);
        parseEngine.setTabSize(4);
        try {
            mainOperatorDefinition = (OperatorDefinitionRel)parseEngine.code().jjtAccept(parser, null);
        }
        catch (ExceptionSemantic es) {
            throw new ExceptionSemantic(String.valueOf(es.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, (TutorialDParser)parser).toString());
        }
        catch (ExceptionFatal ef) {
            throw new ExceptionFatal(String.valueOf(ef.getMessage()) + "\n" + Interpreter.getDebugInfo(this.generator, (TutorialDParser)parser).toString());
        }
        this.run(parseEngine, mainOperatorDefinition);
        this.vm.outputTupleUpdateNotices();
    }

    public void interpret(InputStream input) throws ParseException {
        TutorialDVisitor parser = this.debugAST ? new TutorialDDebugger() : new TutorialDParser(this.generator);
        this.interpret(parser, input);
    }

    public void interpret(String input) throws ParseException {
        this.interpret(new ByteArrayInputStream(input.getBytes()));
    }

    public void interpret(TutorialDVisitor parser, String input) throws ParseException {
        this.interpret(parser, new ByteArrayInputStream(input.getBytes()));
    }

    public Evaluation evaluate(InputStream input) throws ParseException {
        TutorialDVisitor parser = this.debugAST ? new TutorialDDebugger() : new TutorialDParser(this.generator);
        return this.evaluate(parser, input);
    }

    public Evaluation evaluate(String input) throws ParseException {
        return this.evaluate(new ByteArrayInputStream(input.getBytes()));
    }

    public Evaluation evaluate(TutorialDVisitor parser, String input) throws ParseException {
        return this.evaluate(parser, new ByteArrayInputStream(input.getBytes()));
    }
}

