/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.interpreter;

import org.reldb.rel.utilities.StringUtils;
import org.reldb.rel.v0.languages.tutoriald.parser.ParseException;
import org.reldb.rel.v0.languages.tutoriald.parser.Token;

public class ParseExceptionPrinter {
    public static String getParseExceptionMessage(ParseException pe) {
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        int[][] expectedTokenSequences = pe.expectedTokenSequences;
        String eol = System.getProperty("line.separator", "\n");
        String[] tokenImage = pe.tokenImage;
        Token currentToken = pe.currentToken;
        int i = 0;
        while (i < expectedTokenSequences.length) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < expectedTokenSequences[i].length) {
                expected.append(tokenImage[expectedTokenSequences[i][j]]).append(' ');
                ++j;
            }
            if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(eol).append("    ");
            ++i;
        }
        String retval = "Encountered ";
        Token tok = currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval) + tokenImage[0];
                break;
            }
            retval = String.valueOf(retval) + "\"";
            retval = String.valueOf(retval) + StringUtils.quote((String)tok.image);
            retval = String.valueOf(retval) + "\"";
            tok = tok.next;
            ++i2;
        }
        retval = String.valueOf(retval) + " at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn;
        retval = String.valueOf(retval) + "." + eol;
        retval = expectedTokenSequences.length == 1 ? String.valueOf(retval) + "Was expecting:" + eol + "    " : String.valueOf(retval) + "Was expecting one of:" + eol + "    ";
        retval = String.valueOf(retval) + expected.toString();
        return retval;
    }
}

