/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.HashMap;
import org.reldb.rel.v0.interpreter.Instance;
import org.reldb.rel.v0.server.Session;

public class Server {
    private static final int shutdownAttempts = 10;
    private int portNumber;
    private boolean running;
    private ServerSocket serverSocket;
    private HashMap<Long, Session> sessions;
    private Thread daemon;
    private Instance rel;

    public Server(Instance rel, int portNumber) {
        this.rel = rel;
        this.portNumber = portNumber;
        this.serverSocket = null;
        this.startup();
    }

    public Instance getInstance() {
        return this.rel;
    }

    void startup() {
        if (this.serverSocket != null) {
            return;
        }
        this.sessions = new HashMap();
        try {
            this.serverSocket = new ServerSocket(this.portNumber);
        }
        catch (IOException ioe) {
            System.out.println("Server: " + ioe);
            return;
        }
        this.daemon = new Thread(){

            @Override
            public void run() {
                Server.this.running = true;
                InetAddress ip = Server.this.serverSocket.getInetAddress();
                System.out.println("Server: Listening for connections on " + ip + ":" + Server.this.portNumber + " (" + Server.this.rel.getHost() + ")");
                while (Server.this.running) {
                    try {
                        new Session(Server.this, Server.this.serverSocket.accept());
                    }
                    catch (IOException ioe) {
                        System.out.println("Server: " + ioe.getMessage());
                        Server.this.running = false;
                        break;
                    }
                }
                System.out.println("Server: Turned off.");
            }
        };
        this.daemon.start();
    }

    public void shutdown() {
        System.out.println("Server: Shutting down...");
        if (this.serverSocket != null) {
            int i = 0;
            while (i < 10 && this.running) {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.serverSocket.close();
                    this.killAllSessions();
                }
                catch (IOException ioe) {
                    System.out.println("Server: " + ioe);
                }
                ++i;
            }
            if (i == 10) {
                System.out.println("Server: Forcing shutdown after 10 attempts.");
                this.daemon.interrupt();
            }
            this.serverSocket = null;
        }
    }

    synchronized void removeSession(Session s) {
        this.sessions.remove(new Long(s.getId()));
    }

    synchronized void addSession(Session s) {
        this.sessions.put(new Long(s.getId()), s);
    }

    void killAllSessions() {
        Session[] s;
        Session[] sessionArray = s = this.sessions.values().toArray(new Session[0]);
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            Session session = sessionArray[n2];
            session.kill();
            ++n2;
        }
    }
}

