/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.server;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.reldb.rel.v0.interpreter.Interpreter;
import org.reldb.rel.v0.server.Server;

public class Session {
    private static long sessionidgenerator = 0L;
    private Server server;
    private Socket socket;
    private boolean running;
    private long sessionid = sessionidgenerator++;

    public Session(final Server owner, Socket channel) {
        InetAddress ip = channel.getInetAddress();
        ip.getHostName();
        int remotePort = channel.getPort();
        System.out.println("Session: Open session " + this.sessionid + " to " + ip + ":" + remotePort);
        this.server = owner;
        this.socket = channel;
        Thread sessionThread = new Thread(){

            @Override
            public void run() {
                try {
                    Session.this.server.addSession(Session.this);
                    PrintStream output = new PrintStream(Session.this.socket.getOutputStream());
                    Interpreter interpreter = new Interpreter(owner.getInstance().getDatabase(), output);
                    Session.this.running = true;
                    owner.getInstance().announceActive(output);
                    output.println("<EOT>");
                    output.flush();
                    while (Session.this.running) {
                        try {
                            int prefix = Session.this.socket.getInputStream().read();
                            if (prefix < 0) break;
                            if (Character.isWhitespace((char)prefix)) continue;
                            if (prefix == 69) {
                                interpreter.evaluate(Session.this.socket.getInputStream()).toStream(output);
                                output.println();
                            } else if (prefix == 88) {
                                interpreter.interpret(Session.this.socket.getInputStream());
                                output.println("\nOk.");
                            } else if (prefix == 82) {
                                interpreter.reset();
                                output.println("\nCancel.");
                            } else {
                                output.println("ERROR: Rel server protocol error: expected 'R', 'E' or 'X', but got '" + (char)prefix + "'.");
                            }
                        }
                        catch (SocketException se) {
                            break;
                        }
                        catch (Throwable t) {
                            interpreter.reset();
                            output.println("ERROR: " + t.getMessage());
                        }
                        output.println("<EOT>");
                        output.flush();
                    }
                    output.close();
                }
                catch (IOException ioe) {
                    System.out.println("Session: " + ioe);
                }
                Session.this.kill();
            }
        };
        sessionThread.start();
    }

    public long getId() {
        return this.sessionid;
    }

    public synchronized void kill() {
        this.running = false;
        this.server.removeSession(this);
        if (this.socket == null) {
            return;
        }
        try {
            System.out.println("Session: Close session " + this.sessionid);
            this.socket.close();
            this.socket = null;
        }
        catch (IOException ioe) {
            System.out.println("Session: Unable to close socket " + this.socket);
        }
    }
}

