/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage;

import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinitionNativeFunction;
import org.reldb.rel.v0.generator.OperatorDefinitionNativeProcedure;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.TypeArray;
import org.reldb.rel.v0.types.TypeRelation;
import org.reldb.rel.v0.types.TypeTuple;
import org.reldb.rel.v0.types.builtin.TypeBoolean;
import org.reldb.rel.v0.types.builtin.TypeCharacter;
import org.reldb.rel.v0.types.builtin.TypeInteger;
import org.reldb.rel.v0.types.builtin.TypeRational;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueArray;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRational;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.vm.NativeFunction;
import org.reldb.rel.v0.vm.NativeProcedure;

public class BuiltinOperators {
    private Generator generator;
    private static Type[] primitiveTypes = new Type[]{TypeBoolean.getInstance(), TypeInteger.getInstance(), TypeRational.getInstance(), TypeCharacter.getInstance()};

    private void is_empty(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("IS_EMPTY", new Type[]{TypeRelation.getEmptyRelationType()}, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueRelation relation = (ValueRelation)arguments[0];
                return relation.is_empty();
            }
        }));
    }

    private void countRelation(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("COUNT", new Type[]{TypeRelation.getEmptyRelationType()}, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueRelation relation = (ValueRelation)arguments[0];
                return ValueInteger.select(BuiltinOperators.this.generator, relation.getCardinality());
            }
        }));
    }

    private void countArray(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("COUNT", new Type[]{TypeArray.getEmptyArrayType()}, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return ValueInteger.select(BuiltinOperators.this.generator, array.getCount());
            }
        }));
    }

    private void sum(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_SUM_INTEGER", new Type[]{TypeArray.getEmptyArrayType()}, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.sumInteger(0);
            }
        }));
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_SUM_RATIONAL", new Type[]{TypeArray.getEmptyArrayType()}, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.sumRational(0);
            }
        }));
    }

    private void avg(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_AVG_INTEGER", new Type[]{TypeArray.getEmptyArrayType()}, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.avgInteger(0);
            }
        }));
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_AVG_RATIONAL", new Type[]{TypeArray.getEmptyArrayType()}, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.avgRational(0);
            }
        }));
    }

    private void max(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_MAX", new Type[]{TypeArray.getEmptyArrayType()}, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.max(0);
            }
        }));
    }

    private void min(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_MIN", new Type[]{TypeArray.getEmptyArrayType()}, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.min(0);
            }
        }));
    }

    private void and(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_AND", new Type[]{TypeArray.getEmptyArrayType()}, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.and(0);
            }
        }));
    }

    private void or(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_OR", new Type[]{TypeArray.getEmptyArrayType()}, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.or(0);
            }
        }));
    }

    private void xor(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_XOR", new Type[]{TypeArray.getEmptyArrayType()}, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.xor(0);
            }
        }));
    }

    private void union(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_UNION", new Type[]{TypeArray.getEmptyArrayType()}, TypeRelation.getEmptyRelationType(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.union(0);
            }
        }));
    }

    private void xunion(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_XUNION", new Type[]{TypeArray.getEmptyArrayType()}, TypeRelation.getEmptyRelationType(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.xunion(0);
            }
        }));
    }

    private void d_union(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_D_UNION", new Type[]{TypeArray.getEmptyArrayType()}, TypeRelation.getEmptyRelationType(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.d_union(0);
            }
        }));
    }

    private void intersect(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("AGGREGATE_INTERSECT", new Type[]{TypeArray.getEmptyArrayType()}, TypeRelation.getEmptyRelationType(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueArray array = (ValueArray)arguments[0];
                return array.intersect(0);
            }
        }));
    }

    private void exactly(RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("EXACTLY", new Type[]{TypeRelation.getEmptyRelationType(), TypeInteger.getInstance(), TypeInteger.getInstance()}, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                ValueRelation relation = (ValueRelation)arguments[0];
                int attributeIndex = (int)arguments[1].longValue();
                long nCount = arguments[2].longValue();
                return relation.exactly(nCount, attributeIndex);
            }
        }));
    }

    private void cast_as_boolean(RelDatabase database) {
        Type[] typeArray = primitiveTypes;
        int n = primitiveTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("CAST_AS_BOOLEAN", new Type[]{type}, TypeBoolean.getInstance(), new NativeFunction(){

                @Override
                public Value evaluate(Value[] arguments) {
                    return ValueBoolean.select(BuiltinOperators.this.generator, arguments[0].booleanValue());
                }
            }));
            ++n2;
        }
    }

    private void cast_as_integer(RelDatabase database) {
        Type[] typeArray = primitiveTypes;
        int n = primitiveTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("CAST_AS_INTEGER", new Type[]{type}, TypeInteger.getInstance(), new NativeFunction(){

                @Override
                public Value evaluate(Value[] arguments) {
                    return ValueInteger.select(BuiltinOperators.this.generator, arguments[0].longValue());
                }
            }));
            ++n2;
        }
    }

    private void cast_as_rational(RelDatabase database) {
        Type[] typeArray = primitiveTypes;
        int n = primitiveTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("CAST_AS_RATIONAL", new Type[]{type}, TypeRational.getInstance(), new NativeFunction(){

                @Override
                public Value evaluate(Value[] arguments) {
                    return ValueRational.select(BuiltinOperators.this.generator, arguments[0].doubleValue());
                }
            }));
            ++n2;
        }
    }

    private void cast_as_char(RelDatabase database) {
        Type[] typeArray = primitiveTypes;
        int n = primitiveTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("CAST_AS_CHAR", new Type[]{type}, TypeCharacter.getInstance(), new NativeFunction(){

                @Override
                public Value evaluate(Value[] arguments) {
                    return ValueCharacter.select(BuiltinOperators.this.generator, arguments[0].stringValue());
                }
            }));
            ++n2;
        }
    }

    private void equals(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_EQUALS", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, arguments[0].compareTo(arguments[1]) == 0);
            }
        }));
    }

    private void equals(RelDatabase database) {
        this.equals(database, new Type[]{TypeRelation.getEmptyRelationType(), TypeRelation.getEmptyRelationType()});
        this.equals(database, new Type[]{TypeTuple.getEmptyTupleType(), TypeTuple.getEmptyTupleType()});
        this.equals(database, new Type[]{TypeAlpha.getEmptyAlphaType(), TypeAlpha.getEmptyAlphaType()});
    }

    private void notequals(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_NOTEQUALS", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, arguments[0].compareTo(arguments[1]) != 0);
            }
        }));
    }

    private void notequals(RelDatabase database) {
        this.notequals(database, new Type[]{TypeRelation.getEmptyRelationType(), TypeRelation.getEmptyRelationType()});
        this.notequals(database, new Type[]{TypeTuple.getEmptyTupleType(), TypeTuple.getEmptyTupleType()});
        this.notequals(database, new Type[]{TypeAlpha.getEmptyAlphaType(), TypeAlpha.getEmptyAlphaType()});
    }

    private void greaterthanequals(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_GREATERTHANOREQUALS", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, arguments[0].compareTo(arguments[1]) >= 0);
            }
        }));
    }

    private void superset(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_GREATERTHANOREQUALS", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, ((ValueRelation)arguments[0]).isSupersetOf((ValueRelation)arguments[1]));
            }
        }));
    }

    private void greaterthanequals(RelDatabase database) {
        this.superset(database, new Type[]{TypeRelation.getEmptyRelationType(), TypeRelation.getEmptyRelationType()});
        this.greaterthanequals(database, new Type[]{TypeTuple.getEmptyTupleType(), TypeTuple.getEmptyTupleType()});
        this.greaterthanequals(database, new Type[]{TypeAlpha.getEmptyAlphaType(), TypeAlpha.getEmptyAlphaType()});
    }

    private void lessthanequals(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_LESSTHANOREQUALS", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, arguments[0].compareTo(arguments[1]) <= 0);
            }
        }));
    }

    private void subset(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_LESSTHANOREQUALS", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, ((ValueRelation)arguments[0]).isSubsetOf((ValueRelation)arguments[1]));
            }
        }));
    }

    private void lessthanequals(RelDatabase database) {
        this.subset(database, new Type[]{TypeRelation.getEmptyRelationType(), TypeRelation.getEmptyRelationType()});
        this.lessthanequals(database, new Type[]{TypeTuple.getEmptyTupleType(), TypeTuple.getEmptyTupleType()});
        this.lessthanequals(database, new Type[]{TypeAlpha.getEmptyAlphaType(), TypeAlpha.getEmptyAlphaType()});
    }

    private void greaterthan(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_GREATERTHAN", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, arguments[0].compareTo(arguments[1]) > 0);
            }
        }));
    }

    private void propersuperset(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_GREATERTHAN", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, ((ValueRelation)arguments[0]).isProperSupersetOf((ValueRelation)arguments[1]));
            }
        }));
    }

    private void greaterthan(RelDatabase database) {
        this.propersuperset(database, new Type[]{TypeRelation.getEmptyRelationType(), TypeRelation.getEmptyRelationType()});
        this.greaterthan(database, new Type[]{TypeTuple.getEmptyTupleType(), TypeTuple.getEmptyTupleType()});
        this.greaterthan(database, new Type[]{TypeAlpha.getEmptyAlphaType(), TypeAlpha.getEmptyAlphaType()});
    }

    private void lessthan(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_LESSTHAN", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, arguments[0].compareTo(arguments[1]) < 0);
            }
        }));
    }

    private void propersubset(RelDatabase database, Type[] parameters) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("OP_LESSTHAN", parameters, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(BuiltinOperators.this.generator, ((ValueRelation)arguments[0]).isProperSubsetOf((ValueRelation)arguments[1]));
            }
        }));
    }

    private void lessthan(RelDatabase database) {
        this.propersubset(database, new Type[]{TypeRelation.getEmptyRelationType(), TypeRelation.getEmptyRelationType()});
        this.lessthan(database, new Type[]{TypeTuple.getEmptyTupleType(), TypeTuple.getEmptyTupleType()});
        this.lessthan(database, new Type[]{TypeAlpha.getEmptyAlphaType(), TypeAlpha.getEmptyAlphaType()});
    }

    private void getuniquenumber(final RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("GET_UNIQUE_NUMBER", new Type[0], TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueInteger.select(BuiltinOperators.this.generator, database.getUniqueID());
            }
        }));
    }

    private void setuniquenumber(final RelDatabase database) {
        database.defineBuiltinOperator(new OperatorDefinitionNativeProcedure("SET_UNIQUE_NUMBER", new Type[]{TypeInteger.getInstance()}, new NativeProcedure(){

            @Override
            public void execute(Value[] arguments) {
                database.setUniqueID(((ValueInteger)arguments[0]).longValue());
            }
        }));
    }

    private void sequence2(RelDatabase database, Type[] parameters) {
        Heading resultHeading = new Heading();
        resultHeading.add("N", TypeInteger.getInstance());
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("SEQUENCE", parameters, new TypeRelation(resultHeading), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueRelation.sequence(BuiltinOperators.this.generator, (ValueInteger)arguments[0], (ValueInteger)arguments[1]);
            }
        }));
    }

    private void sequence3(RelDatabase database, Type[] parameters) {
        Heading resultHeading = new Heading();
        resultHeading.add("N", TypeInteger.getInstance());
        database.defineBuiltinOperator(new OperatorDefinitionNativeFunction("SEQUENCE", parameters, new TypeRelation(resultHeading), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueRelation.sequence(BuiltinOperators.this.generator, (ValueInteger)arguments[0], (ValueInteger)arguments[1], (ValueInteger)arguments[2]);
            }
        }));
    }

    private void sequence(RelDatabase database) {
        this.sequence2(database, new Type[]{TypeInteger.getInstance(), TypeInteger.getInstance()});
        this.sequence3(database, new Type[]{TypeInteger.getInstance(), TypeInteger.getInstance(), TypeInteger.getInstance()});
    }

    private BuiltinOperators(RelDatabase database) {
        this.generator = new Generator(database, System.out);
        this.is_empty(database);
        this.countRelation(database);
        this.countArray(database);
        this.sum(database);
        this.avg(database);
        this.max(database);
        this.min(database);
        this.and(database);
        this.or(database);
        this.xor(database);
        this.union(database);
        this.xunion(database);
        this.d_union(database);
        this.intersect(database);
        this.exactly(database);
        this.cast_as_boolean(database);
        this.cast_as_integer(database);
        this.cast_as_rational(database);
        this.cast_as_char(database);
        this.equals(database);
        this.notequals(database);
        this.lessthanequals(database);
        this.greaterthanequals(database);
        this.lessthan(database);
        this.greaterthan(database);
        this.getuniquenumber(database);
        this.setuniquenumber(database);
        this.sequence(database);
    }

    public static void buildOperators(RelDatabase database) {
        new BuiltinOperators(database);
    }
}

