/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage;

import java.util.LinkedList;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.generator.References;
import org.reldb.rel.v0.interpreter.Interpreter;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.catalog.RelvarTypes;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.builtin.TypeBoolean;
import org.reldb.rel.v0.types.builtin.TypeCharacter;
import org.reldb.rel.v0.types.builtin.TypeInteger;
import org.reldb.rel.v0.types.builtin.TypeRational;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRational;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.NativeFunction;
import org.reldb.rel.v0.vm.VirtualMachine;

public class BuiltinTypeBuilder {
    public static final String EQUALS = "OP_EQUALS";
    public static final String NOTEQUALS = "OP_NOTEQUALS";
    public static final String GREATERTHAN = "OP_GREATERTHAN";
    public static final String LESSTHAN = "OP_LESSTHAN";
    public static final String GREATERTHANOREQUALS = "OP_GREATERTHANOREQUALS";
    public static final String LESSTHANOREQUALS = "OP_LESSTHANOREQUALS";
    public static final String MAX = "OP_MAX";
    public static final String MIN = "OP_MIN";
    public static final String XOR = "OP_XOR";
    public static final String OR = "OP_OR";
    public static final String AND = "OP_AND";
    public static final String NOT = "OP_NOT";
    public static final String PLUS = "OP_PLUS";
    public static final String MINUS = "OP_MINUS";
    public static final String TIMES = "OP_TIMES";
    public static final String DIVIDE = "OP_DIVIDE";
    public static final String MODULO = "OP_MODULO";
    public static final String UNARY_PLUS = "OP_UNARY_PLUS";
    public static final String UNARY_MINUS = "OP_UNARY_MINUS";
    private static LinkedList<String> subTypes = new LinkedList();
    private RelDatabase database;
    private Generator generator;
    private TypeAlpha type;
    private boolean typeExists;

    private static void loadSubtypes(RelDatabase database) {
        Interpreter interpreter = new Interpreter(database, System.out);
        Generator generator = interpreter.getGenerator();
        for (String typeName : subTypes) {
            database.loadType(generator, typeName);
        }
    }

    public BuiltinTypeBuilder(RelDatabase database, TypeAlpha type) {
        this.database = database;
        this.type = type;
        this.typeExists = false;
        Interpreter interpreter = new Interpreter(database, System.out);
        this.generator = interpreter.getGenerator();
        this.generator.beginCompilation();
        String typeName = type.getTypeName();
        if (database.isTypeExists(this.generator, typeName)) {
            this.generator.beginTypeRetrieval();
            this.generator.createTypeBuiltin(type);
            this.generator.endTypeRetrieval();
            RelvarTypes typesRelvar = (RelvarTypes)database.openGlobalRelvar("sys.Types");
            ValueTuple typeTuple = typesRelvar.getTupleForKey(this.generator, typeName);
            ValueRelation subTypeNames = (ValueRelation)typeTuple.getValues()[5];
            TupleIterator it = subTypeNames.iterator();
            while (it.hasNext()) {
                subTypes.add(it.next().getValues()[0].stringValue());
            }
            this.typeExists = true;
        } else {
            this.generator.createTypeBuiltin(type);
        }
    }

    public void checkTypeOperatorUnary(String name, TypeAlpha returnType, final NativeFunction operator) {
        String typeName = this.type.getTypeName();
        References referenceToType = new References();
        referenceToType.addReferenceToType(this.type.getTypeName());
        OperatorSignature signature = new OperatorSignature(name);
        signature.addParameter("%p0", this.type);
        signature.setReturnType(returnType);
        if (this.typeExists) {
            this.generator.beginTypeRetrieval();
        }
        Generator generator = this.generator;
        generator.getClass();
        new Generator.OperatorAssociatedWithType(generator, typeName, "Rel", signature, referenceToType){

            @Override
            public Value evaluate(Value[] arguments) {
                return operator.evaluate(arguments);
            }
        };
        if (this.typeExists) {
            this.generator.endTypeRetrieval();
        }
    }

    public void checkTypeOperatorBinary(String name, Type returnType, final NativeFunction operator) {
        String typeName = this.type.getTypeName();
        References referenceToType = new References();
        referenceToType.addReferenceToType(this.type.getTypeName());
        OperatorSignature signature = new OperatorSignature(name);
        signature.addParameter("%p0", this.type);
        signature.addParameter("%p1", this.type);
        signature.setReturnType(returnType);
        if (this.typeExists) {
            this.generator.beginTypeRetrieval();
        }
        Generator generator = this.generator;
        generator.getClass();
        new Generator.OperatorAssociatedWithType(generator, typeName, "Rel", signature, referenceToType){

            @Override
            public Value evaluate(Value[] arguments) {
                return operator.evaluate(arguments);
            }
        };
        if (this.typeExists) {
            this.generator.endTypeRetrieval();
        }
    }

    public void go() {
        this.generator.endCompilation().call(new Context(this.generator, new VirtualMachine(this.generator, this.database, System.out)));
    }

    public static void buildTypes(RelDatabase relDatabase) {
        final BuiltinTypeBuilder typeBuilderBoolean = new BuiltinTypeBuilder(relDatabase, TypeBoolean.getInstance());
        final BuiltinTypeBuilder typeBuilderInteger = new BuiltinTypeBuilder(relDatabase, TypeInteger.getInstance());
        final BuiltinTypeBuilder typeBuilderRational = new BuiltinTypeBuilder(relDatabase, TypeRational.getInstance());
        final BuiltinTypeBuilder typeBuilderCharacter = new BuiltinTypeBuilder(relDatabase, TypeCharacter.getInstance());
        typeBuilderBoolean.checkTypeOperatorBinary(EQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderBoolean.generator, arguments[0].booleanValue() == arguments[1].booleanValue());
            }
        });
        typeBuilderBoolean.checkTypeOperatorBinary(NOTEQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderBoolean.generator, arguments[0].booleanValue() ^ arguments[1].booleanValue());
            }
        });
        typeBuilderBoolean.checkTypeOperatorBinary(XOR, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderBoolean.generator, arguments[0].booleanValue() ^ arguments[1].booleanValue());
            }
        });
        typeBuilderBoolean.checkTypeOperatorBinary(OR, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderBoolean.generator, arguments[0].booleanValue() | arguments[1].booleanValue());
            }
        });
        typeBuilderBoolean.checkTypeOperatorBinary(AND, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderBoolean.generator, arguments[0].booleanValue() & arguments[1].booleanValue());
            }
        });
        typeBuilderBoolean.checkTypeOperatorUnary(NOT, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderBoolean.generator, !arguments[0].booleanValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(EQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderInteger.generator, arguments[0].longValue() == arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(NOTEQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderInteger.generator, arguments[0].longValue() != arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(GREATERTHANOREQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderInteger.generator, arguments[0].longValue() >= arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(LESSTHANOREQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderInteger.generator, arguments[0].longValue() <= arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(LESSTHAN, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderInteger.generator, arguments[0].longValue() < arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(GREATERTHAN, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderInteger.generator, arguments[0].longValue() > arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(MAX, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                if (arguments[0].longValue() > arguments[1].longValue()) {
                    return ValueInteger.select(typeBuilderInteger.generator, arguments[0].longValue());
                }
                return ValueInteger.select(typeBuilderInteger.generator, arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(MIN, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                if (arguments[0].longValue() < arguments[1].longValue()) {
                    return ValueInteger.select(typeBuilderInteger.generator, arguments[0].longValue());
                }
                return ValueInteger.select(typeBuilderInteger.generator, arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(PLUS, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueInteger.select(typeBuilderInteger.generator, arguments[0].longValue() + arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(MINUS, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueInteger.select(typeBuilderInteger.generator, arguments[0].longValue() - arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(TIMES, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueInteger.select(typeBuilderInteger.generator, arguments[0].longValue() * arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(DIVIDE, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                if (arguments[1].longValue() == 0L) {
                    throw new ExceptionSemantic("RS0207: Attempt to divide by zero.");
                }
                return ValueInteger.select(typeBuilderInteger.generator, arguments[0].longValue() / arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorBinary(MODULO, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                if (arguments[1].longValue() == 0L) {
                    throw new ExceptionSemantic("RS0419: Attempt to perform modulo by zero.");
                }
                return ValueInteger.select(typeBuilderInteger.generator, arguments[0].longValue() % arguments[1].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorUnary(UNARY_PLUS, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueInteger.select(typeBuilderInteger.generator, arguments[0].longValue());
            }
        });
        typeBuilderInteger.checkTypeOperatorUnary(UNARY_MINUS, TypeInteger.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueInteger.select(typeBuilderInteger.generator, -arguments[0].longValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(EQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderRational.generator, arguments[0].doubleValue() == arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(NOTEQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderRational.generator, arguments[0].doubleValue() != arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(GREATERTHANOREQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderRational.generator, arguments[0].doubleValue() >= arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(LESSTHANOREQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderRational.generator, arguments[0].doubleValue() <= arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(LESSTHAN, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderRational.generator, arguments[0].doubleValue() < arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(GREATERTHAN, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderRational.generator, arguments[0].doubleValue() > arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(MAX, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                if (arguments[0].doubleValue() > arguments[1].doubleValue()) {
                    return ValueRational.select(typeBuilderRational.generator, arguments[0].doubleValue());
                }
                return ValueRational.select(typeBuilderRational.generator, arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(MIN, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                if (arguments[0].doubleValue() < arguments[1].doubleValue()) {
                    return ValueRational.select(typeBuilderRational.generator, arguments[0].doubleValue());
                }
                return ValueRational.select(typeBuilderRational.generator, arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(PLUS, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueRational.select(typeBuilderRational.generator, arguments[0].doubleValue() + arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(MINUS, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueRational.select(typeBuilderRational.generator, arguments[0].doubleValue() - arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(TIMES, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueRational.select(typeBuilderRational.generator, arguments[0].doubleValue() * arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorBinary(DIVIDE, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueRational.select(typeBuilderRational.generator, arguments[0].doubleValue() / arguments[1].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorUnary(UNARY_PLUS, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueRational.select(typeBuilderRational.generator, arguments[0].doubleValue());
            }
        });
        typeBuilderRational.checkTypeOperatorUnary(UNARY_MINUS, TypeRational.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueRational.select(typeBuilderRational.generator, -arguments[0].doubleValue());
            }
        });
        typeBuilderCharacter.checkTypeOperatorBinary(EQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderCharacter.generator, arguments[0].stringValue().compareTo(arguments[1].stringValue()) == 0);
            }
        });
        typeBuilderCharacter.checkTypeOperatorBinary(NOTEQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderCharacter.generator, arguments[0].stringValue().compareTo(arguments[1].stringValue()) != 0);
            }
        });
        typeBuilderCharacter.checkTypeOperatorBinary(GREATERTHANOREQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderCharacter.generator, arguments[0].stringValue().compareTo(arguments[1].stringValue()) >= 0);
            }
        });
        typeBuilderCharacter.checkTypeOperatorBinary(LESSTHANOREQUALS, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderCharacter.generator, arguments[0].stringValue().compareTo(arguments[1].stringValue()) <= 0);
            }
        });
        typeBuilderCharacter.checkTypeOperatorBinary(LESSTHAN, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderCharacter.generator, arguments[0].stringValue().compareTo(arguments[1].stringValue()) < 0);
            }
        });
        typeBuilderCharacter.checkTypeOperatorBinary(GREATERTHAN, TypeBoolean.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                return ValueBoolean.select(typeBuilderCharacter.generator, arguments[0].stringValue().compareTo(arguments[1].stringValue()) > 0);
            }
        });
        typeBuilderCharacter.checkTypeOperatorBinary(MAX, TypeCharacter.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                if (arguments[0].stringValue().compareTo(arguments[1].stringValue()) > 0) {
                    return ValueCharacter.select(typeBuilderCharacter.generator, arguments[0].stringValue());
                }
                return ValueCharacter.select(typeBuilderCharacter.generator, arguments[1].stringValue());
            }
        });
        typeBuilderCharacter.checkTypeOperatorBinary(MIN, TypeCharacter.getInstance(), new NativeFunction(){

            @Override
            public Value evaluate(Value[] arguments) {
                if (arguments[0].stringValue().compareTo(arguments[1].stringValue()) < 0) {
                    return ValueCharacter.select(typeBuilderCharacter.generator, arguments[0].stringValue());
                }
                return ValueCharacter.select(typeBuilderCharacter.generator, arguments[1].stringValue());
            }
        });
        typeBuilderBoolean.go();
        typeBuilderInteger.go();
        typeBuilderRational.go();
        typeBuilderCharacter.go();
        BuiltinTypeBuilder.loadSubtypes(relDatabase);
    }
}

