/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import org.reldb.rel.v0.external.DirClassLoader;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.RelvarMetadata;
import org.reldb.rel.v0.values.ValueTuple;

public class ClassCatalog {
    private StoredClassCatalog classCatalog;
    private Database classCatalogDb;
    private Environment environment;
    private EntryBinding<RelvarMetadata> relvarMetadataBinding;
    private SerialBinding<ValueTuple> tupleBinding;
    private DirClassLoader dirClassLoader;

    ClassCatalog(String directory, EnvironmentConfig environmentConfig, DatabaseConfig dbConfig) {
        this.dirClassLoader = new DirClassLoader(directory);
        String classesDir = String.valueOf(directory) + File.separator + "classes";
        RelDatabase.mkdir(classesDir);
        this.environment = new Environment(new File(classesDir), environmentConfig);
        this.classCatalogDb = this.environment.openDatabase(null, "_ClassCatalog", dbConfig);
        this.classCatalog = new StoredClassCatalog(this.classCatalogDb);
        this.relvarMetadataBinding = new SerialBinding((com.sleepycat.bind.serial.ClassCatalog)this.classCatalog, RelvarMetadata.class);
        this.tupleBinding = new SerialBinding<ValueTuple>((com.sleepycat.bind.serial.ClassCatalog)this.classCatalog, ValueTuple.class){

            public ClassLoader getClassLoader() {
                return ClassCatalog.this.dirClassLoader;
            }
        };
    }

    public void close() throws DatabaseException {
        this.classCatalogDb.close();
        this.environment.close();
    }

    EntryBinding<RelvarMetadata> getRelvarMetadataBinding() {
        return this.relvarMetadataBinding;
    }

    SerialBinding<ValueTuple> getTupleBinding() {
        return this.tupleBinding;
    }

    public StoredClassCatalog getStoredClassCatalog() {
        return this.classCatalog;
    }
}

