/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.reldb.rel.exceptions.DatabaseFormatVersionException;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.external.DirClassLoader;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinition;
import org.reldb.rel.v0.generator.OperatorDefinitionNativeFunctionExternal;
import org.reldb.rel.v0.generator.OperatorDefinitionNativeProcedureExternal;
import org.reldb.rel.v0.generator.OperatorInvocation;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.generator.References;
import org.reldb.rel.v0.generator.SelectOrder;
import org.reldb.rel.v0.generator.SlotScoped;
import org.reldb.rel.v0.interpreter.Interpreter;
import org.reldb.rel.v0.languages.tutoriald.parser.ParseException;
import org.reldb.rel.v0.storage.BuiltinOperators;
import org.reldb.rel.v0.storage.BuiltinTypeBuilder;
import org.reldb.rel.v0.storage.ClassCatalog;
import org.reldb.rel.v0.storage.RelTransaction;
import org.reldb.rel.v0.storage.TransactionRunner;
import org.reldb.rel.v0.storage.catalog.Catalog;
import org.reldb.rel.v0.storage.catalog.RelvarOperators;
import org.reldb.rel.v0.storage.catalog.RelvarSystem;
import org.reldb.rel.v0.storage.catalog.RelvarSystemDependencies;
import org.reldb.rel.v0.storage.catalog.RelvarTypes;
import org.reldb.rel.v0.storage.relvars.RelvarDefinition;
import org.reldb.rel.v0.storage.relvars.RelvarGlobal;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.storage.relvars.RelvarMetadata;
import org.reldb.rel.v0.storage.relvars.RelvarPrivate;
import org.reldb.rel.v0.storage.relvars.RelvarPrivateCell;
import org.reldb.rel.v0.storage.relvars.RelvarReal;
import org.reldb.rel.v0.storage.relvars.RelvarRealMetadata;
import org.reldb.rel.v0.storage.tables.RegisteredTupleIterator;
import org.reldb.rel.v0.storage.tables.Storage;
import org.reldb.rel.v0.storage.tables.StorageNames;
import org.reldb.rel.v0.storage.tables.Table;
import org.reldb.rel.v0.storage.tables.TablePrivate;
import org.reldb.rel.v0.storage.tables.TableReal;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.OrderMap;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.TypeTuple;
import org.reldb.rel.v0.types.builtin.TypeBoolean;
import org.reldb.rel.v0.types.builtin.TypeCharacter;
import org.reldb.rel.v0.types.builtin.TypeInteger;
import org.reldb.rel.v0.types.builtin.TypeRational;
import org.reldb.rel.v0.values.TupleFilter;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueOperator;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueRelationLiteral;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.version.Version;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Instruction;
import org.reldb.rel.v0.vm.Operator;
import org.reldb.rel.v0.vm.VirtualMachine;
import org.reldb.rel.v0.vm.instructions.core.OpInvoke;
import org.reldb.rel.v0.vm.instructions.core.OpInvokeDynamicEvaluate;

public class RelDatabase {
    public static final String systemOwner = "Rel";
    private Environment environment;
    private DatabaseConfig dbConfigurationNormal;
    private DatabaseConfig dbConfigurationAllowCreate;
    private DatabaseConfig dbConfigurationTemporary;
    private DatabaseConfig dbConfigurationTemporaryWithDuplicatesNoComparator;
    private DatabaseConfig dbConfigurationMetadataAllowCreateNoComparator;
    private ClassCatalog classCatalog;
    private StringBinding stringDataBinding;
    private DatabaseEntry keyTableEntry = new DatabaseEntry();
    private Database relvarDb;
    private Hashtable<String, Database> openStorage = new Hashtable();
    private HashSet<String> tempStorageNames = new HashSet();
    private Hashtable<Long, RelTransaction> transactions = new Hashtable();
    private Hashtable<String, Operator> constraints = new Hashtable();
    private HashMap<String, OperatorDefinition> builtinops = new HashMap();
    private HashMap<OperatorSignature, OperatorDefinition> operatorCachePermanent = new HashMap();
    private HashMap<OperatorSignature, OperatorDefinition> operatorCache = new HashMap();
    private HashMap<String, Type> typeCache = new HashMap();
    private HashSet<RegisteredTupleIterator> registeredTupleIterators = new HashSet();
    private DirClassLoader dirClassLoader;
    private static final String databaseHomeRelative = "Reldb";
    private static final String userCodeHomeRelative = "RelUserCode";
    private static final String relUserCodePackage = "Reldb.RelUserCode";
    private String userCodeHome;
    private String databaseHome = "Reldb";
    private String homeDir;
    private boolean specialCacheMode = true;
    private String customRelvarsDatabase;
    private String customRelvarsHome;
    private ArrayList<String> customRelvars;
    private String[] additionalJarsForJavaCompilerClasspath = null;

    public void setAdditionalJarsForJavaCompilerClasspath(String[] additionalJarsForClasspath) {
        this.additionalJarsForJavaCompilerClasspath = additionalJarsForClasspath;
    }

    public String[] getAdditionalJarsForJavaCompilerClasspath() {
        return this.additionalJarsForJavaCompilerClasspath;
    }

    private static void applyComparatorTo(Comparator<byte[]> comparator, DatabaseConfig config) {
        config.setBtreeComparator(comparator);
        config.setOverrideBtreeComparator(true);
        config.setDuplicateComparator(comparator);
        config.setOverrideDuplicateComparator(true);
    }

    private String getBerkeleyJavaDBVersion() {
        return JEVersion.CURRENT_VERSION.getVersionString();
    }

    public static void mkdir(String dir) {
        File dirf = new File(dir);
        if (!dirf.exists() && !dirf.mkdirs()) {
            String msg = "Unable to create directory: " + dirf;
            throw new ExceptionFatal("RS0324: " + msg);
        }
    }

    private String getClickerFileName() {
        return String.valueOf(this.homeDir) + File.separator + "ClickToOpen.rdb";
    }

    private void writeClicker() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.getClickerFileName(), false);
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            System.out.println("WARNING: Unable to create " + this.getClickerFileName());
        }
    }

    private String getVersionFileName() {
        return String.valueOf(this.databaseHome) + File.separator + "version";
    }

    private void writeVersion() throws IOException {
        try (OutputStreamWriter writer = null;){
            writer = new FileWriter(this.getVersionFileName(), false);
            writer.write(Integer.toString(Version.getDatabaseVersion()));
        }
    }

    private int readVersion() {
        List<String> lines = null;
        try {
            lines = Files.readAllLines(new File(this.getVersionFileName()).toPath());
        }
        catch (IOException e1) {
            return -1;
        }
        if (lines.isEmpty()) {
            return -1;
        }
        try {
            return Integer.parseInt(lines.get(0));
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public void open(File envHome, boolean canCreateDb, PrintStream outputStream) throws DatabaseFormatVersionException {
        System.out.println("Opening database in " + envHome + "\nIf it doesn't exist, we'll " + (canCreateDb ? "try to create it" : "cause an error") + ".");
        String usingBerkeleyJavaDBVersion = this.getBerkeleyJavaDBVersion();
        if (!usingBerkeleyJavaDBVersion.equals("7.0.6")) {
            throw new ExceptionFatal("RS0323: Expected to find Berkeley Java DB version 7.0.6 but found version " + usingBerkeleyJavaDBVersion + ".\nAn attempted update or re-installation has probably failed.\nPlease make sure " + Version.getBerkeleyDbJarFilename() + " is not read-only, then try the update or re-installation again.");
        }
        this.homeDir = envHome.getAbsolutePath();
        if (this.homeDir.endsWith(".")) {
            this.homeDir = this.homeDir.substring(0, this.homeDir.length() - 1);
        }
        if (!this.homeDir.endsWith(File.separator)) {
            this.homeDir = String.valueOf(this.homeDir) + File.separator;
        }
        this.databaseHome = String.valueOf(this.homeDir) + databaseHomeRelative;
        if (!new File(this.databaseHome).exists()) {
            if (!canCreateDb) {
                throw new ExceptionSemantic("RS0406: Database " + this.homeDir + " either doesn't exist or isn't a Rel database.");
            }
            RelDatabase.mkdir(this.databaseHome);
            try {
                this.writeVersion();
            }
            catch (IOException ioe) {
                throw new ExceptionSemantic("RS0408: Can't write version file in database in " + this.homeDir + ".");
            }
        } else {
            int detectedVersion = this.readVersion();
            if (detectedVersion < 0) {
                throw new ExceptionSemantic("RS0407: Database in " + this.homeDir + " has no version information, or it's invalid.  The database must be upgraded manually.\nBack it up with the version of Rel used to create it and load the backup into a new database.");
            }
            if (detectedVersion < Version.getDatabaseVersion()) {
                String msg = "RS0410: Database requires conversion from format v" + detectedVersion + " to format v" + Version.getDatabaseVersion();
                throw new DatabaseFormatVersionException(msg, detectedVersion);
            }
            if (detectedVersion > Version.getDatabaseVersion()) {
                throw new ExceptionSemantic("RS0409: Database in " + this.homeDir + " appears to have been created by a newer version of Rel than this one.\nOpen it with the latest version of Rel.");
            }
        }
        this.writeClicker();
        this.userCodeHome = String.valueOf(this.databaseHome) + File.separator + userCodeHomeRelative;
        this.dirClassLoader = new DirClassLoader(this.homeDir);
        try {
            EnvironmentConfig environmentConfig = new EnvironmentConfig();
            environmentConfig.setReadOnly(false);
            environmentConfig.setAllowCreate(true);
            environmentConfig.setTransactional(true);
            environmentConfig.setTxnSerializableIsolation(true);
            this.dbConfigurationNormal = new DatabaseConfig();
            this.dbConfigurationNormal.setReadOnly(false);
            this.dbConfigurationNormal.setAllowCreate(false);
            this.dbConfigurationNormal.setTransactional(true);
            this.dbConfigurationNormal.setSortedDuplicates(false);
            this.dbConfigurationAllowCreate = new DatabaseConfig();
            this.dbConfigurationAllowCreate.setReadOnly(false);
            this.dbConfigurationAllowCreate.setAllowCreate(true);
            this.dbConfigurationAllowCreate.setTransactional(true);
            this.dbConfigurationAllowCreate.setSortedDuplicates(false);
            this.dbConfigurationTemporary = new DatabaseConfig();
            this.dbConfigurationTemporary.setReadOnly(false);
            this.dbConfigurationTemporary.setAllowCreate(true);
            this.dbConfigurationTemporary.setTransactional(false);
            this.dbConfigurationTemporary.setSortedDuplicates(false);
            this.dbConfigurationTemporary.setTemporary(true);
            this.dbConfigurationTemporaryWithDuplicatesNoComparator = new DatabaseConfig();
            this.dbConfigurationTemporaryWithDuplicatesNoComparator.setReadOnly(false);
            this.dbConfigurationTemporaryWithDuplicatesNoComparator.setAllowCreate(true);
            this.dbConfigurationTemporaryWithDuplicatesNoComparator.setTransactional(false);
            this.dbConfigurationTemporaryWithDuplicatesNoComparator.setSortedDuplicates(true);
            this.dbConfigurationTemporaryWithDuplicatesNoComparator.setTemporary(true);
            this.dbConfigurationMetadataAllowCreateNoComparator = new DatabaseConfig();
            this.dbConfigurationMetadataAllowCreateNoComparator.setReadOnly(false);
            this.dbConfigurationMetadataAllowCreateNoComparator.setAllowCreate(true);
            this.dbConfigurationMetadataAllowCreateNoComparator.setTransactional(true);
            this.dbConfigurationMetadataAllowCreateNoComparator.setSortedDuplicates(false);
            this.classCatalog = new ClassCatalog(this.databaseHome, environmentConfig, this.dbConfigurationMetadataAllowCreateNoComparator);
            ComparisonHandler comparator = new ComparisonHandler(this.classCatalog.getTupleBinding());
            RelDatabase.applyComparatorTo(comparator, this.dbConfigurationNormal);
            RelDatabase.applyComparatorTo(comparator, this.dbConfigurationAllowCreate);
            RelDatabase.applyComparatorTo(comparator, this.dbConfigurationTemporary);
            this.environment = new Environment(new File(this.databaseHome), environmentConfig);
            Generator generator = new Generator(this, System.out);
            this.stringDataBinding = new StringBinding();
            this.stringDataBinding.objectToEntry((Object)"", this.keyTableEntry);
            this.relvarDb = this.environment.openDatabase(null, "_Relvars", this.dbConfigurationMetadataAllowCreateNoComparator);
            Catalog catalog = new Catalog(this);
            catalog.generatePhase0(generator);
            this.specialCacheMode = true;
            BuiltinOperators.buildOperators(this);
            BuiltinTypeBuilder.buildTypes(this);
            this.operatorCachePermanent = this.operatorCache;
            this.specialCacheMode = false;
            if (!this.isTypeExists(generator, "TypeInfo")) {
                try {
                    System.out.println("Creating TypeInfo types.");
                    Interpreter.executeStatementPrivileged(this, "TYPE TypeInfo UNION;", systemOwner, System.out);
                    Interpreter.executeStatementPrivileged(this, "TYPE Scalar IS {TypeInfo POSSREP {TypeName CHAR}};", systemOwner, System.out);
                    Interpreter.executeStatementPrivileged(this, "TYPE NonScalar IS {TypeInfo POSSREP {Kind CHAR, Attributes RELATION {AttrName CHAR, AttrType TypeInfo}}};", systemOwner, System.out);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            catalog.generatePhase1(generator);
            if (!this.isRelvarExists("sys.DefinitionHistory")) {
                try {
                    System.out.println("Creating sys.DefinitionHistory relvar.");
                    Interpreter.executeStatementPrivileged(this, "VAR sys.DefinitionHistory REAL RELATION {Definition CHAR, SerialNumber INTEGER} KEY {SerialNumber};", systemOwner, System.out);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this.reset();
            File homePlugins = new File(String.valueOf(System.getProperty("user.home")) + File.separator + "Relplugins");
            File databasePlugins = new File(String.valueOf(this.homeDir) + File.separator + "Relplugins");
            if (!homePlugins.exists()) {
                homePlugins.mkdir();
            }
            if (!databasePlugins.exists()) {
                databasePlugins.mkdir();
            }
            this.customRelvarsHome = String.valueOf(homePlugins.getAbsolutePath()) + File.separator + "relvars";
            this.customRelvarsDatabase = String.valueOf(databasePlugins.getAbsolutePath()) + File.separator + "relvars";
            this.customRelvars = new ArrayList();
            this.loadPaths(new File(this.customRelvarsDatabase), new File(this.customRelvarsHome));
            this.loadConstraints(outputStream);
            System.out.println("Database " + envHome + " is open.");
        }
        catch (DatabaseException db) {
            String msg = "Unable to open database: " + db.getMessage();
            outputStream.println(msg);
            db.printStackTrace(System.out);
            throw new ExceptionFatal("RS0325: " + msg);
        }
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public void registerTupleIterator(RegisteredTupleIterator registeredTupleIterator) {
        this.registeredTupleIterators.add(registeredTupleIterator);
    }

    public void unregisterTupleIterator(RegisteredTupleIterator registeredTupleIterator) {
        this.registeredTupleIterators.remove(registeredTupleIterator);
    }

    public boolean isOpen() {
        return this.environment != null;
    }

    public void close() {
        if (this.environment == null) {
            System.out.println("WARNING: Attempting to re-close a closed database!");
            System.out.println("It's not a problem, but we'll tell you where it's coming from so maybe you can fix it:");
            new Throwable().printStackTrace();
            return;
        }
        System.out.println("Closing database in " + this.homeDir);
        System.out.println("\tClosing active tuple iterators in " + this.homeDir);
        int activeTupleIterators = 0;
        try {
            for (RegisteredTupleIterator tupleIterator : this.registeredTupleIterators) {
                if (!tupleIterator.forceClose()) continue;
                ++activeTupleIterators;
            }
        }
        catch (Exception e) {
            System.err.println("\tError closing active tuple iterators: " + this.homeDir + ": " + e.toString());
        }
        if (activeTupleIterators == 1) {
            System.err.println("\t" + activeTupleIterators + " active tuple iterator was closed.");
        } else if (activeTupleIterators > 1) {
            System.err.println("\t" + activeTupleIterators + " active tuple iterators were closed.");
        }
        System.out.println("\tCommitting open transactions in " + this.homeDir);
        int openTransactions = 0;
        for (RelTransaction transaction : this.transactions.values()) {
            while (transaction.getReferenceCount() > 0) {
                try {
                    this.commitTransaction(transaction);
                    ++openTransactions;
                }
                catch (DatabaseException dbe) {
                    System.err.println("\tError committing active transactions " + this.homeDir + ": " + dbe.toString());
                }
                catch (Exception e) {
                    System.err.println("\tUnknown shutdown error 1: " + e);
                }
            }
        }
        if (openTransactions == 1) {
            System.err.println("\t" + openTransactions + " open transaction was closed.");
        } else if (openTransactions > 1) {
            System.err.println("\t" + openTransactions + " open transactions were closed.");
        }
        System.out.println("\tClosing relvars in " + this.homeDir);
        try {
            for (Database table : this.openStorage.values()) {
                table.close();
            }
        }
        catch (DatabaseException dbe) {
            System.err.println("\tError closing internal tables " + this.homeDir + ": " + dbe.toString());
        }
        catch (Exception e) {
            System.err.println("\tUnknown shutdown error 2: " + e);
        }
        System.out.println("\tPurging temporary data in " + this.homeDir);
        try {
            for (String tableName : this.tempStorageNames) {
                this.environment.removeDatabase(null, tableName);
            }
        }
        catch (DatabaseException dbe) {
            System.err.println("\tError removing temporary data storage " + this.homeDir + ": " + dbe.toString());
        }
        catch (Exception e) {
            System.err.println("\tUnknown shutdown error 3: " + e);
        }
        System.out.println("\tTemporary data purged in " + this.homeDir);
        try {
            this.relvarDb.close();
        }
        catch (DatabaseException dbe) {
            System.err.println("\tError closing the relvarDb " + this.homeDir + ": " + dbe.toString());
        }
        catch (Exception e) {
            System.err.println("\tUnknown shutdown error 4: " + e);
        }
        System.out.println("\tClosing environment in " + this.homeDir);
        try {
            this.environment.close();
        }
        catch (DatabaseException dbe) {
            System.err.println("\tError closing the environment " + this.homeDir + ": " + dbe.toString());
        }
        catch (Exception e) {
            System.err.println("\tUnknown shutdown error 5: " + e);
        }
        this.environment = null;
        try {
            this.classCatalog.close();
        }
        catch (DatabaseException dbe) {
            System.err.println("\tError closing the ClassCatalog in " + this.homeDir + ": " + dbe.toString());
        }
        catch (Exception e) {
            System.err.println("\tUnknown shutdown error 6: " + e);
        }
        System.out.println("Database " + this.homeDir + " is closed.");
    }

    public void reset() {
        this.operatorCache = new HashMap();
        this.typeCache.clear();
    }

    public String getJavaUserSourcePath() {
        return this.userCodeHome;
    }

    public static String getRelUserCodePackage() {
        return relUserCodePackage;
    }

    private Database openDatabaseRaw(Transaction txn, String tabName, DatabaseConfig configuration) throws DatabaseException {
        Database db = this.environment.openDatabase(txn, tabName, configuration);
        this.openStorage.put(tabName, db);
        return db;
    }

    private Database openDatabase(Transaction txn, String tabName, DatabaseConfig configuration) {
        Database db = this.openStorage.get(tabName);
        try {
            if (db == null) {
                db = this.openDatabaseRaw(txn, tabName, configuration);
            } else {
                db.openCursor(txn, null).close();
            }
        }
        catch (IllegalStateException de) {
            try {
                db.close();
                db = this.openDatabaseRaw(txn, tabName, configuration);
            }
            catch (IllegalStateException de2) {
                de2.printStackTrace();
                throw new ExceptionFatal("RS0326: openDatabase: re-open failed: " + de2);
            }
        }
        return db;
    }

    private void closeDatabase(String tabName) throws DatabaseException {
        Database table = this.openStorage.get(tabName);
        if (table != null) {
            table.close();
            this.openStorage.remove(tabName);
        }
    }

    public ValueOperator compileAnonymousOperator(String source, PrintStream outputStream) {
        Interpreter interpreter = new Interpreter(this, outputStream);
        try {
            return interpreter.compileAnonymousOperator(source);
        }
        catch (ParseException pe) {
            throw new ExceptionSemantic("RS0288: Failed compiling anonymous operator " + source + ": " + pe.toString());
        }
    }

    private void loadConstraints(final PrintStream outputStream) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    Interpreter interpreter = new Interpreter(RelDatabase.this, outputStream);
                    RelvarSystem constraintsRelvar = (RelvarSystem)RelDatabase.this.openGlobalRelvar("sys.Constraints");
                    try (TupleIterator ti = constraintsRelvar.iterator(interpreter.getGenerator());){
                        while (ti.hasNext()) {
                            ValueTuple constraintEntry = ti.next();
                            String constraintName = constraintEntry.getValues()[0].toString();
                            String source = constraintEntry.getValues()[1].toString();
                            try {
                                Operator constraintCheckOperator = interpreter.getGenerator().beginConstraintDefinition();
                                interpreter.compileStatement("RETURN " + source + ";");
                                interpreter.getGenerator().endConstraintDefinition();
                                RelDatabase.this.constraints.put(constraintName, constraintCheckOperator);
                            }
                            catch (ParseException pe) {
                                pe.printStackTrace();
                                throw new ExceptionFatal("RS0327: Failed loading constraint " + constraintName + ": " + pe.toString());
                            }
                        }
                    }
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0328: loadConstraints failed: " + t);
        }
    }

    private boolean checkConstraint(VirtualMachine vm, Operator constraintCheck) {
        vm.execute(constraintCheck);
        return ((ValueBoolean)vm.pop()).booleanValue();
    }

    public synchronized String checkConstraints(final PrintStream outputStream) {
        try {
            return (String)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    VirtualMachine vm = new VirtualMachine(new Generator(RelDatabase.this, System.out), RelDatabase.this, outputStream);
                    for (Map.Entry entry : RelDatabase.this.constraints.entrySet()) {
                        String constraintName = (String)entry.getKey();
                        try {
                            if (RelDatabase.this.checkConstraint(vm, (Operator)entry.getValue())) continue;
                            return constraintName;
                        }
                        catch (ExceptionSemantic es) {
                            throw new ExceptionSemantic("RS0393: error in CONSTRAINT " + constraintName + ": " + es.getMessage(), (Throwable)es);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            throw new ExceptionFatal("RS0329: checkConstraints failed: " + t);
                        }
                    }
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ExceptionFatal("RS0392: checkConstraints failed: " + e);
        }
    }

    public String getNativeDBVersion() {
        return "Oracle Berkeley DB Java Edition version " + this.getBerkeleyJavaDBVersion();
    }

    public void putRelvarMetadata(Transaction txn, String relvarName, RelvarMetadata metadata) throws DatabaseException {
        if (metadata.getCreationSequence() == -1L) {
            metadata.setCreationSequence(this.getUniqueID());
        }
        DatabaseEntry theKey = new DatabaseEntry();
        this.stringDataBinding.objectToEntry((Object)relvarName, theKey);
        DatabaseEntry theData = new DatabaseEntry();
        this.classCatalog.getRelvarMetadataBinding().objectToEntry((Object)metadata, theData);
        this.relvarDb.put(txn, theKey, theData);
    }

    public synchronized RelvarMetadata getRelvarMetadata(Transaction txn, String relvarName) throws DatabaseException {
        DatabaseEntry theKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        this.stringDataBinding.objectToEntry((Object)relvarName, theKey);
        if (this.relvarDb.get(txn, theKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            return (RelvarMetadata)this.classCatalog.getRelvarMetadataBinding().entryToObject(foundData);
        }
        return null;
    }

    private void dropRelvarMetadata(Transaction txn, String relvarName) throws DatabaseException {
        DatabaseEntry theKey = new DatabaseEntry();
        this.stringDataBinding.objectToEntry((Object)relvarName, theKey);
        if (this.relvarDb.delete(txn, theKey) != OperationStatus.SUCCESS) {
            throw new ExceptionFatal("RS0330: unable to drop relvar metadata for " + relvarName);
        }
    }

    private final File getUniqueIDFile() {
        return new File(String.valueOf(this.databaseHome) + File.separatorChar + "unique.id");
    }

    public synchronized void setUniqueID(long newid) {
        File uniquidFile = this.getUniqueIDFile();
        long id = 0L;
        long nextid = 1L;
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(uniquidFile));
            id = dis.readLong();
            nextid = id + 1L;
            dis.close();
        }
        catch (Throwable t) {
            System.out.println("Creating new ID file.");
        }
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(uniquidFile));
            if (newid < nextid) {
                dos.writeLong(nextid);
            } else {
                dos.writeLong(newid);
            }
            dos.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0331: " + t.toString());
        }
    }

    public synchronized long getUniqueID() {
        File uniquidFile = this.getUniqueIDFile();
        long id = 0L;
        long nextid = 1L;
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(uniquidFile));
            id = dis.readLong();
            nextid = id + 1L;
            dis.close();
        }
        catch (Throwable t) {
            System.out.println("Creating new ID file.");
        }
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(uniquidFile));
            dos.writeLong(nextid);
            dos.close();
            return id;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0331: " + t.toString());
        }
    }

    private Long getThreadID() {
        return new Long(Thread.currentThread().getId());
    }

    private boolean isRelvarExists(Transaction txn, String name) throws DatabaseException {
        return this.getRelvarMetadata(txn, name) != null;
    }

    public EntryBinding<ValueTuple> getTupleBinding() {
        return this.classCatalog.getTupleBinding();
    }

    public DatabaseEntry getKeyTableEntry() {
        return this.keyTableEntry;
    }

    StoredClassCatalog getClassCatalog() {
        return this.classCatalog.getStoredClassCatalog();
    }

    public synchronized RelTransaction beginTransaction() {
        Long threadID = this.getThreadID();
        RelTransaction currentTransaction = this.transactions.get(threadID);
        if (currentTransaction == null) {
            try {
                Transaction txn = this.environment.beginTransaction(null, null);
                txn.setLockTimeout(10L, TimeUnit.SECONDS);
                currentTransaction = new RelTransaction(txn);
                this.transactions.put(threadID, currentTransaction);
            }
            catch (DatabaseException dbe) {
                dbe.printStackTrace();
                throw new ExceptionFatal("RS0332: unable to begin new transaction: " + (Object)((Object)dbe));
            }
        } else {
            currentTransaction.addReference();
        }
        return currentTransaction;
    }

    private RelTransaction getCurrentTransaction() {
        Long threadID = this.getThreadID();
        return this.transactions.get(threadID);
    }

    private void commitTransactionUnsynchronized(RelTransaction txn) {
        txn.commit();
        if (txn.getReferenceCount() == 0) {
            this.transactions.remove(this.getThreadID());
        }
    }

    public synchronized void commitTransaction(RelTransaction txn) {
        this.commitTransactionUnsynchronized(txn);
    }

    public synchronized void commitTransaction() {
        RelTransaction currentTransaction = this.getCurrentTransaction();
        if (currentTransaction == null) {
            throw new ExceptionSemantic("RS0208: No transaction is active.");
        }
        this.commitTransactionUnsynchronized(currentTransaction);
    }

    private void rollbackTransactionUnsynchronized(RelTransaction txn) {
        txn.abort();
        if (txn.getReferenceCount() == 0) {
            this.transactions.remove(this.getThreadID());
        }
    }

    synchronized void rollbackTransaction(RelTransaction txn) {
        this.rollbackTransactionUnsynchronized(txn);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void rollbackTransactionIfThereIsOne() {
        this.reset();
        currentTransaction = this.getCurrentTransaction();
        if (currentTransaction != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this.rollbackTransactionUnsynchronized(currentTransaction);
lbl6:
            // 2 sources

            ** while (currentTransaction.getReferenceCount() > 0)
        }
lbl7:
        // 1 sources

    }

    public synchronized void rollbackTransaction() {
        RelTransaction currentTransaction = this.getCurrentTransaction();
        if (currentTransaction == null) {
            throw new ExceptionSemantic("RS0209: No transaction is active.");
        }
        this.rollbackTransactionUnsynchronized(currentTransaction);
    }

    private ArrayList<String> getFoldersAt(File f) {
        ArrayList<String> list = new ArrayList<String>();
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                list.add(file.getName().trim());
            }
            ++n2;
        }
        return list;
    }

    private ArrayList<File> getFilesAt(File f) {
        ArrayList<File> list = new ArrayList<File>();
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isDirectory()) {
                list.add(file);
            }
            ++n2;
        }
        return list;
    }

    public ArrayList<String> getAllCustomTypes() {
        return this.customRelvars;
    }

    private void loadSinglePath(File file) throws MalformedURLException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        URL u = file.toURI().toURL();
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }

    private void loadLibFolderContents(String folder, File libFolder) {
        if (!libFolder.exists() || libFolder.list().length == 0 || !libFolder.isDirectory()) {
            System.out.println("\t" + folder.toUpperCase() + ": " + "lib folder not found or empty.");
            return;
        }
        for (File file : this.getFilesAt(libFolder)) {
            try {
                if (file.getName().endsWith("jar")) {
                    this.loadSinglePath(file);
                    System.out.println("\t" + folder.toUpperCase() + ": " + file.getName() + " was loaded succesfully.");
                    continue;
                }
                System.out.println("\t" + folder.toUpperCase() + ": " + "Ignored: " + file.getName());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadPaths(File database, File home) {
        try {
            if (!database.exists() && !home.exists()) {
                database.mkdir();
                home.mkdir();
                return;
            }
            if (!database.exists()) {
                database.mkdir();
            }
            if (!home.exists()) {
                home.mkdir();
                return;
            }
            ArrayList<String> homeTypes = this.getFoldersAt(home);
            if (homeTypes.isEmpty()) {
                System.out.println("No custom relvars were found in " + home);
            }
            for (String folder : homeTypes) {
                File typeFolder = new File(String.valueOf(home.getAbsolutePath()) + File.separator + folder);
                if (typeFolder.list().length > 0) {
                    this.customRelvars.add(folder);
                    System.out.println("Custom relvar " + folder + " was succesfully loaded");
                    File libFolder = new File(String.valueOf(typeFolder.getAbsolutePath()) + File.separator + "lib");
                    this.loadLibFolderContents(folder, libFolder);
                    continue;
                }
                System.out.println("Custom relvar " + folder + " was not loaded. Folder is empty.");
            }
            ArrayList<String> databaseTypes = this.getFoldersAt(database);
            if (databaseTypes.isEmpty()) {
                System.out.println("No custom relvars were found in " + database);
            }
            for (String folder : databaseTypes) {
                if (!homeTypes.contains(folder)) {
                    File typeFolder = new File(String.valueOf(database.getAbsolutePath()) + File.separator + folder);
                    if (typeFolder.list().length > 0) {
                        this.customRelvars.add(folder);
                        System.out.println("Custom relvar " + folder + "was succesfully loaded");
                        File libFolder = new File(String.valueOf(typeFolder.getAbsolutePath()) + File.separator + "lib");
                        this.loadLibFolderContents(folder, libFolder);
                        continue;
                    }
                    System.out.println("Custom relvar " + folder + " was not loaded. Folder is empty.");
                    continue;
                }
                System.out.println("Duplicate custom relvar " + folder + " found!");
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public synchronized TupleIterator getCatalogTupleIterator(final Generator generator) {
        return new RegisteredTupleIterator(generator.getDatabase()){
            DatabaseEntry foundKey;
            DatabaseEntry foundData;
            RelvarMetadata current;
            String currentKey;
            {
                super($anonymous0);
                this.foundKey = new DatabaseEntry();
                this.foundData = new DatabaseEntry();
                this.current = null;
                this.currentKey = null;
            }

            @Override
            public boolean hasNext() {
                if (this.current != null) {
                    return true;
                }
                try {
                    if (this.cursor == null) {
                        this.txn = RelDatabase.this.beginTransaction();
                        this.cursor = RelDatabase.this.relvarDb.openCursor(this.txn.getTransaction(), null);
                    }
                    if (this.cursor.getNext(this.foundKey, this.foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                        this.current = (RelvarMetadata)RelDatabase.this.classCatalog.getRelvarMetadataBinding().entryToObject(this.foundData);
                        this.currentKey = (String)RelDatabase.this.stringDataBinding.entryToObject(this.foundKey);
                        return true;
                    }
                }
                catch (DatabaseException exp) {
                    exp.printStackTrace();
                    throw new ExceptionFatal("RS0333: Unable to get next Catalog entry: " + (Object)((Object)exp));
                }
                return false;
            }

            @Override
            public ValueTuple next() {
                if (this.hasNext()) {
                    try {
                        final RelvarHeading relvarHeading = this.current.getHeadingDefinition(RelDatabase.this);
                        Heading heading = relvarHeading.getHeading();
                        Value typeInfo = generator.getTypeOf(heading, "RELATION");
                        final int keyCount = relvarHeading.getKeyCount();
                        ValueRelation keysRelation = new ValueRelation(generator){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public TupleIterator newIterator() {
                                return new TupleIterator(){
                                    int keyNumber = 0;

                                    @Override
                                    public boolean hasNext() {
                                        return this.keyNumber < keyCount;
                                    }

                                    @Override
                                    public ValueTuple next() {
                                        ValueRelationLiteral keyDef = new ValueRelationLiteral(generator);
                                        for (String attributeName : relvarHeading.getKey(this.keyNumber).getNames()) {
                                            ValueCharacter attributeNameChar = ValueCharacter.select(generator, attributeName);
                                            keyDef.insert(new ValueTuple(generator, new Value[]{attributeNameChar}));
                                        }
                                        ++this.keyNumber;
                                        return new ValueTuple(generator, new Value[]{keyDef});
                                    }

                                    @Override
                                    public void close() {
                                    }
                                };
                            }

                            @Override
                            public int hashCode() {
                                return 0;
                            }
                        };
                        Value[] values = new Value[]{ValueCharacter.select(generator, this.currentKey), ValueCharacter.select(generator, this.current.getSourceDefinition()), ValueCharacter.select(generator, this.current.getOwner()), ValueInteger.select(generator, this.current.getCreationSequence()), ValueBoolean.select(generator, this.current.isVirtual()), typeInfo, keysRelation};
                        ValueTuple valueTuple = new ValueTuple(generator, values);
                        return valueTuple;
                    }
                    finally {
                        this.current = null;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    private void addDependencies(Generator generator, String object, String dependencyRelvarName, Collection<String> uses) {
        RelvarSystemDependencies dependencyRelvar = (RelvarSystemDependencies)this.openGlobalRelvar(dependencyRelvarName);
        for (String usesname : uses) {
            dependencyRelvar.insertInternal(generator, object, usesname);
        }
    }

    private void removeDependencies(Generator generator, final String object, String dependencyRelvarName) {
        RelvarSystemDependencies dependencyRelvar = (RelvarSystemDependencies)this.openGlobalRelvar(dependencyRelvarName);
        dependencyRelvar.delete(generator, new TupleFilter(){

            @Override
            public boolean filter(ValueTuple tuple) {
                return ((ValueCharacter)tuple.getValues()[0]).stringValue().equals(object);
            }
        });
    }

    private void obtainDependencies(Generator generator, StringBuffer output, final String object, String dependencyRelvarName, String usedBy) {
        RelvarSystemDependencies dependencyRelvar = (RelvarSystemDependencies)this.openGlobalRelvar(dependencyRelvarName);
        try (TupleIterator dependencies = dependencyRelvar.getValue(generator).select(new TupleFilter(){

            @Override
            public boolean filter(ValueTuple tuple) {
                return ((ValueCharacter)tuple.getValues()[1]).stringValue().equals(object);
            }
        }).iterator();){
            int referenceCount = 0;
            while (dependencies.hasNext()) {
                if (referenceCount++ < 5) {
                    output.append("\n\tused by " + usedBy + " " + dependencies.next().getValues()[0]);
                    continue;
                }
                output.append(" and more...");
                break;
            }
        }
    }

    public synchronized Type loadType(Generator generator, String typeName) {
        if (typeName.equalsIgnoreCase("CHARACTER") || typeName.equalsIgnoreCase("CHAR")) {
            return TypeCharacter.getInstance();
        }
        if (typeName.equalsIgnoreCase("INTEGER") || typeName.equalsIgnoreCase("INT")) {
            return TypeInteger.getInstance();
        }
        if (typeName.equalsIgnoreCase("BOOLEAN") || typeName.equalsIgnoreCase("BOOL")) {
            return TypeBoolean.getInstance();
        }
        if (typeName.equalsIgnoreCase("RATIONAL") || typeName.equalsIgnoreCase("RAT")) {
            return TypeRational.getInstance();
        }
        Type type = this.typeCache.get(typeName);
        if (type == null) {
            ValueTuple typeTuple;
            block23: {
                RelvarTypes typesRelvar = (RelvarTypes)this.openGlobalRelvar("sys.Types");
                typeTuple = typesRelvar.getTupleForKey(generator, typeName);
                if (typeTuple != null) break block23;
                return null;
            }
            try {
                String language;
                Interpreter interpreter = new Interpreter(this, System.out);
                ValueRelation superTypeNames = (ValueRelation)typeTuple.getValues()[6];
                if (superTypeNames.getCardinality() > 0L) {
                    TupleIterator it = superTypeNames.iterator();
                    while (it.hasNext()) {
                        this.loadType(generator, it.next().getValues()[0].stringValue());
                    }
                    type = this.typeCache.get(typeName);
                    if (type != null) {
                        return type;
                    }
                }
                if ((language = typeTuple.getValues()[4].toString()).equals(systemOwner)) {
                    String source = typeTuple.getValues()[1].toString();
                    try {
                        interpreter.getGenerator().beginTypeRetrieval();
                        interpreter.compileStatement(source);
                        type = interpreter.getGenerator().endTypeRetrieval();
                    }
                    catch (ParseException pe) {
                        pe.printStackTrace();
                        throw new ExceptionFatal("RS0335: Failed loading type " + typeName + ": " + pe.toString());
                    }
                } else if (language.equals("Java")) {
                    try {
                        Class<?> typeClass = this.loadClass(typeName);
                        if (typeClass == null) {
                            throw new ExceptionSemantic("RS0210: Unable to load class " + typeName);
                        }
                        Constructor<?> ctor = typeClass.getConstructor(Generator.class);
                        if (ctor == null) {
                            throw new ExceptionSemantic("RS0211: Unable to find a constructor of the form " + typeName + "(Generator generator)");
                        }
                        type = (Type)ctor.newInstance(generator);
                    }
                    catch (InstantiationException ie) {
                        ie.printStackTrace();
                        throw new ExceptionFatal("RS0336: Unable to load TYPE " + typeName + " [1]: " + ie.getMessage());
                    }
                    catch (IllegalAccessException iae) {
                        iae.printStackTrace();
                        throw new ExceptionFatal("RS0337: Unable to load TYPE " + typeName + " [2]: " + iae.getMessage());
                    }
                } else {
                    throw new ExceptionFatal("RS0338: Unrecognised language '" + language + "' in TYPE " + typeName);
                }
                this.typeCache.put(typeName, type);
                ValueRelation subTypeNames = (ValueRelation)typeTuple.getValues()[5];
                TupleIterator it = subTypeNames.iterator();
                while (it.hasNext()) {
                    this.loadType(generator, it.next().getValues()[0].stringValue());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new ExceptionFatal("RS0339: loadType failed: " + t);
            }
        }
        return type;
    }

    public synchronized boolean isTypeExists(Generator generator, String typeName) {
        if (this.typeCache.containsKey(typeName)) {
            return true;
        }
        RelvarTypes typesRelvar = (RelvarTypes)this.openGlobalRelvar("sys.Types");
        return typesRelvar.getTupleForKey(generator, typeName) != null;
    }

    private void recordDDL(Generator generator, Transaction txn, String newDefinition) {
        try {
            long nextID;
            if (newDefinition.trim().length() == 0) {
                return;
            }
            RelvarMetadata metadata = this.getRelvarMetadata(txn, "sys.DefinitionHistory");
            if (metadata == null) {
                return;
            }
            RelvarGlobal relvarDefinitionHistory = metadata.getRelvar("sys.DefinitionHistory", this);
            ValueRelation currentValue = relvarDefinitionHistory.getValue(generator);
            if (currentValue.getCardinality() > 0L) {
                SelectOrder orderSelection = new SelectOrder();
                OrderMap map = new OrderMap(relvarDefinitionHistory.getHeadingDefinition().getHeading(), orderSelection);
                nextID = currentValue.sort(map).max(1).longValue() + 1L;
            } else {
                nextID = 1L;
            }
            Value[] rawTuple = new Value[]{ValueCharacter.select(generator, newDefinition), ValueInteger.select(generator, nextID)};
            relvarDefinitionHistory.insert(generator, new ValueTuple(generator, rawTuple));
        }
        catch (Exception e) {
            System.out.println("DefinitionHistory not logged due to " + e + ": " + newDefinition);
        }
    }

    public synchronized void createType(final Generator generator, final String typeName, final String src, final String owner, final String language, final References references, final String superTypeName) {
        if (this.isTypeExists(generator, typeName)) {
            throw new ExceptionSemantic("RS0212: TYPE " + typeName + " is already in the database.");
        }
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    RelvarTypes typesRelvar = (RelvarTypes)RelDatabase.this.openGlobalRelvar("sys.Types");
                    Vector<String> superTypeNames = new Vector<String>();
                    if (superTypeName != null) {
                        superTypeNames.add(superTypeName);
                    }
                    typesRelvar.insertInternal(generator, typeName, src, owner, language, superTypeNames);
                    references.removeReferenceToType(typeName);
                    RelDatabase.this.addDependencies(generator, typeName, "sys.DependenciesTypeOperator", references.getReferencedOperators());
                    RelDatabase.this.addDependencies(generator, typeName, "sys.DependenciesTypeRelvar", references.getReferencedRelvars());
                    RelDatabase.this.addDependencies(generator, typeName, "sys.DependenciesTypeType", references.getReferencedTypes());
                    if (superTypeName != null) {
                        typesRelvar.addSubtype(generator, superTypeName, typeName);
                    }
                    RelDatabase.this.recordDDL(generator, txn, src);
                    return null;
                }
            }.execute(this);
            if (!this.specialCacheMode) {
                this.reset();
            }
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0340: createType failed: " + t);
        }
    }

    private void removeGeneratedOperators(Generator generator, String typeName) {
        ArrayList<String> dropOps = new ArrayList<String>();
        RelvarOperators operatorsRelvar = (RelvarOperators)this.openGlobalRelvar("sys.Operators");
        try (TupleIterator operatorsIterator = operatorsRelvar.getValue(generator).iterator();){
            while (operatorsIterator.hasNext()) {
                ValueTuple operatorTuple = operatorsIterator.next();
                ValueRelation implementations = (ValueRelation)operatorTuple.getValues()[1];
                try (TupleIterator implementationsIterator = implementations.iterator();){
                    while (implementationsIterator.hasNext()) {
                        ValueTuple implementationTuple = implementationsIterator.next();
                        if (!((ValueCharacter)implementationTuple.getValues()[4]).stringValue().equals(typeName)) continue;
                        String opSignatureText = ((ValueCharacter)implementationTuple.getValues()[0]).stringValue();
                        dropOps.add(opSignatureText);
                    }
                }
            }
        }
        for (String opSignatureText : dropOps) {
            OperatorSignature signature;
            Interpreter interpreter = new Interpreter(this, System.out);
            try {
                signature = interpreter.getOperatorSignature(opSignatureText);
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                throw new ExceptionFatal("RS0341: Unable to retrieve operator signature for '" + opSignatureText + "': " + pe.toString());
            }
            this.dropOperatorInternal(generator, signature);
        }
    }

    public synchronized void dropType(Generator generator, final String typeName) {
        final Type type = this.loadType(generator, typeName);
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    TypeAlpha udt;
                    Generator generator = new Generator(RelDatabase.this, System.out);
                    RelDatabase.this.removeGeneratedOperators(generator, typeName);
                    StringBuffer dependencies = new StringBuffer();
                    RelDatabase.this.obtainDependencies(generator, dependencies, typeName, "sys.DependenciesOperatorType", "OPERATOR");
                    RelDatabase.this.obtainDependencies(generator, dependencies, typeName, "sys.DependenciesRelvarType", "VAR");
                    RelDatabase.this.obtainDependencies(generator, dependencies, typeName, "sys.DependenciesTypeType", "TYPE");
                    if (dependencies.length() > 0) {
                        throw new ExceptionSemantic("RS0213: Type " + typeName + " may not be dropped due to dependencies:" + dependencies);
                    }
                    RelvarTypes typesRelvar = (RelvarTypes)RelDatabase.this.openGlobalRelvar("sys.Types");
                    typesRelvar.deleteInternal(generator, typeName);
                    RelDatabase.this.removeDependencies(generator, typeName, "sys.DependenciesTypeOperator");
                    RelDatabase.this.removeDependencies(generator, typeName, "sys.DependenciesTypeRelvar");
                    RelDatabase.this.removeDependencies(generator, typeName, "sys.DependenciesTypeType");
                    RelDatabase.this.dirClassLoader.unload(String.valueOf(RelDatabase.getRelUserCodePackage()) + "." + typeName);
                    if (type instanceof TypeAlpha && (udt = (TypeAlpha)type).isSubtype()) {
                        String superTypeName = udt.getSupertype().getSignature();
                        typesRelvar.removeSubtype(generator, superTypeName, typeName);
                    }
                    RelDatabase.this.typeCache.remove(typeName);
                    RelDatabase.this.recordDDL(generator, txn, "DROP TYPE typeName;");
                    return null;
                }
            }.execute(this);
            this.reset();
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0342: dropType failed: " + t);
        }
    }

    public synchronized boolean isConstraintExists(String constraintName) {
        return this.constraints.containsKey(constraintName);
    }

    public synchronized void createConstraint(final Generator generator, final VirtualMachine vm, final String constraintName, final String sourceCode, final Operator operator, final String owner, final References references) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    if (RelDatabase.this.isConstraintExists(constraintName)) {
                        throw new ExceptionSemantic("RS0214: Constraint " + constraintName + " already exists.");
                    }
                    if (!RelDatabase.this.checkConstraint(vm, operator)) {
                        throw new ExceptionSemantic("RS0215: Constraint " + constraintName + " returns false.");
                    }
                    RelvarSystem constraintsRelvar = (RelvarSystem)RelDatabase.this.openGlobalRelvar("sys.Constraints");
                    constraintsRelvar.insertInternal(generator, constraintName, sourceCode, owner);
                    RelDatabase.this.addDependencies(generator, constraintName, "sys.DependenciesConstraintOperator", references.getReferencedOperators());
                    RelDatabase.this.addDependencies(generator, constraintName, "sys.DependenciesConstraintRelvar", references.getReferencedRelvars());
                    RelDatabase.this.addDependencies(generator, constraintName, "sys.DependenciesConstraintType", references.getReferencedTypes());
                    RelDatabase.this.constraints.put(constraintName, operator);
                    RelDatabase.this.recordDDL(generator, txn, "CONSTRAINT " + constraintName + " " + sourceCode + ";");
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0343: createConstraint failed: " + t);
        }
    }

    public synchronized void dropConstraint(final Generator generator, final String constraintName) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    RelvarSystem constraintsRelvar = (RelvarSystem)RelDatabase.this.openGlobalRelvar("sys.Constraints");
                    constraintsRelvar.deleteInternal(generator, constraintName);
                    RelDatabase.this.removeDependencies(generator, constraintName, "sys.DependenciesConstraintOperator");
                    RelDatabase.this.removeDependencies(generator, constraintName, "sys.DependenciesConstraintRelvar");
                    RelDatabase.this.removeDependencies(generator, constraintName, "sys.DependenciesConstraintType");
                    RelDatabase.this.constraints.remove(constraintName);
                    RelDatabase.this.recordDDL(generator, txn, "DROP CONSTRAINT " + constraintName + ";");
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0344: dropConstraint failed: " + t);
        }
    }

    public synchronized boolean isOperatorExists(OperatorSignature signature) {
        RelvarOperators operatorsRelvar = (RelvarOperators)this.openGlobalRelvar("sys.Operators");
        return operatorsRelvar.isOperatorExists(new Generator(this, System.out), signature);
    }

    public synchronized String getOperatorGenerationTypeName(OperatorSignature signature) {
        RelvarOperators operatorsRelvar = (RelvarOperators)this.openGlobalRelvar("sys.Operators");
        return operatorsRelvar.getOperatorGenerationTypeName(new Generator(this, System.out), signature);
    }

    public synchronized void createOperator(final Generator generator, final OperatorDefinition operator) {
        if (this.isOperatorExists(operator.getSignature())) {
            throw new ExceptionSemantic("RS0216: OPERATOR " + operator.getSignature() + " is already in the database.");
        }
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    RelvarOperators operatorsRelvar = (RelvarOperators)RelDatabase.this.openGlobalRelvar("sys.Operators");
                    String opsig = operator.getSignature().toRelLookupString();
                    String returnType = operator.getDeclaredReturnType() != null ? operator.getDeclaredReturnType().getSignature() : "";
                    operatorsRelvar.insertInternal(new Generator(RelDatabase.this, System.out), operator.getSignature().getName(), returnType, opsig, operator.getSourceCode(), operator.getLanguage(), operator.getCreatedByType(), operator.getOwner());
                    References references = operator.getReferences();
                    references.removeReferenceToOperator(opsig);
                    RelDatabase.this.addDependencies(generator, opsig, "sys.DependenciesOperatorOperator", references.getReferencedOperators());
                    RelDatabase.this.addDependencies(generator, opsig, "sys.DependenciesOperatorRelvar", references.getReferencedRelvars());
                    RelDatabase.this.addDependencies(generator, opsig, "sys.DependenciesOperatorType", references.getReferencedTypes());
                    RelDatabase.this.recordDDL(generator, txn, operator.getSourceCode());
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0345: createOperator failed: " + t);
        }
    }

    private void dropOperatorInternal(Generator generator, OperatorSignature signature) {
        if (this.operatorCache.containsKey(signature)) {
            this.operatorCache.remove(signature);
        }
        String opsig = signature.toRelLookupString();
        StringBuffer dependencies = new StringBuffer();
        this.obtainDependencies(generator, dependencies, opsig, "sys.DependenciesConstraintOperator", "CONSTRAINT");
        this.obtainDependencies(generator, dependencies, opsig, "sys.DependenciesOperatorOperator", "OPERATOR");
        this.obtainDependencies(generator, dependencies, opsig, "sys.DependenciesRelvarOperator", "VAR");
        this.obtainDependencies(generator, dependencies, opsig, "sys.DependenciesTypeOperator", "TYPE");
        if (dependencies.length() > 0) {
            throw new ExceptionSemantic("RS0217: Operator " + signature + " may not be dropped due to dependencies:" + dependencies);
        }
        RelvarOperators operatorsRelvar = (RelvarOperators)this.openGlobalRelvar("sys.Operators");
        operatorsRelvar.deleteInternal(generator, signature);
        this.dirClassLoader.unload(String.valueOf(RelDatabase.getRelUserCodePackage()) + "." + signature.getClassSignature());
        this.removeDependencies(generator, opsig, "sys.DependenciesOperatorOperator");
        this.removeDependencies(generator, opsig, "sys.DependenciesOperatorRelvar");
        this.removeDependencies(generator, opsig, "sys.DependenciesOperatorType");
    }

    public synchronized void dropOperator(final Generator generator, final OperatorSignature signature) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    RelDatabase.this.dropOperatorInternal(new Generator(RelDatabase.this, System.out), signature);
                    RelDatabase.this.recordDDL(generator, txn, "DROP OPERATOR " + signature.toRelLookupString() + ";");
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0346: dropOperator failed: " + t);
        }
    }

    public Class<?> loadClass(String classSignature) {
        try {
            return this.dirClassLoader.forName(String.valueOf(RelDatabase.getRelUserCodePackage()) + "." + classSignature);
        }
        catch (ClassNotFoundException t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0347: Failed loading class " + classSignature + ": " + t.toString());
        }
    }

    public Method getMethod(OperatorSignature signature) {
        String classSignature = signature.getClassSignature();
        try {
            return this.loadClass(classSignature).getDeclaredMethod("execute", Context.class);
        }
        catch (NoSuchMethodException m) {
            m.printStackTrace();
            throw new ExceptionFatal("RS0348: Failed loading operator " + signature + " from class " + classSignature + ": " + m.toString());
        }
    }

    public void cacheOperator(OperatorDefinition op) {
        this.operatorCache.put(op.getSignature(), op);
    }

    private OperatorDefinition getOperatorFromCache(OperatorSignature signature) {
        OperatorDefinition definition = this.operatorCachePermanent.get(signature);
        if (definition != null) {
            return definition;
        }
        return this.operatorCache.get(signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized OperatorDefinition loadOperator(Generator generator, OperatorSignature signature) {
        OperatorDefinition definition = this.getOperatorFromCache(signature);
        if (definition != null) {
            return definition;
        }
        definition = this.builtinops.get(signature.toNativeLookupString());
        if (definition != null) {
            return definition;
        }
        RelvarOperators operatorsRelvar = (RelvarOperators)this.openGlobalRelvar("sys.Operators");
        ValueTuple operatorTuple = operatorsRelvar.getTupleForKey(generator, signature.getName());
        if (operatorTuple == null) {
            return null;
        }
        Interpreter interpreter = new Interpreter(this, System.out);
        ValueRelationLiteral existingImplementations = (ValueRelationLiteral)operatorTuple.getValues()[1];
        try (TupleIterator implementationIterator = existingImplementations.iterator();){
            Type returnType;
            ValueTuple implementationTuple;
            String existingImplementationSignature;
            do {
                if (implementationIterator.hasNext()) continue;
                return null;
            } while (!(existingImplementationSignature = ((ValueCharacter)(implementationTuple = implementationIterator.next()).getValues()[0]).stringValue()).equalsIgnoreCase(signature.toRelLookupString()));
            String sourceCode = implementationTuple.getValues()[2].toString();
            String language = implementationTuple.getValues()[3].toString();
            if (language.equals(systemOwner) || language.equals("System")) {
                try {
                    if (sourceCode.length() == 0) {
                        String createdByType = implementationTuple.getValues()[4].toString();
                        this.loadType(generator, createdByType);
                        OperatorDefinition operatorDefinition = this.getOperatorFromCache(signature);
                        return operatorDefinition;
                    }
                }
                catch (ParseException pe) {
                    pe.printStackTrace();
                    throw new ExceptionFatal("RS0349: Failed loading operator " + signature + ": " + pe.toString());
                }
                OperatorDefinition operatorDefinition = interpreter.compileOperator(sourceCode);
                return operatorDefinition;
            }
            if (language.equals("JavaP")) {
                OperatorDefinitionNativeProcedureExternal operatorDefinitionNativeProcedureExternal = new OperatorDefinitionNativeProcedureExternal(signature, this.getMethod(signature));
                return operatorDefinitionNativeProcedureExternal;
            }
            if (!language.equals("JavaF")) throw new ExceptionFatal("RS0351: Unrecognised language '" + language + "' in operator " + signature);
            OperatorDefinitionNativeFunctionExternal opdef = new OperatorDefinitionNativeFunctionExternal(signature, this.getMethod(signature));
            try {
                returnType = interpreter.getOperatorReturnType(sourceCode);
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                throw new ExceptionFatal("RS0350: Failed loading operator " + signature + ": " + pe.toString());
            }
            opdef.setDeclaredReturnType(returnType);
            OperatorDefinitionNativeFunctionExternal operatorDefinitionNativeFunctionExternal = opdef;
            return operatorDefinitionNativeFunctionExternal;
        }
    }

    public synchronized void getPossibleTargetSignatures(HashSet<OperatorSignature> targets, Generator generator, OperatorSignature signature) {
        RelvarOperators operatorsRelvar = (RelvarOperators)this.openGlobalRelvar("sys.Operators");
        ValueTuple operatorTuple = operatorsRelvar.getTupleForKey(generator, signature.getName());
        if (operatorTuple != null) {
            ValueRelationLiteral existingImplementations = (ValueRelationLiteral)operatorTuple.getValues()[1];
            try (TupleIterator implementationIterator = existingImplementations.iterator();){
                Interpreter interpreter = new Interpreter(this, System.out);
                while (implementationIterator.hasNext()) {
                    OperatorSignature storedSignature;
                    ValueTuple implementationTuple = implementationIterator.next();
                    String parmSignature = ((ValueCharacter)implementationTuple.getValues()[0]).stringValue();
                    String returnStr = ((ValueCharacter)implementationTuple.getValues()[1]).stringValue();
                    String existingImplementationSignatureText = String.valueOf(parmSignature) + (returnStr.length() > 0 ? " RETURNS " + returnStr : "");
                    try {
                        storedSignature = interpreter.getOperatorSignature(existingImplementationSignatureText);
                    }
                    catch (ParseException pe) {
                        pe.printStackTrace();
                        throw new ExceptionFatal("RS0352: Unable to retrieve operator signature for '" + existingImplementationSignatureText + "': " + pe.toString());
                    }
                    if (!storedSignature.canBeInvokedBy(signature)) continue;
                    targets.add(storedSignature);
                }
            }
        }
        for (OperatorDefinition op : this.operatorCache.values()) {
            OperatorSignature storedSignature = op.getSignature();
            if (!storedSignature.canBeInvokedBy(signature)) continue;
            targets.add(storedSignature);
        }
        OperatorDefinition definition = this.builtinops.get(signature.toNativeLookupString());
        if (definition != null) {
            targets.add(definition.getSignature());
        }
    }

    synchronized void defineBuiltinOperator(OperatorDefinition operator) {
        this.builtinops.put(operator.getSignature().toNativeLookupString(), operator);
    }

    public synchronized ValueRelation getBuiltinOperators(Generator generator) {
        return new ValueRelation(generator){
            private static final long serialVersionUID = 1L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){
                    Iterator<OperatorDefinition> i;
                    {
                        this.i = RelDatabase.this.builtinops.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public ValueTuple next() {
                        Generator generator = this.getGenerator();
                        return new ValueTuple(generator, new Value[]{ValueCharacter.select(generator, this.i.next().toString())});
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    public synchronized boolean isRelvarExists(final String name) {
        try {
            return (Boolean)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    return new Boolean(RelDatabase.this.isRelvarExists(txn, name));
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0353: isRelvarExists failed: " + t);
        }
    }

    public synchronized Storage getStorage(Transaction txn, String name) throws DatabaseException {
        RelvarMetadata metadata = this.getRelvarMetadata(txn, name);
        if (metadata == null) {
            return null;
        }
        if (!(metadata instanceof RelvarRealMetadata)) {
            throw new ExceptionFatal("RS0354: VAR " + name + " is not a REAL relvar.");
        }
        StorageNames storageNames = ((RelvarRealMetadata)metadata).getStorageNames();
        Storage storage = new Storage(storageNames.size());
        int i = 0;
        while (i < storageNames.size()) {
            String tabName = storageNames.getName(i);
            Database db = this.openDatabase(txn, tabName, this.dbConfigurationNormal);
            storage.setDatabase(i, db);
            ++i;
        }
        return storage;
    }

    public RelvarMetadata getRelvarMetadata(final String relvarName) {
        try {
            return (RelvarMetadata)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    return RelDatabase.this.getRelvarMetadata(txn, relvarName);
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0355: getRelvarMetadata failed: " + t);
        }
    }

    private String getUniqueTableName() {
        return "relvar_" + this.getUniqueID();
    }

    public synchronized void createRealRelvar(final Generator generator, final RelvarDefinition relvarInfo) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    if (RelDatabase.this.isRelvarExists(txn, relvarInfo.getName())) {
                        throw new ExceptionSemantic("RS0218: VAR " + relvarInfo.getName() + " already exists.");
                    }
                    RelvarMetadata metadata = RelDatabase.this.getRelvarMetadata(txn, relvarInfo.getName());
                    if (metadata != null && metadata instanceof RelvarRealMetadata) {
                        StorageNames storageNames = ((RelvarRealMetadata)metadata).getStorageNames();
                        int i = 0;
                        while (i < storageNames.size()) {
                            String tabName = storageNames.getName(i);
                            RelDatabase.this.closeDatabase(tabName);
                            try {
                                RelDatabase.this.environment.removeDatabase(txn, tabName);
                            }
                            catch (DatabaseException dbe) {
                                dbe.printStackTrace();
                                throw new ExceptionFatal("RS0356: unable to remove table " + storageNames);
                            }
                            ++i;
                        }
                    }
                    RelvarRealMetadata newMetadata = (RelvarRealMetadata)relvarInfo.getRelvarMetadata();
                    StorageNames storageNames = new StorageNames(newMetadata.getHeadingDefinition(RelDatabase.this).getKeyCount());
                    int i = 0;
                    while (i < storageNames.size()) {
                        String tabName = RelDatabase.this.getUniqueTableName();
                        storageNames.setName(i, tabName);
                        RelDatabase.this.openDatabase(txn, tabName, RelDatabase.this.dbConfigurationAllowCreate).close();
                        RelDatabase.this.openStorage.remove(tabName);
                        ++i;
                    }
                    newMetadata.setStorageNames(storageNames);
                    RelDatabase.this.putRelvarMetadata(txn, relvarInfo.getName(), newMetadata);
                    RelDatabase.this.addDependencies(generator, relvarInfo.getName(), "sys.DependenciesRelvarType", relvarInfo.getReferences().getReferencedTypes());
                    RelDatabase.this.recordDDL(generator, txn, relvarInfo.toString());
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0357: createRealRelvar failed: " + t);
        }
    }

    public synchronized void createVirtualRelvar(final Generator generator, final RelvarDefinition information) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    if (RelDatabase.this.isRelvarExists(txn, information.getName())) {
                        throw new ExceptionSemantic("RS0219: VAR " + information.getName() + " already exists.");
                    }
                    RelDatabase.this.putRelvarMetadata(txn, information.getName(), information.getRelvarMetadata());
                    RelDatabase.this.addDependencies(generator, information.getName(), "sys.DependenciesRelvarOperator", information.getReferences().getReferencedOperators());
                    RelDatabase.this.addDependencies(generator, information.getName(), "sys.DependenciesRelvarRelvar", information.getReferences().getReferencedRelvars());
                    RelDatabase.this.addDependencies(generator, information.getName(), "sys.DependenciesRelvarType", information.getReferences().getReferencedTypes());
                    RelDatabase.this.recordDDL(generator, txn, information.toString());
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0358: createVirtualRelvar failed: " + t);
        }
    }

    public void createExternalRelvar(final Generator generator, final RelvarDefinition relvarInfo) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    if (RelDatabase.this.isRelvarExists(txn, relvarInfo.getName())) {
                        throw new ExceptionSemantic("RS0220: VAR " + relvarInfo.getName() + " already exists.");
                    }
                    RelDatabase.this.putRelvarMetadata(txn, relvarInfo.getName(), relvarInfo.getRelvarMetadata());
                    RelDatabase.this.addDependencies(generator, relvarInfo.getName(), "sys.DependenciesRelvarType", relvarInfo.getReferences().getReferencedTypes());
                    RelDatabase.this.recordDDL(generator, txn, relvarInfo.toString());
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0359: createExternalRelvar failed: " + t);
        }
    }

    private synchronized Database createTempStorage(DatabaseConfig config) {
        String newTableName = this.getUniqueTableName();
        Transaction txn = null;
        Database database = this.openDatabase(txn, newTableName, config);
        this.tempStorageNames.add(newTableName);
        return database;
    }

    public Database createTempStorage() {
        return this.createTempStorage(this.dbConfigurationTemporary);
    }

    public Database createTempStorageWithDuplicatesNoComparator() {
        return this.createTempStorage(this.dbConfigurationTemporaryWithDuplicatesNoComparator);
    }

    public synchronized void destroyTempStorage(Database temp) {
        String tableName = temp.getDatabaseName();
        this.closeDatabase(tableName);
        this.tempStorageNames.remove(tableName);
    }

    public synchronized TablePrivate getTempTable(final RelvarHeading keyDefinition) {
        try {
            return (TablePrivate)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    Storage storage = new Storage(keyDefinition.getKeyCount());
                    int i = 0;
                    while (i < storage.size()) {
                        String newTableName = RelDatabase.this.getUniqueTableName();
                        Database db = RelDatabase.this.openDatabase(txn, newTableName, RelDatabase.this.dbConfigurationAllowCreate);
                        RelDatabase.this.tempStorageNames.add(newTableName);
                        storage.setDatabase(i, db);
                        ++i;
                    }
                    return new TablePrivate(RelDatabase.this, storage, keyDefinition);
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0360: getTempTable failed: " + t);
        }
    }

    public synchronized SlotScoped createPrivateRelvar(int depth, int offset, RelvarHeading keydef) {
        return new RelvarPrivate(depth, offset, this, keydef);
    }

    public synchronized RelvarGlobal openGlobalRelvar(final String name) {
        try {
            return (RelvarGlobal)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    RelvarMetadata metadata = RelDatabase.this.getRelvarMetadata(txn, name);
                    if (metadata == null) {
                        return null;
                    }
                    return metadata.getRelvar(name, RelDatabase.this);
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0361: openRelvar failed: " + t);
        }
    }

    public synchronized void dropRelvar(final String name) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    RelvarMetadata metadata = RelDatabase.this.getRelvarMetadata(txn, name);
                    if (metadata == null) {
                        throw new ExceptionSemantic("RS0221: VAR " + name + " does not exist.");
                    }
                    Generator generator = new Generator(RelDatabase.this, System.out);
                    StringBuffer dependencies = new StringBuffer();
                    RelDatabase.this.obtainDependencies(generator, dependencies, name, "sys.DependenciesRelvarRelvar", "VAR");
                    RelDatabase.this.obtainDependencies(generator, dependencies, name, "sys.DependenciesOperatorRelvar", "OPERATOR");
                    RelDatabase.this.obtainDependencies(generator, dependencies, name, "sys.DependenciesConstraintRelvar", "CONSTRAINT");
                    RelDatabase.this.obtainDependencies(generator, dependencies, name, "sys.DependenciesTypeRelvar", "TYPE");
                    if (dependencies.length() > 0) {
                        throw new ExceptionSemantic("RS0222: VAR " + name + " may not be dropped due to dependencies:" + dependencies);
                    }
                    metadata.dropRelvar(RelDatabase.this);
                    if (metadata instanceof RelvarRealMetadata) {
                        StorageNames storageNames = ((RelvarRealMetadata)metadata).getStorageNames();
                        int i = 0;
                        while (i < storageNames.size()) {
                            String tabName = storageNames.getName(i);
                            RelDatabase.this.closeDatabase(tabName);
                            RelDatabase.this.environment.removeDatabase(txn, tabName);
                            ++i;
                        }
                    }
                    RelDatabase.this.dropRelvarMetadata(txn, name);
                    RelDatabase.this.removeDependencies(generator, name, "sys.DependenciesRelvarOperator");
                    RelDatabase.this.removeDependencies(generator, name, "sys.DependenciesRelvarRelvar");
                    RelDatabase.this.removeDependencies(generator, name, "sys.DependenciesRelvarType");
                    RelDatabase.this.recordDDL(generator, txn, "DROP VAR " + name + ";");
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0362: dropRelvar failed: " + t);
        }
    }

    private void copy(Generator generator, Transaction txn, Table table, Storage db, ValueRelation source) throws DatabaseException {
        try (TupleIterator iterator = ((ValueRelation)source.getSerializableClone()).iterator();){
            while (iterator.hasNext()) {
                table.insertTupleNoDuplicates(generator, db, txn, iterator.next(), "Assigning");
            }
        }
    }

    public synchronized void setValue(final RelvarPrivateCell target, final ValueRelation source) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    StorageNames newStorageNames = new StorageNames(target.getTable().getHeadingDefinition().getKeyCount());
                    Storage newDb = new Storage(newStorageNames.size());
                    int i = 0;
                    while (i < newStorageNames.size()) {
                        String tabName = RelDatabase.this.getUniqueTableName();
                        newStorageNames.setName(i, tabName);
                        Database db = RelDatabase.this.openDatabase(txn, tabName, RelDatabase.this.dbConfigurationAllowCreate);
                        RelDatabase.this.tempStorageNames.add(tabName);
                        newDb.setDatabase(i, db);
                        ++i;
                    }
                    RelDatabase.this.copy(new Generator(RelDatabase.this, System.out), txn, target.getTable(), newDb, source);
                    Storage oldStorage = target.getTable().getStorage(txn);
                    int i2 = 0;
                    while (i2 < oldStorage.size()) {
                        Database olddb = oldStorage.getDatabase(i2);
                        String tabName = olddb.getDatabaseName();
                        RelDatabase.this.openStorage.remove(tabName);
                        RelDatabase.this.tempStorageNames.remove(tabName);
                        olddb.close();
                        RelDatabase.this.environment.removeDatabase(txn, tabName);
                        ++i2;
                    }
                    target.setTable(newDb);
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0363: RelvarPrivate setValue failed: " + t);
        }
    }

    public synchronized void setValue(final RelvarReal target, final ValueRelation source) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    Storage oldStorage = RelDatabase.this.getStorage(txn, target.getName());
                    StorageNames newStorageNames = new StorageNames(oldStorage.size());
                    Storage newStorage = new Storage(oldStorage.size());
                    int i = 0;
                    while (i < newStorageNames.size()) {
                        String tabName = RelDatabase.this.getUniqueTableName();
                        newStorageNames.setName(i, tabName);
                        Database dbase = RelDatabase.this.openDatabase(txn, tabName, RelDatabase.this.dbConfigurationAllowCreate);
                        newStorage.setDatabase(i, dbase);
                        ++i;
                    }
                    RelDatabase.this.copy(new Generator(RelDatabase.this, System.out), txn, target.getTable(), newStorage, source);
                    StorageNames oldStorageNames = oldStorage.getStorageNames();
                    int i2 = 0;
                    while (i2 < oldStorageNames.size()) {
                        String tabName = oldStorageNames.getName(i2);
                        RelDatabase.this.openStorage.remove(tabName);
                        oldStorage.getDatabase(i2).close();
                        RelDatabase.this.environment.removeDatabase(txn, tabName);
                        ++i2;
                    }
                    RelvarRealMetadata metadata = (RelvarRealMetadata)RelDatabase.this.getRelvarMetadata(txn, target.getName());
                    metadata.setStorageNames(newStorageNames);
                    RelDatabase.this.putRelvarMetadata(txn, target.getName(), metadata);
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0364: RelvarReal setValue failed: " + t);
        }
    }

    private void alterVar(Generator generator, final String varname, final Alteration alteration) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    RelvarMetadata rawMetadata = RelDatabase.this.getRelvarMetadata(txn, varname);
                    if (rawMetadata == null) {
                        throw new ExceptionSemantic("RS0430: REAL VAR '" + varname + "' does not exist.");
                    }
                    if (!(rawMetadata instanceof RelvarRealMetadata)) {
                        throw new ExceptionSemantic("RS0431: '" + varname + "' is not a REAL VAR.");
                    }
                    RelvarRealMetadata metadata = (RelvarRealMetadata)rawMetadata;
                    alteration.alter(txn, varname, metadata);
                    RelDatabase.this.dropRelvarMetadata(txn, varname);
                    RelDatabase.this.putRelvarMetadata(txn, varname, metadata);
                    return null;
                }
            }.execute(this);
        }
        catch (ExceptionSemantic es) {
            throw es;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0432: ALTER failed: " + t);
        }
    }

    private void reindex(Transaction txn, Generator generator, String varname, RelvarRealMetadata metadata, RelvarHeading keydefs) {
        StorageNames storageNames = new StorageNames(keydefs.getKeyCount());
        Storage newStorage = new Storage(storageNames.size());
        int i = 0;
        while (i < storageNames.size()) {
            String tabName = this.getUniqueTableName();
            storageNames.setName(i, tabName);
            Database berkeleyDB = this.openDatabase(txn, tabName, this.dbConfigurationAllowCreate);
            newStorage.setDatabase(i, berkeleyDB);
            ++i;
        }
        RelvarReal relvar = (RelvarReal)metadata.getRelvar(varname, this);
        TableReal table = relvar.getTable();
        try (TupleIterator iterator = relvar.iterator(generator);){
            while (iterator.hasNext()) {
                table.insertTupleNoDuplicates(generator, newStorage, txn, iterator.next(), "Altering KEY means");
            }
        }
        StorageNames oldStorageNames = metadata.getStorageNames();
        int i2 = 0;
        while (i2 < oldStorageNames.size()) {
            String tabName = oldStorageNames.getName(i2);
            this.closeDatabase(tabName);
            try {
                this.environment.removeDatabase(txn, tabName);
            }
            catch (DatabaseException dbe) {
                dbe.printStackTrace();
                throw new ExceptionFatal("RS0435: unable to remove table " + storageNames);
            }
            ++i2;
        }
        metadata.setStorageNames(storageNames);
    }

    public synchronized void alterVarRealChangeAttributeType(final Generator generator, String varname, final String attributeName, final Type newType) {
        this.alterVar(generator, varname, new Alteration(this){

            @Override
            public void alter(Transaction txn, String varname, RelvarRealMetadata metadata) {
                OperatorSignature signature = new OperatorSignature(newType.getSignature());
                signature.addParameterType(TypeCharacter.getInstance());
                OperatorInvocation newAttributeSelector = generator.findOperator(signature);
                if (newAttributeSelector == null) {
                    throw new ExceptionSemantic("RS0447: ALTER VAR " + varname + " TYPE_OF " + attributeName + " TO " + newType.getSignature() + " requires selector " + signature);
                }
                Instruction selector = newAttributeSelector.useDynamicDispatch() ? new OpInvokeDynamicEvaluate(generator, newAttributeSelector.getOperatorSignature()) : new OpInvoke(newAttributeSelector.getStaticOperatorDefinition().getOperator());
                RelvarReal relvar = (RelvarReal)metadata.getRelvar(varname, this);
                TableReal table = relvar.getTable();
                Heading headingForConvertedAttribute = new Heading();
                String tempName = "%tempname";
                headingForConvertedAttribute.add(tempName, newType);
                metadata.insertAttributes(this, headingForConvertedAttribute);
                ValueTuple newAttributes = new ValueTuple(generator, new TypeTuple(headingForConvertedAttribute));
                table.expandTuples(txn, newAttributes);
                Heading heading = metadata.getHeadingDefinition(this).getHeading();
                int oldAttributeIndex = heading.getIndexOf(attributeName);
                Type oldAttributeType = heading.getAttributes().get(oldAttributeIndex).getType();
                int newAttributeIndex = heading.getIndexOf(tempName);
                table.convertTuples(generator, txn, oldAttributeType, oldAttributeIndex, newAttributeIndex, selector);
                int attributeIndex = metadata.dropAttribute(this, attributeName);
                table.shrinkTuples(txn, attributeIndex);
                metadata.renameAttribute(this, tempName, attributeName);
                RelvarHeading keydefs = metadata.getHeadingDefinition(this);
                if (keydefs.isKeyUsing(attributeName)) {
                    this.reindex(txn, generator, varname, metadata, keydefs);
                }
                this.recordDDL(generator, txn, "ALTER VAR " + varname + " TYPE_OF " + attributeName + " TO " + newType.getSignature());
            }
        });
    }

    public synchronized void alterVarRealAlterKey(final Generator generator, String varname, final RelvarHeading keydefs) {
        this.alterVar(generator, varname, new Alteration(this){

            @Override
            public void alter(Transaction txn, String varname, RelvarRealMetadata metadata) {
                metadata.setKeys(this, keydefs);
                this.reindex(txn, generator, varname, metadata, keydefs);
                this.recordDDL(generator, txn, "ALTER VAR " + varname + " " + keydefs.toString() + ";");
            }
        });
    }

    public synchronized void alterVarRealDropAttribute(final Generator generator, String varname, final String attributeName) {
        this.alterVar(generator, varname, new Alteration(this){

            @Override
            public void alter(Transaction txn, String varname, RelvarRealMetadata metadata) {
                int attributeIndex = metadata.dropAttribute(this, attributeName);
                RelvarReal relvar = (RelvarReal)metadata.getRelvar(varname, this);
                TableReal table = relvar.getTable();
                table.shrinkTuples(txn, attributeIndex);
                this.recordDDL(generator, txn, "ALTER VAR " + varname + " DROP " + attributeName);
            }
        });
    }

    public synchronized void alterVarRealInsertAttributes(final Generator generator, String varname, final Heading heading) {
        this.alterVar(generator, varname, new Alteration(this){

            @Override
            public void alter(Transaction txn, String varname, RelvarRealMetadata metadata) {
                metadata.insertAttributes(this, heading);
                RelvarReal relvar = (RelvarReal)metadata.getRelvar(varname, this);
                TableReal table = relvar.getTable();
                ValueTuple newAttributes = new ValueTuple(generator, new TypeTuple(heading));
                table.expandTuples(txn, newAttributes);
                this.recordDDL(generator, txn, "ALTER VAR " + varname + " INSERT " + heading.getSpecification() + ";");
            }
        });
    }

    public synchronized void alterVarRealRenameAttribute(final Generator generator, String varname, final String oldAttributeName, final String newAttributeName) {
        this.alterVar(generator, varname, new Alteration(this){

            @Override
            public void alter(Transaction txn, String varname, RelvarRealMetadata metadata) {
                metadata.renameAttribute(this, oldAttributeName, newAttributeName);
                this.recordDDL(generator, txn, "ALTER VAR " + varname + " RENAME " + oldAttributeName + " TO " + newAttributeName + ";");
            }
        });
    }

    private abstract class Alteration {
        private Alteration() {
        }

        public abstract void alter(Transaction var1, String var2, RelvarRealMetadata var3);
    }

    private static class ComparisonHandler
    implements Serializable,
    Comparator<byte[]> {
        private static final long serialVersionUID = 1L;
        private static volatile SerialBinding<ValueTuple> tupleBinding;

        public ComparisonHandler(SerialBinding<ValueTuple> tupleBinding) {
            ComparisonHandler.tupleBinding = tupleBinding;
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            ValueTuple v1 = (ValueTuple)tupleBinding.entryToObject(new DatabaseEntry(o1));
            ValueTuple v2 = (ValueTuple)tupleBinding.entryToObject(new DatabaseEntry(o2));
            return v1.compareTo(v2);
        }
    }
}

