/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import org.reldb.rel.exceptions.ExceptionFatal;

public class RelTransaction {
    private int referenceCount;
    private Transaction transaction;
    private boolean aborting;
    private boolean aborted;

    public RelTransaction(Transaction txn) {
        this.transaction = txn;
        this.referenceCount = 1;
        this.aborting = false;
        this.aborted = false;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    void addReference() {
        ++this.referenceCount;
    }

    int getReferenceCount() {
        return this.referenceCount;
    }

    void abort() {
        this.aborting = true;
        if (--this.referenceCount > 0) {
            return;
        }
        try {
            this.transaction.abort();
            this.aborted = true;
        }
        catch (DatabaseException de) {
            throw new ExceptionFatal("RS0365: abort failed: " + (Object)((Object)de));
        }
    }

    void commit() {
        if (--this.referenceCount > 0) {
            return;
        }
        try {
            if (this.aborting && !this.aborted) {
                this.transaction.abort();
                this.aborted = true;
            } else {
                this.transaction.commit();
            }
        }
        catch (DatabaseException de) {
            throw new ExceptionFatal("RS0366: commit failed: " + (Object)((Object)de));
        }
    }

    public String toString() {
        return this.transaction.toString();
    }
}

