/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage;

import com.sleepycat.je.LockTimeoutException;
import com.sleepycat.je.Transaction;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.RelTransaction;

public abstract class TransactionRunner {
    private static final int retryLimit = 10;

    public abstract Object run(Transaction var1) throws Throwable;

    public Object execute(RelDatabase environment) throws Throwable {
        boolean ran = false;
        Object returnvalue = null;
        RelTransaction txn = null;
        int attempt = 0;
        while (attempt < 10) {
            txn = environment.beginTransaction();
            try {
                returnvalue = this.run(txn.getTransaction());
                ran = true;
                break;
            }
            catch (LockTimeoutException lte) {
                environment.rollbackTransaction(txn);
                Thread.sleep((long)(Math.random() * 5000.0));
            }
            catch (Throwable t) {
                environment.rollbackTransaction(txn);
                throw t;
            }
            ++attempt;
        }
        if (!ran) {
            throw new ExceptionFatal("RS0379: Transaction " + txn + " attempted " + 10 + " times.  Aborted.");
        }
        environment.commitTransaction(txn);
        return returnvalue;
    }
}

