/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.catalog;

import com.sleepycat.je.DatabaseException;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.References;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.catalog.RelvarCatalogMetadata;
import org.reldb.rel.v0.storage.catalog.RelvarOperatorsBuiltinMetadata;
import org.reldb.rel.v0.storage.catalog.RelvarOperatorsMetadata;
import org.reldb.rel.v0.storage.catalog.RelvarSystemDependenciesMetadata;
import org.reldb.rel.v0.storage.catalog.RelvarSystemMetadata;
import org.reldb.rel.v0.storage.catalog.RelvarTypesMetadata;
import org.reldb.rel.v0.storage.catalog.RelvarVersionMetadata;
import org.reldb.rel.v0.storage.relvars.RelvarDefinition;
import org.reldb.rel.v0.storage.relvars.RelvarMetadata;

public class Catalog {
    public static final String relvarCatalog = "sys.Catalog";
    public static final String relvarVersion = "sys.Version";
    public static final String relvarConstraints = "sys.Constraints";
    public static final String relvarOperators = "sys.Operators";
    public static final String relvarOperatorsBuiltin = "sys.OperatorsBuiltin";
    public static final String relvarTypes = "sys.Types";
    public static final String relvarDefinitionHistory = "sys.DefinitionHistory";
    public static final String relvarDependenciesRelvarOperator = "sys.DependenciesRelvarOperator";
    public static final String relvarDependenciesRelvarRelvar = "sys.DependenciesRelvarRelvar";
    public static final String relvarDependenciesRelvarType = "sys.DependenciesRelvarType";
    public static final String relvarDependenciesTypeOperator = "sys.DependenciesTypeOperator";
    public static final String relvarDependenciesTypeType = "sys.DependenciesTypeType";
    public static final String relvarDependenciesTypeRelvar = "sys.DependenciesTypeRelvar";
    public static final String relvarDependenciesConstraintOperator = "sys.DependenciesConstraintOperator";
    public static final String relvarDependenciesConstraintRelvar = "sys.DependenciesConstraintRelvar";
    public static final String relvarDependenciesConstraintType = "sys.DependenciesConstraintType";
    public static final String relvarDependenciesOperatorOperator = "sys.DependenciesOperatorOperator";
    public static final String relvarDependenciesOperatorRelvar = "sys.DependenciesOperatorRelvar";
    public static final String relvarDependenciesOperatorType = "sys.DependenciesOperatorType";
    private RelDatabase database;

    public void generatePhase0(Generator generator) throws DatabaseException {
        new RegisterSpecialRelvar(this, relvarVersion){

            @Override
            RelvarMetadata getMetadata() {
                return new RelvarVersionMetadata(database);
            }
        }.go();
        new CreateSystemRelvar(generator, relvarConstraints).go();
        new CreateSystemRelvar(this, generator, relvarOperators){

            @Override
            RelvarMetadata getMetadata() {
                return new RelvarOperatorsMetadata(database, this.name);
            }
        }.go();
        new RegisterSpecialRelvar(this, relvarOperatorsBuiltin){

            @Override
            RelvarMetadata getMetadata() {
                return new RelvarOperatorsBuiltinMetadata(database);
            }
        }.go();
        new CreateSystemRelvar(this, generator, relvarTypes){

            @Override
            RelvarMetadata getMetadata() {
                return new RelvarTypesMetadata(database, this.name);
            }
        }.go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesRelvarOperator).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesRelvarRelvar).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesRelvarType).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesTypeOperator).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesTypeRelvar).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesTypeType).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesConstraintOperator).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesConstraintRelvar).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesConstraintType).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesOperatorOperator).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesOperatorRelvar).go();
        new CreateSystemDependenciesRelvar(generator, relvarDependenciesOperatorType).go();
    }

    public void generatePhase1(final Generator generator) throws DatabaseException {
        new RegisterSpecialRelvar(this, relvarCatalog){

            @Override
            RelvarMetadata getMetadata() {
                return new RelvarCatalogMetadata(database, generator);
            }
        }.go();
    }

    public Catalog(RelDatabase database) {
        this.database = database;
    }

    private void registerSpecialRelvar(String name, RelvarMetadata metadata) throws DatabaseException {
        this.database.putRelvarMetadata(null, name, metadata);
    }

    private void createSystemRelvar(Generator generator, RelvarSystemMetadata metadata) {
        String name = metadata.getName();
        this.database.createRealRelvar(generator, new RelvarDefinition(name, metadata, new References()));
    }

    private class CreateSystemDependenciesRelvar
    extends CreateSystemRelvar {
        CreateSystemDependenciesRelvar(Generator generator, String name) {
            super(generator, name);
        }

        @Override
        RelvarMetadata getMetadata() {
            return new RelvarSystemDependenciesMetadata(Catalog.this.database, this.name);
        }
    }

    private class CreateSystemRelvar
    extends HandleRelvar {
        private Generator generator;

        CreateSystemRelvar(Generator generator, String name) {
            super(name);
            this.generator = generator;
        }

        @Override
        RelvarMetadata getMetadata() {
            return new RelvarSystemMetadata(Catalog.this.database, this.name);
        }

        @Override
        public void process() throws DatabaseException {
            Catalog.this.createSystemRelvar(this.generator, (RelvarSystemMetadata)this.getMetadata());
        }
    }

    private abstract class HandleRelvar {
        protected String name;

        HandleRelvar(String name) {
            this.name = name;
        }

        abstract RelvarMetadata getMetadata();

        abstract void process() throws DatabaseException;

        public void go() throws DatabaseException {
            if (!Catalog.this.database.isRelvarExists(this.name)) {
                System.out.println("Creating " + this.name + " relvar.");
                this.process();
            }
            Catalog.this.database.openGlobalRelvar(this.name);
        }
    }

    private abstract class RegisterSpecialRelvar
    extends HandleRelvar {
        RegisterSpecialRelvar(String name) {
            super(name);
        }

        @Override
        public void process() throws DatabaseException {
            Catalog.this.registerSpecialRelvar(this.name, this.getMetadata());
        }
    }
}

