/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.catalog;

import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.catalog.RelvarSystem;
import org.reldb.rel.v0.storage.relvars.RelvarRealMetadata;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRelationLiteral;
import org.reldb.rel.v0.values.ValueTuple;

public class RelvarExternals
extends RelvarSystem {
    public RelvarExternals(String name, RelDatabase database, RelvarRealMetadata metadata) {
        super(name, database, metadata);
    }

    private ValueTuple getTupleFor(Generator generator, String name, String definition, String owner, String language) {
        Value[] rawTuple = new Value[]{ValueCharacter.select(generator, name), ValueCharacter.select(generator, definition), ValueCharacter.select(generator, owner), ValueInteger.select(generator, this.getDatabase().getUniqueID()), ValueCharacter.select(generator, language), new ValueRelationLiteral(generator)};
        return new ValueTuple(generator, rawTuple);
    }

    @Override
    protected ValueTuple getKeyTuple(Generator generator, String name) {
        return this.getTupleFor(generator, name, "", "", "");
    }

    public void insertInternal(Generator generator, String name, String definition, String owner, String language) {
        this.insertInternal(generator, this.getTupleFor(generator, name, definition, owner, language));
    }

    public void addSubtype(Generator generator, String superTypeName, String subTypeName) {
        ValueTuple superTypeData = this.getTupleForKey(generator, superTypeName);
        if (superTypeData == null) {
            throw new ExceptionFatal("RS0314: Unable to obtain data for " + superTypeName);
        }
        ValueRelationLiteral subtypes = (ValueRelationLiteral)superTypeData.getValues()[5];
        subtypes.insert(new ValueTuple(generator, new Value[]{ValueCharacter.select(generator, subTypeName)}));
        this.deleteInternal(generator, superTypeName);
        this.insertInternal(generator, superTypeData);
    }

    public void removeSubtype(Generator generator, String superTypeName, String subTypeName) {
        ValueTuple superTypeData = this.getTupleForKey(generator, superTypeName);
        if (superTypeData == null) {
            throw new ExceptionFatal("RS0315: Unable to obtain data for " + superTypeName);
        }
        ValueRelationLiteral subtypes = (ValueRelationLiteral)superTypeData.getValues()[5];
        subtypes.remove(new ValueTuple(generator, new Value[]{ValueCharacter.select(generator, subTypeName)}));
        this.deleteInternal(generator, superTypeName);
        this.insertInternal(generator, superTypeData);
    }
}

