/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.catalog;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.catalog.RelvarSystem;
import org.reldb.rel.v0.storage.relvars.RelvarRealMetadata;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRelationLiteral;
import org.reldb.rel.v0.values.ValueTuple;

public class RelvarOperators
extends RelvarSystem {
    public RelvarOperators(String name, RelDatabase database, RelvarRealMetadata metadata) {
        super(name, database, metadata);
    }

    private ValueTuple getTupleFor(Generator generator, String signature, String returnsType, String definition, String language, String generatedByType, String owner) {
        Value[] rawTuple = new Value[]{ValueCharacter.select(generator, signature), ValueCharacter.select(generator, returnsType), ValueCharacter.select(generator, definition), ValueCharacter.select(generator, language), ValueCharacter.select(generator, generatedByType), ValueCharacter.select(generator, owner), ValueInteger.select(generator, this.getDatabase().getUniqueID())};
        return new ValueTuple(generator, rawTuple);
    }

    private ValueTuple getTupleFor(Generator generator, String name, ValueRelationLiteral implementation) {
        Value[] rawTuple = new Value[]{ValueCharacter.select(generator, name), implementation};
        return new ValueTuple(generator, rawTuple);
    }

    @Override
    protected ValueTuple getKeyTuple(Generator generator, String name) {
        return this.getTupleFor(generator, name, null);
    }

    public void insertInternal(Generator generator, String name, String returnsType, String signature, String definition, String language, String generatedByType, String owner) {
        ValueTuple operatorTuple = this.getTupleForKey(generator, name);
        if (operatorTuple == null) {
            ValueRelationLiteral newImplementation = new ValueRelationLiteral(generator);
            newImplementation.insert(this.getTupleFor(generator, signature, returnsType, definition, language, generatedByType, owner));
            this.insertInternal(generator, this.getTupleFor(generator, name, newImplementation));
        } else {
            ValueRelationLiteral existingImplementations = (ValueRelationLiteral)operatorTuple.getValues()[1];
            try (TupleIterator implementationIterator = existingImplementations.iterator();){
                while (implementationIterator.hasNext()) {
                    ValueTuple implementationTuple = implementationIterator.next();
                    String existingImplementationSignature = ((ValueCharacter)implementationTuple.getValues()[0]).stringValue();
                    if (!existingImplementationSignature.equalsIgnoreCase(signature)) continue;
                    throw new ExceptionSemantic("RS0199: OPERATOR " + signature + " already exists.");
                }
            }
            existingImplementations.insert(this.getTupleFor(generator, signature, returnsType, definition, language, generatedByType, owner));
            this.deleteInternal(generator, name);
            this.insertInternal(generator, this.getTupleFor(generator, name, existingImplementations));
        }
    }

    public void deleteInternal(Generator generator, OperatorSignature signature) {
        String name = signature.getName();
        ValueTuple operatorTuple = this.getTupleForKey(generator, name);
        if (operatorTuple == null) {
            throw new ExceptionSemantic("RS0200: OPERATOR " + signature + " could not be found.");
        }
        ValueRelationLiteral existingImplementations = (ValueRelationLiteral)operatorTuple.getValues()[1];
        try (TupleIterator implementationIterator = existingImplementations.iterator();){
            while (implementationIterator.hasNext()) {
                ValueTuple implementationTuple = implementationIterator.next();
                String existingImplementationSignature = ((ValueCharacter)implementationTuple.getValues()[0]).stringValue();
                if (!existingImplementationSignature.equalsIgnoreCase(signature.toRelLookupString())) continue;
                existingImplementations.remove(implementationTuple);
                this.deleteInternal(generator, name);
                if (existingImplementations.getCardinality() > 0L) {
                    this.insertInternal(generator, this.getTupleFor(generator, name, existingImplementations));
                }
                return;
            }
        }
        throw new ExceptionSemantic("RS0201: OPERATOR " + signature + " could not be found.");
    }

    public String getOperatorGenerationTypeName(Generator generator, OperatorSignature signature) {
        ValueTuple operatorTuple = this.getTupleForKey(generator, signature.getName());
        if (operatorTuple == null) {
            return null;
        }
        ValueRelationLiteral existingImplementations = (ValueRelationLiteral)operatorTuple.getValues()[1];
        try (TupleIterator implementationIterator = existingImplementations.iterator();){
            while (implementationIterator.hasNext()) {
                ValueTuple implementationTuple = implementationIterator.next();
                String existingImplementationSignature = ((ValueCharacter)implementationTuple.getValues()[0]).stringValue();
                if (!existingImplementationSignature.equalsIgnoreCase(signature.toRelLookupString())) continue;
                String string = ((ValueCharacter)implementationTuple.getValues()[4]).stringValue();
                return string;
            }
        }
        return null;
    }

    public boolean isOperatorExists(Generator generator, OperatorSignature signature) {
        ValueTuple operatorTuple = this.getTupleForKey(generator, signature.getName());
        if (operatorTuple == null) {
            return false;
        }
        ValueRelationLiteral existingImplementations = (ValueRelationLiteral)operatorTuple.getValues()[1];
        try (TupleIterator implementationIterator = existingImplementations.iterator();){
            while (implementationIterator.hasNext()) {
                ValueTuple implementationTuple = implementationIterator.next();
                String existingImplementationSignature = ((ValueCharacter)implementationTuple.getValues()[0]).stringValue();
                if (!existingImplementationSignature.equalsIgnoreCase(signature.toRelLookupString())) continue;
                return true;
            }
        }
        return false;
    }
}

