/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.catalog;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.RelvarGlobal;
import org.reldb.rel.v0.values.TupleFilter;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Operator;

public abstract class RelvarSpecial
extends RelvarGlobal {
    RelvarSpecial(String name, RelDatabase database) {
        super(name, database);
    }

    @Override
    public long getCardinality(Generator generator) {
        try (TupleIterator iterator = this.iterator(generator);){
            long count = 0L;
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            long l = count;
            return l;
        }
    }

    @Override
    public boolean contains(Generator generator, ValueTuple tuple) {
        try (TupleIterator iterator = this.iterator(generator);){
            while (iterator.hasNext()) {
                if (!tuple.equals(iterator.next())) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public abstract TupleIterator iterator(Generator var1);

    private void noUpdates() {
        throw new ExceptionSemantic("RS0203: The " + this.getName() + " relvar is not updateable.");
    }

    @Override
    public void setValue(ValueRelation relation) {
        this.noUpdates();
    }

    @Override
    public long insert(Generator generator, ValueTuple tuple) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long insert(Generator generator, ValueRelation relation) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long insertNoDuplicates(Generator generator, ValueRelation relation) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public void purge() {
        this.noUpdates();
    }

    @Override
    public long delete(Context context, Operator whereTupleOperator) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long delete(Generator generator, TupleFilter filter) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long delete(Context context, ValueRelation tuplesToDelete, boolean errorIfNotIncluded) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long update(Context context, Operator updateTupleOperator) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long update(Context context, Operator whereTupleOperator, Operator updateTupleOperator) {
        this.noUpdates();
        return 0L;
    }
}

