/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.catalog;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.RelvarReal;
import org.reldb.rel.v0.storage.relvars.RelvarRealMetadata;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Operator;

public class RelvarSystem
extends RelvarReal {
    public RelvarSystem(String name, RelDatabase database, RelvarRealMetadata metadata) {
        super(name, database, metadata);
    }

    private void doesNotSupport(String prompt) {
        throw new ExceptionSemantic("RS0204: The " + this.getName() + " relvar does not support " + prompt + ".");
    }

    @Override
    public void setValue(ValueRelation relation) {
        this.doesNotSupport("assignment");
    }

    public long insert(ValueTuple tuple) {
        this.doesNotSupport("INSERT");
        return 0L;
    }

    @Override
    public long insert(Generator generator, ValueRelation relation) {
        this.doesNotSupport("INSERT");
        return 0L;
    }

    @Override
    public void purge() {
        this.doesNotSupport("DELETE");
    }

    public void delete(ValueTuple tuple) {
        this.doesNotSupport("DELETE");
    }

    @Override
    public long delete(Context context, Operator whereTupleOperator) {
        this.doesNotSupport("DELETE");
        return 0L;
    }

    @Override
    public long update(Context context, Operator updateTupleOperator) {
        this.doesNotSupport("UPDATE");
        return 0L;
    }

    @Override
    public long update(Context context, Operator whereTupleOperator, Operator updateTupleOperator) {
        this.doesNotSupport("UPDATE");
        return 0L;
    }

    private ValueTuple getTupleFor(Generator generator, String name, String definition, String owner) {
        Value[] rawTuple = new Value[]{ValueCharacter.select(generator, name), ValueCharacter.select(generator, definition), ValueCharacter.select(generator, owner), ValueInteger.select(generator, this.getDatabase().getUniqueID())};
        return new ValueTuple(generator, rawTuple);
    }

    protected ValueTuple getKeyTuple(Generator generator, String name) {
        return this.getTupleFor(generator, name, "", "");
    }

    public void insertInternal(Generator generator, ValueTuple tuple) {
        super.insert(generator, tuple);
    }

    public void insertInternal(Generator generator, String name, String definition, String owner) {
        this.insertInternal(generator, this.getTupleFor(generator, name, definition, owner));
    }

    public void deleteInternal(Generator generator, ValueTuple keyTuple) {
        super.delete(generator, keyTuple);
    }

    public void deleteInternal(Generator generator, String name) {
        this.deleteInternal(generator, this.getKeyTuple(generator, name));
    }

    public ValueTuple getTupleForKey(Generator generator, String name) {
        return this.getTupleForKey(generator, this.getKeyTuple(generator, name));
    }
}

