/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.catalog;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.SelectAttributes;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.catalog.RelvarSystem;
import org.reldb.rel.v0.storage.relvars.RelvarGlobal;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.storage.relvars.RelvarRealMetadata;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.builtin.TypeCharacter;
import org.reldb.rel.v0.types.builtin.TypeInteger;

public class RelvarSystemMetadata
extends RelvarRealMetadata {
    public static final long serialVersionUID = 0L;
    private String name;

    static Heading getNewHeading() {
        Heading heading = new Heading();
        heading.add("Name", TypeCharacter.getInstance());
        heading.add("Definition", TypeCharacter.getInstance());
        heading.add("Owner", TypeCharacter.getInstance());
        heading.add("CreationSequence", TypeInteger.getInstance());
        return heading;
    }

    static RelvarHeading getNewKeyDefinition() {
        SelectAttributes attributes = new SelectAttributes();
        attributes.add("Name");
        RelvarHeading keyDefinition = new RelvarHeading(RelvarSystemMetadata.getNewHeading());
        keyDefinition.addKey(attributes);
        return keyDefinition;
    }

    protected RelvarSystemMetadata(RelDatabase database, String name, RelvarHeading definition) {
        super(database, definition, "Rel");
        this.name = name;
    }

    public RelvarSystemMetadata(RelDatabase database, String name) {
        this(database, name, RelvarSystemMetadata.getNewKeyDefinition());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public RelvarGlobal getRelvar(String name, RelDatabase database) {
        return new RelvarSystem(name, database, this);
    }

    @Override
    public void dropRelvar(RelDatabase database) {
        throw new ExceptionSemantic("RS0205: The " + this.name + " relvar may not be dropped.");
    }
}

