/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.catalog;

import java.util.Vector;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.catalog.RelvarSystem;
import org.reldb.rel.v0.storage.relvars.RelvarRealMetadata;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRelationLiteral;
import org.reldb.rel.v0.values.ValueTuple;

public class RelvarTypes
extends RelvarSystem {
    public RelvarTypes(String name, RelDatabase database, RelvarRealMetadata metadata) {
        super(name, database, metadata);
    }

    private ValueTuple getTupleFor(Generator generator, String name, String definition, String owner, String language, Vector<String> superTypes) {
        ValueRelationLiteral superTypesRelation = new ValueRelationLiteral(generator);
        for (String typeName : superTypes) {
            superTypesRelation.insert(new ValueTuple(generator, new Value[]{ValueCharacter.select(generator, typeName)}));
        }
        Value[] rawTuple = new Value[]{ValueCharacter.select(generator, name), ValueCharacter.select(generator, definition), ValueCharacter.select(generator, owner), ValueInteger.select(generator, this.getDatabase().getUniqueID()), ValueCharacter.select(generator, language), new ValueRelationLiteral(generator), superTypesRelation};
        return new ValueTuple(generator, rawTuple);
    }

    @Override
    protected ValueTuple getKeyTuple(Generator generator, String name) {
        return this.getTupleFor(generator, name, "", "", "", new Vector<String>());
    }

    public void insertInternal(Generator generator, String name, String definition, String owner, String language, Vector<String> superTypes) {
        this.insertInternal(generator, this.getTupleFor(generator, name, definition, owner, language, superTypes));
    }

    public void addSubtype(Generator generator, String superTypeName, String subTypeName) {
        ValueTuple superTypeData = this.getTupleForKey(generator, superTypeName);
        if (superTypeData == null) {
            throw new ExceptionFatal("RS0316: Unable to obtain data for " + superTypeName);
        }
        ValueRelationLiteral subtypes = (ValueRelationLiteral)superTypeData.getValues()[5];
        subtypes.insert(new ValueTuple(generator, new Value[]{ValueCharacter.select(generator, subTypeName)}));
        this.deleteInternal(generator, superTypeName);
        this.insertInternal(generator, superTypeData);
    }

    public void removeSubtype(Generator generator, String superTypeName, String subTypeName) {
        ValueTuple superTypeData = this.getTupleForKey(generator, superTypeName);
        if (superTypeData == null) {
            throw new ExceptionFatal("RS0317: Unable to obtain data for " + superTypeName);
        }
        ValueRelationLiteral subtypes = (ValueRelationLiteral)superTypeData.getValues()[5];
        subtypes.remove(new ValueTuple(generator, new Value[]{ValueCharacter.select(generator, subTypeName)}));
        this.deleteInternal(generator, superTypeName);
        this.insertInternal(generator, superTypeData);
    }
}

