/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.catalog;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.SelectAttributes;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.catalog.RelvarVersion;
import org.reldb.rel.v0.storage.relvars.RelvarGlobal;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.storage.relvars.RelvarMetadata;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.builtin.TypeCharacter;
import org.reldb.rel.v0.types.builtin.TypeInteger;

public class RelvarVersionMetadata
extends RelvarMetadata {
    public static final long serialVersionUID = 0L;

    static Heading getNewHeading() {
        Heading heading = new Heading();
        heading.add("minor", TypeInteger.getInstance());
        heading.add("major", TypeInteger.getInstance());
        heading.add("revision", TypeInteger.getInstance());
        heading.add("copyright", TypeCharacter.getInstance());
        heading.add("license", TypeCharacter.getInstance());
        heading.add("versionnum", TypeCharacter.getInstance());
        heading.add("redistribution", TypeCharacter.getInstance());
        heading.add("release", TypeCharacter.getInstance());
        heading.add("versionstr", TypeCharacter.getInstance());
        heading.add("warranty", TypeCharacter.getInstance());
        return heading;
    }

    static RelvarHeading getNewKeyDefinition() {
        RelvarHeading keydef = new RelvarHeading(RelvarVersionMetadata.getNewHeading());
        keydef.addKey(new SelectAttributes());
        return keydef;
    }

    public RelvarVersionMetadata(RelDatabase database) {
        super(database, RelvarVersionMetadata.getNewKeyDefinition(), "Rel");
    }

    @Override
    public RelvarGlobal getRelvar(String name, RelDatabase database) {
        return new RelvarVersion(database);
    }

    @Override
    public void dropRelvar(RelDatabase database) {
        throw new ExceptionSemantic("RS0206: The sys.Version relvar may not be dropped.");
    }
}

