/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.relvars;

import java.lang.reflect.InvocationTargetException;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.RelvarCustomMetadata;
import org.reldb.rel.v0.storage.relvars.RelvarGlobal;
import org.reldb.rel.v0.storage.tables.TableCustom;
import org.reldb.rel.v0.storage.tables.TableExternal;
import org.reldb.rel.v0.values.RelTupleFilter;
import org.reldb.rel.v0.values.RelTupleMap;
import org.reldb.rel.v0.values.TupleFilter;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Operator;

public class RelvarExternal
extends RelvarGlobal {
    private TableExternal table;

    public RelvarExternal(String name, RelDatabase database, Generator generator, RelvarCustomMetadata metadata, TableExternal.DuplicateHandling duplicates) {
        super(name, database);
        String tableName = metadata.tableClassName();
        String type = metadata.getType();
        try {
            this.table = (TableCustom)Class.forName("Relplugins.relvars." + type.toUpperCase() + "." + tableName).getConstructors()[0].newInstance(new Object[]{name, metadata, generator, duplicates});
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionSemantic("RS0223: " + tableName + " could not be found");
        }
        catch (ClassCastException e) {
            throw new ExceptionSemantic("RS0224: " + tableName + " does not extend TableCustom");
        }
    }

    @Override
    public long getCardinality(Generator generator) {
        return this.table.getCardinality();
    }

    @Override
    public boolean contains(Generator generator, ValueTuple tuple) {
        return this.table.contains(generator, tuple);
    }

    public ValueTuple getTupleForKey(Generator generator, ValueTuple tuple) {
        return this.table.getTupleForKey(generator, tuple);
    }

    @Override
    public void setValue(ValueRelation relation) {
        this.table.setValue(this, relation);
    }

    @Override
    public long insert(Generator generator, ValueTuple tuple) {
        return this.table.insert(generator, tuple);
    }

    @Override
    public long insert(Generator generator, ValueRelation relation) {
        return this.table.insert(generator, relation);
    }

    @Override
    public long insertNoDuplicates(Generator generator, ValueRelation relation) {
        return this.table.insertNoDuplicates(generator, relation);
    }

    @Override
    public void purge() {
        this.table.purge();
    }

    public void delete(Generator generator, ValueTuple tuple) {
        this.table.delete(generator, tuple);
    }

    @Override
    public long delete(Context context, Operator whereTupleOperator) {
        return this.table.delete(context.getGenerator(), new RelTupleFilter(context, whereTupleOperator));
    }

    @Override
    public long delete(Generator generator, TupleFilter filter) {
        return this.table.delete(generator, filter);
    }

    @Override
    public long delete(Context context, ValueRelation tuplesToDelete, boolean errorIfNotIncluded) {
        return this.table.delete(context, tuplesToDelete, errorIfNotIncluded);
    }

    @Override
    public long update(Context context, Operator updateTupleOperator) {
        return this.table.update(context.getGenerator(), new RelTupleMap(context, updateTupleOperator));
    }

    @Override
    public long update(Context context, Operator whereTupleOperator, Operator updateTupleOperator) {
        return this.table.update(context.getGenerator(), new RelTupleFilter(context, whereTupleOperator), new RelTupleMap(context, updateTupleOperator));
    }

    @Override
    public TupleIterator iterator(Generator generator) {
        return this.table.iterator(generator);
    }
}

